/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.js.checkers.declaration;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.js.FirJsErrors;
import org.jetbrains.kotlin.fir.analysis.js.checkers.FirJsHelpersKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertyAccessorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.name.JsStandardClassIds;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsNameChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)V", "checkers.js"})
@SourceDebugExtension(value={"SMAP\nFirJsNameChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJsNameChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsNameChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 4 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,70:1\n1834#2,4:71\n38#3:75\n29#4:76\n*S KotlinDebug\n*F\n+ 1 FirJsNameChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsNameChecker\n*L\n26#1:71,4\n40#1:75\n41#1:76\n*E\n"})
public final class FirJsNameChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirJsNameChecker INSTANCE = new FirJsNameChecker();

    private FirJsNameChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirDeclaration declaration) {
        FirDeclaration firDeclaration;
        KtSourceElement jsNameSource;
        block21: {
            block20: {
                boolean $i$f$isOverride;
                Object $this$isOverride$iv;
                block19: {
                    Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                    Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
                    Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                    if (declaration instanceof FirProperty) {
                        int namedAccessorCount;
                        int n2;
                        Object[] objectArray = new FirPropertyAccessorSymbol[2];
                        FirPropertyAccessor firPropertyAccessor = ((FirProperty)declaration).getGetter();
                        objectArray[0] = firPropertyAccessor != null ? firPropertyAccessor.getSymbol() : null;
                        FirPropertyAccessor firPropertyAccessor2 = ((FirProperty)declaration).getSetter();
                        objectArray[1] = firPropertyAccessor2 != null ? firPropertyAccessor2.getSymbol() : null;
                        List accessors = CollectionsKt.listOfNotNull((Object[])objectArray);
                        Iterable $this$count$iv = accessors;
                        boolean $i$f$count = false;
                        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                            n2 = 0;
                        } else {
                            int count$iv = 0;
                            for (Object element$iv : $this$count$iv) {
                                FirPropertyAccessorSymbol it = (FirPropertyAccessorSymbol)element$iv;
                                boolean bl = false;
                                if (!(FirJsHelpersKt.getJsName(it, context2.getSession()) != null) || ++count$iv >= 0) continue;
                                CollectionsKt.throwCountOverflow();
                            }
                            n2 = namedAccessorCount = count$iv;
                        }
                        if (namedAccessorCount > 0 && namedAccessorCount < accessors.size()) {
                            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)((FirProperty)declaration).getSource(), FirJsErrors.INSTANCE.getJS_NAME_IS_NOT_ON_ALL_ACCESSORS(), null, 8, null);
                        }
                    }
                    FirAnnotation firAnnotation = FirAnnotationUtilsKt.getAnnotationByClassId(declaration, JsStandardClassIds.Annotations.JsName, context2.getSession());
                    if (firAnnotation == null) {
                        return;
                    }
                    FirAnnotation jsName = firAnnotation;
                    KtSourceElement ktSourceElement = jsName.getSource();
                    if (ktSourceElement == null) {
                        ktSourceElement = jsNameSource = declaration.getSource();
                    }
                    if (FirHelpersKt.getAnnotationStringParameter(declaration.getSymbol(), JsStandardClassIds.Annotations.JsNative, context2.getSession()) != null) {
                        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)jsNameSource, FirJsErrors.INSTANCE.getJS_NAME_PROHIBITED_FOR_NAMED_NATIVE(), null, 8, null);
                    }
                    if (!(declaration instanceof FirCallableDeclaration)) break block19;
                    $this$isOverride$iv = (FirMemberDeclaration)declaration;
                    $i$f$isOverride = false;
                    if (((FirMemberDeclaration)$this$isOverride$iv).getStatus().isOverride()) break block20;
                }
                if (!(declaration instanceof FirPropertyAccessor)) break block21;
                $this$isOverride$iv = ((FirPropertyAccessor)declaration).getPropertySymbol();
                $i$f$isOverride = false;
                if (!((FirCallableSymbol)$this$isOverride$iv).getResolvedStatus().isOverride()) break block21;
            }
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)jsNameSource, FirJsErrors.INSTANCE.getJS_NAME_PROHIBITED_FOR_OVERRIDE(), null, 8, null);
        }
        if ((firDeclaration = declaration) instanceof FirConstructor) {
            if (((FirConstructor)declaration).isPrimary()) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)jsNameSource, FirJsErrors.INSTANCE.getJS_NAME_ON_PRIMARY_CONSTRUCTOR_PROHIBITED(), null, 8, null);
            }
        } else if (firDeclaration instanceof FirPropertyAccessor) {
            FirPropertySymbol property2 = ((FirPropertyAccessor)declaration).getPropertySymbol();
            if (FirJsHelpersKt.getJsName(property2, context2.getSession()) != null) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)jsNameSource, FirJsErrors.INSTANCE.getJS_NAME_ON_ACCESSOR_AND_PROPERTY(), null, 8, null);
            }
        } else if (firDeclaration instanceof FirProperty && FirDeclarationUtilKt.isExtension((FirCallableDeclaration)declaration)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)jsNameSource, FirJsErrors.INSTANCE.getJS_NAME_PROHIBITED_FOR_EXTENSION_PROPERTY(), null, 8, null);
        }
    }
}

