/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.experimental;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirLiteralExpression;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u0002H\u0002\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/experimental/EmptyRangeChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirFunctionCallChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;)V", "compareLeftAndRight", "", "(Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;)Ljava/lang/Integer;", "checkers"})
@SourceDebugExtension(value={"SMAP\nEmptyRangeChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmptyRangeChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/experimental/EmptyRangeChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,54:1\n1#2:55\n*E\n"})
public final class EmptyRangeChecker
extends FirExpressionChecker<FirFunctionCall> {
    @NotNull
    public static final EmptyRangeChecker INSTANCE = new EmptyRangeChecker();

    private EmptyRangeChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirFunctionCall expression2) {
        boolean needReport;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        KtSourceElement ktSourceElement = expression2.getSource();
        if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) {
            return;
        }
        Integer n2 = this.compareLeftAndRight(expression2);
        if (n2 == null) {
            return;
        }
        int comparison = n2;
        switch (expression2.getCalleeReference().getName().asString()) {
            case "rangeTo": {
                boolean bl;
                if (comparison > 0) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case "downTo": {
                boolean bl;
                if (comparison < 0) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case "rangeUntil": 
            case "until": {
                boolean bl;
                if (comparison >= 0) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                boolean bl = needReport = false;
            }
        }
        if (needReport) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getEMPTY_RANGE(), null, 8, null);
        }
    }

    private final Integer compareLeftAndRight(FirFunctionCall $this$compareLeftAndRight) {
        Integer n2;
        Object object = $this$compareLeftAndRight.getExplicitReceiver();
        Object object2 = object instanceof FirLiteralExpression ? (FirLiteralExpression)object : null;
        if (object2 == null || (object2 = ((FirLiteralExpression)object2).getValue()) == null) {
            return null;
        }
        Object left = object2;
        Object object3 = CollectionsKt.getOrNull($this$compareLeftAndRight.getArgumentList().getArguments(), (int)0);
        Object object4 = object3 instanceof FirLiteralExpression ? (FirLiteralExpression)object3 : null;
        if (object4 == null || (object4 = ((FirLiteralExpression)object4).getValue()) == null) {
            return null;
        }
        Object right = object4;
        object = left;
        if (object instanceof Long) {
            Long l2 = right instanceof Long ? (Long)right : null;
            if (l2 != null) {
                long it = ((Number)l2).longValue();
                boolean bl = false;
                n2 = Intrinsics.compare((long)((Number)left).longValue(), (long)it);
            } else {
                n2 = null;
            }
        } else if (object instanceof Float) {
            Float f2 = right instanceof Float ? (Float)right : null;
            if (f2 != null) {
                float it = ((Number)f2).floatValue();
                boolean bl = false;
                n2 = Float.compare(((Number)left).floatValue(), it);
            } else {
                n2 = null;
            }
        } else if (object instanceof Double) {
            Double d2 = right instanceof Double ? (Double)right : null;
            if (d2 != null) {
                double it = ((Number)d2).doubleValue();
                boolean bl = false;
                n2 = Double.compare(((Number)left).doubleValue(), it);
            } else {
                n2 = null;
            }
        } else if (object instanceof Character) {
            Character c2 = right instanceof Character ? (Character)right : null;
            if (c2 != null) {
                char it = c2.charValue();
                boolean bl = false;
                n2 = Intrinsics.compare((int)((Character)left).charValue(), (int)it);
            } else {
                n2 = null;
            }
        } else {
            n2 = null;
        }
        return n2;
    }
}

