/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.container;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.container.CacheKt;
import org.jetbrains.kotlin.container.ClassInfo;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\n\u001a\u00020\t2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u0006R7\u0010\u0004\u001a+\u0012\u0012\u0012\u0010\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b\u0012\u000e\u0012\f0\t\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b0\u0005\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/container/ClassTraversalCache;", "", "<init>", "()V", "cache", "Ljava/util/concurrent/ConcurrentMap;", "Ljava/lang/Class;", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "Lorg/jetbrains/kotlin/container/ClassInfo;", "getClassInfo", "c", "container"})
final class ClassTraversalCache {
    @NotNull
    public static final ClassTraversalCache INSTANCE = new ClassTraversalCache();
    @NotNull
    private static final ConcurrentMap<Class<?>, ClassInfo> cache;

    private ClassTraversalCache() {
    }

    @NotNull
    public final ClassInfo getClassInfo(@NotNull Class<?> c2) {
        Intrinsics.checkNotNullParameter(c2, (String)"c");
        ClassInfo classInfo = (ClassInfo)cache.get(c2);
        if (classInfo == null) {
            ClassInfo newClassInfo = CacheKt.access$traverseClass(c2);
            cache.put(c2, newClassInfo);
            return newClassInfo;
        }
        return classInfo;
    }

    static {
        ConcurrentMap concurrentMap = System.getProperty("idea.system.path") != null ? (ConcurrentMap)new ConcurrentHashMap() : ContainerUtil.createConcurrentWeakKeySoftValueMap();
        Intrinsics.checkNotNull((Object)concurrentMap);
        cache = concurrentMap;
    }
}

