/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.UtilsKt;
import org.jetbrains.kotlin.backend.common.ir.IrInlineUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.LocalDeclarationsLowering;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmCachedDeclarationsKt;
import org.jetbrains.kotlin.backend.jvm.JvmIrAttributesKt;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrCoroutineUtilsKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrTypeUtilsKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.backend.jvm.lower.AddContinuationLowering;
import org.jetbrains.kotlin.backend.jvm.lower.AddContinuationLoweringKt;
import org.jetbrains.kotlin.backend.jvm.lower.JvmLocalDeclarationsLowering;
import org.jetbrains.kotlin.backend.jvm.lower.SuspendLambdaLowering;
import org.jetbrains.kotlin.backend.jvm.lower.SuspendLoweringUtils;
import org.jetbrains.kotlin.backend.jvm.lower.TailCallOptimizationLowering;
import org.jetbrains.kotlin.backend.jvm.mapping.MethodSignatureMapper;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrClassBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrDeclarationBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFieldBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrMutableAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrParameterKind;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrRichFunctionReference;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrFunctionReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetFieldImpl;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeSystemContextKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.util.TransformKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.load.java.JavaDescriptorVisibilities;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.org.objectweb.asm.Type;

@PhaseDescription(name="AddContinuation", prerequisite={SuspendLambdaLowering.class, JvmLocalDeclarationsLowering.class, TailCallOptimizationLowering.class})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J*\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001e\u0010\u0016\u001a\u00020\u0017*\u00020\r2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J6\u0010\u001a\u001a\u00020\b*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00192\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001d\u001a\u00020\u0015H\u0002J\f\u0010\u001e\u001a\u00020\u001f*\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u000e\u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/AddContinuationLowering;", "Lorg/jetbrains/kotlin/backend/jvm/lower/SuspendLoweringUtils;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "addContinuationParameterToSuspendCalls", "generateContinuationClassForNamedFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "dispatchReceiverParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "attributeContainer", "Lorg/jetbrains/kotlin/ir/IrElement;", "capturesCrossinline", "", "addConstructorForNamedFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "capturedThisField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "addInvokeSuspendForNamedFunction", "resultField", "labelField", "isStaticSuspendImpl", "toSuspendImplementationName", "Lorg/jetbrains/kotlin/name/Name;", "createStaticSuspendImpl", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "addContinuationObjectAndContinuationParameterToSuspendFunctions", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nAddContinuationLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddContinuationLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/AddContinuationLowering\n+ 2 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 ExpressionHelpers.kt\norg/jetbrains/kotlin/ir/builders/ExpressionHelpersKt\n+ 6 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBodyBuilder\n+ 7 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 8 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,535:1\n51#2,4:536\n81#2:540\n75#2,10:541\n81#2:551\n75#2,10:552\n321#2:562\n315#2,13:563\n1#3:576\n351#4,12:577\n351#4,12:601\n351#4,12:634\n418#5,10:589\n418#5,10:613\n76#6,2:599\n76#6:623\n77#6:633\n406#7,5:624\n411#7:632\n1661#8,3:629\n*S KotlinDebug\n*F\n+ 1 AddContinuationLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/AddContinuationLowering\n*L\n103#1:536,4\n113#1:540\n113#1:541,10\n120#1:551\n120#1:552,10\n141#1:562\n141#1:563,13\n149#1:577,12\n171#1:601,12\n186#1:634,12\n152#1:589,10\n277#1:613,10\n152#1:599,2\n277#1:623\n277#1:633\n282#1:624,5\n282#1:632\n282#1:629,3\n*E\n"})
public final class AddContinuationLowering
extends SuspendLoweringUtils
implements FileLoweringPass {
    public AddContinuationLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2);
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        this.addContinuationObjectAndContinuationParameterToSuspendFunctions(irFile);
        this.addContinuationParameterToSuspendCalls(irFile);
    }

    private final void addContinuationParameterToSuspendCalls(IrFile irFile) {
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, new IrElementTransformerVoid(this){
            private final List<IrFunction> functionStack;
            final /* synthetic */ AddContinuationLowering this$0;
            {
                this.this$0 = $receiver;
                this.functionStack = new ArrayList<E>();
            }

            public final List<IrFunction> getFunctionStack() {
                return this.functionStack;
            }

            public IrStatement visitFunction(IrFunction declaration) {
                IrStatement irStatement;
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                UtilsKt.push(this.functionStack, declaration);
                IrStatement it = irStatement = super.visitFunction(declaration);
                boolean bl = false;
                UtilsKt.pop(this.functionStack);
                return irStatement;
            }

            public IrExpression visitFunctionReference(IrFunctionReference expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrExpression irExpression = super.visitFunctionReference(expression2);
                Intrinsics.checkNotNull((Object)irExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrFunctionReference");
                IrFunctionReference transformed = (IrFunctionReference)irExpression;
                return AddContinuationLoweringKt.access$retargetToSuspendView(transformed, this.this$0.getContext(), null, addContinuationParameterToSuspendCalls.1::visitFunctionReference$lambda$1);
            }

            public IrExpression visitRawFunctionReference(IrRawFunctionReference expression2) {
                IrRawFunctionReference transformed;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrExpression irExpression = super.visitRawFunctionReference(expression2);
                Intrinsics.checkNotNull((Object)irExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference");
                IrRawFunctionReference irRawFunctionReference = transformed = (IrRawFunctionReference)irExpression;
                AddContinuationLowering addContinuationLowering = this.this$0;
                IrRawFunctionReference $this$visitRawFunctionReference_u24lambda_u242 = irRawFunctionReference;
                boolean bl = false;
                AddContinuationLoweringKt.access$retargetToSuspendView($this$visitRawFunctionReference_u24lambda_u242, addContinuationLowering.getContext());
                return irRawFunctionReference;
            }

            public IrExpression visitCall(IrCall expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrExpression irExpression = super.visitCall(expression2);
                Intrinsics.checkNotNull((Object)irExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrCall");
                IrCall transformed = (IrCall)irExpression;
                IrFunction irFunction = UtilsKt.peek(this.functionStack);
                if (irFunction == null) {
                    return transformed;
                }
                return AddContinuationLoweringKt.access$retargetToSuspendView(transformed, this.this$0.getContext(), irFunction, addContinuationParameterToSuspendCalls.1::visitCall$lambda$3);
            }

            private static final IrFunctionReference visitFunctionReference$lambda$1(IrFunctionReference $this$retargetToSuspendView, IrSimpleFunctionSymbol it) {
                Intrinsics.checkNotNullParameter((Object)$this$retargetToSuspendView, (String)"$this$retargetToSuspendView");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return BuildersKt.fromSymbolOwner(IrFunctionReferenceImpl.Companion, $this$retargetToSuspendView.getStartOffset(), $this$retargetToSuspendView.getEndOffset(), $this$retargetToSuspendView.getType(), it, $this$retargetToSuspendView.getTypeArguments().size(), $this$retargetToSuspendView.getReflectionTarget(), $this$retargetToSuspendView.getOrigin());
            }

            private static final IrCall visitCall$lambda$3(IrCall $this$retargetToSuspendView, IrSimpleFunctionSymbol it) {
                Intrinsics.checkNotNullParameter((Object)$this$retargetToSuspendView, (String)"$this$retargetToSuspendView");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return BuildersKt.fromSymbolOwner(IrCallImpl.Companion, $this$retargetToSuspendView.getStartOffset(), $this$retargetToSuspendView.getEndOffset(), $this$retargetToSuspendView.getType(), it, $this$retargetToSuspendView.getOrigin(), $this$retargetToSuspendView.getSuperQualifierSymbol());
            }
        });
    }

    private final IrClass generateContinuationClassForNamedFunction(IrFunction irFunction, IrValueParameter dispatchReceiverParameter, IrElement attributeContainer, boolean capturesCrossinline) {
        IrField irField;
        IrClass irClass;
        DescriptorVisibility descriptorVisibility;
        IrFactory $this$buildClass$iv = this.getContext().getIrFactory();
        boolean $i$f$buildClass = false;
        IrClassBuilder $this$buildClass_u24lambda_u241$iv = new IrClassBuilder();
        boolean bl = false;
        IrClassBuilder $this$generateContinuationClassForNamedFunction_u24lambda_u240 = $this$buildClass_u24lambda_u241$iv;
        boolean bl2 = false;
        Name name2 = Name.special("<Continuation>");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"special(...)");
        $this$generateContinuationClassForNamedFunction_u24lambda_u240.setName(name2);
        $this$generateContinuationClassForNamedFunction_u24lambda_u240.setOrigin(JvmLoweredDeclarationOrigin.INSTANCE.getCONTINUATION_CLASS());
        if (capturesCrossinline) {
            DescriptorVisibility descriptorVisibility2 = DescriptorVisibilities.PUBLIC;
            descriptorVisibility = descriptorVisibility2;
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility2, (String)"PUBLIC");
        } else {
            DescriptorVisibility descriptorVisibility3 = JavaDescriptorVisibilities.PACKAGE_VISIBILITY;
            descriptorVisibility = descriptorVisibility3;
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility3, (String)"PACKAGE_VISIBILITY");
        }
        $this$generateContinuationClassForNamedFunction_u24lambda_u240.setVisibility(descriptorVisibility);
        IrClass $this$generateContinuationClassForNamedFunction_u24lambda_u241 = irClass = DeclarationBuildersKt.buildClass($this$buildClass$iv, $this$buildClass_u24lambda_u241$iv);
        boolean bl3 = false;
        IrUtilsKt.createThisReceiverParameter($this$generateContinuationClassForNamedFunction_u24lambda_u241);
        $this$generateContinuationClassForNamedFunction_u24lambda_u241.setSuperTypes(CollectionsKt.plus((Collection)$this$generateContinuationClassForNamedFunction_u24lambda_u241.getSuperTypes(), (Object)IrUtilsKt.getDefaultType((IrClass)this.getContext().getSymbols().getContinuationImplClass().getOwner())));
        $this$generateContinuationClassForNamedFunction_u24lambda_u241.setParent(irFunction);
        IrUtilsKt.copyTypeParametersFrom$default($this$generateContinuationClassForNamedFunction_u24lambda_u241, irFunction, null, null, 6, null);
        IrClass $this$addField$iv = $this$generateContinuationClassForNamedFunction_u24lambda_u241;
        boolean $i$f$addField = false;
        Object $this$buildField$iv$iv = $this$addField$iv.getFactory();
        boolean $i$f$buildField = false;
        IrFieldBuilder $this$buildField_u24lambda_u241$iv$iv = new IrFieldBuilder();
        boolean bl4 = false;
        IrFieldBuilder $this$generateContinuationClassForNamedFunction_u24lambda_u241_u240 = $this$buildField_u24lambda_u241$iv$iv;
        boolean bl5 = false;
        $this$generateContinuationClassForNamedFunction_u24lambda_u241_u240.setOrigin(JvmLoweredDeclarationOrigin.INSTANCE.getCONTINUATION_CLASS_RESULT_FIELD());
        Name name3 = Name.identifier("result");
        Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(...)");
        $this$generateContinuationClassForNamedFunction_u24lambda_u241_u240.setName(name3);
        $this$generateContinuationClassForNamedFunction_u24lambda_u241_u240.setType(this.getContext().getSymbols().getResultOfAnyType());
        DescriptorVisibility descriptorVisibility4 = JavaDescriptorVisibilities.PACKAGE_VISIBILITY;
        Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility4, (String)"PACKAGE_VISIBILITY");
        $this$generateContinuationClassForNamedFunction_u24lambda_u241_u240.setVisibility(descriptorVisibility4);
        Object field$iv = $this$buildField$iv$iv = DeclarationBuildersKt.buildField((IrFactory)$this$buildField$iv$iv, $this$buildField_u24lambda_u241$iv$iv);
        boolean bl6 = false;
        ((IrDeclarationBase)field$iv).setParent($this$addField$iv);
        $this$addField$iv.getDeclarations().add((IrDeclaration)field$iv);
        Object resultField = $this$buildField$iv$iv;
        IrValueParameter irValueParameter = dispatchReceiverParameter;
        if (irValueParameter != null) {
            IrField irField2;
            IrValueParameter it = irValueParameter;
            boolean bl7 = false;
            IrClass $this$addField$iv2 = $this$generateContinuationClassForNamedFunction_u24lambda_u241;
            boolean $i$f$addField2 = false;
            IrFactory $this$buildField$iv$iv2 = $this$addField$iv2.getFactory();
            boolean $i$f$buildField2 = false;
            IrFieldBuilder $this$buildField_u24lambda_u241$iv$iv2 = new IrFieldBuilder();
            $i$a$-run-DeclarationBuildersKt$buildField$2$iv$iv = false;
            IrFieldBuilder $this$generateContinuationClassForNamedFunction_u24lambda_u241_u241_u240 = $this$buildField_u24lambda_u241$iv$iv2;
            boolean bl8 = false;
            Name name4 = Name.identifier("this$0");
            Intrinsics.checkNotNullExpressionValue((Object)name4, (String)"identifier(...)");
            $this$generateContinuationClassForNamedFunction_u24lambda_u241_u241_u240.setName(name4);
            $this$generateContinuationClassForNamedFunction_u24lambda_u241_u241_u240.setType(it.getType());
            $this$generateContinuationClassForNamedFunction_u24lambda_u241_u241_u240.setOrigin(IrDeclarationOrigin.Companion.getFIELD_FOR_OUTER_THIS());
            DescriptorVisibility descriptorVisibility5 = JavaDescriptorVisibilities.PACKAGE_VISIBILITY;
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility5, (String)"PACKAGE_VISIBILITY");
            $this$generateContinuationClassForNamedFunction_u24lambda_u241_u241_u240.setVisibility(descriptorVisibility5);
            $this$generateContinuationClassForNamedFunction_u24lambda_u241_u241_u240.setFinal(true);
            IrField field$iv2 = irField2 = DeclarationBuildersKt.buildField($this$buildField$iv$iv2, $this$buildField_u24lambda_u241$iv$iv2);
            $i$a$-also-DeclarationBuildersKt$addField$1$iv = false;
            field$iv2.setParent($this$addField$iv2);
            $this$addField$iv2.getDeclarations().add(field$iv2);
            irField = irField2;
        } else {
            irField = null;
        }
        IrField capturedThisField = irField;
        IrType irType = this.getContext().getIrBuiltIns().getIntType();
        DescriptorVisibility descriptorVisibility6 = JavaDescriptorVisibilities.PACKAGE_VISIBILITY;
        Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility6, (String)"PACKAGE_VISIBILITY");
        IrField labelField = DeclarationBuildersKt.addField($this$generateContinuationClassForNamedFunction_u24lambda_u241, "label", irType, descriptorVisibility6);
        this.addConstructorForNamedFunction($this$generateContinuationClassForNamedFunction_u24lambda_u241, capturedThisField, capturesCrossinline);
        this.addInvokeSuspendForNamedFunction($this$generateContinuationClassForNamedFunction_u24lambda_u241, irFunction, (IrField)resultField, labelField, capturedThisField, Intrinsics.areEqual((Object)irFunction.getOrigin(), (Object)JvmLoweredDeclarationOrigin.INSTANCE.getSUSPEND_IMPL_STATIC_FUNCTION()));
        IrDeclarationsKt.copyAttributes$default($this$generateContinuationClassForNamedFunction_u24lambda_u241, attributeContainer, false, 2, null);
        return irClass;
    }

    /*
     * WARNING - void declaration
     */
    private final IrConstructor addConstructorForNamedFunction(IrClass $this$addConstructorForNamedFunction, IrField capturedThisField, boolean capturesCrossinline) {
        void it;
        IrDelegatingConstructorCall irDelegatingConstructorCall;
        void $this$addConstructorForNamedFunction_u24lambda_u241_u242;
        void this_$iv$iv;
        IrConstructor it2;
        IrValueParameter irValueParameter;
        Object object;
        DescriptorVisibility descriptorVisibility;
        IrClass $this$addConstructor$iv = $this$addConstructorForNamedFunction;
        boolean $i$f$addConstructor = false;
        Object $this$buildConstructor$iv$iv = $this$addConstructor$iv.getFactory();
        boolean $i$f$buildConstructor = false;
        IrFunctionBuilder $this$buildConstructor_u24lambda_u241$iv$iv = new IrFunctionBuilder();
        boolean bl = false;
        IrFunctionBuilder $this$addConstructor_u24lambda_u240$iv = $this$buildConstructor_u24lambda_u241$iv$iv;
        boolean bl2 = false;
        IrFunctionBuilder $this$addConstructorForNamedFunction_u24lambda_u240 = $this$addConstructor_u24lambda_u240$iv;
        boolean bl3 = false;
        $this$addConstructorForNamedFunction_u24lambda_u240.setPrimary(true);
        $this$addConstructorForNamedFunction_u24lambda_u240.setReturnType(IrUtilsKt.getDefaultType($this$addConstructorForNamedFunction));
        if (capturesCrossinline) {
            DescriptorVisibility descriptorVisibility2 = DescriptorVisibilities.PUBLIC;
            descriptorVisibility = descriptorVisibility2;
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility2, (String)"PUBLIC");
        } else {
            DescriptorVisibility descriptorVisibility3 = JavaDescriptorVisibilities.PACKAGE_VISIBILITY;
            descriptorVisibility = descriptorVisibility3;
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility3, (String)"PACKAGE_VISIBILITY");
        }
        $this$addConstructorForNamedFunction_u24lambda_u240.setVisibility(descriptorVisibility);
        $this$addConstructor_u24lambda_u240$iv.setReturnType(IrUtilsKt.getDefaultType($this$addConstructor$iv));
        Object constructor$iv = $this$buildConstructor$iv$iv = DeclarationBuildersKt.buildConstructor((IrFactory)$this$buildConstructor$iv$iv, $this$buildConstructor_u24lambda_u241$iv$iv);
        boolean bl4 = false;
        $this$addConstructor$iv.getDeclarations().add((IrDeclaration)constructor$iv);
        ((IrDeclarationBase)constructor$iv).setParent($this$addConstructor$iv);
        Object constructor = object = $this$buildConstructor$iv$iv;
        boolean bl5 = false;
        IrField irField = capturedThisField;
        if (irField != null) {
            IrField it3 = irField;
            boolean bl6 = false;
            IrFunction irFunction = (IrFunction)constructor;
            String string = it3.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            irValueParameter = DeclarationBuildersKt.addValueParameter$default(irFunction, string, it3.getType(), null, 4, null);
        } else {
            irValueParameter = null;
        }
        IrValueParameter capturedThisParameter = irValueParameter;
        IrValueParameter completionParameterSymbol = this.addCompletionValueParameter((IrFunction)constructor);
        Sequence<IrConstructor> $this$single$iv = IrUtilsKt.getConstructors((IrClass)this.getContext().getSymbols().getContinuationImplClass().getOwner());
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            it2 = (IrConstructor)element$iv;
            boolean bl7 = false;
            if (!IrUtilsKt.hasShape$default(it2, false, false, 0, 1, null, 23, null)) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        IrConstructor superClassConstructor = single$iv;
        IrBuilderWithScope $this$irBlockBody_u24default$iv = LowerUtilsKt.createIrBuilder$default(this.getContext(), (IrSymbol)((IrConstructor)constructor).getSymbol(), 0, 0, 6, null);
        int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
        boolean $i$f$irBlockBody = false;
        IrBlockBodyBuilder irBlockBodyBuilder = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
        boolean $i$f$blockBody = false;
        it2 = this_$iv$iv;
        Object object2 = constructor;
        boolean bl8 = false;
        if (capturedThisField != null) {
            IrBuilder irBuilder = (IrBuilder)$this$addConstructorForNamedFunction_u24lambda_u241_u242;
            IrBuilder irBuilder2 = (IrBuilder)$this$addConstructorForNamedFunction_u24lambda_u241_u242;
            IrValueParameter irValueParameter2 = $this$addConstructorForNamedFunction.getThisReceiver();
            Intrinsics.checkNotNull((Object)irValueParameter2);
            IrExpression irExpression = ExpressionHelpersKt.irGet(irBuilder2, irValueParameter2);
            IrBuilder irBuilder3 = (IrBuilder)$this$addConstructorForNamedFunction_u24lambda_u241_u242;
            IrValueParameter irValueParameter3 = capturedThisParameter;
            Intrinsics.checkNotNull((Object)irValueParameter3);
            $this$addConstructorForNamedFunction_u24lambda_u241_u242.unaryPlus(ExpressionHelpersKt.irSetField$default(irBuilder, irExpression, capturedThisField, ExpressionHelpersKt.irGet(irBuilder3, irValueParameter3), null, 8, null));
        }
        IrDelegatingConstructorCall irDelegatingConstructorCall2 = irDelegatingConstructorCall = ExpressionHelpersKt.irDelegatingConstructorCall((IrBuilder)$this$addConstructorForNamedFunction_u24lambda_u241_u242, superClassConstructor);
        void var21_29 = $this$addConstructorForNamedFunction_u24lambda_u241_u242;
        boolean bl9 = false;
        it.getArguments().set(0, ExpressionHelpersKt.irGet((IrBuilder)$this$addConstructorForNamedFunction_u24lambda_u241_u242, completionParameterSymbol));
        var21_29.unaryPlus(irDelegatingConstructorCall);
        ((IrFunction)object2).setBody(this_$iv$iv.doBuild());
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final void addInvokeSuspendForNamedFunction(IrClass $this$addInvokeSuspendForNamedFunction, IrFunction irFunction, IrField resultField, IrField labelField, IrField capturedThisField, boolean isStaticSuspendImpl) {
        void $this$single$iv;
        JvmBackendContext backendContext = this.getContext();
        Sequence<IrSimpleFunction> sequence2 = IrUtilsKt.getFunctions((IrClass)this.getContext().getSymbols().getContinuationImplClass().getOwner());
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            IrSimpleFunction it = (IrSimpleFunction)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)Name.identifier("invokeSuspend"))) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        IrSimpleFunction invokeSuspend = single$iv;
        this.addFunctionOverride($this$addInvokeSuspendForNamedFunction, invokeSuspend, irFunction.getStartOffset(), irFunction.getEndOffset(), (Function2<? super IrBlockBodyBuilder, ? super IrFunction, Unit>)((Function2)(arg_0, arg_1) -> AddContinuationLowering.addInvokeSuspendForNamedFunction$lambda$1(resultField, labelField, irFunction, $this$addInvokeSuspendForNamedFunction, capturedThisField, isStaticSuspendImpl, backendContext, arg_0, arg_1)));
    }

    private final Name toSuspendImplementationName(Name $this$toSuspendImplementationName) {
        Name name2 = Name.guessByFirstCharacter($this$toSuspendImplementationName.asString() + "$suspendImpl");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"guessByFirstCharacter(...)");
        return name2;
    }

    /*
     * WARNING - void declaration
     */
    private final IrSimpleFunction createStaticSuspendImpl(IrSimpleFunction irFunction) {
        void $this$mapTo$iv$iv;
        void $this$assignFrom$iv;
        void it;
        void $this$createStaticSuspendImpl_u24lambda_u241;
        IrFunctionAccessExpression irFunctionAccessExpression;
        void this_$iv$iv;
        IrFactory irFactory = this.getContext().getIrFactory();
        IrDeclarationParent irDeclarationParent = irFunction.getParent();
        Name name2 = this.toSuspendImplementationName(irFunction.getName());
        IrFunction irFunction2 = irFunction;
        IrDeclarationOrigin irDeclarationOrigin = JvmLoweredDeclarationOrigin.INSTANCE.getSUSPEND_IMPL_STATIC_FUNCTION();
        DescriptorVisibility descriptorVisibility = JvmIrUtilsKt.isJvmInterface(IrUtilsKt.getParentAsClass(irFunction)) ? DescriptorVisibilities.PUBLIC : JavaDescriptorVisibilities.PACKAGE_VISIBILITY;
        Intrinsics.checkNotNull((Object)descriptorVisibility);
        IrSimpleFunction irSimpleFunction = IrUtilsKt.createStaticFunctionWithReceivers$default(irFactory, irDeclarationParent, name2, irFunction2, null, irDeclarationOrigin, Modality.OPEN, descriptorVisibility, false, false, IrTypeSystemContextKt.extractTypeParameters(IrUtilsKt.getParentAsClass(irFunction)), (Function3)new Function3<IrFunction, IrFunction, Map<IrValueParameter, ? extends IrValueParameter>, Unit>((Object)this.getContext()){

            public final void invoke(IrFunction p0, IrFunction p1, Map<IrValueParameter, ? extends IrValueParameter> p2) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                ((JvmBackendContext)this.receiver).remapMultiFieldValueClassStructure(p0, p1, p2);
            }
        }, 8, null);
        irSimpleFunction.setBody(IrInlineUtilsKt.moveBodyTo(irFunction, irSimpleFunction));
        if (IrUtilsKt.getParentAsClass(irFunction).isInner()) {
            IrValueParameter movedDispatchParameter = irSimpleFunction.getParameters().get(0);
            boolean bl = Intrinsics.areEqual((Object)movedDispatchParameter.getOrigin(), (Object)IrDeclarationOrigin.Companion.getMOVED_DISPATCH_RECEIVER());
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-AddContinuationLowering$createStaticSuspendImpl$22 = false;
                String $i$a$-assert-AddContinuationLowering$createStaticSuspendImpl$22 = "MOVED_DISPATCH_RECEIVER should be the first parameter in " + RenderIrElementKt.render$default(irSimpleFunction, null, 1, null);
                throw new AssertionError((Object)$i$a$-assert-AddContinuationLowering$createStaticSuspendImpl$22);
            }
            IrBody irBody = irSimpleFunction.getBody();
            Intrinsics.checkNotNull((Object)irBody);
            IrElementTransformerVoidKt.transformChildrenVoid(irBody, new IrElementTransformerVoid(irFunction, movedDispatchParameter, this){
                final /* synthetic */ IrSimpleFunction $irFunction;
                final /* synthetic */ IrValueParameter $movedDispatchParameter;
                final /* synthetic */ AddContinuationLowering this$0;
                {
                    this.$irFunction = $irFunction;
                    this.$movedDispatchParameter = $movedDispatchParameter;
                    this.this$0 = $receiver;
                }

                public IrExpression visitGetValue(IrGetValue expression2) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrValueDeclaration owner = expression2.getSymbol().getOwner();
                    if (owner instanceof IrValueParameter && this.isInstanceReceiverOfOuterClass((IrValueParameter)owner)) {
                        IrClass cursor = IrUtilsKt.getParentAsClass(this.$irFunction);
                        IrExpression value2 = BuildersKt.IrGetValueImpl$default(expression2.getStartOffset(), expression2.getEndOffset(), this.$movedDispatchParameter.getSymbol(), null, 8, null);
                        while (!Intrinsics.areEqual((Object)cursor, (Object)((IrValueParameter)owner).getParent())) {
                            IrField outerThisField = this.this$0.getContext().getInnerClassesSupport().getOuterThisField(cursor);
                            value2 = BuildersKt.IrGetFieldImpl$default(expression2.getStartOffset(), expression2.getEndOffset(), outerThisField.getSymbol(), outerThisField.getType(), value2, null, null, 96, null);
                            cursor = IrUtilsKt.getParentAsClass(cursor);
                        }
                        return value2;
                    }
                    return super.visitGetValue(expression2);
                }

                private final boolean isInstanceReceiverOfOuterClass(IrValueParameter param) {
                    if (!Intrinsics.areEqual((Object)param.getOrigin(), (Object)IrDeclarationOrigin.Companion.getINSTANCE_RECEIVER())) {
                        return false;
                    }
                    if (!(param.getParent() instanceof IrClass)) {
                        return false;
                    }
                    IrDeclarationParent cursor = IrUtilsKt.getParentAsClass(this.$irFunction).getParent();
                    while (cursor instanceof IrClass) {
                        if (Intrinsics.areEqual((Object)cursor, (Object)param.getParent())) {
                            return true;
                        }
                        cursor = ((IrClass)cursor).getParent();
                    }
                    return false;
                }
            });
        }
        IrDeclarationsKt.copyAttributes$default(irSimpleFunction, irFunction, false, 2, null);
        IrBuilderWithScope $this$irBlockBody_u24default$iv = LowerUtilsKt.createIrBuilder$default(this.getContext(), (IrSymbol)irFunction.getSymbol(), 0, 0, 6, null);
        int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
        boolean $i$f$irBlockBody = false;
        IrBlockBodyBuilder irBlockBodyBuilder = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
        boolean $i$f$blockBody = false;
        void var9_11 = this_$iv$iv;
        IrSimpleFunction irSimpleFunction2 = irFunction;
        boolean bl = false;
        IrFunctionAccessExpression irFunctionAccessExpression2 = irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilder)$this$createStaticSuspendImpl_u24lambda_u241, irSimpleFunction);
        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$createStaticSuspendImpl_u24lambda_u241;
        void var14_17 = $this$createStaticSuspendImpl_u24lambda_u241;
        boolean bl2 = false;
        int n2 = ((Collection)irFunction.getTypeParameters()).size();
        for (int i2 = 0; i2 < n2; ++i2) {
            it.getTypeArguments().set(i2, $this$createStaticSuspendImpl_u24lambda_u241.getContext().getIrBuiltIns().getAnyNType());
        }
        List i2 = it.getArguments();
        Collection other$iv = irFunction.getParameters();
        boolean $i$f$assignFrom = false;
        $this$assignFrom$iv.clear();
        if ($this$assignFrom$iv instanceof ArrayList) {
            ((ArrayList)$this$assignFrom$iv).ensureCapacity(other$iv.size());
        }
        Iterable iterable = other$iv;
        Collection destination$iv$iv = (Collection)$this$assignFrom$iv;
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            IrValueDeclaration irValueDeclaration = (IrValueDeclaration)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(ExpressionHelpersKt.irGet((IrBuilder)$this$createStaticSuspendImpl_u24lambda_u241, (IrValueDeclaration)p0));
        }
        Unit unit = Unit.INSTANCE;
        var14_17.unaryPlus(ExpressionHelpersKt.irReturn(irBuilderWithScope, irFunctionAccessExpression));
        irSimpleFunction2.setBody(this_$iv$iv.doBuild());
        JvmIrAttributesKt.setStaticSuspendImplMethod(irFunction, irSimpleFunction);
        return irSimpleFunction;
    }

    private final void addContinuationObjectAndContinuationParameterToSuspendFunctions(IrFile irFile) {
        irFile.accept(new IrElementTransformerVoid(this){
            final /* synthetic */ AddContinuationLowering this$0;
            {
                this.this$0 = $receiver;
            }

            public IrStatement visitClass(IrClass declaration) {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                TransformKt.transformDeclarationsFlat(declaration, (Function1<? super IrDeclaration, ? extends List<? extends IrDeclaration>>)((Function1)arg_0 -> addContinuationObjectAndContinuationParameterToSuspendFunctions.1.visitClass$lambda$0(this, arg_0)));
                return declaration;
            }

            public IrExpression visitRichFunctionReference(IrRichFunctionReference expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrSimpleFunction function2 = expression2.getInvokeFunction();
                if (function2.isSuspend()) {
                    expression2.setInvokeFunction((IrSimpleFunction)CollectionsKt.single(this.transformToView(function2)));
                    return expression2;
                }
                return super.visitRichFunctionReference(expression2);
            }

            /*
             * WARNING - void declaration
             */
            private final List<IrSimpleFunction> transformToView(IrSimpleFunction function2) {
                void $this$transformToView_u24lambda_u246;
                void this_$iv$iv;
                void $this$irBlockBody_u24default$iv;
                IrSimpleFunction irSimpleFunction;
                Object $this$buildFun$iv;
                Object $this$transformToView_u24lambda_u243;
                Object newType;
                IrFactory $this$filterTo$iv$iv;
                void $this$filter$iv;
                IrSimpleFunction viewForOriginal;
                Object originalForDefaultImplBridge;
                function2.accept(this, null);
                boolean capturesCrossinline = this.isCapturingCrossinline(function2);
                IrSimpleFunction view = AddContinuationLoweringKt.access$suspendFunctionViewOrStub(function2, this.this$0.getContext());
                IrSimpleFunction irSimpleFunction2 = JvmCachedDeclarationsKt.getOriginalFunctionForDefaultImpl(function2);
                if (irSimpleFunction2 != null) {
                    originalForDefaultImplBridge = irSimpleFunction2;
                    boolean bl = false;
                    viewForOriginal = JvmIrAttributesKt.getViewOfOriginalSuspendFunction(JvmIrUtilsKt.suspendFunctionOriginal((IrSimpleFunction)originalForDefaultImplBridge));
                    if (viewForOriginal != null) {
                        JvmCachedDeclarationsKt.setOriginalFunctionForDefaultImpl(view, viewForOriginal);
                    }
                }
                IrValueParameter continuationParameter = JvmIrCoroutineUtilsKt.continuationParameter(view);
                originalForDefaultImplBridge = view.getParameters();
                Object object = function2.getParameters();
                boolean $i$f$filter22 = false;
                viewForOriginal = $this$filter$iv;
                Object destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                Object object2 = $this$filterTo$iv$iv.iterator();
                while (object2.hasNext()) {
                    T element$iv$iv = object2.next();
                    IrValueParameter it = (IrValueParameter)element$iv$iv;
                    boolean bl = false;
                    if (!(!Intrinsics.areEqual((Object)it, (Object)continuationParameter))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Map parameterMap = MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)object, (Iterable)((List)destination$iv$iv)));
                view.setBody(IrInlineUtilsKt.moveBodyTo(function2, view, parameterMap));
                Object[] $i$f$filter22 = new IrSimpleFunction[]{view};
                List result2 = CollectionsKt.mutableListOf((Object[])$i$f$filter22);
                if (function2.getBody() == null || !JvmIrCoroutineUtilsKt.hasContinuation(function2)) {
                    return result2;
                }
                if (Intrinsics.areEqual((Object)IrUtilsKt.getParentAsClass(function2).getOrigin(), (Object)JvmLoweredDeclarationOrigin.INSTANCE.getLAMBDA_IMPL()) || Intrinsics.areEqual((Object)IrUtilsKt.getParentAsClass(function2).getOrigin(), (Object)JvmLoweredDeclarationOrigin.INSTANCE.getFUNCTION_REFERENCE_IMPL())) {
                    StringBuilder stringBuilder = new StringBuilder();
                    Type type = JvmIrAttributesKt.getLocalClassType(IrUtilsKt.getParentAsClass(function2));
                    Intrinsics.checkNotNull((Object)type);
                    newType = Type.getObjectType(stringBuilder.append(type.getInternalName()).append('$').append(function2.getName()).append("$1").toString());
                    JvmIrAttributesKt.setLocalClassType(function2, (Type)newType);
                }
                if (capturesCrossinline || function2.isInline()) {
                    DescriptorVisibility descriptorVisibility;
                    newType = result2;
                    $this$filterTo$iv$iv = this.this$0.getContext().getIrFactory();
                    destination$iv$iv = this.this$0;
                    boolean $i$f$buildFun = false;
                    IrFunctionBuilder $this$buildFun_u24lambda_u240$iv = new IrFunctionBuilder();
                    boolean bl = false;
                    $this$transformToView_u24lambda_u243 = $this$buildFun_u24lambda_u240$iv;
                    boolean bl2 = false;
                    ((IrFunctionBuilder)$this$transformToView_u24lambda_u243).setContainerSource(view.getContainerSource());
                    Name name2 = Name.identifier(MethodSignatureMapper.mapFunctionName$default(((SuspendLoweringUtils)destination$iv$iv).getContext().getDefaultMethodSignatureMapper(), view, false, 2, null) + "$$forInline");
                    Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
                    ((IrDeclarationBuilder)$this$transformToView_u24lambda_u243).setName(name2);
                    ((IrFunctionBuilder)$this$transformToView_u24lambda_u243).setReturnType(view.getReturnType());
                    ((IrFunctionBuilder)$this$transformToView_u24lambda_u243).setModality(view.getModality());
                    ((IrFunctionBuilder)$this$transformToView_u24lambda_u243).setSuspend(view.isSuspend());
                    ((IrFunctionBuilder)$this$transformToView_u24lambda_u243).setInline(view.isInline());
                    if (view.isInline()) {
                        DescriptorVisibility descriptorVisibility2 = DescriptorVisibilities.PRIVATE;
                        descriptorVisibility = descriptorVisibility2;
                        Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility2, (String)"PRIVATE");
                    } else {
                        descriptorVisibility = view.getVisibility();
                    }
                    ((IrDeclarationBuilder)$this$transformToView_u24lambda_u243).setVisibility(descriptorVisibility);
                    ((IrDeclarationBuilder)$this$transformToView_u24lambda_u243).setOrigin(view.isInline() ? (IrDeclarationOrigin)JvmLoweredDeclarationOrigin.INSTANCE.getFOR_INLINE_STATE_MACHINE_TEMPLATE() : (IrDeclarationOrigin)JvmLoweredDeclarationOrigin.INSTANCE.getFOR_INLINE_STATE_MACHINE_TEMPLATE_CAPTURES_CROSSINLINE());
                    $this$buildFun$iv = DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv, $this$buildFun_u24lambda_u240$iv);
                    destination$iv$iv = this.this$0;
                    Object $this$transformToView_u24lambda_u244 = $this$buildFun$iv;
                    boolean bl3 = false;
                    IrUtilsKt.copyAnnotationsFrom((IrMutableAnnotationContainer)$this$transformToView_u24lambda_u244, view);
                    IrUtilsKt.copyValueAndTypeParametersFrom((IrFunction)$this$transformToView_u24lambda_u244, view);
                    ((SuspendLoweringUtils)destination$iv$iv).getContext().remapMultiFieldValueClassStructure(view, (IrFunction)$this$transformToView_u24lambda_u244, null);
                    IrDeclarationsKt.copyAttributes$default((IrElement)$this$transformToView_u24lambda_u244, view, false, 2, null);
                    ((SuspendLoweringUtils)destination$iv$iv).generateErrorForInlineBody((IrSimpleFunction)$this$transformToView_u24lambda_u244);
                    JvmIrAttributesKt.setOriginalOfSuspendForInline((IrFunction)$this$transformToView_u24lambda_u244, view);
                    newType.add($this$buildFun$iv);
                }
                if (IrUtilsKt.isOverridable(function2)) {
                    $this$buildFun$iv = AddContinuationLowering.access$createStaticSuspendImpl(this.this$0, view);
                    IrSimpleFunction it = $this$buildFun$iv;
                    boolean bl = false;
                    ((Collection)result2).add(it);
                    irSimpleFunction = $this$buildFun$iv;
                } else {
                    irSimpleFunction = view;
                }
                IrSimpleFunction newFunction = irSimpleFunction;
                $this$buildFun$iv = LowerUtilsKt.createIrBuilder$default(this.this$0.getContext(), (IrSymbol)newFunction.getSymbol(), 0, 0, 6, null);
                object2 = this.this$0;
                int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
                int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
                boolean $i$f$irBlockBody = false;
                $this$transformToView_u24lambda_u243 = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
                boolean $i$f$blockBody = false;
                void var15_22 = this_$iv$iv;
                object = newFunction;
                boolean bl = false;
                $this$transformToView_u24lambda_u246.unaryPlus(AddContinuationLowering.access$generateContinuationClassForNamedFunction((AddContinuationLowering)object2, newFunction, view.getDispatchReceiverParameter(), function2, capturesCrossinline));
                if (((SuspendLoweringUtils)object2).getContext().getConfig().getEnhancedCoroutinesDebugging()) {
                    for (IrSimpleFunctionSymbol fakeInlineFunction : IrUtilsKt.getFunctions(((SuspendLoweringUtils)object2).getContext().getSymbols().getGeneratedCodeMarkersInCoroutinesClass())) {
                        $this$transformToView_u24lambda_u246.unaryPlus(ExpressionHelpersKt.irCall((IrBuilder)$this$transformToView_u24lambda_u246, fakeInlineFunction));
                    }
                }
                if (newFunction.getBody() instanceof IrExpressionBody) {
                    IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$transformToView_u24lambda_u246;
                    IrBody irBody = newFunction.getBody();
                    Intrinsics.checkNotNull((Object)irBody);
                    IrStatement irStatement = IrUtilsKt.getStatements(irBody).get(0);
                    Intrinsics.checkNotNull((Object)irStatement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
                    $this$transformToView_u24lambda_u246.unaryPlus(ExpressionHelpersKt.irReturn(irBuilderWithScope, (IrExpression)irStatement));
                } else {
                    IrBody irBody = newFunction.getBody();
                    Intrinsics.checkNotNull((Object)irBody);
                    for (IrStatement statement : IrUtilsKt.getStatements(irBody)) {
                        $this$transformToView_u24lambda_u246.unaryPlus(statement);
                    }
                }
                ((IrFunction)object).setBody(this_$iv$iv.doBuild());
                return result2;
            }

            private final boolean isCapturingCrossinline(IrSimpleFunction $this$isCapturingCrossinline) {
                Ref.BooleanRef capturesCrossinline = new Ref.BooleanRef();
                IrVisitorsKt.acceptVoid((IrElement)$this$isCapturingCrossinline, new IrVisitorVoid(capturesCrossinline){
                    final /* synthetic */ Ref.BooleanRef $capturesCrossinline;
                    {
                        this.$capturesCrossinline = $capturesCrossinline;
                    }

                    public void visitElement(IrElement element) {
                        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                        IrVisitorsKt.acceptChildrenVoid(element, this);
                    }

                    public void visitFieldAccess(IrFieldAccessExpression expression2) {
                        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                        if (Intrinsics.areEqual((Object)((IrField)expression2.getSymbol().getOwner()).getOrigin(), (Object)LocalDeclarationsLowering.Companion.getDECLARATION_ORIGIN_FIELD_FOR_CROSSINLINE_CAPTURED_VALUE())) {
                            this.$capturesCrossinline.element = true;
                            return;
                        }
                        super.visitFieldAccess(expression2);
                    }

                    public void visitClass(IrClass declaration) {
                        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                    }
                });
                return capturesCrossinline.element;
            }

            private static final List visitClass$lambda$0(addContinuationObjectAndContinuationParameterToSuspendFunctions.1 this$0, IrDeclaration it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (it instanceof IrSimpleFunction && ((IrSimpleFunction)it).isSuspend()) {
                    return this$0.transformToView((IrSimpleFunction)it);
                }
                it.accept(this$0, null);
                return null;
            }
        }, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit addInvokeSuspendForNamedFunction$lambda$1(IrField $resultField, IrField $labelField, IrFunction $irFunction, IrClass $this_addInvokeSuspendForNamedFunction, IrField $capturedThisField, boolean $isStaticSuspendImpl, JvmBackendContext $backendContext, IrBlockBodyBuilder $this$addFunctionOverride, IrFunction function2) {
        IrGetFieldImpl irGetFieldImpl;
        void it;
        void $this$single$iv;
        Intrinsics.checkNotNullParameter((Object)$this$addFunctionOverride, (String)"$this$addFunctionOverride");
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        IrBuilder irBuilder = $this$addFunctionOverride;
        IrBuilder irBuilder2 = $this$addFunctionOverride;
        IrValueParameter irValueParameter = function2.getDispatchReceiverParameter();
        Intrinsics.checkNotNull((Object)irValueParameter);
        $this$addFunctionOverride.unaryPlus(ExpressionHelpersKt.irSetField$default(irBuilder, ExpressionHelpersKt.irGet(irBuilder2, irValueParameter), $resultField, ExpressionHelpersKt.irGet($this$addFunctionOverride, (IrValueDeclaration)CollectionsKt.first(IrUtilsKt.getNonDispatchParameters(function2))), null, 8, null));
        int signBit = Integer.MIN_VALUE;
        IrBuilder irBuilder3 = $this$addFunctionOverride;
        IrBuilder irBuilder4 = $this$addFunctionOverride;
        IrValueParameter irValueParameter2 = function2.getDispatchReceiverParameter();
        Intrinsics.checkNotNull((Object)irValueParameter2);
        Object object = IrUtilsKt.getFunctions($this$addFunctionOverride.getContext().getIrBuiltIns().getIntClass());
        IrBuilder irBuilder5 = $this$addFunctionOverride;
        IrField irField = $labelField;
        IrExpression irExpression = ExpressionHelpersKt.irGet(irBuilder4, irValueParameter2);
        IrBuilder irBuilder6 = irBuilder3;
        IrBlockBodyBuilder irBlockBodyBuilder = $this$addFunctionOverride;
        boolean $i$f$single22 = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            IrSimpleFunctionSymbol it2 = (IrSimpleFunctionSymbol)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)((IrSimpleFunction)it2.getOwner()).getName(), (Object)OperatorNameConventions.OR)) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        Object var23_30 = single$iv;
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = var23_30;
        IrType irType = $this$addFunctionOverride.getContext().getIrBuiltIns().getIntType();
        IrBuilder irBuilder7 = $this$addFunctionOverride;
        IrBuilder irBuilder8 = $this$addFunctionOverride;
        IrValueParameter irValueParameter3 = function2.getDispatchReceiverParameter();
        Intrinsics.checkNotNull((Object)irValueParameter3);
        irBlockBodyBuilder.unaryPlus(ExpressionHelpersKt.irSetField$default(irBuilder6, irExpression, irField, ExpressionHelpersKt.irCallOp$default(irBuilder5, irSimpleFunctionSymbol, irType, ExpressionHelpersKt.irGetField$default(irBuilder7, ExpressionHelpersKt.irGet(irBuilder8, irValueParameter3), $labelField, null, 4, null), ExpressionHelpersKt.irInt$default($this$addFunctionOverride, signBit, null, 2, null), null, 16, null), null, 8, null));
        Object $i$f$single22 = object = ExpressionHelpersKt.irCall((IrBuilder)$this$addFunctionOverride, $irFunction);
        irBuilder6 = $this$addFunctionOverride;
        irBlockBodyBuilder = $this$addFunctionOverride;
        boolean bl = false;
        int n2 = ((Collection)$irFunction.getTypeParameters()).size();
        for (int i2 = 0; i2 < n2; ++i2) {
            it.getTypeArguments().set(i2, IrTypesKt.getDefaultType($this_addInvokeSuspendForNamedFunction.getTypeParameters().get(i2)));
        }
        IrField irField2 = $capturedThisField;
        if (irField2 != null) {
            IrField irField3 = irField2;
            boolean bl2 = false;
            IrBuilder irBuilder9 = $this$addFunctionOverride;
            IrBuilder irBuilder10 = $this$addFunctionOverride;
            IrValueParameter irValueParameter4 = function2.getDispatchReceiverParameter();
            Intrinsics.checkNotNull((Object)irValueParameter4);
            irGetFieldImpl = ExpressionHelpersKt.irGetField$default(irBuilder9, ExpressionHelpersKt.irGet(irBuilder10, irValueParameter4), irField3, null, 4, null);
        } else {
            irGetFieldImpl = null;
        }
        IrGetFieldImpl capturedThisValue = irGetFieldImpl;
        for (IrValueParameter parameter : $irFunction.getParameters()) {
            IrExpression irExpression2;
            IrMemberAccessExpression.ValueArgumentsList valueArgumentsList = it.getArguments();
            switch (WhenMappings.$EnumSwitchMapping$0[parameter.getKind().ordinal()]) {
                case 1: {
                    irExpression2 = capturedThisValue;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    IrValueParameter irValueParameter5 = parameter;
                    if (Intrinsics.areEqual((Object)irValueParameter5, (Object)CollectionsKt.first($irFunction.getParameters())) && $isStaticSuspendImpl) {
                        irExpression2 = capturedThisValue;
                        break;
                    }
                    if (Intrinsics.areEqual((Object)irValueParameter5, (Object)CollectionsKt.last($irFunction.getParameters()))) {
                        IrValueParameter irValueParameter6 = function2.getDispatchReceiverParameter();
                        Intrinsics.checkNotNull((Object)irValueParameter6);
                        irExpression2 = BuildersKt.IrGetValueImpl$default(-1, -1, irValueParameter6.getSymbol(), null, 8, null);
                        break;
                    }
                    irExpression2 = JvmIrTypeUtilsKt.defaultValue(parameter.getType(), -1, -1, $backendContext);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            valueArgumentsList.set(parameter, irExpression2);
        }
        irExpression = Unit.INSTANCE;
        irBlockBodyBuilder.unaryPlus(ExpressionHelpersKt.irReturn((IrBuilderWithScope)irBuilder6, (IrExpression)object));
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ IrSimpleFunction access$createStaticSuspendImpl(AddContinuationLowering $this, IrSimpleFunction irFunction) {
        return $this.createStaticSuspendImpl(irFunction);
    }

    public static final /* synthetic */ IrClass access$generateContinuationClassForNamedFunction(AddContinuationLowering $this, IrFunction irFunction, IrValueParameter dispatchReceiverParameter, IrElement attributeContainer, boolean capturesCrossinline) {
        return $this.generateContinuationClassForNamedFunction(irFunction, dispatchReceiverParameter, attributeContainer, capturesCrossinline);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IrParameterKind.values().length];
            try {
                nArray[IrParameterKind.DispatchReceiver.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrParameterKind.Context.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrParameterKind.ExtensionReceiver.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrParameterKind.Regular.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

