/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.stub.file;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiler.psi.text.IncompatibleAbiVersionKt;
import org.jetbrains.kotlin.analysis.decompiler.stub.ClsStubBuilderComponents;
import org.jetbrains.kotlin.analysis.decompiler.stub.ClsStubBuilderContext;
import org.jetbrains.kotlin.analysis.decompiler.stub.ClsStubBuildingKt;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.AnnotationLoaderForClassFileStubBuilder;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.ClsClassFinder;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.ClsKotlinBinaryClassCache;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.DirectoryBasedClassFinder;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.DirectoryBasedDataFinder;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.compiled.ClsStubBuilder;
import org.jetbrains.kotlin.com.intellij.psi.stubs.PsiFileStub;
import org.jetbrains.kotlin.com.intellij.util.indexing.FileContent;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinarySourceElement;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.metadata.deserialization.Flags;
import org.jetbrains.kotlin.metadata.deserialization.MetadataVersion;
import org.jetbrains.kotlin.metadata.deserialization.NameResolver;
import org.jetbrains.kotlin.metadata.deserialization.TypeTable;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmNameResolver;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmProtoBufUtil;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.serialization.deserialization.builtins.BuiltInSerializerProtocol;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0016\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J(\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\rR\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinClsStubBuilder;", "Lorg/jetbrains/kotlin/com/intellij/psi/compiled/ClsStubBuilder;", "<init>", "()V", "getStubVersion", "", "buildFileStub", "Lorg/jetbrains/kotlin/com/intellij/psi/stubs/PsiFileStub;", "content", "Lorg/jetbrains/kotlin/com/intellij/util/indexing/FileContent;", "doBuildFileStub", "Lorg/jetbrains/kotlin/psi/KtFile;", "file", "Lorg/jetbrains/kotlin/com/intellij/openapi/vfs/VirtualFile;", "fileContent", "", "createStubBuilderComponents", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/ClsStubBuilderComponents;", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "metadataVersion", "Lorg/jetbrains/kotlin/metadata/deserialization/MetadataVersion;", "LOG", "Lorg/jetbrains/kotlin/com/intellij/openapi/diagnostic/Logger;", "VERSIONED_PATH_MARKER", "", "isVersioned", "", "virtualFile", "decompiler-to-file-stubs"})
@SourceDebugExtension(value={"SMAP\nKotlinClsStubBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinClsStubBuilder.kt\norg/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinClsStubBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,264:1\n1#2:265\n11#3:266\n*S KotlinDebug\n*F\n+ 1 KotlinClsStubBuilder.kt\norg/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinClsStubBuilder\n*L\n134#1:266\n*E\n"})
public final class KotlinClsStubBuilder
extends ClsStubBuilder {
    @NotNull
    public static final KotlinClsStubBuilder INSTANCE = new KotlinClsStubBuilder();
    @NotNull
    private static final Logger LOG;

    private KotlinClsStubBuilder() {
    }

    @Override
    public int getStubVersion() {
        return 181;
    }

    @Override
    @Nullable
    public PsiFileStub<?> buildFileStub(@NotNull FileContent content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        VirtualFile virtualFile = content.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        VirtualFile virtualFile2 = virtualFile;
        if (ClsClassFinder.isKotlinInternalCompiledFile$default(ClsClassFinder.INSTANCE, virtualFile2, content.getContent(), null, 4, null)) {
            return null;
        }
        if (this.isVersioned(virtualFile2)) {
            return null;
        }
        byte[] byArray = content.getContent();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getContent(...)");
        return this.doBuildFileStub(virtualFile2, byArray);
    }

    private final PsiFileStub<KtFile> doBuildFileStub(VirtualFile file, byte[] fileContent) {
        PsiFileStub psiFileStub;
        FqName packageFqName;
        FqName fqName;
        KotlinJvmBinaryClass kotlinJvmBinaryClass = ClsKotlinBinaryClassCache.Companion.getInstance().getKotlinBinaryClass(file, fileContent);
        if (kotlinJvmBinaryClass == null) {
            throw new IllegalStateException(("Can't find binary class for Kotlin file: " + file).toString());
        }
        KotlinJvmBinaryClass kotlinClass = kotlinJvmBinaryClass;
        KotlinClassHeader header = kotlinClass.getClassHeader();
        ClassId classId = kotlinClass.getClassId();
        String string = header.getPackageName();
        if (string != null) {
            String it = string;
            boolean bl = false;
            fqName = new FqName(it);
        } else {
            fqName = packageFqName = classId.getPackageFqName();
        }
        if (!header.getMetadataVersion().isCompatibleWithCurrentCompilerVersion()) {
            return ClsStubBuildingKt.createIncompatibleAbiVersionFileStub(IncompatibleAbiVersionKt.createIncompatibleMetadataVersionDecompiledText((BinaryVersion)header.getMetadataVersion()));
        }
        ClsStubBuilderComponents components = this.createStubBuilderComponents(file, packageFqName, fileContent, header.getMetadataVersion());
        if (header.getKind() == KotlinClassHeader.Kind.MULTIFILE_CLASS) {
            List<KotlinJvmBinaryClass> partFiles = ClsClassFinder.INSTANCE.findMultifileClassParts(file, classId, header.getMultifilePartNames());
            return ClsStubBuildingKt.createMultifileClassStub(packageFqName, partFiles, classId.asSingleFqName(), components);
        }
        String[] annotationData = header.getData();
        if (annotationData == null) {
            LOG.error("Corrupted kotlin header for file " + file.getName());
            return null;
        }
        String[] strings2 = header.getStrings();
        if (strings2 == null) {
            LOG.error("String table not found in file " + file.getName());
            return null;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[header.getKind().ordinal()]) {
            case 1: {
                if (classId.isLocal()) {
                    return null;
                }
                Pair<JvmNameResolver, ProtoBuf.Class> pair = JvmProtoBufUtil.readClassDataFrom(annotationData, strings2);
                JvmNameResolver nameResolver = (JvmNameResolver)pair.component1();
                ProtoBuf.Class classProto = (ProtoBuf.Class)pair.component2();
                if (Flags.VISIBILITY.get(classProto.getFlags()) == ProtoBuf.Visibility.LOCAL) {
                    return null;
                }
                NameResolver nameResolver2 = nameResolver;
                ProtoBuf.TypeTable typeTable = classProto.getTypeTable();
                Intrinsics.checkNotNullExpressionValue((Object)typeTable, (String)"getTypeTable(...)");
                ClsStubBuilderContext context2 = components.createContext(nameResolver2, packageFqName, new TypeTable(typeTable));
                psiFileStub = ClsStubBuildingKt.createTopLevelClassStub(classId, classProto, new KotlinJvmBinarySourceElement(kotlinClass, null, null, null, 14, null), context2, header.isScript());
                break;
            }
            case 2: 
            case 3: {
                Pair<JvmNameResolver, ProtoBuf.Package> pair = JvmProtoBufUtil.readPackageDataFrom(annotationData, strings2);
                JvmNameResolver nameResolver = (JvmNameResolver)pair.component1();
                ProtoBuf.Package packageProto = (ProtoBuf.Package)pair.component2();
                NameResolver nameResolver3 = nameResolver;
                ProtoBuf.TypeTable typeTable = packageProto.getTypeTable();
                Intrinsics.checkNotNullExpressionValue((Object)typeTable, (String)"getTypeTable(...)");
                ClsStubBuilderContext context3 = components.createContext(nameResolver3, packageFqName, new TypeTable(typeTable));
                FqName facadeFqName = packageFqName.child(classId.getShortClassName());
                psiFileStub = ClsStubBuildingKt.createFileFacadeStub(packageFqName, packageProto, facadeFqName, classId.asSingleFqName(), context3);
                break;
            }
            default: {
                throw new IllegalStateException("Should have processed " + file.getPath() + " with header " + header);
            }
        }
        return psiFileStub;
    }

    private final ClsStubBuilderComponents createStubBuilderComponents(VirtualFile file, FqName packageFqName, byte[] fileContent, MetadataVersion metadataVersion) {
        VirtualFile virtualFile = file.getParent();
        Intrinsics.checkNotNull((Object)virtualFile);
        DirectoryBasedClassFinder classFinder = new DirectoryBasedClassFinder(virtualFile, packageFqName);
        DirectoryBasedDataFinder classDataFinder = new DirectoryBasedDataFinder(classFinder, LOG, metadataVersion);
        AnnotationLoaderForClassFileStubBuilder annotationLoader = new AnnotationLoaderForClassFileStubBuilder(classFinder, file, fileContent, metadataVersion);
        return new ClsStubBuilderComponents(classDataFinder, annotationLoader, file, BuiltInSerializerProtocol.INSTANCE, classFinder, metadataVersion);
    }

    public final boolean isVersioned(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        String string = virtualFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return StringsKt.contains$default((CharSequence)string, (CharSequence)"!/META-INF/versions/", (boolean)false, (int)2, null);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(KotlinClsStubBuilder.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[KotlinClassHeader.Kind.values().length];
            try {
                nArray[KotlinClassHeader.Kind.CLASS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinClassHeader.Kind.FILE_FACADE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinClassHeader.Kind.MULTIFILE_CLASS_PART.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

