/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.library.impl;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.konan.file.File;
import org.jetbrains.kotlin.library.KotlinLibraryVersioning;
import org.jetbrains.kotlin.library.SerializedIrModule;
import org.jetbrains.kotlin.library.impl.BuiltInsPlatform;
import org.jetbrains.kotlin.library.impl.IrWriterImpl;
import org.jetbrains.kotlin.library.impl.KotlinLibraryLayoutForWriter;
import org.jetbrains.kotlin.library.impl.KotlinLibraryWriterImpl;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n\u00a2\u0006\u0002\u0010\u000bJ6\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n2\u0006\u0010\u0015\u001a\u00020\u0011H\u0002J\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/library/impl/KotlinLibraryOnlyIrWriter;", "", "output", "", "moduleName", "versions", "Lorg/jetbrains/kotlin/library/KotlinLibraryVersioning;", "platform", "Lorg/jetbrains/kotlin/library/impl/BuiltInsPlatform;", "nativeTargets", "", "(Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/kotlin/library/KotlinLibraryVersioning;Lorg/jetbrains/kotlin/library/impl/BuiltInsPlatform;Ljava/util/List;)V", "library", "Lorg/jetbrains/kotlin/library/impl/KotlinLibraryWriterImpl;", "getLibrary", "()Lorg/jetbrains/kotlin/library/impl/KotlinLibraryWriterImpl;", "outputDir", "Lorg/jetbrains/kotlin/konan/file/File;", "getOutputDir", "()Lorg/jetbrains/kotlin/konan/file/File;", "createLibrary", "directory", "invalidate", "", "writeIr", "serializedIrModule", "Lorg/jetbrains/kotlin/library/SerializedIrModule;", "kotlin-util-klib"})
public final class KotlinLibraryOnlyIrWriter {
    @NotNull
    private final File outputDir;
    @NotNull
    private final KotlinLibraryWriterImpl library;

    public KotlinLibraryOnlyIrWriter(@NotNull String output2, @NotNull String moduleName2, @NotNull KotlinLibraryVersioning versions2, @NotNull BuiltInsPlatform platform, @NotNull List<String> nativeTargets) {
        Intrinsics.checkNotNullParameter((Object)output2, (String)"output");
        Intrinsics.checkNotNullParameter((Object)moduleName2, (String)"moduleName");
        Intrinsics.checkNotNullParameter((Object)versions2, (String)"versions");
        Intrinsics.checkNotNullParameter((Object)((Object)platform), (String)"platform");
        Intrinsics.checkNotNullParameter(nativeTargets, (String)"nativeTargets");
        this.outputDir = new File(output2);
        this.library = this.createLibrary(moduleName2, versions2, platform, nativeTargets, this.outputDir);
    }

    @NotNull
    public final File getOutputDir() {
        return this.outputDir;
    }

    @NotNull
    public final KotlinLibraryWriterImpl getLibrary() {
        return this.library;
    }

    private final KotlinLibraryWriterImpl createLibrary(String moduleName2, KotlinLibraryVersioning versions2, BuiltInsPlatform platform, List<String> nativeTargets, File directory) {
        KotlinLibraryLayoutForWriter layout = new KotlinLibraryLayoutForWriter(directory, directory, null, 4, null);
        IrWriterImpl irWriter = new IrWriterImpl(layout);
        return new KotlinLibraryWriterImpl(moduleName2, versions2, platform, nativeTargets, true, null, layout, null, null, irWriter, 416, null);
    }

    public final void invalidate() {
        this.outputDir.deleteRecursively();
        this.library.getLayout().getMainIr().getDir().mkdirs();
    }

    public final void writeIr(@NotNull SerializedIrModule serializedIrModule) {
        Intrinsics.checkNotNullParameter((Object)serializedIrModule, (String)"serializedIrModule");
        this.library.addIr(serializedIrModule);
    }
}

