/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.backend.ast;

import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsVisitor;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContext;
import org.jetbrains.kotlin.js.backend.ast.metadata.HasMetadata;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0004\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\n\u0010\u000e\u001a\u00020\u000fH\u0096\u0080\u0004J\u001c\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/js/backend/ast/JsBigIntLiteral;", "Lorg/jetbrains/kotlin/js/backend/ast/JsLiteral$JsValueLiteral;", "value", "Ljava/math/BigInteger;", "<init>", "(Ljava/math/BigInteger;)V", "", "(J)V", "getValue", "()Ljava/math/BigInteger;", "accept", "", "visitor", "Lorg/jetbrains/kotlin/js/backend/ast/JsVisitor;", "toString", "", "traverse", "Lorg/jetbrains/kotlin/js/backend/ast/JsVisitorWithContext;", "ctx", "Lorg/jetbrains/kotlin/js/backend/ast/JsContext;", "deepCopy", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "js.ast"})
public final class JsBigIntLiteral
extends JsLiteral.JsValueLiteral {
    @NotNull
    private final BigInteger value;

    public JsBigIntLiteral(@NotNull BigInteger value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.value = value2;
    }

    @NotNull
    public final BigInteger getValue() {
        return this.value;
    }

    public JsBigIntLiteral(long value2) {
        BigInteger bigInteger = BigInteger.valueOf(value2);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"valueOf(...)");
        this(bigInteger);
    }

    @Override
    public void accept(@NotNull JsVisitor visitor2) {
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        visitor2.visitBigInt(this);
    }

    @Override
    @NotNull
    public String toString() {
        String string = this.value.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public void traverse(@NotNull JsVisitorWithContext visitor2, @NotNull JsContext<?> ctx) {
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        visitor2.visit(this, ctx);
        visitor2.endVisit(this, ctx);
    }

    @Override
    @NotNull
    public JsExpression deepCopy() {
        HasMetadata hasMetadata = new JsBigIntLiteral(this.value).withMetadataFrom(this);
        Intrinsics.checkNotNullExpressionValue((Object)hasMetadata, (String)"withMetadataFrom(...)");
        return (JsExpression)hasMetadata;
    }
}

