/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirMustUseReturnValueStatusComponentKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirEnumEntrySymbol;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.resolve.ReturnValueStatus;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\f\u0010\u0002\u001a\u00020\u0003*\u00020\u0004H\u0002\u001a\u0018\u0010\u0005\u001a\u00020\u0003*\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0010\u0010\t\u001a\u00020\u0003*\u0006\u0012\u0002\b\u00030\u0006H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"JAVA_LANG_VOID", "Lorg/jetbrains/kotlin/name/ClassId;", "isIgnorable", "", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "isExcluded", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "isSubjectToCheck", "checkers"})
public final class FirUnusedReturnValueCheckerKt {
    @NotNull
    private static final ClassId JAVA_LANG_VOID = ClassId.Companion.topLevel(new FqName("java.lang.Void"));

    private static final boolean isIgnorable(ConeKotlinType $this$isIgnorable) {
        if ($this$isIgnorable instanceof ConeErrorType || ConeTypeUtilsKt.hasError($this$isIgnorable)) {
            return true;
        }
        ClassId classId = ConeTypeUtilsKt.getClassId($this$isIgnorable);
        if (classId == null) {
            return false;
        }
        ClassId classId2 = classId;
        if (Intrinsics.areEqual((Object)classId2, (Object)StandardClassIds.INSTANCE.getNothing())) {
            return true;
        }
        if (Intrinsics.areEqual((Object)classId2, (Object)StandardClassIds.INSTANCE.getUnit()) && !ConeTypeUtilsKt.isMarkedNullable($this$isIgnorable)) {
            return true;
        }
        return Intrinsics.areEqual((Object)classId2, (Object)JAVA_LANG_VOID) && !ConeTypeUtilsKt.isMarkedNullable($this$isIgnorable);
    }

    private static final boolean isExcluded(FirCallableSymbol<?> $this$isExcluded, FirSession session) {
        return FirMustUseReturnValueStatusComponentKt.getMustUseReturnValueStatusComponent(session).hasIgnorableLikeAnnotation($this$isExcluded.getResolvedAnnotationClassIds());
    }

    private static final boolean isSubjectToCheck(FirCallableSymbol<?> $this$isSubjectToCheck) {
        if ($this$isSubjectToCheck instanceof FirEnumEntrySymbol) {
            return true;
        }
        return $this$isSubjectToCheck.getResolvedStatus().getReturnValueStatus() == ReturnValueStatus.MustUse;
    }

    public static final /* synthetic */ boolean access$isIgnorable(ConeKotlinType $receiver) {
        return FirUnusedReturnValueCheckerKt.isIgnorable($receiver);
    }

    public static final /* synthetic */ boolean access$isSubjectToCheck(FirCallableSymbol $receiver) {
        return FirUnusedReturnValueCheckerKt.isSubjectToCheck($receiver);
    }

    public static final /* synthetic */ boolean access$isExcluded(FirCallableSymbol $receiver, FirSession session) {
        return FirUnusedReturnValueCheckerKt.isExcluded($receiver, session);
    }
}

