/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl;

import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.com.intellij.injected.editor.DocumentWindow;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.editor.ex.DocumentEx;
import org.jetbrains.kotlin.com.intellij.openapi.fileEditor.FileDocumentManager;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.pom.core.impl.PomModelImpl;
import org.jetbrains.kotlin.com.intellij.pom.tree.events.impl.ChangeInfoImpl;
import org.jetbrains.kotlin.com.intellij.pom.tree.events.impl.TreeChangeEventImpl;
import org.jetbrains.kotlin.com.intellij.pom.tree.events.impl.TreeChangeImpl;
import org.jetbrains.kotlin.com.intellij.psi.IgnorePsiEventsMarker;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiTreeChangeEvent;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiDocumentManagerBase;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiDocumentTransactionListener;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiFileEx;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiTreeChangeEventImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.DummyHolder;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.kotlin.com.intellij.util.ExceptionUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.messages.MessageBus;
import org.jetbrains.kotlin.com.intellij.util.text.CharArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.text.ImmutableCharSequence;

public class PsiToDocumentSynchronizer {
    private static final Logger LOG = Logger.getInstance(PsiToDocumentSynchronizer.class);
    private static final Key<Boolean> PSI_DOCUMENT_ATOMIC_ACTION = Key.create("PSI_DOCUMENT_ATOMIC_ACTION");
    private final PsiDocumentManagerBase myPsiDocumentManager;
    private final MessageBus myBus;
    private final Map<Document, Pair<DocumentChangeTransaction, Integer>> myTransactionsMap;
    private volatile Document mySyncDocument;
    private boolean myIgnorePsiEvents;

    PsiToDocumentSynchronizer(@NotNull PsiDocumentManagerBase psiDocumentManager, @NotNull MessageBus bus) {
        if (psiDocumentManager == null) {
            PsiToDocumentSynchronizer.$$$reportNull$$$0(0);
        }
        if (bus == null) {
            PsiToDocumentSynchronizer.$$$reportNull$$$0(1);
        }
        this.myTransactionsMap = new ConcurrentHashMap<Document, Pair<DocumentChangeTransaction, Integer>>();
        this.myPsiDocumentManager = psiDocumentManager;
        this.myBus = bus;
    }

    @Nullable
    public DocumentChangeTransaction getTransaction(@NotNull Document document) {
        if (document == null) {
            PsiToDocumentSynchronizer.$$$reportNull$$$0(2);
        }
        Pair<DocumentChangeTransaction, Integer> pair = this.myTransactionsMap.get(document);
        return Pair.getFirst(pair);
    }

    public boolean isInSynchronization(@NotNull Document document) {
        if (document == null) {
            PsiToDocumentSynchronizer.$$$reportNull$$$0(3);
        }
        return this.mySyncDocument == document;
    }

    @TestOnly
    void cleanupForNextTest() {
        this.myTransactionsMap.clear();
        this.mySyncDocument = null;
    }

    private void checkPsiModificationAllowed(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            PsiToDocumentSynchronizer.$$$reportNull$$$0(4);
        }
        if (!this.toProcessPsiEvent()) {
            return;
        }
        PsiFile psiFile = event.getFile();
        if (!(psiFile instanceof PsiFileEx) || !((PsiFileEx)psiFile).isContentsLoaded()) {
            return;
        }
        Document document = this.myPsiDocumentManager.getCachedDocument(psiFile);
        if (document != null && this.myPsiDocumentManager.isUncommited(document)) {
            throw new IllegalStateException("Attempt to modify PSI for non-committed Document!");
        }
    }

    private DocumentEx getCachedDocument(PsiFile psiFile, boolean force) {
        DocumentEx document = (DocumentEx)FileDocumentManager.getInstance().getCachedDocument(psiFile.getViewProvider().getVirtualFile());
        if (document == null || document instanceof DocumentWindow || !force && this.getTransaction(document) == null) {
            return null;
        }
        return document;
    }

    private void doSync(@NotNull PsiTreeChangeEvent event, @NotNull DocSyncAction syncAction) {
        if (event == null) {
            PsiToDocumentSynchronizer.$$$reportNull$$$0(5);
        }
        if (syncAction == null) {
            PsiToDocumentSynchronizer.$$$reportNull$$$0(6);
        }
        if (!this.toProcessPsiEvent()) {
            return;
        }
        PsiFile psiFile = event.getFile();
        if (!(psiFile instanceof PsiFileEx) || !((PsiFileEx)psiFile).isContentsLoaded()) {
            return;
        }
        DocumentEx document = this.getCachedDocument(psiFile, true);
        if (document == null) {
            return;
        }
        PsiToDocumentSynchronizer.performAtomically(psiFile, () -> syncAction.syncDocument(document, (PsiTreeChangeEventImpl)event));
        boolean insideTransaction = this.myTransactionsMap.containsKey(document);
        if (!insideTransaction) {
            document.setModificationStamp(psiFile.getViewProvider().getModificationStamp());
        }
    }

    static boolean isInsideAtomicChange(@NotNull PsiFile file) {
        if (file == null) {
            PsiToDocumentSynchronizer.$$$reportNull$$$0(7);
        }
        return file.getUserData(PSI_DOCUMENT_ATOMIC_ACTION) == Boolean.TRUE;
    }

    public static void performAtomically(@NotNull PsiFile file, @NotNull Runnable runnable) {
        if (file == null) {
            PsiToDocumentSynchronizer.$$$reportNull$$$0(8);
        }
        if (runnable == null) {
            PsiToDocumentSynchronizer.$$$reportNull$$$0(9);
        }
        PsiUtilCore.ensureValid(file);
        assert (!PsiToDocumentSynchronizer.isInsideAtomicChange(file));
        file.putUserData(PSI_DOCUMENT_ATOMIC_ACTION, Boolean.TRUE);
        try {
            runnable.run();
        }
        finally {
            file.putUserData(PSI_DOCUMENT_ATOMIC_ACTION, null);
        }
    }

    public void setIgnorePsiEvents(boolean ignorePsiEvents) {
        this.myIgnorePsiEvents = ignorePsiEvents;
    }

    public boolean isIgnorePsiEvents() {
        return this.myIgnorePsiEvents;
    }

    public boolean toProcessPsiEvent() {
        return !this.myIgnorePsiEvents && !this.myPsiDocumentManager.isCommitInProgress() && !ApplicationManager.getApplication().hasWriteAction(IgnorePsiEventsMarker.class);
    }

    @TestOnly
    public void replaceString(@NotNull Document document, int startOffset, int endOffset, @NotNull String s2) {
        DocumentChangeTransaction documentChangeTransaction;
        if (document == null) {
            PsiToDocumentSynchronizer.$$$reportNull$$$0(10);
        }
        if (s2 == null) {
            PsiToDocumentSynchronizer.$$$reportNull$$$0(11);
        }
        if ((documentChangeTransaction = this.getTransaction(document)) != null) {
            documentChangeTransaction.replace(startOffset, endOffset - startOffset, s2, null);
        }
    }

    @TestOnly
    public void insertString(@NotNull Document document, int offset, @NotNull String s2) {
        DocumentChangeTransaction documentChangeTransaction;
        if (document == null) {
            PsiToDocumentSynchronizer.$$$reportNull$$$0(12);
        }
        if (s2 == null) {
            PsiToDocumentSynchronizer.$$$reportNull$$$0(13);
        }
        if ((documentChangeTransaction = this.getTransaction(document)) != null) {
            documentChangeTransaction.replace(offset, 0, s2, null);
        }
    }

    public void startTransaction(@NotNull Project project, @NotNull Document doc, @NotNull PsiFile scope2) {
        Pair<DocumentChangeTransaction, Integer> pair;
        if (project == null) {
            PsiToDocumentSynchronizer.$$$reportNull$$$0(14);
        }
        if (doc == null) {
            PsiToDocumentSynchronizer.$$$reportNull$$$0(15);
        }
        if (scope2 == null) {
            PsiToDocumentSynchronizer.$$$reportNull$$$0(16);
        }
        LOG.assertTrue(!project.isDisposed());
        Pair<DocumentChangeTransaction, Integer> prev = pair = this.myTransactionsMap.get(doc);
        if (pair == null) {
            PsiFile psiFile = scope2.getContainingFile();
            pair = new Pair<DocumentChangeTransaction, Integer>(new DocumentChangeTransaction(doc, psiFile), 0);
            if (scope2.isPhysical()) {
                this.myBus.syncPublisher(PsiDocumentTransactionListener.TOPIC).transactionStarted(doc, psiFile);
            }
        } else {
            pair = new Pair<DocumentChangeTransaction, Integer>(pair.getFirst(), pair.getSecond() + 1);
        }
        LOG.assertTrue(this.myTransactionsMap.put(doc, pair) == prev);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean commitTransaction(@NotNull Document document) {
        DocumentChangeTransaction documentChangeTransaction;
        if (document == null) {
            PsiToDocumentSynchronizer.$$$reportNull$$$0(17);
        }
        if ((documentChangeTransaction = this.removeTransaction(document)) == null) {
            return false;
        }
        PsiFile changeScope = documentChangeTransaction.myChangeScope;
        try {
            this.mySyncDocument = document;
            PsiTreeChangeEventImpl fakeEvent = new PsiTreeChangeEventImpl(changeScope.getManager());
            fakeEvent.setParent(changeScope);
            fakeEvent.setFile(changeScope);
            this.checkPsiModificationAllowed(fakeEvent);
            this.doSync(fakeEvent, (document1, event) -> PsiToDocumentSynchronizer.doCommitTransaction(document1, documentChangeTransaction));
            if (PomModelImpl.shouldFirePhysicalPsiEvents(changeScope)) {
                this.myBus.syncPublisher(PsiDocumentTransactionListener.TOPIC).transactionCompleted(document, changeScope);
            }
        }
        catch (Throwable e2) {
            this.myPsiDocumentManager.forceReload(changeScope.getViewProvider().getVirtualFile(), changeScope.getViewProvider());
            ExceptionUtil.rethrowAllAsUnchecked(e2);
        }
        finally {
            this.mySyncDocument = null;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doCommitTransaction(@NotNull Document document, @NotNull DocumentChangeTransaction documentChangeTransaction) {
        if (document == null) {
            PsiToDocumentSynchronizer.$$$reportNull$$$0(18);
        }
        if (documentChangeTransaction == null) {
            PsiToDocumentSynchronizer.$$$reportNull$$$0(19);
        }
        DocumentEx ex = (DocumentEx)document;
        ex.suppressGuardedExceptions();
        try {
            boolean isReadOnly = !document.isWritable();
            ex.setReadOnly(false);
            for (Map.Entry entry : documentChangeTransaction.myAffectedFragments.descendingMap().entrySet()) {
                ex.replaceString(((TextRange)entry.getKey()).getStartOffset(), ((TextRange)entry.getKey()).getEndOffset(), (CharSequence)entry.getValue());
            }
            ex.setReadOnly(isReadOnly);
        }
        finally {
            ex.unSuppressGuardedExceptions();
        }
    }

    @Nullable
    private DocumentChangeTransaction removeTransaction(@NotNull Document doc) {
        Pair<DocumentChangeTransaction, Integer> pair;
        if (doc == null) {
            PsiToDocumentSynchronizer.$$$reportNull$$$0(20);
        }
        if ((pair = this.myTransactionsMap.get(doc)) == null) {
            return null;
        }
        int nestedCount = pair.getSecond();
        if (nestedCount > 0) {
            pair = Pair.create(pair.getFirst(), nestedCount - 1);
            this.myTransactionsMap.put(doc, pair);
            return null;
        }
        this.myTransactionsMap.remove(doc);
        return pair.getFirst();
    }

    public boolean isDocumentAffectedByTransactions(@NotNull Document document) {
        if (document == null) {
            PsiToDocumentSynchronizer.$$$reportNull$$$0(21);
        }
        return this.myTransactionsMap.containsKey(document);
    }

    @ApiStatus.Internal
    public void processEvents(@NotNull TreeChangeEventImpl changeSet, @NotNull PsiFile file) {
        DocumentChangeTransaction transaction;
        if (changeSet == null) {
            PsiToDocumentSynchronizer.$$$reportNull$$$0(22);
        }
        if (file == null) {
            PsiToDocumentSynchronizer.$$$reportNull$$$0(23);
        }
        if (file instanceof DummyHolder || !this.toProcessPsiEvent()) {
            return;
        }
        DocumentEx document = this.getCachedDocument(file, false);
        DocumentChangeTransaction documentChangeTransaction = transaction = document == null ? null : this.getTransaction(document);
        if (transaction == null) {
            return;
        }
        for (TreeChangeImpl change : changeSet.getSortedChanges()) {
            int parentStart = change.getChangedParent().getStartOffset();
            for (ASTNode child : change.getAffectedChildren()) {
                PsiElement newPsi;
                ChangeInfoImpl info = change.getChangeByChild(child);
                ASTNode newChild = info.getNewChild();
                PsiElement psiElement = newPsi = newChild == null ? null : newChild.getPsi();
                if (newPsi instanceof ForeignLeafPsiElement) continue;
                transaction.replace(info.getOffsetInParent() + parentStart, info.getOldLength(), newChild == null ? "" : newChild.getText(), newPsi);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiDocumentManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bus";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 12: 
            case 17: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncAction";
                break;
            }
            case 7: 
            case 8: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doc";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentChangeTransaction";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeSet";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/PsiToDocumentSynchronizer";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getTransaction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isInSynchronization";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkPsiModificationAllowed";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "doSync";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isInsideAtomicChange";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "performAtomically";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceString";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "insertString";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "startTransaction";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "commitTransaction";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "doCommitTransaction";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "removeTransaction";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "isDocumentAffectedByTransactions";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "processEvents";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class DocumentChangeTransaction {
        private final TreeMap<TextRange, CharSequence> myAffectedFragments;
        private final PsiFile myChangeScope;
        private ImmutableCharSequence myPsiText;

        DocumentChangeTransaction(@NotNull Document doc, @NotNull PsiFile scope2) {
            if (doc == null) {
                DocumentChangeTransaction.$$$reportNull$$$0(0);
            }
            if (scope2 == null) {
                DocumentChangeTransaction.$$$reportNull$$$0(1);
            }
            this.myAffectedFragments = new TreeMap(Comparator.comparingInt(TextRange::getStartOffset));
            this.myChangeScope = scope2;
            this.myPsiText = CharArrayUtil.createImmutableCharSequence(doc.getImmutableCharSequence());
        }

        @TestOnly
        @NotNull
        public Map<TextRange, CharSequence> getAffectedFragments() {
            TreeMap<TextRange, CharSequence> treeMap = this.myAffectedFragments;
            if (treeMap == null) {
                DocumentChangeTransaction.$$$reportNull$$$0(2);
            }
            return treeMap;
        }

        void replace(int psiStart, int length, @NotNull String replace, @Nullable PsiElement replacement) {
            int newEndInReplace;
            int newStartInReplace;
            if (replace == null) {
                DocumentChangeTransaction.$$$reportNull$$$0(3);
            }
            int start = 0;
            int end = start + length;
            CharSequence chars = this.myPsiText.subSequence(psiStart, psiStart + length);
            if (StringUtil.equals(chars, replace)) {
                return;
            }
            int replaceLength = replace.length();
            for (newStartInReplace = 0; newStartInReplace < replaceLength && start < end && replace.charAt(newStartInReplace) == chars.charAt(start); ++start, ++newStartInReplace) {
            }
            for (newEndInReplace = replaceLength; start < end && newStartInReplace < newEndInReplace && replace.charAt(newEndInReplace - 1) == chars.charAt(end - 1); --newEndInReplace, --end) {
            }
            if (replacement != null && (newStartInReplace > 0 || newEndInReplace < replaceLength)) {
                PsiElement startLeaf = replacement.findElementAt(newStartInReplace);
                PsiElement endLeaf = replacement.findElementAt(newEndInReplace - 1);
                if (startLeaf != null && endLeaf != null) {
                    int leafStart = startLeaf.getTextRange().getStartOffset() - replacement.getTextRange().getStartOffset();
                    int leafEnd = endLeaf.getTextRange().getEndOffset() - replacement.getTextRange().getStartOffset();
                    start += leafStart - newStartInReplace;
                    end += leafEnd - newEndInReplace;
                    newStartInReplace = leafStart;
                    newEndInReplace = leafEnd;
                }
            }
            if (newStartInReplace == newEndInReplace && start > 0 && start < end && StringUtil.indexOf(chars, '\n', start, end) != -1) {
                while (start > 0 && newStartInReplace > 0 && chars.charAt(start - 1) == chars.charAt(end - 1) && chars.charAt(end - 1) != '\n') {
                    --start;
                    --end;
                    --newStartInReplace;
                    --newEndInReplace;
                }
            }
            this.updateFragments(start += psiStart, end += psiStart, replace.substring(newStartInReplace, newEndInReplace));
        }

        private void updateFragments(int start, int end, @NotNull String replace) {
            if (replace == null) {
                DocumentChangeTransaction.$$$reportNull$$$0(4);
            }
            int docStart = this.psiToDocumentOffset(start);
            int docEnd = this.psiToDocumentOffset(end);
            TextRange startRange = this.findFragment(docStart);
            TextRange endRange = this.findFragment(docEnd);
            this.myPsiText = this.myPsiText.replace(start, end, replace);
            TextRange newFragment = new TextRange(startRange != null ? startRange.getStartOffset() : docStart, endRange != null ? endRange.getEndOffset() : docEnd);
            CharSequence newReplacement = this.myPsiText.subSequence(this.documentToPsiOffset(newFragment.getStartOffset(), false), this.documentToPsiOffset(newFragment.getEndOffset(), true) + replace.length() - (end - start));
            this.myAffectedFragments.keySet().removeIf(range -> range.intersects(newFragment));
            this.myAffectedFragments.put(newFragment, newReplacement);
        }

        private TextRange findFragment(int docOffset) {
            return ContainerUtil.find(this.myAffectedFragments.keySet(), range -> range.containsOffset(docOffset));
        }

        private int psiToDocumentOffset(int offset) {
            for (Map.Entry<TextRange, CharSequence> entry : this.myAffectedFragments.entrySet()) {
                int lengthAfter = entry.getValue().length();
                TextRange range = entry.getKey();
                if (range.getStartOffset() + lengthAfter < offset) {
                    offset += range.getLength() - lengthAfter;
                    continue;
                }
                return Math.min(range.getStartOffset(), offset);
            }
            return offset;
        }

        private int documentToPsiOffset(int offset, boolean greedyRight) {
            int delta = 0;
            for (Map.Entry<TextRange, CharSequence> entry : this.myAffectedFragments.entrySet()) {
                int lengthAfter = entry.getValue().length();
                TextRange range = entry.getKey();
                if (range.containsOffset(offset)) {
                    return range.getStartOffset() + delta + (greedyRight ? lengthAfter : 0);
                }
                if (range.getStartOffset() > offset) break;
                delta += lengthAfter - range.getLength();
            }
            return offset + delta;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 2: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "doc";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/PsiToDocumentSynchronizer$DocumentChangeTransaction";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "replace";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/PsiToDocumentSynchronizer$DocumentChangeTransaction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAffectedFragments";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "replace";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "updateFragments";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    @FunctionalInterface
    private static interface DocSyncAction {
        public void syncDocument(@NotNull Document var1, @NotNull PsiTreeChangeEventImpl var2);
    }
}

