/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.pipeline.jvm;

import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.jvm.JvmPhasesKt;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeysKt;
import org.jetbrains.kotlin.cli.common.CreatePhaseConfigKt;
import org.jetbrains.kotlin.cli.common.UtilsKt;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.modules.ModuleChunk;
import org.jetbrains.kotlin.cli.jvm.JvmArgumentsKt;
import org.jetbrains.kotlin.cli.jvm.K2JVMCompilerKt;
import org.jetbrains.kotlin.cli.jvm.compiler.CoreEnvironmentUtilsKt;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinToJVMBytecodeCompilerKt;
import org.jetbrains.kotlin.cli.jvm.config.ClassicFrontendSpecificJvmConfigurationKeys;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootsKt;
import org.jetbrains.kotlin.cli.pipeline.ArgumentsPipelineArtifact;
import org.jetbrains.kotlin.cli.pipeline.ConfigurationUpdater;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeysKt;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.config.phaser.PhaseConfig;
import org.jetbrains.kotlin.incremental.components.EnumWhenTracker;
import org.jetbrains.kotlin.incremental.components.ExpectActualTracker;
import org.jetbrains.kotlin.incremental.components.ICFileMappingTracker;
import org.jetbrains.kotlin.incremental.components.ImportTracker;
import org.jetbrains.kotlin.incremental.components.InlineConstTracker;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.load.java.JavaClassesTracker;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCompilationComponents;
import org.jetbrains.kotlin.modules.Module;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001e\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001c\u0010\u000b\u001a\u00020\u0006*\u00020\n2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0014\u0010\u000f\u001a\u00020\u0006*\u00020\n2\u0006\u0010\f\u001a\u00020\u0002H\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/cli/pipeline/jvm/JvmConfigurationUpdater;", "Lorg/jetbrains/kotlin/cli/pipeline/ConfigurationUpdater;", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JVMCompilerArguments;", "<init>", "()V", "fillConfiguration", "", "input", "Lorg/jetbrains/kotlin/cli/pipeline/ArgumentsPipelineArtifact;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "setupIncrementalCompilationServices", "arguments", "services", "Lorg/jetbrains/kotlin/config/Services;", "setupModuleChunk", "cli"})
@SourceDebugExtension(value={"SMAP\nJvmConfigurationPipelinePhase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmConfigurationPipelinePhase.kt\norg/jetbrains/kotlin/cli/pipeline/jvm/JvmConfigurationUpdater\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,126:1\n1#2:127\n*E\n"})
public final class JvmConfigurationUpdater
extends ConfigurationUpdater<K2JVMCompilerArguments> {
    @NotNull
    public static final JvmConfigurationUpdater INSTANCE = new JvmConfigurationUpdater();

    private JvmConfigurationUpdater() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fillConfiguration(@NotNull ArgumentsPipelineArtifact<K2JVMCompilerArguments> input, @NotNull CompilerConfiguration configuration) {
        PhaseConfig phaseConfig;
        Intrinsics.checkNotNullParameter(input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        K2JVMCompilerArguments arguments = input.component1();
        Services services = input.component2();
        MessageCollector messageCollector = CommonConfigurationKeysKt.getMessageCollector(configuration);
        MessageCollector.report$default(messageCollector, CompilerMessageSeverity.LOGGING, "Configuring the compilation environment", null, 4, null);
        String string = arguments.getBuildFile();
        if (string != null) {
            String it = string;
            boolean bl = false;
            CLIConfigurationKeysKt.setBuildFile(configuration, new File(it));
        }
        CLIConfigurationKeysKt.setAllowNoSourceFiles(configuration, arguments.getAllowNoSourceFiles());
        JvmArgumentsKt.setupJvmSpecificArguments(configuration, arguments);
        this.setupIncrementalCompilationServices(configuration, arguments, services);
        PhaseConfig phaseConfig2 = phaseConfig = CreatePhaseConfigKt.createPhaseConfig(arguments, JvmPhasesKt.getJvmPhases());
        CompilerConfiguration compilerConfiguration = configuration;
        boolean bl = false;
        if (arguments.getListPhases()) {
            void it;
            CreatePhaseConfigKt.listPhases((PhaseConfig)it, JvmPhasesKt.getJvmPhases());
        }
        CommonConfigurationKeysKt.setPhaseConfig(compilerConfiguration, phaseConfig);
        if (!JvmArgumentsKt.configureJdkHome(configuration, arguments)) {
            return;
        }
        JVMConfigurationKeysKt.setDisableStandardScriptDefinition(configuration, arguments.getDisableStandardScript());
        String string2 = arguments.getModuleName();
        if (string2 == null) {
            string2 = "main";
        }
        String moduleName2 = string2;
        CommonConfigurationKeysKt.setModuleName(configuration, moduleName2);
        JvmArgumentsKt.configureJavaModulesContentRoots(configuration, arguments);
        JvmArgumentsKt.configureStandardLibs(configuration, CLIConfigurationKeysKt.getKotlinPaths(configuration), arguments);
        JvmArgumentsKt.configureAdvancedJvmOptions(configuration, arguments);
        JvmArgumentsKt.configureKlibPaths(configuration, arguments);
        if (arguments.getExpression() == null) {
            this.setupModuleChunk(configuration, arguments);
        } else {
            JvmArgumentsKt.configureContentRootsFromClassPath(configuration, arguments);
        }
        if (arguments.getScript() || arguments.getExpression() != null) {
            CLIConfigurationKeysKt.setScriptMode(configuration, arguments.getScript());
            CLIConfigurationKeysKt.setFreeArgsForScript(configuration, CollectionsKt.plus((Collection)CLIConfigurationKeysKt.getFreeArgsForScript(configuration), (Iterable)arguments.getFreeArgs()));
            JVMConfigurationKeysKt.setExpressionToEvaluate(configuration, arguments.getExpression());
            CLIConfigurationKeysKt.setDefaultExtensionForScripts(configuration, arguments.getDefaultScriptExtension());
        } else {
            CLIConfigurationKeysKt.setReplMode(configuration, arguments.getRepl());
            CLIConfigurationKeysKt.setFreeArgsForScript(configuration, CollectionsKt.plus((Collection)CLIConfigurationKeysKt.getFreeArgsForScript(configuration), (Iterable)arguments.getFreeArgs()));
        }
        JvmContentRootsKt.configureJdkClasspathRoots(configuration);
    }

    private final void setupIncrementalCompilationServices(CompilerConfiguration $this$setupIncrementalCompilationServices, K2JVMCompilerArguments arguments, Services services) {
        if (!UtilsKt.incrementalCompilationIsEnabled(arguments)) {
            return;
        }
        CommonConfigurationKeysKt.setLookupTracker($this$setupIncrementalCompilationServices, services.get(LookupTracker.class));
        CommonConfigurationKeysKt.setExpectActualTracker($this$setupIncrementalCompilationServices, services.get(ExpectActualTracker.class));
        CommonConfigurationKeysKt.setInlineConstTracker($this$setupIncrementalCompilationServices, services.get(InlineConstTracker.class));
        CommonConfigurationKeysKt.setEnumWhenTracker($this$setupIncrementalCompilationServices, services.get(EnumWhenTracker.class));
        CommonConfigurationKeysKt.setImportTracker($this$setupIncrementalCompilationServices, services.get(ImportTracker.class));
        CommonConfigurationKeysKt.setFileMappingTracker($this$setupIncrementalCompilationServices, services.get(ICFileMappingTracker.class));
        JVMConfigurationKeysKt.setIncrementalCompilationComponents($this$setupIncrementalCompilationServices, services.get(IncrementalCompilationComponents.class));
        $this$setupIncrementalCompilationServices.putIfNotNull(ClassicFrontendSpecificJvmConfigurationKeys.JAVA_CLASSES_TRACKER, services.get(JavaClassesTracker.class));
    }

    private final void setupModuleChunk(CompilerConfiguration $this$setupModuleChunk, K2JVMCompilerArguments arguments) {
        File buildFile = CLIConfigurationKeysKt.getBuildFile($this$setupModuleChunk);
        ModuleChunk moduleChunk = K2JVMCompilerKt.configureModuleChunk($this$setupModuleChunk, arguments, buildFile);
        CLIConfigurationKeysKt.setModuleChunk($this$setupModuleChunk, moduleChunk);
        if (moduleChunk.getModules().size() == 1) {
            List<Module> list = moduleChunk.getModules();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getModules(...)");
            Object object = CollectionsKt.single(list);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"single(...)");
            CoreEnvironmentUtilsKt.applyModuleProperties($this$setupModuleChunk, (Module)object, buildFile);
        }
        List<Module> list = moduleChunk.getModules();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getModules(...)");
        KotlinToJVMBytecodeCompilerKt.configureSourceRoots($this$setupModuleChunk, list, buildFile);
    }
}

