/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.checkers.diagnostics;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.Severity;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0018\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/checkers/diagnostics/AbstractDiagnosticForTests;", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "psiElement", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "factory", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory;", "<init>", "(Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory;)V", "getPsiElement", "()Lcom/intellij/psi/PsiElement;", "getFactory", "()Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory;", "severity", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "getSeverity", "()Lorg/jetbrains/kotlin/diagnostics/Severity;", "textRanges", "", "Lorg/jetbrains/kotlin/com/intellij/openapi/util/TextRange;", "getTextRanges", "()Ljava/util/List;", "psiFile", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiFile;", "getPsiFile", "()Lcom/intellij/psi/PsiFile;", "isValid", "", "()Z", "frontend"})
public class AbstractDiagnosticForTests
implements Diagnostic {
    @NotNull
    private final PsiElement psiElement;
    @NotNull
    private final DiagnosticFactory<?> factory;

    public AbstractDiagnosticForTests(@NotNull PsiElement psiElement, @NotNull DiagnosticFactory<?> factory) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        Intrinsics.checkNotNullParameter(factory, (String)"factory");
        this.psiElement = psiElement;
        this.factory = factory;
    }

    @Override
    @NotNull
    public PsiElement getPsiElement() {
        return this.psiElement;
    }

    @Override
    @NotNull
    public DiagnosticFactory<?> getFactory() {
        return this.factory;
    }

    @Override
    @NotNull
    public Severity getSeverity() {
        return Severity.ERROR;
    }

    @Override
    @NotNull
    public List<TextRange> getTextRanges() {
        return CollectionsKt.listOf((Object)this.getPsiElement().getTextRange());
    }

    @Override
    @NotNull
    public PsiFile getPsiFile() {
        PsiFile psiFile = this.getPsiElement().getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        return psiFile;
    }

    @Override
    public boolean isValid() {
        return true;
    }
}

