/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.snapshots;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporter;
import org.jetbrains.kotlin.build.report.metrics.BuildTime;
import org.jetbrains.kotlin.build.report.metrics.GradleBuildTime;
import org.jetbrains.kotlin.incremental.ClasspathChanges;
import org.jetbrains.kotlin.incremental.ClasspathSnapshotFiles;
import org.jetbrains.kotlin.incremental.LookupStorage;
import org.jetbrains.kotlin.incremental.classpathDiff.AccessibleClassSnapshot;
import org.jetbrains.kotlin.incremental.classpathDiff.AccessibleClassSnapshotExternalizer;
import org.jetbrains.kotlin.incremental.classpathDiff.CachedClasspathSnapshotSerializer;
import org.jetbrains.kotlin.incremental.classpathDiff.ClasspathSnapshot;
import org.jetbrains.kotlin.incremental.classpathDiff.ClasspathSnapshotBuildReporter;
import org.jetbrains.kotlin.incremental.classpathDiff.ClasspathSnapshotShrinker;
import org.jetbrains.kotlin.incremental.classpathDiff.ClasspathSnapshotShrinkerKt;
import org.jetbrains.kotlin.incremental.snapshots.LazySnapshotLoadingMetrics;
import org.jetbrains.kotlin.incremental.storage.ExternalizersKt;
import org.jetbrains.kotlin.incremental.storage.ListExternalizer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000fJ\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/incremental/snapshots/LazyClasspathSnapshot;", "", "classpathChanges", "Lorg/jetbrains/kotlin/incremental/ClasspathChanges;", "reporter", "Lorg/jetbrains/kotlin/incremental/classpathDiff/ClasspathSnapshotBuildReporter;", "<init>", "(Lorg/jetbrains/kotlin/incremental/ClasspathChanges;Lorg/jetbrains/kotlin/incremental/classpathDiff/ClasspathSnapshotBuildReporter;)V", "currentClasspathSnapshot", "", "Lorg/jetbrains/kotlin/incremental/classpathDiff/AccessibleClassSnapshot;", "computedShrunkClasspathAgainstPreviousLookups", "savedShrunkClasspathSnapshot", "getCurrentClasspathSnapshot", "metricToReportIfComputing", "Lorg/jetbrains/kotlin/incremental/snapshots/LazySnapshotLoadingMetrics;", "getComputedShrunkClasspathAgainstPreviousLookups", "lookupStorage", "Lorg/jetbrains/kotlin/incremental/LookupStorage;", "getSavedShrunkClasspathAgainstPreviousLookups", "incremental-compilation-impl"})
@SourceDebugExtension(value={"SMAP\nLazyClasspathSnapshot.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LazyClasspathSnapshot.kt\norg/jetbrains/kotlin/incremental/snapshots/LazyClasspathSnapshot\n+ 2 BuildMetricsReporter.kt\norg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporterKt\n*L\n1#1,134:1\n32#2,3:135\n32#2,5:138\n36#2:143\n32#2,5:144\n32#2,5:149\n*S KotlinDebug\n*F\n+ 1 LazyClasspathSnapshot.kt\norg/jetbrains/kotlin/incremental/snapshots/LazyClasspathSnapshot\n*L\n40#1:135,3\n44#1:138,5\n40#1:143\n60#1:144,5\n84#1:149,5\n*E\n"})
public final class LazyClasspathSnapshot {
    @NotNull
    private final ClasspathChanges classpathChanges;
    @NotNull
    private final ClasspathSnapshotBuildReporter reporter;
    @Nullable
    private List<? extends AccessibleClassSnapshot> currentClasspathSnapshot;
    @Nullable
    private List<? extends AccessibleClassSnapshot> computedShrunkClasspathAgainstPreviousLookups;
    @Nullable
    private List<? extends AccessibleClassSnapshot> savedShrunkClasspathSnapshot;

    public LazyClasspathSnapshot(@NotNull ClasspathChanges classpathChanges, @NotNull ClasspathSnapshotBuildReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)classpathChanges, (String)"classpathChanges");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        this.classpathChanges = classpathChanges;
        this.reporter = reporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final List<AccessibleClassSnapshot> getCurrentClasspathSnapshot(@NotNull LazySnapshotLoadingMetrics metricToReportIfComputing) {
        List<AccessibleClassSnapshot> computed;
        List<AccessibleClassSnapshot> list;
        Intrinsics.checkNotNullParameter((Object)metricToReportIfComputing, (String)"metricToReportIfComputing");
        List<AccessibleClassSnapshot> stored = this.currentClasspathSnapshot;
        if (stored != null) {
            return stored;
        }
        if (this.classpathChanges instanceof ClasspathChanges.ClasspathSnapshotEnabled) {
            void $this$measure$iv;
            BuildMetricsReporter buildMetricsReporter = this.reporter;
            BuildTime time$iv = metricToReportIfComputing.getLoadClasspathSnapshotTag();
            boolean $i$f$measure = false;
            $this$measure$iv.startMeasure(time$iv);
            try {
                List<AccessibleClassSnapshot> list2;
                void $this$measure$iv2;
                boolean bl = false;
                ClasspathSnapshotFiles classpathSnapshotFiles = ((ClasspathChanges.ClasspathSnapshotEnabled)this.classpathChanges).getClasspathSnapshotFiles();
                ClasspathSnapshot classpathSnapshot = CachedClasspathSnapshotSerializer.INSTANCE.load(classpathSnapshotFiles.getCurrentClasspathEntrySnapshotFiles(), this.reporter);
                BuildMetricsReporter buildMetricsReporter2 = this.reporter;
                BuildTime time$iv2 = metricToReportIfComputing.getRemoveDuplicateClassesTag();
                boolean $i$f$measure2 = false;
                $this$measure$iv2.startMeasure(time$iv2);
                try {
                    boolean bl2 = false;
                    list2 = ClasspathSnapshotShrinkerKt.removeDuplicateAndInaccessibleClasses(classpathSnapshot);
                }
                finally {
                    $this$measure$iv2.endMeasure(time$iv2);
                }
                List<AccessibleClassSnapshot> list3 = list2;
                list = list3;
            }
            finally {
                $this$measure$iv.endMeasure(time$iv);
            }
        }
        list = CollectionsKt.emptyList();
        this.currentClasspathSnapshot = computed = list;
        return computed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final List<AccessibleClassSnapshot> getComputedShrunkClasspathAgainstPreviousLookups(@NotNull LookupStorage lookupStorage, @NotNull LazySnapshotLoadingMetrics metricToReportIfComputing) {
        List<AccessibleClassSnapshot> list;
        void $this$measure$iv;
        Intrinsics.checkNotNullParameter((Object)lookupStorage, (String)"lookupStorage");
        Intrinsics.checkNotNullParameter((Object)metricToReportIfComputing, (String)"metricToReportIfComputing");
        List<AccessibleClassSnapshot> stored = this.computedShrunkClasspathAgainstPreviousLookups;
        if (stored != null) {
            return stored;
        }
        BuildMetricsReporter buildMetricsReporter = this.reporter;
        BuildTime time$iv = metricToReportIfComputing.getCalculateShrunkClasspathTag();
        boolean $i$f$measure = false;
        $this$measure$iv.startMeasure(time$iv);
        try {
            boolean bl = false;
            ClasspathSnapshotShrinker.MetricsReporter metricsReporter = metricToReportIfComputing instanceof LazySnapshotLoadingMetrics.OnClasspathDiffComputation ? new ClasspathSnapshotShrinker.MetricsReporter(this.reporter, GradleBuildTime.GET_LOOKUP_SYMBOLS, GradleBuildTime.FIND_REFERENCED_CLASSES, GradleBuildTime.FIND_TRANSITIVELY_REFERENCED_CLASSES) : new ClasspathSnapshotShrinker.MetricsReporter(null, null, null, null, 15, null);
            List<? extends AccessibleClassSnapshot> list2 = this.currentClasspathSnapshot;
            Intrinsics.checkNotNull(list2);
            list = ClasspathSnapshotShrinker.INSTANCE.shrinkClasspath(list2, lookupStorage, metricsReporter);
        }
        finally {
            $this$measure$iv.endMeasure(time$iv);
        }
        List<AccessibleClassSnapshot> computed = list;
        this.computedShrunkClasspathAgainstPreviousLookups = computed;
        return computed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final List<AccessibleClassSnapshot> getSavedShrunkClasspathAgainstPreviousLookups(@NotNull LazySnapshotLoadingMetrics metricToReportIfComputing) {
        List loaded;
        List list;
        Intrinsics.checkNotNullParameter((Object)metricToReportIfComputing, (String)"metricToReportIfComputing");
        List<AccessibleClassSnapshot> stored = this.savedShrunkClasspathSnapshot;
        if (stored != null) {
            return stored;
        }
        if (this.classpathChanges instanceof ClasspathChanges.ClasspathSnapshotEnabled) {
            void $this$measure$iv;
            BuildMetricsReporter buildMetricsReporter = this.reporter;
            BuildTime time$iv = metricToReportIfComputing.getLoadShrunkClasspathTag();
            boolean $i$f$measure = false;
            $this$measure$iv.startMeasure(time$iv);
            try {
                boolean bl = false;
                List list2 = (List)ExternalizersKt.loadFromFile(new ListExternalizer(AccessibleClassSnapshotExternalizer.INSTANCE), ((ClasspathChanges.ClasspathSnapshotEnabled)this.classpathChanges).getClasspathSnapshotFiles().getShrunkPreviousClasspathSnapshotFile());
                list = list2;
            }
            finally {
                $this$measure$iv.endMeasure(time$iv);
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        this.savedShrunkClasspathSnapshot = loaded = list;
        return loaded;
    }
}

