/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls.stages;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirLookupTrackerComponent;
import org.jetbrains.kotlin.fir.FirLookupTrackerComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousFunctionExpression;
import org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirResolvable;
import org.jetbrains.kotlin.fir.expressions.FirSafeCallExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.FirSamResolver;
import org.jetbrains.kotlin.fir.resolve.ImplicitIntegerCoercionKt;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.ArgumentUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.ConeLambdaWithTypeVariableAsExpectedTypeAtom;
import org.jetbrains.kotlin.fir.resolve.calls.ConePostponedResolvedAtom;
import org.jetbrains.kotlin.fir.resolve.calls.LowerPriorityToPreserveCompatibilityDiagnostic;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionContext;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.CallInfo;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.CheckerSink;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.FirNamedReferenceWithCandidate;
import org.jetbrains.kotlin.fir.resolve.inference.ConstraintSystemCompleterKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FunctionalTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilderKt;
import org.jetbrains.kotlin.types.model.TypeSystemContextHelpersKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001aA\u0010\u0002\u001a\u0004\u0018\u00010\u0003*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002R\u00020\u0004j\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u000f\u001a7\u0010\u0010\u001a\u0004\u0018\u00010\u0003*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0003H\u0002R\u00020\u0004j\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0012\u001a,\u0010\u0013\u001a\u00020\u0014*\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0006H\u0002\u001a\u0014\u0010\u0017\u001a\u00020\u0014*\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a*\u0010\u0018\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0003H\u0002\u001a\u000e\u0010\u0019\u001a\u0004\u0018\u00010\u001a*\u00020\fH\u0002\u001a\u001d\u0010\u001b\u001a\u00020\u001c*\u00020\u001dH\u0002R\u00020\u0004j\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u001e\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"SAM_LOOKUP_NAME", "Lorg/jetbrains/kotlin/name/Name;", "prepareExpectedType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;", "context", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "callInfo", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CallInfo;", "argument", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "parameter", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "(Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CallInfo;Lorg/jetbrains/kotlin/fir/expressions/FirExpression;Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;)Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "getExpectedTypeWithSAMConversion", "candidateExpectedType", "(Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/expressions/FirExpression;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "shouldUseSamConversion", "", "expectedFunctionType", "candidate", "isCallWithGenericReturnTypeAndMatchingLambda", "getExpectedTypeWithImplicitIntegerCoercion", "namedReferenceWithCandidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/FirNamedReferenceWithCandidate;", "markCandidateForCompatibilityResolve", "", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CheckerSink;", "(Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CheckerSink;)V", "resolve"})
@SourceDebugExtension(value={"SMAP\nCheckArguments.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CheckArguments.kt\norg/jetbrains/kotlin/fir/resolve/calls/stages/CheckArgumentsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,255:1\n1#2:256\n1761#3,3:257\n*S KotlinDebug\n*F\n+ 1 CheckArguments.kt\norg/jetbrains/kotlin/fir/resolve/calls/stages/CheckArgumentsKt\n*L\n214#1:257,3\n*E\n"})
public final class CheckArgumentsKt {
    @NotNull
    private static final Name SAM_LOOKUP_NAME;

    private static final ConeKotlinType prepareExpectedType(ResolutionContext context2, Candidate $this$prepareExpectedType, FirSession session, CallInfo callInfo, FirExpression argument, FirValueParameter parameter) {
        ConeKotlinType coneKotlinType;
        if (parameter == null) {
            return null;
        }
        ConeKotlinType basicExpectedType = ArgumentUtilsKt.getExpectedType(argument, session, parameter);
        ConeKotlinType coneKotlinType2 = CheckArgumentsKt.getExpectedTypeWithSAMConversion(context2, $this$prepareExpectedType, session, argument, basicExpectedType);
        if (coneKotlinType2 != null) {
            ConeKotlinType coneKotlinType3;
            ConeKotlinType it = coneKotlinType3 = coneKotlinType2;
            boolean bl = false;
            FirLookupTrackerComponent firLookupTrackerComponent = FirLookupTrackerComponentKt.getLookupTracker(session);
            if (firLookupTrackerComponent != null) {
                FirLookupTrackerComponent lookupTracker = firLookupTrackerComponent;
                boolean bl2 = false;
                ClassId classId = ConeTypeUtilsKt.getClassId(ConeTypeUtilsKt.lowerBoundIfFlexible(FirTypeUtilsKt.getConeType(parameter.getReturnTypeRef())));
                if (classId != null) {
                    ClassId classId2;
                    ClassId it2 = classId2 = classId;
                    boolean bl3 = false;
                    classId = !it2.isLocal() ? classId2 : null;
                    if (classId != null) {
                        ClassId classId3 = classId;
                        boolean bl4 = false;
                        String string = SAM_LOOKUP_NAME.asString();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
                        FirLookupTrackerComponentKt.recordClassMemberLookup(lookupTracker, string, classId3, callInfo.getCallSite().getSource(), callInfo.getContainingFile().getSource());
                        FirLookupTrackerComponentKt.recordClassLikeLookup(lookupTracker, classId3, callInfo.getCallSite().getSource(), callInfo.getContainingFile().getSource());
                    }
                }
            }
            coneKotlinType = coneKotlinType3;
        } else {
            coneKotlinType = CheckArgumentsKt.getExpectedTypeWithImplicitIntegerCoercion(session, argument, parameter, basicExpectedType);
            if (coneKotlinType == null) {
                coneKotlinType = basicExpectedType;
            }
        }
        ConeKotlinType expectedType = coneKotlinType;
        return $this$prepareExpectedType.getSubstitutor().substituteOrSelf(expectedType);
    }

    private static final ConeKotlinType getExpectedTypeWithSAMConversion(ResolutionContext context2, Candidate $this$getExpectedTypeWithSAMConversion, FirSession session, FirExpression argument, ConeKotlinType candidateExpectedType) {
        if (FunctionalTypeUtilsKt.isSomeFunctionType(candidateExpectedType, session)) {
            return null;
        }
        FirSamResolver.SamConversionInfo samConversionInfo = context2.getBodyResolveComponents().getSamResolver().getSamInfoForPossibleSamType(candidateExpectedType);
        if (samConversionInfo == null) {
            return null;
        }
        FirSamResolver.SamConversionInfo samConversionInfo2 = samConversionInfo;
        ConeKotlinType expectedFunctionType = samConversionInfo2.getFunctionalType();
        if (!CheckArgumentsKt.shouldUseSamConversion(argument, session, candidateExpectedType, expectedFunctionType, $this$getExpectedTypeWithSAMConversion)) {
            return null;
        }
        $this$getExpectedTypeWithSAMConversion.setSamConversionOfArgument(FirExpressionUtilKt.unwrapArgument(argument), samConversionInfo2);
        return expectedFunctionType;
    }

    private static final boolean shouldUseSamConversion(FirExpression $this$shouldUseSamConversion, FirSession session, ConeKotlinType candidateExpectedType, ConeKotlinType expectedFunctionType, Candidate candidate2) {
        FirExpression unwrapped = FirExpressionUtilKt.unwrapArgument($this$shouldUseSamConversion);
        if (unwrapped instanceof FirAnonymousFunctionExpression || unwrapped instanceof FirCallableReferenceAccess) {
            return true;
        }
        if (CheckArgumentsKt.isCallWithGenericReturnTypeAndMatchingLambda(unwrapped, session)) {
            return true;
        }
        ConeKotlinType expressionType = FirTypeUtilsKt.getResolvedType($this$shouldUseSamConversion);
        if (expressionType instanceof ConeIntegerLiteralType) {
            return false;
        }
        ConeKotlinType substitutedExpectedType = candidate2.getSubstitutor().substituteOrSelf(candidateExpectedType);
        if (ConstraintSystemBuilderKt.isSubtypeConstraintCompatible(ConstraintSystemCompleterKt.getCsBuilder(candidate2), expressionType, substitutedExpectedType)) {
            return false;
        }
        if (FunctionalTypeUtilsKt.isSomeFunctionType(expressionType, session)) {
            return true;
        }
        ConeKotlinType substitutedExpectedFunctionType = candidate2.getSubstitutor().substituteOrSelf(expectedFunctionType);
        if (ConstraintSystemBuilderKt.isSubtypeConstraintCompatible(ConstraintSystemCompleterKt.getCsBuilder(candidate2), expressionType, substitutedExpectedFunctionType)) {
            return true;
        }
        if (!FunctionalTypeUtilsKt.isBasicFunctionOrKFunctionType(substitutedExpectedFunctionType, session)) {
            ConeClassLikeType expectedFunctionTypeAsSimpleFunctionType = FunctionalTypeUtilsKt.customFunctionTypeToSimpleFunctionType(ConeTypeUtilsKt.lowerBoundIfFlexible(substitutedExpectedFunctionType), session);
            if (ConstraintSystemBuilderKt.isSubtypeConstraintCompatible(ConstraintSystemCompleterKt.getCsBuilder(candidate2), expressionType, expectedFunctionTypeAsSimpleFunctionType)) {
                return true;
            }
        }
        return false;
    }

    private static final boolean isCallWithGenericReturnTypeAndMatchingLambda(FirExpression $this$isCallWithGenericReturnTypeAndMatchingLambda, FirSession session) {
        boolean bl;
        block4: {
            ConeKotlinType expressionType = FirTypeUtilsKt.getResolvedType($this$isCallWithGenericReturnTypeAndMatchingLambda);
            Object object = CheckArgumentsKt.namedReferenceWithCandidate($this$isCallWithGenericReturnTypeAndMatchingLambda);
            if (object == null || (object = ((FirNamedReferenceWithCandidate)object).getCandidate()) == null || (object = ((Candidate)object).getPostponedAtoms()) == null) {
                return false;
            }
            List<ConePostponedResolvedAtom> postponedAtoms = object;
            Iterable $this$any$iv = postponedAtoms;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ConePostponedResolvedAtom it = (ConePostponedResolvedAtom)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof ConeLambdaWithTypeVariableAsExpectedTypeAtom && Intrinsics.areEqual((Object)TypeSystemContextHelpersKt.typeConstructor(((ConeLambdaWithTypeVariableAsExpectedTypeAtom)it).getExpectedType(), TypeComponentsKt.getTypeContext(session)), (Object)TypeSystemContextHelpersKt.typeConstructor(expressionType, TypeComponentsKt.getTypeContext(session))))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final ConeKotlinType getExpectedTypeWithImplicitIntegerCoercion(FirSession session, FirExpression argument, FirValueParameter parameter, ConeKotlinType candidateExpectedType) {
        ConeKotlinType argumentType;
        ConeKotlinType coneKotlinType;
        if (!FirLanguageSettingsComponentKt.getLanguageVersionSettings(session).supportsFeature(LanguageFeature.ImplicitSignedToUnsignedIntegerConversion)) {
            return null;
        }
        if (!ImplicitIntegerCoercionKt.isMarkedWithImplicitIntegerCoercion(parameter)) {
            return null;
        }
        if (!ConeBuiltinTypeUtilsKt.isUnsignedTypeOrNullableUnsignedType(TypeExpansionUtilsKt.fullyExpandedType$default(candidateExpectedType, session, null, 2, null))) {
            return null;
        }
        if (ResolveUtilsKt.isIntegerLiteralOrOperatorCall(argument)) {
            coneKotlinType = FirTypeUtilsKt.getResolvedType(argument);
        } else {
            FirCallableSymbol firCallableSymbol;
            FirReference firReference = ReferenceUtilsKt.toReference(argument, session);
            if (firReference == null) return null;
            FirCallableSymbol firCallableSymbol2 = FirReferenceUtilsKt.toResolvedCallableSymbol$default(firReference, false, 1, null);
            if (firCallableSymbol2 == null) return null;
            FirCallableSymbol it = firCallableSymbol = firCallableSymbol2;
            boolean bl = false;
            if (!it.getRawStatus().isConst()) return null;
            if (!ImplicitIntegerCoercionKt.isMarkedWithImplicitIntegerCoercion(it)) return null;
            boolean bl2 = true;
            if (!bl2) return null;
            FirCallableSymbol firCallableSymbol3 = firCallableSymbol;
            FirCallableSymbol firCallableSymbol4 = firCallableSymbol3;
            if (firCallableSymbol4 == null) return null;
            coneKotlinType = firCallableSymbol4.getResolvedReturnType();
        }
        ConeKotlinType coneKotlinType2 = argumentType = coneKotlinType;
        if (coneKotlinType2 == null) return null;
        ConeKotlinType coneKotlinType3 = TypeUtilsKt.withNullabilityOf(coneKotlinType2, candidateExpectedType, TypeComponentsKt.getTypeContext(session));
        return coneKotlinType3;
    }

    private static final FirNamedReferenceWithCandidate namedReferenceWithCandidate(FirExpression $this$namedReferenceWithCandidate) {
        FirNamedReferenceWithCandidate firNamedReferenceWithCandidate;
        FirExpression firExpression = $this$namedReferenceWithCandidate;
        if (firExpression instanceof FirResolvable) {
            FirReference firReference = ((FirResolvable)((Object)$this$namedReferenceWithCandidate)).getCalleeReference();
            firNamedReferenceWithCandidate = firReference instanceof FirNamedReferenceWithCandidate ? (FirNamedReferenceWithCandidate)firReference : null;
        } else if (firExpression instanceof FirSafeCallExpression) {
            FirStatement firStatement = ((FirSafeCallExpression)$this$namedReferenceWithCandidate).getSelector();
            FirExpression firExpression2 = firStatement instanceof FirExpression ? (FirExpression)firStatement : null;
            firNamedReferenceWithCandidate = firExpression2 != null ? CheckArgumentsKt.namedReferenceWithCandidate(firExpression2) : null;
        } else {
            firNamedReferenceWithCandidate = null;
        }
        return firNamedReferenceWithCandidate;
    }

    private static final void markCandidateForCompatibilityResolve(ResolutionContext context2, CheckerSink $this$markCandidateForCompatibilityResolve) {
        if (FirLanguageSettingsComponentKt.getLanguageVersionSettings(context2.getSession()).supportsFeature(LanguageFeature.DisableCompatibilityModeForNewInference)) {
            return;
        }
        $this$markCandidateForCompatibilityResolve.reportDiagnostic(LowerPriorityToPreserveCompatibilityDiagnostic.INSTANCE);
    }

    public static final /* synthetic */ void access$markCandidateForCompatibilityResolve(ResolutionContext context2, CheckerSink $receiver) {
        CheckArgumentsKt.markCandidateForCompatibilityResolve(context2, $receiver);
    }

    public static final /* synthetic */ ConeKotlinType access$prepareExpectedType(ResolutionContext context2, Candidate $receiver, FirSession session, CallInfo callInfo, FirExpression argument, FirValueParameter parameter) {
        return CheckArgumentsKt.prepareExpectedType(context2, $receiver, session, callInfo, argument, parameter);
    }

    static {
        Name name2 = Name.special("<SAM-CONSTRUCTOR>");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"special(...)");
        SAM_LOOKUP_NAME = name2;
    }
}

