/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.native.checkers;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.native.FirNativeErrors;
import org.jetbrains.kotlin.fir.backend.native.interop.FirObjCInteropKt;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertyAccessorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirReceiverParameterSymbol;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.name.NativeStandardInteropNames;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCOutletChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirClass;)V", "checkers.native"})
@SourceDebugExtension(value={"SMAP\nFirNativeObjCOutletChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirNativeObjCOutletChecker.kt\norg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCOutletChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,68:1\n36#2:69\n*S KotlinDebug\n*F\n+ 1 FirNativeObjCOutletChecker.kt\norg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCOutletChecker\n*L\n63#1:69\n*E\n"})
public final class FirNativeObjCOutletChecker
extends FirDeclarationChecker<FirClass> {
    @NotNull
    public static final FirNativeObjCOutletChecker INSTANCE = new FirNativeObjCOutletChecker();

    private FirNativeObjCOutletChecker() {
        super(MppCheckerKind.Platform);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirClass declaration) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        FirSession session = context2.getSession();
        FirMemberDeclaration $this$isExpect$iv = declaration;
        boolean $i$f$isExpect = false;
        if (!$this$isExpect$iv.getStatus().isExpect() && FirObjCInteropKt.isKotlinObjCClass(declaration.getSymbol(), context2.getSession())) {
            FirNativeObjCOutletChecker.check$checkKotlinObjCClass(context2, session, reporter, declaration);
        }
    }

    private static final void check$checkCanGenerateFunctionImp(CheckerContext $context, DiagnosticReporter $reporter, FirPropertyAccessorSymbol setter2) {
        if (setter2.getValueParameterSymbols().size() > 2) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)$context, $reporter, (AbstractKtSourceElement)setter2.getSource(), FirNativeErrors.INSTANCE.getTWO_OR_LESS_PARAMETERS_ARE_SUPPORTED_HERE(), null, 8, null);
        }
    }

    private static final void check$checkCanGenerateOutletSetterImp(CheckerContext $context, DiagnosticReporter $reporter, FirSession session, FirPropertySymbol property2) {
        if (!property2.isVar()) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)$context, $reporter, (AbstractKtSourceElement)property2.getSource(), FirNativeErrors.INSTANCE.getPROPERTY_MUST_BE_VAR(), (Object)NativeStandardInteropNames.INSTANCE.getObjCOutletClassId().asSingleFqName(), null, 16, null);
            return;
        }
        FirReceiverParameterSymbol firReceiverParameterSymbol = property2.getReceiverParameterSymbol();
        if (firReceiverParameterSymbol != null) {
            FirReceiverParameterSymbol it = firReceiverParameterSymbol;
            boolean bl = false;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)$context, $reporter, (AbstractKtSourceElement)it.getSource(), FirNativeErrors.INSTANCE.getMUST_NOT_HAVE_EXTENSION_RECEIVER(), (Object)('@' + NativeStandardInteropNames.INSTANCE.getObjCOutletClassId().asFqNameString()), null, 16, null);
        }
        FirResolvedTypeRef type = property2.getResolvedReturnTypeRef();
        if (!FirObjCInteropKt.isObjCObjectType(type, session)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)$context, $reporter, (AbstractKtSourceElement)property2.getResolvedReturnTypeRef().getSource(), FirNativeErrors.INSTANCE.getMUST_BE_OBJC_OBJECT_TYPE(), (Object)("" + '@' + NativeStandardInteropNames.INSTANCE.getObjCOutletClassId().asSingleFqName() + " type"), (Object)type.getConeType(), null, 32, null);
        }
        FirPropertyAccessorSymbol firPropertyAccessorSymbol = property2.getSetterSymbol();
        Intrinsics.checkNotNull((Object)firPropertyAccessorSymbol);
        FirNativeObjCOutletChecker.check$checkCanGenerateFunctionImp($context, $reporter, firPropertyAccessorSymbol);
    }

    private static final Unit check$checkKotlinObjCClass$lambda$1(FirSession $session, CheckerContext $context, DiagnosticReporter $reporter, FirCallableSymbol symbol) {
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        if (symbol instanceof FirPropertySymbol && FirAnnotationUtilsKt.hasAnnotation(symbol, NativeStandardInteropNames.INSTANCE.getObjCOutletClassId(), $session)) {
            FirNativeObjCOutletChecker.check$checkCanGenerateOutletSetterImp($context, $reporter, $session, (FirPropertySymbol)symbol);
        }
        return Unit.INSTANCE;
    }

    private static final void check$checkKotlinObjCClass(CheckerContext $context, FirSession session, DiagnosticReporter $reporter, FirClass firClass) {
        DeclarationUtilsKt.processAllDeclaredCallables$default(firClass.getSymbol(), $context.getSession(), null, arg_0 -> FirNativeObjCOutletChecker.check$checkKotlinObjCClass$lambda$1(session, $context, $reporter, arg_0), 2, null);
    }
}

