/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKind;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirVisibilityCheckerKt;
import org.jetbrains.kotlin.fir.analysis.FirSourceUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirDeprecationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.ConeDiagnosticToFirDiagnosticKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirImport;
import org.jetbrains.kotlin.fir.declarations.FirResolvedImport;
import org.jetbrains.kotlin.fir.declarations.ImplicitReceiverUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirProviderKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirProviderUtilsKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.resolve.transformers.ImportUtilsKt;
import org.jetbrains.kotlin.fir.resolve.transformers.PackageResolutionResult;
import org.jetbrains.kotlin.fir.scopes.FirContainingNamesAwareScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirDeclaredMemberScopeProviderKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousObjectSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirEnumEntrySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFileSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u00019B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ-\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0011J-\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0011J-\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0011J!\u0010\u0014\u001a\u00020\u0015*\u0006\u0012\u0002\b\u00030\u0016H\u0002R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0017J3\u0010\u0018\u001a\u00020\u00072\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00100\u001aH\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u001bJ-\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u001dH\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u001eJ\u001d\u0010\u001f\u001a\u00020\u0015*\u00020\u001dH\u0002R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010 J#\u0010!\u001a\b\u0012\u0002\b\u0003\u0018\u00010\"*\u00020#H\u0002R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010$J\u001f\u0010%\u001a\u0004\u0018\u00010&*\u00020#H\u0002R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010'J9\u0010(\u001a\u00020\u0015*\u00020&2\u0006\u0010)\u001a\u00020*2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020\u00150,H\u0002R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010.J%\u0010/\u001a\u000200*\u00020&2\u0006\u0010)\u001a\u00020*H\u0002R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u00101JJ\u00102\u001a\u0002002\f\u00103\u001a\b\u0012\u0004\u0012\u0002040\u001a2\u0006\u0010)\u001a\u00020*2\u0018\b\u0004\u00105\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u000306\u0012\u0004\u0012\u00020\u00150,H\u0082\bR\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u00107J-\u00108\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006:"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImportsChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFileChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirFile;)V", "checkAllUnderFromEnumEntry", "import", "Lorg/jetbrains/kotlin/fir/declarations/FirImport;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirImport;)V", "checkAllUnderFromObject", "checkCanBeImported", "isVisible", "", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;)Z", "checkConflictingImports", "imports", "", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Ljava/util/List;)V", "checkOperatorRename", "Lorg/jetbrains/kotlin/fir/declarations/FirResolvedImport;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirResolvedImport;)V", "resolvesToClass", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/declarations/FirResolvedImport;)Z", "resolveToClassLike", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "Lorg/jetbrains/kotlin/name/ClassId;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/name/ClassId;)Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "resolveToClass", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/name/ClassId;)Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "hasFunction", "name", "Lorg/jetbrains/kotlin/name/Name;", "predicate", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;Lorg/jetbrains/kotlin/name/Name;Lkotlin/jvm/functions/Function1;)Z", "getImportStatusOfCallableMembers", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImportsChecker$ImportStatus;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;Lorg/jetbrains/kotlin/name/Name;)Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImportsChecker$ImportStatus;", "getImportStatus", "scopes", "Lorg/jetbrains/kotlin/fir/scopes/FirContainingNamesAwareScope;", "isApplicable", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Ljava/util/List;Lorg/jetbrains/kotlin/name/Name;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImportsChecker$ImportStatus;", "checkImportApiStatus", "ImportStatus", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirImportsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirImportsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImportsChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 4 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n+ 5 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,371:1\n338#1,21:417\n338#1,19:438\n357#1,2:458\n1869#2,2:372\n1761#2,3:376\n827#2:389\n855#2,2:390\n1491#2:392\n1516#2,3:393\n1519#2,3:403\n774#2:406\n865#2,2:407\n1869#2:409\n1869#2,2:410\n1870#2:412\n1761#2,2:413\n1763#2:416\n84#3:374\n18#3:380\n44#3:381\n26#3:415\n24#3:457\n26#3:460\n37#4:375\n46#4:379\n48#5,7:382\n382#6,7:396\n*S KotlinDebug\n*F\n+ 1 FirImportsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImportsChecker\n*L\n314#1:417,21\n328#1:438,19\n328#1:458,2\n43#1:372,2\n68#1:376,3\n225#1:389\n225#1:390,2\n227#1:392\n227#1:393,3\n227#1:403,3\n229#1:406\n229#1:407,2\n230#1:409\n231#1:410,2\n230#1:412\n247#1:413,2\n247#1:416\n68#1:374\n197#1:380\n198#1:381\n248#1:415\n328#1:457\n245#1:460\n68#1:375\n86#1:379\n220#1:382,7\n227#1:396,7\n*E\n"})
public final class FirImportsChecker
extends FirDeclarationChecker<FirFile> {
    @NotNull
    public static final FirImportsChecker INSTANCE = new FirImportsChecker();

    private FirImportsChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirFile declaration) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Iterable $this$forEach$iv = declaration.getImports();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirImport firImport = (FirImport)element$iv;
            boolean bl = false;
            Object object = firImport.getSource();
            if (object != null && (object = ((KtSourceElement)object).getKind()) != null ? ((KtSourceElementKind)object).getShouldSkipErrorTypeReporting() : false) continue;
            if (firImport.isAllUnder()) {
                if (firImport instanceof FirResolvedImport) {
                    INSTANCE.checkAllUnderFromObject(context2, reporter, firImport);
                } else {
                    INSTANCE.checkAllUnderFromEnumEntry(context2, reporter, firImport);
                }
            } else {
                INSTANCE.checkCanBeImported(context2, reporter, firImport);
                if (firImport instanceof FirResolvedImport) {
                    INSTANCE.checkOperatorRename(context2, reporter, (FirResolvedImport)firImport);
                }
            }
            INSTANCE.checkImportApiStatus(context2, reporter, firImport);
        }
        this.checkConflictingImports(context2, reporter, declaration.getImports());
    }

    private final void checkAllUnderFromEnumEntry(CheckerContext context2, DiagnosticReporter reporter, FirImport firImport) {
        FqName fqName = firImport.getImportedFqName();
        if (fqName == null) {
            return;
        }
        FqName fqName2 = fqName;
        if (fqName2.isRoot() || fqName2.parent().isRoot()) {
            return;
        }
        ClassId classId = ClassId.Companion.topLevel(fqName2.parent());
        FirRegularClassSymbol firRegularClassSymbol = this.resolveToClass(context2, classId);
        if (firRegularClassSymbol == null) {
            return;
        }
        FirRegularClassSymbol classSymbol = firRegularClassSymbol;
        FirClassSymbol $this$isEnumClass$iv = classSymbol;
        boolean $i$f$isEnumClass = false;
        ClassKind $this$isEnumClass$iv$iv = $this$isEnumClass$iv.getClassKind();
        boolean $i$f$isEnumClass2 = false;
        boolean bl = $this$isEnumClass$iv$iv == ClassKind.ENUM_CLASS;
        if (bl) {
            boolean bl2;
            block8: {
                Iterable $this$any$iv = DeclarationUtilsKt.collectEnumEntries(classSymbol, context2.getSession());
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirEnumEntrySymbol it = (FirEnumEntrySymbol)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getCallableId().getCallableName(), (Object)fqName2.shortName())) continue;
                        bl2 = true;
                        break block8;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)firImport.getSource(), FirErrors.INSTANCE.getCANNOT_ALL_UNDER_IMPORT_FROM_SINGLETON(), (Object)classSymbol.getClassId().getShortClassName(), null, 16, null);
            }
        }
    }

    private final void checkAllUnderFromObject(CheckerContext context2, DiagnosticReporter reporter, FirImport firImport) {
        FirClassLikeSymbol<?> firClassLikeSymbol;
        FqName fqName = firImport.getImportedFqName();
        if (fqName == null) {
            return;
        }
        FqName fqName2 = fqName;
        if (fqName2.isRoot()) {
            return;
        }
        PackageResolutionResult resolutionResult = ImportUtilsKt.resolveToPackageOrClass(FirSymbolProviderKt.getSymbolProvider(context2.getSession()), fqName2);
        if (resolutionResult instanceof PackageResolutionResult.PackageOrClass) {
            firClassLikeSymbol = ((PackageResolutionResult.PackageOrClass)resolutionResult).getClassSymbol();
            if (firClassLikeSymbol == null) {
                return;
            }
        } else {
            if (resolutionResult instanceof PackageResolutionResult.Error) {
                return;
            }
            throw new NoWhenBranchMatchedException();
        }
        FirClassLikeSymbol<?> classLike = firClassLikeSymbol;
        FirRegularClassSymbol classSymbol = DeclarationUtilsKt.fullyExpandedClass(classLike, context2.getSession());
        if (classSymbol != null) {
            ClassKind $this$isObject$iv = classSymbol.getClassKind();
            boolean $i$f$isObject = false;
            if ($this$isObject$iv == ClassKind.OBJECT) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)firImport.getSource(), FirErrors.INSTANCE.getCANNOT_ALL_UNDER_IMPORT_FROM_SINGLETON(), (Object)classSymbol.getClassId().getShortClassName(), null, 16, null);
            }
        }
        if (!this.isVisible(context2, (FirBasedSymbol)classLike)) {
            KtSourceElement ktSourceElement = FirSourceUtilsKt.getLastImportedFqNameSegmentSource(firImport);
            if (ktSourceElement == null) {
                throw new IllegalStateException(("" + '`' + firImport.getSource() + "` does not contain `" + fqName2 + '`').toString());
            }
            KtSourceElement source = ktSourceElement;
            reporter.report(ConeDiagnosticToFirDiagnosticKt.toInvisibleReferenceDiagnostic((FirBasedSymbol)classLike, source, context2.getSession()), context2);
        }
    }

    private final void checkCanBeImported(CheckerContext context2, DiagnosticReporter reporter, FirImport firImport) {
        ClassId parentClassId;
        Name importedName;
        FqName importedFqName;
        block26: {
            block25: {
                FqName fqName = firImport.getImportedFqName();
                if (fqName == null) {
                    return;
                }
                importedFqName = fqName;
                importedName = importedFqName.shortName();
                if (importedName.isSpecial()) break block25;
                String string = importedName.getIdentifier();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIdentifier(...)");
                if (!(((CharSequence)string).length() == 0)) break block26;
            }
            return;
        }
        FirSymbolProvider symbolProvider = FirSymbolProviderKt.getSymbolProvider(context2.getSession());
        FirResolvedImport firResolvedImport = firImport instanceof FirResolvedImport ? (FirResolvedImport)firImport : null;
        ClassId classId = parentClassId = firResolvedImport != null ? firResolvedImport.getResolvedParentClassId() : null;
        if (parentClassId != null) {
            FirClassLikeSymbol<?> firClassLikeSymbol = this.resolveToClassLike(context2, parentClassId);
            if (firClassLikeSymbol == null) {
                return;
            }
            FirClassLikeSymbol<?> parentClassLikeSymbol = firClassLikeSymbol;
            FirRegularClassSymbol firRegularClassSymbol = DeclarationUtilsKt.fullyExpandedClass(parentClassLikeSymbol, context2.getSession());
            if (firRegularClassSymbol == null) {
                return;
            }
            FirRegularClassSymbol parentClassSymbol = firRegularClassSymbol;
            if (parentClassLikeSymbol instanceof FirTypeAliasSymbol) {
                FirImportsChecker.checkCanBeImported$reportInvisibleParentClasses(context2, firImport, reporter, parentClassLikeSymbol, 1);
            }
            FirImportsChecker.checkCanBeImported$reportInvisibleParentClassesRecursively(context2, firImport, reporter, parentClassSymbol, 1);
            ImportStatus status2 = this.getImportStatusOfCallableMembers(context2, parentClassSymbol, importedName);
            if (Intrinsics.areEqual((Object)status2, (Object)ImportStatus.OK.INSTANCE)) {
                if (parentClassLikeSymbol instanceof FirTypeAliasSymbol) {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)((FirResolvedImport)firImport).getSource(), FirErrors.INSTANCE.getTYPEALIAS_AS_CALLABLE_QUALIFIER_IN_IMPORT(), (Object)((FirTypeAliasSymbol)parentClassLikeSymbol).getName(), (Object)parentClassSymbol.getName(), null, 32, null);
                }
            } else if (status2 instanceof ImportStatus.Invisible) {
                KtSourceElement ktSourceElement = FirSourceUtilsKt.getSourceForImportSegment(firImport, 0);
                reporter.report(ConeDiagnosticToFirDiagnosticKt.toInvisibleReferenceDiagnostic((FirBasedSymbol)((ImportStatus.Invisible)status2).getSymbol(), ktSourceElement, context2.getSession()), context2);
            } else {
                ClassId classId2 = parentClassSymbol.getClassId().createNestedClassId(importedName);
                if (symbolProvider.getClassLikeSymbolByClassId(classId2) != null) {
                    return;
                }
                if (Intrinsics.areEqual((Object)status2, (Object)ImportStatus.Unresolved.INSTANCE)) {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)((FirResolvedImport)firImport).getSource(), FirErrors.INSTANCE.getUNRESOLVED_IMPORT(), (Object)importedName.asString(), null, 16, null);
                } else {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)((FirResolvedImport)firImport).getSource(), FirErrors.INSTANCE.getCANNOT_BE_IMPORTED(), (Object)importedName, null, 16, null);
                }
            }
            return;
        }
        FirBasedSymbol resolvedDeclaration = null;
        FirRegularClassSymbol firRegularClassSymbol = this.resolveToClass(context2, ClassId.Companion.topLevel(importedFqName));
        if (firRegularClassSymbol != null) {
            FirRegularClassSymbol firRegularClassSymbol2 = firRegularClassSymbol;
            boolean bl = false;
            resolvedDeclaration = firRegularClassSymbol2;
            if (INSTANCE.isVisible(context2, firRegularClassSymbol2)) {
                return;
            }
        }
        List<FirCallableSymbol<?>> topLevelCallableSymbol = symbolProvider.getTopLevelCallableSymbols(importedFqName.parent(), importedName);
        for (FirCallableSymbol<?> firCallableSymbol : topLevelCallableSymbol) {
            if (this.isVisible(context2, (FirBasedSymbol)firCallableSymbol)) {
                return;
            }
            if (resolvedDeclaration != null) continue;
            resolvedDeclaration = firCallableSymbol;
        }
        FirBasedSymbol firBasedSymbol = resolvedDeclaration;
        if (firBasedSymbol != null) {
            FirBasedSymbol it = firBasedSymbol;
            boolean bl = false;
            KtSourceElement ktSourceElement = FirSourceUtilsKt.getSourceForImportSegment(firImport, 0);
            if (ktSourceElement == null) {
                ktSourceElement = firImport.getSource();
            }
            KtSourceElement source = ktSourceElement;
            reporter.report(ConeDiagnosticToFirDiagnosticKt.toInvisibleReferenceDiagnostic(it, source, context2.getSession()), context2);
            return;
        }
        if (symbolProvider.hasPackage(importedFqName)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)firImport.getSource(), FirErrors.INSTANCE.getPACKAGE_CANNOT_BE_IMPORTED(), null, 8, null);
        } else {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)firImport.getSource(), FirErrors.INSTANCE.getUNRESOLVED_IMPORT(), (Object)importedName.asString(), null, 16, null);
        }
    }

    private final boolean isVisible(CheckerContext context2, FirBasedSymbol<?> $this$isVisible) {
        Visibility visibility;
        boolean $i$f$getVisibility;
        FirBasedSymbol $this$visibility$iv;
        FirFileSymbol firFileSymbol = context2.getContainingFileSymbol();
        if (firFileSymbol == null) {
            return false;
        }
        FirFileSymbol useSiteFileSymbol = firFileSymbol;
        FirBasedSymbol<?> firBasedSymbol = $this$isVisible;
        if (firBasedSymbol instanceof FirCallableSymbol) {
            $this$visibility$iv = (FirCallableSymbol)$this$isVisible;
            $i$f$getVisibility = false;
            visibility = ((FirCallableSymbol)$this$visibility$iv).getResolvedStatus().getVisibility();
        } else if (firBasedSymbol instanceof FirClassLikeSymbol) {
            $this$visibility$iv = (FirClassLikeSymbol)$this$isVisible;
            $i$f$getVisibility = false;
            visibility = ((FirClassLikeSymbol)$this$visibility$iv).getResolvedStatus().getVisibility();
        } else {
            return false;
        }
        Visibility visibility2 = visibility;
        if (!Intrinsics.areEqual((Object)visibility2, (Object)Visibilities.Unknown.INSTANCE) && !visibility2.mustCheckInImports()) {
            return true;
        }
        if (Intrinsics.areEqual((Object)visibility2, (Object)Visibilities.Private.INSTANCE) || Intrinsics.areEqual((Object)visibility2, (Object)Visibilities.PrivateToThis.INSTANCE)) {
            FirFile firFile = FirProviderUtilsKt.getContainingFile(FirProviderKt.getFirProvider(context2.getSession()), $this$isVisible);
            return Intrinsics.areEqual((Object)useSiteFileSymbol, (Object)(firFile != null ? firFile.getSymbol() : null));
        }
        return FirVisibilityCheckerKt.isVisible(FirVisibilityCheckerKt.getVisibilityChecker(context2.getSession()), $this$isVisible, context2.getSession(), useSiteFileSymbol, CollectionsKt.emptyList(), null, true);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void checkConflictingImports(CheckerContext context, DiagnosticReporter reporter, List<? extends FirImport> imports) {
        var5_4 = imports;
        $i$f$filterIsInstanceWithChecker = false;
        result$iv = new ArrayList<E>();
        for (T element$iv : $this$filterIsInstanceWithChecker$iv) {
            if (!(element$iv instanceof FirResolvedImport)) continue;
            import = (FirResolvedImport)element$iv;
            $i$a$-filterIsInstanceWithChecker-FirImportsChecker$checkConflictingImports$interestingImports$1 = false;
            if (import.isAllUnder()) ** GOTO lbl-1000
            v0 = import.getSource();
            if (v0 != null && (v0 = v0.getKind()) != null ? v0.getShouldSkipErrorTypeReporting() : false) ** GOTO lbl-1000
            v1 = import.getImportedName();
            v2 = v1 != null && (v1 = v1.getIdentifierOrNullIfSpecial()) != null ? ((CharSequence)v1).length() > 0 : false;
            if (v2 && FirImportsChecker.INSTANCE.resolvesToClass(context, (FirResolvedImport)import)) {
                v3 = true;
            } else lbl-1000:
            // 3 sources

            {
                v3 = false;
            }
            if (!v3) continue;
            ((Collection)result$iv).add(element$iv);
        }
        $this$filterIsInstanceWithChecker$iv = result$iv;
        $i$f$filterNot = false;
        result$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterNotTo = false;
        for (E element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (FirResolvedImport)element$iv$iv;
            $i$a$-filterNot-FirImportsChecker$checkConflictingImports$interestingImports$2 = false;
            v4 = it.getSource();
            if (Intrinsics.areEqual((Object)(v4 != null ? v4.getKind() : null), (Object)KtFakeSourceElementKind.ImplicitImport.INSTANCE)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        interestingImports = (List)destination$iv$iv;
        $this$filterNot$iv = interestingImports;
        $i$f$groupBy = false;
        $this$filterNotTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap<K, V>();
        $i$f$groupByTo = false;
        for (T element$iv$iv : $this$groupByTo$iv$iv) {
            it = (FirResolvedImport)element$iv$iv;
            $i$a$-groupBy-FirImportsChecker$checkConflictingImports$1 = false;
            v5 = it.getAliasName();
            if (v5 == null) {
                v6 = it.getImportedName();
                v5 = v6;
                Intrinsics.checkNotNull((Object)v6);
            }
            key$iv$iv = v5;
            var15_24 = destination$iv$iv;
            key$iv$iv$iv = key$iv$iv;
            $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                $i$a$-getOrPut-CollectionsKt___CollectionsKt$groupByTo$list$1$iv$iv = false;
                answer$iv$iv$iv = new ArrayList<E>();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                v7 /* !! */  = answer$iv$iv$iv;
            } else {
                v7 /* !! */  = value$iv$iv$iv;
            }
            list$iv$iv = (List)v7 /* !! */ ;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv.values();
        $i$f$filter = false;
        $this$groupByTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (List)element$iv$iv;
            $i$a$-filter-FirImportsChecker$checkConflictingImports$2 = false;
            if (!(it.size() > 1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            conflicts = (List)element$iv;
            $i$a$-forEach-FirImportsChecker$checkConflictingImports$3 = false;
            $this$forEach$iv = conflicts;
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                it = (FirResolvedImport)element$iv;
                $i$a$-forEach-FirImportsChecker$checkConflictingImports$3$1 = false;
                v8 = context;
                v9 = it.getSource();
                v10 = FirErrors.INSTANCE.getCONFLICTING_IMPORT();
                v11 = it.getImportedName();
                Intrinsics.checkNotNull((Object)v11);
                KtDiagnosticReportHelpersKt.reportOn$default(v8, reporter, v9, v10, (Object)v11, null, 16, null);
            }
        }
    }

    private final void checkOperatorRename(CheckerContext context2, DiagnosticReporter reporter, FirResolvedImport firResolvedImport) {
        boolean illegalRename;
        block10: {
            boolean bl;
            Name name2 = firResolvedImport.getAliasName();
            if (name2 == null) {
                return;
            }
            Name alias = name2;
            Name name3 = firResolvedImport.getImportedName();
            if (name3 == null) {
                return;
            }
            Name importedName = name3;
            if (!OperatorConventions.isConventionName(alias)) {
                return;
            }
            ClassId classId = firResolvedImport.getResolvedParentClassId();
            if (classId != null) {
                FirRegularClassSymbol firRegularClassSymbol = this.resolveToClass(context2, classId);
                if (firRegularClassSymbol == null) {
                    return;
                }
                FirRegularClassSymbol classFir = firRegularClassSymbol;
                bl = classFir.getClassKind().isSingleton() && this.hasFunction(context2, classFir, importedName, (Function1<? super FirNamedFunctionSymbol, Boolean>)((Function1)FirImportsChecker::checkOperatorRename$lambda$11));
            } else {
                Iterable $this$any$iv = FirSymbolProviderKt.getSymbolProvider(context2.getSession()).getTopLevelFunctionSymbols(firResolvedImport.getPackageFqName(), importedName);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirNamedFunctionSymbol it = (FirNamedFunctionSymbol)element$iv;
                        boolean bl2 = false;
                        FirCallableSymbol $this$isOperator$iv = it;
                        boolean $i$f$isOperator = false;
                        if (!$this$isOperator$iv.getResolvedStatus().isOperator()) continue;
                        bl = true;
                        break block10;
                    }
                    bl = illegalRename = false;
                }
            }
        }
        if (illegalRename) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)firResolvedImport.getSource(), FirErrors.INSTANCE.getOPERATOR_RENAMED_ON_IMPORT(), null, 8, null);
        }
    }

    private final boolean resolvesToClass(CheckerContext context2, FirResolvedImport $this$resolvesToClass) {
        if ($this$resolvesToClass.getResolvedParentClassId() != null) {
            if ($this$resolvesToClass.isAllUnder()) {
                return true;
            }
            ClassId classId = $this$resolvesToClass.getResolvedParentClassId();
            Intrinsics.checkNotNull((Object)classId);
            ClassId parentClass = classId;
            FqName fqName = $this$resolvesToClass.getRelativeParentClassName();
            if (fqName == null) {
                return false;
            }
            FqName relativeClassName = fqName;
            Name name2 = $this$resolvesToClass.getImportedName();
            if (name2 == null) {
                return false;
            }
            Name importedName = name2;
            ClassId innerClassId = new ClassId(parentClass.getPackageFqName(), relativeClassName.child(importedName), false);
            return this.resolveToClass(context2, innerClassId) != null;
        }
        FqName fqName = $this$resolvesToClass.getImportedFqName();
        if (fqName == null) {
            return false;
        }
        FqName importedFqName = fqName;
        if (importedFqName.isRoot()) {
            return false;
        }
        ClassId importedClassId = ClassId.Companion.topLevel(importedFqName);
        return this.resolveToClass(context2, importedClassId) != null;
    }

    private final FirClassLikeSymbol<?> resolveToClassLike(CheckerContext context2, ClassId $this$resolveToClassLike) {
        return FirSymbolProviderKt.getSymbolProvider(context2.getSession()).getClassLikeSymbolByClassId($this$resolveToClassLike);
    }

    private final FirRegularClassSymbol resolveToClass(CheckerContext context2, ClassId $this$resolveToClass) {
        FirRegularClassSymbol firRegularClassSymbol;
        FirClassLikeSymbol<?> firClassLikeSymbol = this.resolveToClassLike(context2, $this$resolveToClass);
        if (firClassLikeSymbol == null) {
            return null;
        }
        FirClassLikeSymbol<?> classSymbol = firClassLikeSymbol;
        FirClassLikeSymbol<?> firClassLikeSymbol2 = classSymbol;
        if (firClassLikeSymbol2 instanceof FirRegularClassSymbol) {
            firRegularClassSymbol = (FirRegularClassSymbol)classSymbol;
        } else if (firClassLikeSymbol2 instanceof FirTypeAliasSymbol) {
            firRegularClassSymbol = DeclarationUtilsKt.fullyExpandedClass(classSymbol, context2.getSession());
        } else if (firClassLikeSymbol2 instanceof FirAnonymousObjectSymbol) {
            firRegularClassSymbol = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return firRegularClassSymbol;
    }

    private final boolean hasFunction(CheckerContext context2, FirRegularClassSymbol $this$hasFunction, Name name2, Function1<? super FirNamedFunctionSymbol, Boolean> predicate) {
        Ref.BooleanRef result2 = new Ref.BooleanRef();
        FirDeclaredMemberScopeProviderKt.declaredMemberScope(context2.getSession(), $this$hasFunction, null).processFunctionsByName(name2, (Function1<? super FirNamedFunctionSymbol, Unit>)((Function1)arg_0 -> FirImportsChecker.hasFunction$lambda$13(result2, predicate, arg_0)));
        return result2.element;
    }

    /*
     * WARNING - void declaration
     */
    private final ImportStatus getImportStatusOfCallableMembers(CheckerContext context2, FirRegularClassSymbol $this$getImportStatusOfCallableMembers, Name name2) {
        ImportStatus importStatus;
        block16: {
            if ($this$getImportStatusOfCallableMembers.getClassKind().isSingleton()) {
                boolean bl;
                void scopes$iv;
                Object object = new FirContainingNamesAwareScope[]{FirDeclaredMemberScopeProviderKt.declaredMemberScope(context2.getSession(), $this$getImportStatusOfCallableMembers, null), FirHelpersKt.unsubstitutedScope(context2, $this$getImportStatusOfCallableMembers)};
                List scopes = CollectionsKt.listOf((Object[])object);
                object = this;
                CheckerContext checkerContext = context2;
                List list = scopes;
                Name name$iv = name2;
                boolean $i$f$getImportStatus = false;
                Ref.BooleanRef found$iv = new Ref.BooleanRef();
                Ref.ObjectRef symbol$iv = new Ref.ObjectRef();
                for (FirContainingNamesAwareScope scope$iv : scopes$iv) {
                    void context$iv;
                    scope$iv.processFunctionsByName(name$iv, (Function1<? super FirNamedFunctionSymbol, Unit>)((Function1)new Function1<FirNamedFunctionSymbol, Unit>((CheckerContext)context$iv, found$iv, symbol$iv){
                        final /* synthetic */ CheckerContext $context;
                        final /* synthetic */ Ref.BooleanRef $found;
                        final /* synthetic */ Ref.ObjectRef $symbol;
                        {
                            this.$context = $context;
                            this.$found = $found;
                            this.$symbol = $symbol;
                        }

                        public final void invoke(FirNamedFunctionSymbol sym) {
                            Intrinsics.checkNotNullParameter((Object)sym, (String)"sym");
                            if (FirImportsChecker.access$isVisible(FirImportsChecker.INSTANCE, this.$context, sym)) {
                                FirCallableSymbol it = sym;
                                boolean bl = false;
                                if (true) {
                                    this.$found.element = true;
                                }
                            }
                            this.$symbol.element = sym;
                        }
                    }));
                    if (found$iv.element) {
                        importStatus = ImportStatus.OK.INSTANCE;
                    } else {
                        scope$iv.processPropertiesByName(name$iv, (Function1)new Function1<FirVariableSymbol<?>, Unit>((CheckerContext)context$iv, found$iv, symbol$iv){
                            final /* synthetic */ CheckerContext $context;
                            final /* synthetic */ Ref.BooleanRef $found;
                            final /* synthetic */ Ref.ObjectRef $symbol;
                            {
                                this.$context = $context;
                                this.$found = $found;
                                this.$symbol = $symbol;
                            }

                            public final void invoke(FirVariableSymbol<?> sym) {
                                Intrinsics.checkNotNullParameter(sym, (String)"sym");
                                if (FirImportsChecker.access$isVisible(FirImportsChecker.INSTANCE, this.$context, sym)) {
                                    FirCallableSymbol it = sym;
                                    boolean bl = false;
                                    if (true) {
                                        this.$found.element = true;
                                    }
                                }
                                this.$symbol.element = sym;
                            }
                        });
                        if (!found$iv.element) continue;
                        importStatus = ImportStatus.OK.INSTANCE;
                    }
                    break block16;
                }
                FirCallableSymbol firCallableSymbol = (FirCallableSymbol)symbol$iv.element;
                if (firCallableSymbol != null) {
                    FirCallableSymbol it = firCallableSymbol;
                    boolean bl2 = false;
                    bl = true;
                } else {
                    bl = false;
                }
                if (bl) {
                    Object object2 = symbol$iv.element;
                    Intrinsics.checkNotNull((Object)object2);
                    importStatus = new ImportStatus.Invisible((FirCallableSymbol)object2);
                } else {
                    importStatus = symbol$iv.element != null ? (ImportStatus)ImportStatus.CannotBeImported.INSTANCE : (ImportStatus)ImportStatus.Unresolved.INSTANCE;
                }
            } else {
                boolean bl;
                Object this_$iv = new FirContainingNamesAwareScope[]{FirDeclaredMemberScopeProviderKt.declaredMemberScope(context2.getSession(), $this$getImportStatusOfCallableMembers, null), ImplicitReceiverUtilsKt.staticScope($this$getImportStatusOfCallableMembers, context2.getSessionHolder()), FirHelpersKt.unsubstitutedScope(context2, $this$getImportStatusOfCallableMembers)};
                List scopes = CollectionsKt.listOfNotNull((Object[])this_$iv);
                this_$iv = this;
                CheckerContext context$iv = context2;
                List scopes$iv = scopes;
                Name name$iv = name2;
                boolean $i$f$getImportStatus = false;
                Ref.BooleanRef found$iv = new Ref.BooleanRef();
                Ref.ObjectRef symbol$iv = new Ref.ObjectRef();
                for (FirContainingNamesAwareScope scope$iv : scopes$iv) {
                    scope$iv.processFunctionsByName(name$iv, (Function1<? super FirNamedFunctionSymbol, Unit>)((Function1)new Function1<FirNamedFunctionSymbol, Unit>(context$iv, found$iv, symbol$iv){
                        final /* synthetic */ CheckerContext $context;
                        final /* synthetic */ Ref.BooleanRef $found;
                        final /* synthetic */ Ref.ObjectRef $symbol;
                        {
                            this.$context = $context;
                            this.$found = $found;
                            this.$symbol = $symbol;
                        }

                        public final void invoke(FirNamedFunctionSymbol sym) {
                            Intrinsics.checkNotNullParameter((Object)sym, (String)"sym");
                            if (FirImportsChecker.access$isVisible(FirImportsChecker.INSTANCE, this.$context, sym)) {
                                FirCallableSymbol it = sym;
                                boolean bl = false;
                                FirCallableSymbol $this$isStatic$iv = it;
                                boolean $i$f$isStatic = false;
                                if ($this$isStatic$iv.getRawStatus().isStatic()) {
                                    this.$found.element = true;
                                }
                            }
                            this.$symbol.element = sym;
                        }
                    }));
                    if (found$iv.element) {
                        importStatus = ImportStatus.OK.INSTANCE;
                    } else {
                        scope$iv.processPropertiesByName(name$iv, (Function1)new Function1<FirVariableSymbol<?>, Unit>(context$iv, found$iv, symbol$iv){
                            final /* synthetic */ CheckerContext $context;
                            final /* synthetic */ Ref.BooleanRef $found;
                            final /* synthetic */ Ref.ObjectRef $symbol;
                            {
                                this.$context = $context;
                                this.$found = $found;
                                this.$symbol = $symbol;
                            }

                            public final void invoke(FirVariableSymbol<?> sym) {
                                Intrinsics.checkNotNullParameter(sym, (String)"sym");
                                if (FirImportsChecker.access$isVisible(FirImportsChecker.INSTANCE, this.$context, sym)) {
                                    FirCallableSymbol it = sym;
                                    boolean bl = false;
                                    FirCallableSymbol $this$isStatic$iv = it;
                                    boolean $i$f$isStatic = false;
                                    if ($this$isStatic$iv.getRawStatus().isStatic()) {
                                        this.$found.element = true;
                                    }
                                }
                                this.$symbol.element = sym;
                            }
                        });
                        if (!found$iv.element) continue;
                        importStatus = ImportStatus.OK.INSTANCE;
                    }
                    break block16;
                }
                FirCallableSymbol firCallableSymbol = (FirCallableSymbol)symbol$iv.element;
                if (firCallableSymbol != null) {
                    FirCallableSymbol it = firCallableSymbol;
                    boolean bl3 = false;
                    FirCallableSymbol $this$isStatic$iv = it;
                    boolean $i$f$isStatic = false;
                    bl = $this$isStatic$iv.getRawStatus().isStatic();
                } else {
                    bl = false;
                }
                if (bl) {
                    Object object = symbol$iv.element;
                    Intrinsics.checkNotNull((Object)object);
                    importStatus = new ImportStatus.Invisible((FirCallableSymbol)object);
                } else {
                    importStatus = symbol$iv.element != null ? (ImportStatus)ImportStatus.CannotBeImported.INSTANCE : (ImportStatus)ImportStatus.Unresolved.INSTANCE;
                }
            }
        }
        return importStatus;
    }

    private final void checkImportApiStatus(CheckerContext context2, DiagnosticReporter reporter, FirImport firImport) {
        FqName importedFqName;
        block7: {
            block6: {
                FqName fqName = firImport.getImportedFqName();
                if (fqName == null) {
                    return;
                }
                importedFqName = fqName;
                if (importedFqName.isRoot()) break block6;
                String string = importedFqName.shortName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
                if (!(((CharSequence)string).length() == 0)) break block7;
            }
            return;
        }
        Object object = firImport instanceof FirResolvedImport ? (FirResolvedImport)firImport : null;
        if (object == null || (object = ((FirResolvedImport)object).getResolvedParentClassId()) == null) {
            object = ClassId.Companion.topLevel(importedFqName);
        }
        Object classId = object;
        FirClassifierSymbol<?> firClassifierSymbol = ToSymbolUtilsKt.toSymbol((ClassId)classId, context2.getSession());
        if (firClassifierSymbol == null) {
            return;
        }
        FirClassifierSymbol<?> symbol = firClassifierSymbol;
        FirDeprecationChecker.reportApiStatusIfNeeded$checkers$default(FirDeprecationChecker.INSTANCE, context2, reporter, firImport.getSource(), symbol, null, 16, null);
    }

    private static final void checkCanBeImported$reportInvisibleParentClasses(CheckerContext $context, FirImport $import, DiagnosticReporter $reporter, FirClassLikeSymbol<?> classSymbol, int depth) {
        if (!INSTANCE.isVisible($context, (FirBasedSymbol)classSymbol)) {
            KtSourceElement source = FirSourceUtilsKt.getSourceForImportSegment($import, depth);
            $reporter.report(ConeDiagnosticToFirDiagnosticKt.toInvisibleReferenceDiagnostic((FirBasedSymbol)classSymbol, source, $context.getSession()), $context);
        }
    }

    private static final void checkCanBeImported$reportInvisibleParentClassesRecursively(CheckerContext $context, FirImport $import, DiagnosticReporter $reporter, FirRegularClassSymbol classSymbol, int depth) {
        block0: {
            FirRegularClassSymbol firRegularClassSymbol;
            FirImportsChecker.checkCanBeImported$reportInvisibleParentClasses($context, $import, $reporter, classSymbol, depth);
            ClassId classId = classSymbol.getClassId().getOuterClassId();
            if (classId == null || (firRegularClassSymbol = INSTANCE.resolveToClass($context, classId)) == null) break block0;
            FirRegularClassSymbol it = firRegularClassSymbol;
            boolean bl = false;
            FirImportsChecker.checkCanBeImported$reportInvisibleParentClassesRecursively($context, $import, $reporter, it, depth + 1);
        }
    }

    private static final boolean checkOperatorRename$lambda$11(FirNamedFunctionSymbol it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        FirCallableSymbol $this$isOperator$iv = it;
        boolean $i$f$isOperator = false;
        return $this$isOperator$iv.getResolvedStatus().isOperator();
    }

    private static final Unit hasFunction$lambda$13(Ref.BooleanRef $result, Function1 $predicate, FirNamedFunctionSymbol sym) {
        Intrinsics.checkNotNullParameter((Object)sym, (String)"sym");
        if (!$result.element) {
            $result.element = (Boolean)$predicate.invoke((Object)sym);
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ boolean access$isVisible(FirImportsChecker $this, CheckerContext context2, FirBasedSymbol $receiver) {
        return $this.isVisible(context2, $receiver);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0004\u0004\u0005\u0006\u0007B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0004\b\t\n\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImportsChecker$ImportStatus;", "", "<init>", "()V", "OK", "Invisible", "CannotBeImported", "Unresolved", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImportsChecker$ImportStatus$CannotBeImported;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImportsChecker$ImportStatus$Invisible;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImportsChecker$ImportStatus$OK;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImportsChecker$ImportStatus$Unresolved;", "checkers"})
    private static abstract class ImportStatus {
        private ImportStatus() {
        }

        public /* synthetic */ ImportStatus(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImportsChecker$ImportStatus$CannotBeImported;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImportsChecker$ImportStatus;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "checkers"})
        public static final class CannotBeImported
        extends ImportStatus {
            @NotNull
            public static final CannotBeImported INSTANCE = new CannotBeImported();

            private CannotBeImported() {
                super(null);
            }

            @NotNull
            public String toString() {
                return "CannotBeImported";
            }

            public int hashCode() {
                return 1558473421;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof CannotBeImported)) {
                    return false;
                }
                CannotBeImported cfr_ignored_0 = (CannotBeImported)other;
                return true;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\u0017\u0010\t\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImportsChecker$ImportStatus$Invisible;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImportsChecker$ImportStatus;", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "<init>", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;)V", "getSymbol", "()Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "checkers"})
        public static final class Invisible
        extends ImportStatus {
            @NotNull
            private final FirCallableSymbol<?> symbol;

            public Invisible(@NotNull FirCallableSymbol<?> symbol) {
                Intrinsics.checkNotNullParameter(symbol, (String)"symbol");
                super(null);
                this.symbol = symbol;
            }

            @NotNull
            public final FirCallableSymbol<?> getSymbol() {
                return this.symbol;
            }

            @NotNull
            public final FirCallableSymbol<?> component1() {
                return this.symbol;
            }

            @NotNull
            public final Invisible copy(@NotNull FirCallableSymbol<?> symbol) {
                Intrinsics.checkNotNullParameter(symbol, (String)"symbol");
                return new Invisible(symbol);
            }

            public static /* synthetic */ Invisible copy$default(Invisible invisible, FirCallableSymbol firCallableSymbol, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    firCallableSymbol = invisible.symbol;
                }
                return invisible.copy(firCallableSymbol);
            }

            @NotNull
            public String toString() {
                return "Invisible(symbol=" + this.symbol + ')';
            }

            public int hashCode() {
                return this.symbol.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Invisible)) {
                    return false;
                }
                Invisible invisible = (Invisible)other;
                return Intrinsics.areEqual(this.symbol, invisible.symbol);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImportsChecker$ImportStatus$OK;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImportsChecker$ImportStatus;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "checkers"})
        public static final class OK
        extends ImportStatus {
            @NotNull
            public static final OK INSTANCE = new OK();

            private OK() {
                super(null);
            }

            @NotNull
            public String toString() {
                return "OK";
            }

            public int hashCode() {
                return -1967623169;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof OK)) {
                    return false;
                }
                OK cfr_ignored_0 = (OK)other;
                return true;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImportsChecker$ImportStatus$Unresolved;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImportsChecker$ImportStatus;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "checkers"})
        public static final class Unresolved
        extends ImportStatus {
            @NotNull
            public static final Unresolved INSTANCE = new Unresolved();

            private Unresolved() {
                super(null);
            }

            @NotNull
            public String toString() {
                return "Unresolved";
            }

            public int hashCode() {
                return -1417964332;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Unresolved)) {
                    return false;
                }
                Unresolved cfr_ignored_0 = (Unresolved)other;
                return true;
            }
        }
    }
}

