/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.linkage.partial;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.linkage.issues.PartialLinkageErrorsLogged;
import org.jetbrains.kotlin.backend.common.linkage.partial.ClassifierExplorer;
import org.jetbrains.kotlin.backend.common.linkage.partial.MissingDeclarationStubGenerator;
import org.jetbrains.kotlin.backend.common.linkage.partial.PartialLinkageLogLevel;
import org.jetbrains.kotlin.backend.common.linkage.partial.PartialLinkageLogger;
import org.jetbrains.kotlin.backend.common.linkage.partial.PartialLinkageSupportForLinker;
import org.jetbrains.kotlin.backend.common.linkage.partial.PartialLinkageUtilsKt;
import org.jetbrains.kotlin.backend.common.linkage.partial.PartiallyLinkedIrTreePatcher;
import org.jetbrains.kotlin.backend.common.overrides.IrLinkerFakeOverrideProvider;
import org.jetbrains.kotlin.backend.common.serialization.CompatibilityMode;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeAliasSymbol;
import org.jetbrains.kotlin.ir.util.SymbolTable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0013H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0010H\u0016J\u0010\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u0013H\u0016J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020%H\u0016J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u00100\u000fj\b\u0012\u0004\u0012\u00020\u0010`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u00130\u000fj\b\u0012\u0004\u0012\u00020\u0013`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/backend/common/linkage/partial/PartialLinkageSupportForLinkerImpl;", "Lorg/jetbrains/kotlin/backend/common/linkage/partial/PartialLinkageSupportForLinker;", "builtIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "logger", "Lorg/jetbrains/kotlin/backend/common/linkage/partial/PartialLinkageLogger;", "<init>", "(Lorg/jetbrains/kotlin/ir/IrBuiltIns;Lorg/jetbrains/kotlin/backend/common/linkage/partial/PartialLinkageLogger;)V", "stubGenerator", "Lorg/jetbrains/kotlin/backend/common/linkage/partial/MissingDeclarationStubGenerator;", "classifierExplorer", "Lorg/jetbrains/kotlin/backend/common/linkage/partial/ClassifierExplorer;", "patcher", "Lorg/jetbrains/kotlin/backend/common/linkage/partial/PartiallyLinkedIrTreePatcher;", "filesEnqueuedForProcessing", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "Lkotlin/collections/HashSet;", "declarationsEnqueuedForProcessing", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "isEnabled", "", "()Z", "shouldBeSkipped", "declaration", "enqueueFile", "", "file", "enqueueDeclaration", "exploreClassifiers", "fakeOverrideBuilder", "Lorg/jetbrains/kotlin/backend/common/overrides/IrLinkerFakeOverrideProvider;", "exploreClassifiersInInlineLazyIrFunction", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "generateStubsAndPatchUsages", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "generateStubsForClassifiers", "collectAllStubbedSymbols", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "ir.serialization.common"})
@SourceDebugExtension(value={"SMAP\nPartialLinkageSupportForLinkerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PartialLinkageSupportForLinkerImpl.kt\norg/jetbrains/kotlin/backend/common/linkage/partial/PartialLinkageSupportForLinkerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,108:1\n774#2:109\n865#2,2:110\n1869#2,2:112\n*S KotlinDebug\n*F\n+ 1 PartialLinkageSupportForLinkerImpl.kt\norg/jetbrains/kotlin/backend/common/linkage/partial/PartialLinkageSupportForLinkerImpl\n*L\n100#1:109\n100#1:110,2\n101#1:112,2\n*E\n"})
public final class PartialLinkageSupportForLinkerImpl
implements PartialLinkageSupportForLinker {
    @NotNull
    private final PartialLinkageLogger logger;
    @NotNull
    private final MissingDeclarationStubGenerator stubGenerator;
    @NotNull
    private final ClassifierExplorer classifierExplorer;
    @NotNull
    private final PartiallyLinkedIrTreePatcher patcher;
    @NotNull
    private final HashSet<IrFile> filesEnqueuedForProcessing;
    @NotNull
    private final HashSet<IrDeclaration> declarationsEnqueuedForProcessing;

    public PartialLinkageSupportForLinkerImpl(@NotNull IrBuiltIns builtIns, @NotNull PartialLinkageLogger logger) {
        Intrinsics.checkNotNullParameter((Object)builtIns, (String)"builtIns");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
        this.stubGenerator = new MissingDeclarationStubGenerator(builtIns);
        this.classifierExplorer = new ClassifierExplorer(builtIns, this.stubGenerator);
        this.patcher = new PartiallyLinkedIrTreePatcher(builtIns, this.classifierExplorer, this.stubGenerator, this.logger);
        this.filesEnqueuedForProcessing = new HashSet();
        this.declarationsEnqueuedForProcessing = new HashSet();
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public boolean shouldBeSkipped(@NotNull IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        return this.patcher.shouldBeSkipped(declaration);
    }

    @Override
    public void enqueueFile(@NotNull IrFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ((Collection)this.filesEnqueuedForProcessing).add(file);
    }

    @Override
    public void enqueueDeclaration(@NotNull IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        ((Collection)this.declarationsEnqueuedForProcessing).add(declaration);
    }

    @Override
    public void exploreClassifiers(@NotNull IrLinkerFakeOverrideProvider fakeOverrideBuilder) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)fakeOverrideBuilder, (String)"fakeOverrideBuilder");
        Map<IrClass, CompatibilityMode> entries = fakeOverrideBuilder.getFakeOverrideCandidates();
        if (entries.isEmpty()) {
            return;
        }
        Set $this$exploreClassifiers_u24lambda_u240 = set = SetsKt.createSetBuilder();
        boolean bl = false;
        for (IrClass clazz : entries.keySet()) {
            if (this.classifierExplorer.exploreSymbol(clazz.getSymbol()) == null) continue;
            ((Collection)$this$exploreClassifiers_u24lambda_u240).add(clazz);
        }
        Set toExclude = SetsKt.build((Set)set);
        CollectionsKt.removeAll((Collection)entries.keySet(), (Iterable)toExclude);
    }

    @Override
    public void exploreClassifiersInInlineLazyIrFunction(@NotNull IrFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        this.classifierExplorer.exploreIrElement(function2);
    }

    @Override
    public void generateStubsAndPatchUsages(@NotNull SymbolTable symbolTable) {
        Intrinsics.checkNotNullParameter((Object)symbolTable, (String)"symbolTable");
        for (IrSymbol symbol : symbolTable.getDescriptorExtension().getAllUnboundSymbols()) {
            this.stubGenerator.getDeclaration(symbol);
        }
        this.patcher.removeUnusableAnnotationsFromFiles(PartialLinkageUtilsKt.getCopyAndClear((Collection)this.filesEnqueuedForProcessing));
        this.patcher.patchDeclarations(PartialLinkageUtilsKt.getCopyAndClear((Collection)this.declarationsEnqueuedForProcessing));
        if (this.logger.getLogLevel() == PartialLinkageLogLevel.ERROR && this.patcher.getLinkageIssuesLogged() > 0) {
            PartialLinkageErrorsLogged.INSTANCE.raiseIssue(this.logger.getMessageCollector());
            throw new KotlinNothingValueException();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void generateStubsForClassifiers(@NotNull SymbolTable symbolTable) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)symbolTable, (String)"symbolTable");
        Iterable $this$filter$iv = symbolTable.getDescriptorExtension().getAllUnboundSymbols();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IrSymbol it = (IrSymbol)element$iv$iv;
            boolean bl = false;
            if (!(it instanceof IrClassifierSymbol || it instanceof IrTypeAliasSymbol)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrSymbol it = (IrSymbol)element$iv;
            boolean bl = false;
            this.stubGenerator.getDeclaration(it);
        }
    }

    @Override
    @NotNull
    public Set<IrSymbol> collectAllStubbedSymbols() {
        return this.stubGenerator.getAllStubbedSymbols();
    }
}

