/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.backend.common.CompilationExceptionKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.utils.IrJsUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrTransformer;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.utils.SmartList;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u001d\u001eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\f\u0010\u001a\u001a\u00020\u001b*\u00020\u001cH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/ThrowableLowering;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "throwableClass", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "throwableConstructors", "", "Lorg/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;", "newThrowableFunction", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "extendThrowableFunction", "setupCauseParameter", "setPropertiesToThrowableInstanceSymbol", "undefinedValue", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "lower", "", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "extractThrowableArguments", "Lorg/jetbrains/kotlin/ir/backend/js/lower/ThrowableLowering$ThrowableArguments;", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "ThrowableArguments", "Transformer", "backend.js"})
public final class ThrowableLowering
implements BodyLoweringPass {
    @NotNull
    private final JsIrBackendContext context;
    @NotNull
    private final IrClassSymbol throwableClass;
    @NotNull
    private final List<IrConstructorSymbol> throwableConstructors;
    @NotNull
    private final IrSimpleFunctionSymbol newThrowableFunction;
    @NotNull
    private final IrSimpleFunctionSymbol extendThrowableFunction;
    @NotNull
    private final IrSimpleFunctionSymbol setupCauseParameter;
    @NotNull
    private final IrSimpleFunctionSymbol setPropertiesToThrowableInstanceSymbol;

    public ThrowableLowering(@NotNull JsIrBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        this.throwableClass = this.context.getThrowableClass();
        this.throwableConstructors = this.context.getThrowableConstructors();
        this.newThrowableFunction = this.context.getNewThrowableSymbol();
        this.extendThrowableFunction = this.context.getExtendThrowableSymbol();
        this.setupCauseParameter = this.context.getSetupCauseParameterSymbol();
        this.setPropertiesToThrowableInstanceSymbol = this.context.getSetPropertiesToThrowableInstanceSymbol();
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    private final IrExpression undefinedValue() {
        return IrJsUtilsKt.getVoid(this.context);
    }

    @Override
    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container) {
        Intrinsics.checkNotNullParameter((Object)irBody, (String)"irBody");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        irBody.transformChildren(new Transformer(), container instanceof IrConstructor ? (IrConstructor)container : null);
    }

    private final ThrowableArguments extractThrowableArguments(IrFunctionAccessExpression $this$extractThrowableArguments) {
        ThrowableArguments throwableArguments;
        switch ($this$extractThrowableArguments.getArguments().size()) {
            case 0: {
                throwableArguments = new ThrowableArguments(null, null);
                break;
            }
            case 2: {
                throwableArguments = new ThrowableArguments((IrExpression)$this$extractThrowableArguments.getArguments().get(0), (IrExpression)$this$extractThrowableArguments.getArguments().get(1));
                break;
            }
            default: {
                Object e2 = $this$extractThrowableArguments.getArguments().get(0);
                Intrinsics.checkNotNull(e2);
                IrExpression arg = (IrExpression)e2;
                IrValueParameter parameter = ((IrFunctionSymbol)$this$extractThrowableArguments.getSymbol()).getOwner().getParameters().get(0);
                if (IrTypePredicatesKt.isNullableString(parameter.getType())) {
                    throwableArguments = new ThrowableArguments(arg, null);
                    break;
                }
                boolean bl = IrTypeUtilsKt.isThrowable(IrTypesKt.makeNotNull(parameter.getType()));
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                throwableArguments = new ThrowableArguments(null, arg);
            }
        }
        return throwableArguments;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J!\u0010\f\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/ThrowableLowering$ThrowableArguments;", "", "message", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "cause", "<init>", "(Lorg/jetbrains/kotlin/ir/expressions/IrExpression;Lorg/jetbrains/kotlin/ir/expressions/IrExpression;)V", "getMessage", "()Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "getCause", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "backend.js"})
    public static final class ThrowableArguments {
        @Nullable
        private final IrExpression message;
        @Nullable
        private final IrExpression cause;

        public ThrowableArguments(@Nullable IrExpression message2, @Nullable IrExpression cause) {
            this.message = message2;
            this.cause = cause;
        }

        @Nullable
        public final IrExpression getMessage() {
            return this.message;
        }

        @Nullable
        public final IrExpression getCause() {
            return this.cause;
        }

        @Nullable
        public final IrExpression component1() {
            return this.message;
        }

        @Nullable
        public final IrExpression component2() {
            return this.cause;
        }

        @NotNull
        public final ThrowableArguments copy(@Nullable IrExpression message2, @Nullable IrExpression cause) {
            return new ThrowableArguments(message2, cause);
        }

        public static /* synthetic */ ThrowableArguments copy$default(ThrowableArguments throwableArguments, IrExpression irExpression, IrExpression irExpression2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                irExpression = throwableArguments.message;
            }
            if ((n2 & 2) != 0) {
                irExpression2 = throwableArguments.cause;
            }
            return throwableArguments.copy(irExpression, irExpression2);
        }

        @NotNull
        public String toString() {
            return "ThrowableArguments(message=" + this.message + ", cause=" + this.cause + ')';
        }

        public int hashCode() {
            int result2 = this.message == null ? 0 : this.message.hashCode();
            result2 = result2 * 31 + (this.cause == null ? 0 : this.cause.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ThrowableArguments)) {
                return false;
            }
            ThrowableArguments throwableArguments = (ThrowableArguments)other;
            if (!Intrinsics.areEqual((Object)this.message, (Object)throwableArguments.message)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.cause, (Object)throwableArguments.cause);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\b\u0010\n\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\n\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00102\b\u0010\n\u001a\u0004\u0018\u00010\u0002H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/ThrowableLowering$Transformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrTransformer;", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/lower/ThrowableLowering;)V", "anyConstructor", "Lorg/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;", "visitConstructor", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "data", "visitConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "visitDelegatingConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "backend.js"})
    @SourceDebugExtension(value={"SMAP\nThrowableLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThrowableLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/ThrowableLowering$Transformer\n+ 2 CollectionUtil.kt\norg/jetbrains/kotlin/utils/CollectionUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,205:1\n32#2,2:206\n9#2,6:208\n1761#3,3:214\n230#3,2:217\n*S KotlinDebug\n*F\n+ 1 ThrowableLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/ThrowableLowering$Transformer\n*L\n119#1:206,2\n119#1:208,6\n120#1:214,3\n140#1:217,2\n*E\n"})
    public final class Transformer
    extends IrTransformer<IrConstructor> {
        @NotNull
        private final IrConstructorSymbol anyConstructor;

        public Transformer() {
            this.anyConstructor = (IrConstructorSymbol)SequencesKt.first(IrUtilsKt.getConstructors(ThrowableLowering.this.getContext().getIrBuiltIns().getAnyClass()));
        }

        @Override
        @NotNull
        public IrStatement visitConstructor(@NotNull IrConstructor declaration, @Nullable IrConstructor data) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            return super.visitConstructor(declaration, declaration);
        }

        @Override
        @NotNull
        public IrExpression visitConstructorCall(@NotNull IrConstructorCall expression2, @Nullable IrConstructor data) {
            IrCallImpl irCallImpl;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            expression2.transformChildren(this, data);
            if (!ThrowableLowering.this.throwableConstructors.contains(expression2.getSymbol())) {
                return expression2;
            }
            ThrowableArguments throwableArguments = ThrowableLowering.this.extractThrowableArguments(expression2);
            IrExpression messageArg = throwableArguments.component1();
            IrExpression causeArg = throwableArguments.component2();
            IrConstructorCall irConstructorCall = expression2;
            ThrowableLowering throwableLowering = ThrowableLowering.this;
            IrConstructorCall $this$visitConstructorCall_u24lambda_u241 = irConstructorCall;
            boolean bl = false;
            IrCallImpl it = irCallImpl = BuildersKt.IrCallImpl$default($this$visitConstructorCall_u24lambda_u241.getStartOffset(), $this$visitConstructorCall_u24lambda_u241.getEndOffset(), $this$visitConstructorCall_u24lambda_u241.getType(), throwableLowering.newThrowableFunction, 0, null, null, 96, null);
            boolean bl2 = false;
            IrMemberAccessExpression.ValueArgumentsList valueArgumentsList = it.getArguments();
            IrExpression irExpression = messageArg;
            if (irExpression == null) {
                irExpression = throwableLowering.undefinedValue();
            }
            valueArgumentsList.set(0, irExpression);
            IrMemberAccessExpression.ValueArgumentsList valueArgumentsList2 = it.getArguments();
            IrExpression irExpression2 = causeArg;
            if (irExpression2 == null) {
                irExpression2 = throwableLowering.undefinedValue();
            }
            valueArgumentsList2.set(1, irExpression2);
            return irCallImpl;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public IrExpression visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable IrConstructor data) {
            IrCallImpl irCallImpl;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            expression2.transformChildren(this, data);
            if (!ThrowableLowering.this.throwableConstructors.contains(expression2.getSymbol())) {
                return (IrExpression)expression2;
            }
            IrConstructor irConstructor = data;
            if (irConstructor == null) {
                CompilationExceptionKt.compilationException("Delegation call outside of constructor", (IrElement)expression2);
                throw new KotlinNothingValueException();
            }
            IrConstructor currentConstructor = irConstructor;
            IrClass klass = AdditionalIrUtilsKt.getConstructedClass(currentConstructor);
            ThrowableArguments throwableArguments = ThrowableLowering.this.extractThrowableArguments((IrFunctionAccessExpression)expression2);
            IrExpression messageArg = throwableArguments.component1();
            IrExpression causeArg = throwableArguments.component2();
            int n2 = expression2.getStartOffset();
            int n3 = expression2.getEndOffset();
            IrValueParameter irValueParameter = klass.getThisReceiver();
            Intrinsics.checkNotNull((Object)irValueParameter);
            IrGetValueImpl thisReceiver = BuildersKt.IrGetValueImpl$default(n2, n3, irValueParameter.getSymbol(), null, 8, null);
            if (ThrowableLowering.this.getContext().getEs6mode()) {
                void $this$visitDelegatingConstructorCall_u24lambda_u247;
                Unit unit;
                ThrowableLowering $this$visitDelegatingConstructorCall_u24lambda_u246;
                Object object;
                IrCall irCall;
                Object throwableCtorWithCause;
                Iterator function2;
                boolean bl;
                Object $i$f$filterIsInstanceAnd22;
                Object it;
                Object destination$iv$iv;
                Object delegatingCall;
                block17: {
                    void $this$any$iv;
                    List list;
                    Iterable $this$filterIsInstanceAnd$iv;
                    delegatingCall = expression2;
                    Collection collection = klass.getDeclarations();
                    boolean $i$f$filterIsInstanceAnd22 = false;
                    if ($this$filterIsInstanceAnd$iv.isEmpty()) {
                        list = CollectionsKt.emptyList();
                    } else {
                        void $this$filterIsInstanceAndTo$iv$iv;
                        Iterable iterable = $this$filterIsInstanceAnd$iv;
                        destination$iv$iv = new SmartList();
                        boolean $i$f$filterIsInstanceAndTo = false;
                        for (Object element$iv$iv : $this$filterIsInstanceAndTo$iv$iv) {
                            if (!(element$iv$iv instanceof IrSimpleFunction)) continue;
                            it = (IrSimpleFunction)element$iv$iv;
                            boolean bl2 = false;
                            if (!(!it.isFakeOverride())) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        list = (List)destination$iv$iv;
                    }
                    $this$filterIsInstanceAnd$iv = list;
                    $i$f$filterIsInstanceAnd22 = ThrowableLowering.this;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            Object property2;
                            function2 = (IrSimpleFunction)element$iv;
                            boolean bl3 = false;
                            Object object2 = ((IrSimpleFunction)((Object)function2)).getCorrespondingPropertySymbol();
                            if (!(object2 == null || (object2 = (IrProperty)object2.getOwner()) == null ? false : Intrinsics.areEqual((Object)(property2 = object2).getName(), (Object)Name.identifier("message")) && !((Collection)IrFakeOverrideUtilsKt.collectRealOverrides$default((IrOverridableDeclaration)property2, null, arg_0 -> Transformer.visitDelegatingConstructorCall$lambda$4$lambda$3((ThrowableLowering)$i$f$filterIsInstanceAnd22, arg_0), 1, null)).isEmpty())) continue;
                            bl = true;
                            break block17;
                        }
                        bl = false;
                    }
                }
                boolean thereIsAnOverrideOfThrowableMessage = bl;
                $i$f$filterIsInstanceAnd22 = JsIrBuilder.INSTANCE;
                IrExpression irExpression = messageArg;
                if (irExpression == null) {
                    irExpression = ThrowableLowering.this.undefinedValue();
                }
                Object $i$f$any = irExpression;
                destination$iv$iv = ThrowableLowering.this.getContext().getDynamicType();
                Object element$iv = IrDeclarationOrigin.Companion.getIR_TEMPORARY_VARIABLE();
                IrVariable messageTmp = JsIrBuilder.buildVar$default((JsIrBuilder)$i$f$filterIsInstanceAnd22, (IrType)destination$iv$iv, currentConstructor, null, false, false, false, (IrExpression)$i$f$any, (IrDeclarationOrigin)element$iv, 60, null);
                $i$f$any = JsIrBuilder.INSTANCE;
                IrExpression irExpression2 = causeArg;
                if (irExpression2 == null) {
                    irExpression2 = ThrowableLowering.this.undefinedValue();
                }
                destination$iv$iv = irExpression2;
                element$iv = ThrowableLowering.this.getContext().getDynamicType();
                function2 = IrDeclarationOrigin.Companion.getIR_TEMPORARY_VARIABLE();
                IrVariable causeTmp = JsIrBuilder.buildVar$default((JsIrBuilder)$i$f$any, (IrType)element$iv, currentConstructor, null, false, false, false, (IrExpression)destination$iv$iv, (IrDeclarationOrigin)((Object)function2), 60, null);
                if (causeArg != null) {
                    Object element$iv22;
                    block18: {
                        Iterable $this$first$iv = ThrowableLowering.this.throwableConstructors;
                        boolean $i$f$first = false;
                        for (Object element$iv22 : $this$first$iv) {
                            it = (IrConstructorSymbol)element$iv22;
                            boolean bl4 = false;
                            if (!(((IrConstructor)it.getOwner()).getParameters().size() == 2)) continue;
                            break block18;
                        }
                        throw new NoSuchElementException("Collection contains no element matching the predicate.");
                    }
                    throwableCtorWithCause = (IrConstructorSymbol)element$iv22;
                    if (!Intrinsics.areEqual((Object)delegatingCall.getSymbol(), (Object)throwableCtorWithCause)) {
                        delegatingCall = JsIrBuilder.buildDelegatingConstructorCall$default(JsIrBuilder.INSTANCE, (IrConstructorSymbol)throwableCtorWithCause, null, expression2.getStartOffset(), expression2.getEndOffset(), 2, null);
                    }
                    IrCall $i$f$first = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, ThrowableLowering.this.setupCauseParameter, null, null, null, null, 0, 0, 126, null);
                    int n4 = 1;
                    object = delegatingCall.getArguments();
                    boolean bl5 = false;
                    ((IrMemberAccessExpression)((Object)$this$visitDelegatingConstructorCall_u24lambda_u246)).getArguments().set(0, JsIrBuilder.buildGetValue$default(JsIrBuilder.INSTANCE, causeTmp.getSymbol(), null, 2, null));
                    unit = Unit.INSTANCE;
                    ((ArrayList)object).set(n4, irCall);
                }
                if (messageArg != null) {
                    delegatingCall.getArguments().set(0, JsIrBuilder.buildGetValue$default(JsIrBuilder.INSTANCE, messageTmp.getSymbol(), null, 2, null));
                }
                throwableCtorWithCause = new IrElement[4];
                throwableCtorWithCause[0] = messageTmp;
                throwableCtorWithCause[1] = causeTmp;
                throwableCtorWithCause[2] = delegatingCall;
                irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, ThrowableLowering.this.setPropertiesToThrowableInstanceSymbol, null, null, null, null, 0, 0, 126, null);
                $this$visitDelegatingConstructorCall_u24lambda_u246 = ThrowableLowering.this;
                IrCall bl5 = irCall;
                int n5 = 3;
                unit = throwableCtorWithCause;
                IrType irType = ThrowableLowering.this.getContext().getIrBuiltIns().getUnitType();
                object = JsIrBuilder.INSTANCE;
                boolean bl6 = false;
                $this$visitDelegatingConstructorCall_u24lambda_u247.getArguments().set(0, thisReceiver);
                $this$visitDelegatingConstructorCall_u24lambda_u247.getArguments().set(1, thereIsAnOverrideOfThrowableMessage ? (IrExpression)JsIrBuilder.INSTANCE.buildString($this$visitDelegatingConstructorCall_u24lambda_u246.getContext().getIrBuiltIns().getStringType(), "") : (causeArg != null || messageArg != null ? (IrExpression)JsIrBuilder.buildGetValue$default(JsIrBuilder.INSTANCE, messageTmp.getSymbol(), null, 2, null) : $this$visitDelegatingConstructorCall_u24lambda_u246.undefinedValue()));
                $this$visitDelegatingConstructorCall_u24lambda_u247.getArguments().set(2, causeArg != null ? (IrExpression)JsIrBuilder.buildGetValue$default(JsIrBuilder.INSTANCE, causeTmp.getSymbol(), null, 2, null) : $this$visitDelegatingConstructorCall_u24lambda_u246.undefinedValue());
                Unit unit2 = Unit.INSTANCE;
                unit[n5] = irCall;
                return ((JsIrBuilder)object).buildComposite(irType, CollectionsKt.listOf((Object[])throwableCtorWithCause));
            }
            Object[] objectArray = expression2;
            ThrowableLowering throwableLowering = ThrowableLowering.this;
            Object[] $this$visitDelegatingConstructorCall_u24lambda_u249 = objectArray;
            boolean bl = false;
            IrCallImpl $this$visitDelegatingConstructorCall_u24lambda_u249_u24lambda_u248 = irCallImpl = BuildersKt.IrCallImpl$default($this$visitDelegatingConstructorCall_u24lambda_u249.getStartOffset(), $this$visitDelegatingConstructorCall_u24lambda_u249.getEndOffset(), $this$visitDelegatingConstructorCall_u24lambda_u249.getType(), throwableLowering.extendThrowableFunction, 0, null, null, 96, null);
            boolean bl7 = false;
            $this$visitDelegatingConstructorCall_u24lambda_u249_u24lambda_u248.getArguments().set(0, thisReceiver);
            IrMemberAccessExpression.ValueArgumentsList valueArgumentsList = $this$visitDelegatingConstructorCall_u24lambda_u249_u24lambda_u248.getArguments();
            IrExpression irExpression = messageArg;
            if (irExpression == null) {
                irExpression = throwableLowering.undefinedValue();
            }
            valueArgumentsList.set(1, irExpression);
            IrMemberAccessExpression.ValueArgumentsList valueArgumentsList2 = $this$visitDelegatingConstructorCall_u24lambda_u249_u24lambda_u248.getArguments();
            IrExpression irExpression3 = causeArg;
            if (irExpression3 == null) {
                irExpression3 = throwableLowering.undefinedValue();
            }
            valueArgumentsList2.set(2, irExpression3);
            IrCallImpl expressionReplacement = irCallImpl;
            objectArray = new IrFunctionAccessExpression[]{BuildersKt.IrDelegatingConstructorCallImpl$default(expression2.getStartOffset(), expression2.getEndOffset(), ThrowableLowering.this.getContext().getIrBuiltIns().getAnyType(), this.anyConstructor, 0, null, 32, null), expressionReplacement};
            return JsIrBuilder.INSTANCE.buildComposite(ThrowableLowering.this.getContext().getIrBuiltIns().getUnitType(), CollectionsKt.listOf((Object[])objectArray));
        }

        private static final boolean visitDelegatingConstructorCall$lambda$4$lambda$3(ThrowableLowering this$0, IrProperty it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Intrinsics.areEqual((Object)it.getParent(), this$0.throwableClass.getOwner());
        }
    }
}

