/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.deprecation;

import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.metadata.deserialization.VersionRequirement;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationLevelValue;
import org.jetbrains.kotlin.resolve.deprecation.DescriptorBasedDeprecationInfo;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/resolve/deprecation/DeprecatedByVersionRequirement;", "Lorg/jetbrains/kotlin/resolve/deprecation/DescriptorBasedDeprecationInfo;", "versionRequirement", "Lorg/jetbrains/kotlin/metadata/deserialization/VersionRequirement;", "target", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "<init>", "(Lorg/jetbrains/kotlin/metadata/deserialization/VersionRequirement;Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)V", "getVersionRequirement", "()Lorg/jetbrains/kotlin/metadata/deserialization/VersionRequirement;", "getTarget", "()Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "deprecationLevel", "Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationLevelValue;", "getDeprecationLevel", "()Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationLevelValue;", "message", "", "getMessage", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "frontend"})
public final class DeprecatedByVersionRequirement
extends DescriptorBasedDeprecationInfo {
    @NotNull
    private final VersionRequirement versionRequirement;
    @NotNull
    private final DeclarationDescriptor target;

    public DeprecatedByVersionRequirement(@NotNull VersionRequirement versionRequirement, @NotNull DeclarationDescriptor target) {
        Intrinsics.checkNotNullParameter((Object)versionRequirement, (String)"versionRequirement");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.versionRequirement = versionRequirement;
        this.target = target;
    }

    @NotNull
    public final VersionRequirement getVersionRequirement() {
        return this.versionRequirement;
    }

    @Override
    @NotNull
    public DeclarationDescriptor getTarget() {
        return this.target;
    }

    @Override
    @NotNull
    public DeprecationLevelValue getDeprecationLevel() {
        DeprecationLevelValue deprecationLevelValue;
        switch (WhenMappings.$EnumSwitchMapping$0[this.versionRequirement.getLevel().ordinal()]) {
            case 1: {
                deprecationLevelValue = DeprecationLevelValue.WARNING;
                break;
            }
            case 2: {
                deprecationLevelValue = DeprecationLevelValue.ERROR;
                break;
            }
            case 3: {
                deprecationLevelValue = DeprecationLevelValue.HIDDEN;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return deprecationLevelValue;
    }

    @Override
    @Nullable
    public String getMessage() {
        StringBuilder stringBuilder;
        String message2 = this.versionRequirement.getMessage();
        Integer errorCode = this.versionRequirement.getErrorCode();
        if (message2 == null && errorCode == null) {
            return null;
        }
        StringBuilder $this$_get_message__u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (message2 != null) {
            $this$_get_message__u24lambda_u240.append(message2);
            if (errorCode != null) {
                $this$_get_message__u24lambda_u240.append(" (error code " + errorCode + ')');
            }
        } else {
            $this$_get_message__u24lambda_u240.append("Error code " + errorCode);
        }
        return stringBuilder.toString();
    }

    @NotNull
    public final VersionRequirement component1() {
        return this.versionRequirement;
    }

    @NotNull
    public final DeclarationDescriptor component2() {
        return this.target;
    }

    @NotNull
    public final DeprecatedByVersionRequirement copy(@NotNull VersionRequirement versionRequirement, @NotNull DeclarationDescriptor target) {
        Intrinsics.checkNotNullParameter((Object)versionRequirement, (String)"versionRequirement");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return new DeprecatedByVersionRequirement(versionRequirement, target);
    }

    public static /* synthetic */ DeprecatedByVersionRequirement copy$default(DeprecatedByVersionRequirement deprecatedByVersionRequirement, VersionRequirement versionRequirement, DeclarationDescriptor declarationDescriptor, int n, Object object) {
        if ((n & 1) != 0) {
            versionRequirement = deprecatedByVersionRequirement.versionRequirement;
        }
        if ((n & 2) != 0) {
            declarationDescriptor = deprecatedByVersionRequirement.target;
        }
        return deprecatedByVersionRequirement.copy(versionRequirement, declarationDescriptor);
    }

    @NotNull
    public String toString() {
        return "DeprecatedByVersionRequirement(versionRequirement=" + this.versionRequirement + ", target=" + this.target + ')';
    }

    public int hashCode() {
        int result2 = this.versionRequirement.hashCode();
        result2 = result2 * 31 + this.target.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DeprecatedByVersionRequirement)) {
            return false;
        }
        DeprecatedByVersionRequirement deprecatedByVersionRequirement = (DeprecatedByVersionRequirement)other;
        if (!Intrinsics.areEqual((Object)this.versionRequirement, (Object)deprecatedByVersionRequirement.versionRequirement)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.target, (Object)deprecatedByVersionRequirement.target);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DeprecationLevel.values().length];
            try {
                nArray[DeprecationLevel.WARNING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeprecationLevel.ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeprecationLevel.HIDDEN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

