/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.resolve.calls.model.CollectionLiteralKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.SimpleKotlinCallArgument;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.multiplatform.ExpectedActualResolverKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValueWithSmartCastInfo;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.checker.IntersectionTypeKt;
import org.jetbrains.kotlin.types.checker.NewCapturedTypeKt;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.utils.DFS;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u001c\u0010\u000b\u001a\u00020\u0005*\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a\n\u0010\u0015\u001a\u00020\u0011*\u00020\u0012\u001a \u0010\u0016\u001a\u00020\u0011*\u00020\u00122\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00110\u0018H\u0002\u001a\u001c\u0010\u001b\u001a\u00020\u0011*\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u001c\u0010\u001c\u001a\u00020\u0011*\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\n\u0010\u001d\u001a\u00020\u0011*\u00020\u0003\"\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0015\u0010\t\u001a\u00020\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\b\"\u0015\u0010\u0010\u001a\u00020\u0011*\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0013\"\u0015\u0010\u0010\u001a\u00020\u0011*\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0014\"\u0015\u0010\u0019\u001a\u00020\u0011*\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0013\"\u0015\u0010\u001a\u001a\u00020\u0011*\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0013\u00a8\u0006\u001e"}, d2={"unexpectedArgument", "", "argument", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallArgument;", "unstableType", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValueWithSmartCastInfo;", "getUnstableType", "(Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValueWithSmartCastInfo;)Lorg/jetbrains/kotlin/types/UnwrappedType;", "stableType", "getStableType", "getExpectedType", "parameter", "Lorg/jetbrains/kotlin/descriptors/ParameterDescriptor;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "isVararg", "", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;)Z", "(Lorg/jetbrains/kotlin/descriptors/ParameterDescriptor;)Z", "hasDefaultValue", "checkExpectedParameter", "checker", "Lkotlin/Function1;", "isActualParameterWithAnyExpectedDefault", "isActualParameterWithCorrespondingExpectedDefault", "isArrayAssignedAsNamedArgumentInAnnotation", "isArrayAssignedAsNamedArgumentInFunction", "isArrayOrArrayLiteral", "resolution"})
@SourceDebugExtension(value={"SMAP\nArgumentsUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArgumentsUtils.kt\norg/jetbrains/kotlin/resolve/calls/components/ArgumentsUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,179:1\n1563#2:180\n1634#2,3:181\n*S KotlinDebug\n*F\n+ 1 ArgumentsUtils.kt\norg/jetbrains/kotlin/resolve/calls/components/ArgumentsUtilsKt\n*L\n105#1:180\n105#1:181,3\n*E\n"})
public final class ArgumentsUtilsKt {
    @NotNull
    public static final Void unexpectedArgument(@NotNull KotlinCallArgument argument) {
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        throw new IllegalStateException(("Unexpected argument type: " + argument + ", " + argument.getClass().getCanonicalName() + '.').toString());
    }

    @Nullable
    public static final UnwrappedType getUnstableType(@NotNull ReceiverValueWithSmartCastInfo $this$unstableType) {
        Intrinsics.checkNotNullParameter((Object)$this$unstableType, (String)"<this>");
        if ($this$unstableType.isStable() || !$this$unstableType.hasTypesFromSmartCasts()) {
            return $this$unstableType.isStable() ? null : $this$unstableType.getReceiverValue().getType().unwrap();
        }
        UnwrappedType intersectionType = IntersectionTypeKt.intersectWrappedTypes((Collection<? extends KotlinType>)$this$unstableType.getAllOriginalTypes());
        UnwrappedType unwrappedType = NewCapturedTypeKt.prepareArgumentTypeRegardingCaptureTypes(intersectionType);
        if (unwrappedType == null) {
            unwrappedType = intersectionType;
        }
        return unwrappedType;
    }

    @NotNull
    public static final UnwrappedType getStableType(@NotNull ReceiverValueWithSmartCastInfo $this$stableType) {
        Intrinsics.checkNotNullParameter((Object)$this$stableType, (String)"<this>");
        if (!$this$stableType.isStable() || !$this$stableType.hasTypesFromSmartCasts()) {
            return $this$stableType.getReceiverValue().getType().unwrap();
        }
        UnwrappedType intersectionType = IntersectionTypeKt.intersectWrappedTypes((Collection<? extends KotlinType>)$this$stableType.getAllOriginalTypes());
        if (TypeUtilsKt.isNullableNothing(intersectionType) && !intersectionType.isMarkedNullable()) {
            return TypeUtilsKt.makeNullable(intersectionType).unwrap();
        }
        UnwrappedType unwrappedType = NewCapturedTypeKt.prepareArgumentTypeRegardingCaptureTypes(intersectionType);
        if (unwrappedType == null) {
            unwrappedType = intersectionType;
        }
        return unwrappedType;
    }

    @NotNull
    public static final UnwrappedType getExpectedType(@NotNull KotlinCallArgument $this$getExpectedType, @NotNull ParameterDescriptor parameter, @NotNull LanguageVersionSettings languageVersionSettings) {
        Annotated annotated;
        Intrinsics.checkNotNullParameter((Object)$this$getExpectedType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        if ($this$getExpectedType.isSpread() || ArgumentsUtilsKt.isArrayAssignedAsNamedArgumentInAnnotation($this$getExpectedType, parameter, languageVersionSettings) || ArgumentsUtilsKt.isArrayAssignedAsNamedArgumentInFunction($this$getExpectedType, parameter, languageVersionSettings)) {
            annotated = parameter.getType().unwrap();
        } else {
            annotated = parameter instanceof ValueParameterDescriptor ? (ValueParameterDescriptor)parameter : null;
            if (annotated == null || (annotated = annotated.getVarargElementType()) == null || (annotated = ((KotlinType)annotated).unwrap()) == null) {
                annotated = parameter.getType().unwrap();
            }
        }
        return annotated;
    }

    public static final boolean isVararg(@NotNull ValueParameterDescriptor $this$isVararg) {
        Intrinsics.checkNotNullParameter((Object)$this$isVararg, (String)"<this>");
        return $this$isVararg.getVarargElementType() != null;
    }

    public static final boolean isVararg(@NotNull ParameterDescriptor $this$isVararg) {
        Intrinsics.checkNotNullParameter((Object)$this$isVararg, (String)"<this>");
        ValueParameterDescriptor valueParameterDescriptor = $this$isVararg instanceof ValueParameterDescriptor ? (ValueParameterDescriptor)$this$isVararg : null;
        return valueParameterDescriptor != null ? ArgumentsUtilsKt.isVararg(valueParameterDescriptor) : false;
    }

    public static final boolean hasDefaultValue(@NotNull ValueParameterDescriptor $this$hasDefaultValue) {
        Intrinsics.checkNotNullParameter((Object)$this$hasDefaultValue, (String)"<this>");
        Boolean bl = DFS.ifAny(CollectionsKt.listOf((Object)$this$hasDefaultValue), ArgumentsUtilsKt::hasDefaultValue$lambda$0, ArgumentsUtilsKt::hasDefaultValue$lambda$1);
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"ifAny(...)");
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean checkExpectedParameter(ValueParameterDescriptor $this$checkExpectedParameter, Function1<? super ValueParameterDescriptor, Boolean> checker) {
        CallableDescriptor function2 = $this$checkExpectedParameter.getContainingDeclaration();
        if (!(function2 instanceof FunctionDescriptor)) return false;
        if (!((FunctionDescriptor)function2).isActual()) return false;
        MemberDescriptor expected = (MemberDescriptor)CollectionsKt.firstOrNull((List)ExpectedActualResolverKt.findCompatibleExpectsForActual$default((MemberDescriptor)((Object)function2), null, 1, null));
        if (!(expected instanceof FunctionDescriptor)) return false;
        ValueParameterDescriptor valueParameterDescriptor = ((FunctionDescriptor)expected).getValueParameters().get($this$checkExpectedParameter.getIndex());
        Intrinsics.checkNotNullExpressionValue((Object)valueParameterDescriptor, (String)"get(...)");
        if ((Boolean)checker.invoke((Object)valueParameterDescriptor) == false) return false;
        return true;
    }

    public static final boolean isActualParameterWithAnyExpectedDefault(@NotNull ValueParameterDescriptor $this$isActualParameterWithAnyExpectedDefault) {
        Intrinsics.checkNotNullParameter((Object)$this$isActualParameterWithAnyExpectedDefault, (String)"<this>");
        return ArgumentsUtilsKt.checkExpectedParameter($this$isActualParameterWithAnyExpectedDefault, (Function1<? super ValueParameterDescriptor, Boolean>)((Function1)ArgumentsUtilsKt::_get_isActualParameterWithAnyExpectedDefault_$lambda$2));
    }

    public static final boolean isActualParameterWithCorrespondingExpectedDefault(@NotNull ValueParameterDescriptor $this$isActualParameterWithCorrespondingExpectedDefault) {
        Intrinsics.checkNotNullParameter((Object)$this$isActualParameterWithCorrespondingExpectedDefault, (String)"<this>");
        return ArgumentsUtilsKt.checkExpectedParameter($this$isActualParameterWithCorrespondingExpectedDefault, (Function1<? super ValueParameterDescriptor, Boolean>)((Function1)ArgumentsUtilsKt::_get_isActualParameterWithCorrespondingExpectedDefault_$lambda$3));
    }

    private static final boolean isArrayAssignedAsNamedArgumentInAnnotation(KotlinCallArgument $this$isArrayAssignedAsNamedArgumentInAnnotation, ParameterDescriptor parameter, LanguageVersionSettings languageVersionSettings) {
        boolean isAllowedAssigningSingleElementsToVarargsInNamedForm;
        if (!languageVersionSettings.supportsFeature(LanguageFeature.AssigningArraysToVarargsInNamedFormInAnnotations)) {
            return false;
        }
        boolean bl = isAllowedAssigningSingleElementsToVarargsInNamedForm = !languageVersionSettings.supportsFeature(LanguageFeature.ProhibitAssigningSingleElementsToVarargsInNamedForm);
        if (isAllowedAssigningSingleElementsToVarargsInNamedForm && !ArgumentsUtilsKt.isArrayOrArrayLiteral($this$isArrayAssignedAsNamedArgumentInAnnotation)) {
            return false;
        }
        return $this$isArrayAssignedAsNamedArgumentInAnnotation.getArgumentName() != null && ArgumentsUtilsKt.isVararg(parameter) && DescriptorUtilsKt.isParameterOfAnnotation(parameter);
    }

    private static final boolean isArrayAssignedAsNamedArgumentInFunction(KotlinCallArgument $this$isArrayAssignedAsNamedArgumentInFunction, ParameterDescriptor parameter, LanguageVersionSettings languageVersionSettings) {
        boolean isAllowedAssigningSingleElementsToVarargsInNamedForm;
        if (!languageVersionSettings.supportsFeature(LanguageFeature.AllowAssigningArrayElementsToVarargsInNamedFormForFunctions)) {
            return false;
        }
        boolean bl = isAllowedAssigningSingleElementsToVarargsInNamedForm = !languageVersionSettings.supportsFeature(LanguageFeature.ProhibitAssigningSingleElementsToVarargsInNamedForm);
        if (isAllowedAssigningSingleElementsToVarargsInNamedForm && !ArgumentsUtilsKt.isArrayOrArrayLiteral($this$isArrayAssignedAsNamedArgumentInFunction)) {
            return false;
        }
        return $this$isArrayAssignedAsNamedArgumentInFunction.getArgumentName() != null && ArgumentsUtilsKt.isVararg(parameter);
    }

    public static final boolean isArrayOrArrayLiteral(@NotNull KotlinCallArgument $this$isArrayOrArrayLiteral) {
        Intrinsics.checkNotNullParameter((Object)$this$isArrayOrArrayLiteral, (String)"<this>");
        if ($this$isArrayOrArrayLiteral instanceof CollectionLiteralKotlinCallArgument) {
            return true;
        }
        if (!($this$isArrayOrArrayLiteral instanceof SimpleKotlinCallArgument)) {
            return false;
        }
        KotlinType kotlinType = ((SimpleKotlinCallArgument)$this$isArrayOrArrayLiteral).getReceiver().getReceiverValue().getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
        KotlinType type2 = kotlinType;
        return KotlinBuiltIns.isArrayOrPrimitiveArray(type2);
    }

    /*
     * WARNING - void declaration
     */
    private static final Iterable hasDefaultValue$lambda$0(ValueParameterDescriptor current) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = current.getOverriddenDescriptors();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getOriginal());
        }
        return (List)destination$iv$iv;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final Boolean hasDefaultValue$lambda$1(ValueParameterDescriptor it) {
        boolean bl;
        if (!it.declaresDefaultValue()) {
            Intrinsics.checkNotNull((Object)it);
            if (!ArgumentsUtilsKt.isActualParameterWithCorrespondingExpectedDefault(it)) {
                bl = false;
                return bl;
            }
        }
        bl = true;
        return bl;
    }

    private static final boolean _get_isActualParameterWithAnyExpectedDefault_$lambda$2(ValueParameterDescriptor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ArgumentsUtilsKt.hasDefaultValue(it);
    }

    private static final boolean _get_isActualParameterWithCorrespondingExpectedDefault_$lambda$3(ValueParameterDescriptor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.declaresDefaultValue();
    }
}

