/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableSet;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiPackage;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.search.LocalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.search.PackageScope;
import org.jetbrains.kotlin.com.intellij.psi.search.SearchScope;
import org.jetbrains.kotlin.com.intellij.psi.stubs.IStubElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtDeclarationStub;
import org.jetbrains.kotlin.psi.KtDeclarationWithInitializer;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedDeclarationUtil;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.stubs.KotlinStubWithFqName;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.util.OperatorNameConventions;

abstract class KtNamedDeclarationStub<T extends KotlinStubWithFqName<?>>
extends KtDeclarationStub<T>
implements KtNamedDeclaration {
    private static final Set<String> FUNCTIONLIKE_CONVENTIONS = ImmutableSet.of(OperatorNameConventions.INVOKE.asString(), OperatorNameConventions.GET.asString());

    public KtNamedDeclarationStub(@NotNull T stub, @NotNull IStubElementType nodeType) {
        if (stub == null) {
            KtNamedDeclarationStub.$$$reportNull$$$0(0);
        }
        if (nodeType == null) {
            KtNamedDeclarationStub.$$$reportNull$$$0(1);
        }
        super(stub, nodeType);
    }

    public KtNamedDeclarationStub(@NotNull ASTNode node) {
        if (node == null) {
            KtNamedDeclarationStub.$$$reportNull$$$0(2);
        }
        super(node);
    }

    @Override
    public String getName() {
        KotlinStubWithFqName stub = (KotlinStubWithFqName)this.getGreenStub();
        if (stub != null) {
            return stub.getName();
        }
        PsiElement identifier = this.getNameIdentifier();
        if (identifier != null) {
            String text = identifier.getText();
            return text != null ? KtPsiUtil.unquoteIdentifier(text) : null;
        }
        return null;
    }

    @Override
    public Name getNameAsName() {
        String name2 = this.getName();
        return name2 != null ? Name.identifier(name2) : null;
    }

    @Override
    @NotNull
    public Name getNameAsSafeName() {
        Name name2 = KtPsiUtil.safeName(this.getName());
        if (name2 == null) {
            KtNamedDeclarationStub.$$$reportNull$$$0(3);
        }
        return name2;
    }

    @Override
    public PsiElement getNameIdentifier() {
        return this.findChildByType(KtTokens.IDENTIFIER);
    }

    private static boolean shouldDropOperatorKeyword(String oldName, String newName) {
        return !OperatorConventions.isConventionName(Name.identifier(newName)) || FUNCTIONLIKE_CONVENTIONS.contains(oldName) != FUNCTIONLIKE_CONVENTIONS.contains(newName);
    }

    @Override
    public PsiElement setName(@NonNls @NotNull String name2) throws IncorrectOperationException {
        PsiElement newIdentifier;
        PsiElement identifier;
        if (name2 == null) {
            KtNamedDeclarationStub.$$$reportNull$$$0(4);
        }
        if ((identifier = this.getNameIdentifier()) == null) {
            return null;
        }
        KtModifierList modifierList2 = this.getModifierList();
        if (modifierList2 != null && modifierList2.hasModifier(KtTokens.OPERATOR_KEYWORD) && KtNamedDeclarationStub.shouldDropOperatorKeyword(this.getName(), name2)) {
            this.removeModifier(KtTokens.OPERATOR_KEYWORD);
        }
        if ((newIdentifier = new KtPsiFactory(this.getProject()).createNameIdentifierIfPossible(KtPsiUtilKt.quoteIfNeeded(name2))) != null) {
            KtPsiUtilKt.astReplace(identifier, newIdentifier);
        } else {
            identifier.delete();
        }
        return this;
    }

    @Override
    public int getTextOffset() {
        PsiElement identifier = this.getNameIdentifier();
        return identifier != null ? identifier.getTextRange().getStartOffset() : this.getTextRange().getStartOffset();
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        PsiElement grandParent;
        KtElement enclosingBlock = KtPsiUtil.getEnclosingElementForLocalDeclaration(this, false);
        if (enclosingBlock != null) {
            KtExpression condition;
            KtDeclarationWithInitializer declaration;
            PsiElement enclosingParent = enclosingBlock.getParent();
            KtObjectDeclaration containingObject = PsiTreeUtil.getParentOfType((PsiElement)this, KtObjectDeclaration.class);
            if (containingObject != null && containingObject.isObjectLiteral() && (declaration = PsiTreeUtil.getParentOfType((PsiElement)containingObject, KtDeclarationWithInitializer.class)) != null && declaration.hasModifier(KtTokens.PRIVATE_KEYWORD)) {
                if (enclosingParent instanceof KtFile) {
                    return new LocalSearchScope(enclosingParent);
                }
                if (enclosingParent instanceof KtObjectDeclaration && ((KtObjectDeclaration)enclosingParent).isCompanion()) {
                    return new LocalSearchScope(enclosingParent.getParent());
                }
            }
            if (enclosingParent instanceof KtContainerNode) {
                enclosingParent = enclosingParent.getParent();
            }
            if (enclosingBlock instanceof KtBlockExpression && enclosingParent instanceof KtDoWhileExpression && (condition = ((KtDoWhileExpression)enclosingParent).getCondition()) != null) {
                return new LocalSearchScope(new PsiElement[]{enclosingBlock, condition});
            }
            return new LocalSearchScope(enclosingBlock);
        }
        PsiElement parent2 = this.getParent();
        PsiElement psiElement = grandParent = parent2 != null ? parent2.getParent() : null;
        if (parent2 instanceof KtBlockExpression && grandParent instanceof KtScript) {
            return new LocalSearchScope(this.getContainingFile());
        }
        if (this.hasModifier(KtTokens.PRIVATE_KEYWORD)) {
            KtElement companionObjectClass;
            KtElement containingClass = PsiTreeUtil.getParentOfType((PsiElement)this, KtClassOrObject.class);
            if (containingClass instanceof KtObjectDeclaration && ((KtObjectDeclaration)containingClass).isCompanion() && (companionObjectClass = (KtElement)PsiTreeUtil.getParentOfType((PsiElement)containingClass, KtClassOrObject.class)) != null) {
                containingClass = companionObjectClass;
            }
            if (containingClass != null) {
                return new LocalSearchScope(containingClass);
            }
            KtFile ktFile = this.getContainingKtFile();
            if (this instanceof KtClassOrObject) {
                Project project = this.getProject();
                GlobalSearchScope kotlinFilesScope = GlobalSearchScope.getScopeRestrictedByFileTypes(GlobalSearchScope.allScope(project), KotlinFileType.INSTANCE);
                GlobalSearchScope fileScope = GlobalSearchScope.fileScope(ktFile);
                PsiPackage psiPackage = JavaPsiFacade.getInstance(project).findPackage(ktFile.getPackageFqName().asString());
                SearchScope superScope = super.getUseScope();
                if (psiPackage == null) {
                    SearchScope searchScope = superScope;
                    if (searchScope == null) {
                        KtNamedDeclarationStub.$$$reportNull$$$0(5);
                    }
                    return searchScope;
                }
                SearchScope jvmScope = PackageScope.packageScope(psiPackage, false).intersectWith(superScope);
                SearchScope nonKotlinJvmScope = GlobalSearchScope.notScope(kotlinFilesScope).intersectWith(jvmScope);
                SearchScope searchScope = ((SearchScope)fileScope).union(nonKotlinJvmScope);
                if (searchScope == null) {
                    KtNamedDeclarationStub.$$$reportNull$$$0(6);
                }
                return searchScope;
            }
            return new LocalSearchScope(ktFile);
        }
        SearchScope scope2 = super.getUseScope();
        KtClassOrObject classOrObject = KtPsiUtilKt.getContainingClassOrObject(this);
        if (classOrObject != null) {
            scope2 = scope2.intersectWith(classOrObject.getUseScope());
        }
        SearchScope searchScope = scope2;
        if (searchScope == null) {
            KtNamedDeclarationStub.$$$reportNull$$$0(7);
        }
        return searchScope;
    }

    @Override
    @Nullable
    public FqName getFqName() {
        KotlinStubWithFqName stub = (KotlinStubWithFqName)this.getGreenStub();
        if (stub != null) {
            return stub.getFqName();
        }
        return KtNamedDeclarationUtil.getFQName(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/psi/KtNamedDeclarationStub";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/psi/KtNamedDeclarationStub";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameAsSafeName";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

