/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.components;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.load.java.components.JavaResolverCache;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.lazy.ResolveSession;
import org.jetbrains.kotlin.resolve.lazy.ResolveSessionUtils;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyPackageDescriptor;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000f\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/load/java/components/AbstractJavaResolverCache;", "Lorg/jetbrains/kotlin/load/java/components/JavaResolverCache;", "resolveSession", "Lorg/jetbrains/kotlin/resolve/lazy/ResolveSession;", "<init>", "(Lorg/jetbrains/kotlin/resolve/lazy/ResolveSession;)V", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "getTrace", "()Lorg/jetbrains/kotlin/resolve/BindingTrace;", "getClassResolvedFromSource", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "findInPackageFragments", "fullFqName", "frontend.java"})
@SourceDebugExtension(value={"SMAP\nAbstractJavaResolverCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractJavaResolverCache.kt\norg/jetbrains/kotlin/load/java/components/AbstractJavaResolverCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,53:1\n1#2:54\n*E\n"})
public abstract class AbstractJavaResolverCache
implements JavaResolverCache {
    @NotNull
    private final ResolveSession resolveSession;

    public AbstractJavaResolverCache(@NotNull ResolveSession resolveSession) {
        Intrinsics.checkNotNullParameter((Object)resolveSession, (String)"resolveSession");
        this.resolveSession = resolveSession;
    }

    @NotNull
    protected final BindingTrace getTrace() {
        BindingTrace bindingTrace = this.resolveSession.getTrace();
        Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"<get-trace>(...)");
        return bindingTrace;
    }

    @Override
    @Nullable
    public ClassDescriptor getClassResolvedFromSource(@NotNull FqName fqName) {
        ClassDescriptor classDescriptor;
        block3: {
            block2: {
                ClassDescriptor classDescriptor2;
                Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
                classDescriptor = (ClassDescriptor)this.getTrace().get(BindingContext.FQNAME_TO_CLASS_DESCRIPTOR, fqName.toUnsafe());
                if (classDescriptor == null) break block2;
                ClassDescriptor it = classDescriptor2 = classDescriptor;
                boolean bl = false;
                classDescriptor = !it.isExpect() ? classDescriptor2 : null;
                if (classDescriptor != null) break block3;
            }
            classDescriptor = this.findInPackageFragments(fqName);
        }
        return classDescriptor;
    }

    private final ClassDescriptor findInPackageFragments(FqName fullFqName) {
        FqName fqName = fullFqName.isRoot() ? fullFqName : fullFqName.parent();
        while (true) {
            ClassDescriptor result2;
            LazyPackageDescriptor packageDescriptor;
            if ((packageDescriptor = this.resolveSession.getPackageFragment(fqName)) != null && (result2 = ResolveSessionUtils.findClassByRelativePath(packageDescriptor.getMemberScope(), FqNamesUtilKt.tail(fullFqName, fqName))) != null) {
                return result2;
            }
            if (fqName.isRoot()) break;
            fqName = fqName.parent();
        }
        return null;
    }
}

