/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.clean;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.inline.util.InvocationUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\b\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/RedundantCallElimination;", "", "root", "Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "<init>", "(Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;)V", "changed", "", "apply", "js.translator"})
public final class RedundantCallElimination {
    @NotNull
    private final JsBlock root;
    private boolean changed;

    public RedundantCallElimination(@NotNull JsBlock root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this.root = root;
    }

    public final boolean apply() {
        this.root.accept(new RecursiveJsVisitor(this){
            final /* synthetic */ RedundantCallElimination this$0;
            {
                this.this$0 = $receiver;
            }

            public void visitInvocation(JsInvocation invocation) {
                Intrinsics.checkNotNullParameter((Object)invocation, (String)"invocation");
                this.tryEliminate(invocation);
                super.visitInvocation(invocation);
            }

            private final void tryEliminate(JsInvocation invocation) {
                if (!InvocationUtilsKt.isCallInvocation(invocation)) {
                    return;
                }
                JsExpression jsExpression = invocation.getQualifier();
                JsNameRef jsNameRef = jsExpression instanceof JsNameRef ? (JsNameRef)jsExpression : null;
                if (jsNameRef == null) {
                    return;
                }
                JsNameRef call2 = jsNameRef;
                if (!MetadataProperties.isJsCall(call2)) {
                    return;
                }
                JsExpression jsExpression2 = call2.getQualifier();
                JsNameRef jsNameRef2 = jsExpression2 instanceof JsNameRef ? (JsNameRef)jsExpression2 : null;
                if (jsNameRef2 == null) {
                    return;
                }
                JsNameRef qualifier = jsNameRef2;
                JsExpression jsExpression3 = qualifier.getQualifier();
                JsNameRef jsNameRef3 = jsExpression3 instanceof JsNameRef ? (JsNameRef)jsExpression3 : null;
                if (jsNameRef3 == null) {
                    return;
                }
                JsNameRef receiver = jsNameRef3;
                List<JsExpression> list = invocation.getArguments();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getArguments(...)");
                Object object = CollectionsKt.firstOrNull(list);
                JsNameRef jsNameRef4 = object instanceof JsNameRef ? (JsNameRef)object : null;
                if (jsNameRef4 == null) {
                    return;
                }
                JsNameRef firstArg = jsNameRef4;
                if (receiver.getQualifier() == null && receiver.getName() != null && firstArg.getQualifier() == null && Intrinsics.areEqual((Object)receiver.getName(), (Object)firstArg.getName())) {
                    invocation.getArguments().remove(0);
                    invocation.setQualifier(qualifier);
                    RedundantCallElimination.access$setChanged$p(this.this$0, true);
                }
            }
        });
        return this.changed;
    }

    public static final /* synthetic */ void access$setChanged$p(RedundantCallElimination $this, boolean bl) {
        $this.changed = bl;
    }
}

