/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.build.GeneratedFile;
import org.jetbrains.kotlin.build.report.ICReporterKt;
import org.jetbrains.kotlin.com.intellij.util.containers.MultiMap;
import org.jetbrains.kotlin.incremental.CompilationTransaction;
import org.jetbrains.kotlin.incremental.IncrementalCompilationContext;
import org.jetbrains.kotlin.incremental.snapshots.FileSnapshotMap;
import org.jetbrains.kotlin.incremental.storage.BasicMap;
import org.jetbrains.kotlin.incremental.storage.BasicMapsOwner;
import org.jetbrains.kotlin.incremental.storage.SourceToOutputFilesMap;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011J\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u00132\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011J\u0014\u0010\u0014\u001a\u00020\u000f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/incremental/InputsCache;", "Lorg/jetbrains/kotlin/incremental/storage/BasicMapsOwner;", "workingDir", "Ljava/io/File;", "icContext", "Lorg/jetbrains/kotlin/incremental/IncrementalCompilationContext;", "<init>", "(Ljava/io/File;Lorg/jetbrains/kotlin/incremental/IncrementalCompilationContext;)V", "sourceSnapshotMap", "Lorg/jetbrains/kotlin/incremental/snapshots/FileSnapshotMap;", "getSourceSnapshotMap$incremental_compilation_impl", "()Lorg/jetbrains/kotlin/incremental/snapshots/FileSnapshotMap;", "sourceToOutputMap", "Lorg/jetbrains/kotlin/incremental/storage/SourceToOutputFilesMap;", "removeOutputForSourceFiles", "", "sources", "", "getOutputForSourceFiles", "", "registerOutputForSourceFiles", "generatedFiles", "Lorg/jetbrains/kotlin/build/GeneratedFile;", "Companion", "incremental-compilation-impl"})
@SourceDebugExtension(value={"SMAP\nInputsCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InputsCache.kt\norg/jetbrains/kotlin/incremental/InputsCache\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,67:1\n1869#2,2:68\n1374#2:70\n1460#2,5:71\n*S KotlinDebug\n*F\n+ 1 InputsCache.kt\norg/jetbrains/kotlin/incremental/InputsCache\n*L\n41#1:68,2\n48#1:70\n48#1:71,5\n*E\n"})
public final class InputsCache
extends BasicMapsOwner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IncrementalCompilationContext icContext;
    @NotNull
    private final FileSnapshotMap sourceSnapshotMap;
    @NotNull
    private final SourceToOutputFilesMap sourceToOutputMap;

    public InputsCache(@NotNull File workingDir, @NotNull IncrementalCompilationContext icContext) {
        Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
        Intrinsics.checkNotNullParameter((Object)icContext, (String)"icContext");
        super(workingDir);
        this.icContext = icContext;
        this.sourceSnapshotMap = (FileSnapshotMap)this.registerMap((BasicMap)new FileSnapshotMap(this.getStorageFile("source-snapshot"), this.icContext));
        this.sourceToOutputMap = (SourceToOutputFilesMap)this.registerMap((BasicMap)new SourceToOutputFilesMap(this.getStorageFile("source-to-output"), this.icContext));
    }

    @NotNull
    public final FileSnapshotMap getSourceSnapshotMap$incremental_compilation_impl() {
        return this.sourceSnapshotMap;
    }

    public final void removeOutputForSourceFiles(@NotNull Iterable<? extends File> sources) {
        Intrinsics.checkNotNullParameter(sources, (String)"sources");
        for (File file2 : sources) {
            Set<File> set = this.sourceToOutputMap.getAndRemove(file2);
            if (set == null) continue;
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it = (File)element$iv;
                boolean bl = false;
                ICReporterKt.debug(this.icContext.getReporter(), (Function0<String>)((Function0)() -> InputsCache.removeOutputForSourceFiles$lambda$1$lambda$0(it, file2)));
                CompilationTransaction compilationTransaction = this.icContext.getTransaction();
                Path path = it.toPath();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
                compilationTransaction.deleteFile(path);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<File> getOutputForSourceFiles(@NotNull Iterable<? extends File> sources) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(sources, (String)"sources");
        Iterable<? extends File> $this$flatMap$iv = sources;
        boolean $i$f$flatMap = false;
        Iterable<? extends File> iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            File it = (File)element$iv$iv;
            boolean bl = false;
            Object object = this.sourceToOutputMap.get(it);
            if (object == null) {
                object = SetsKt.emptySet();
            }
            Iterable list$iv$iv = (Iterable)object;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final void registerOutputForSourceFiles(@NotNull List<? extends GeneratedFile> generatedFiles) {
        Intrinsics.checkNotNullParameter(generatedFiles, (String)"generatedFiles");
        MultiMap<File, File> multiMap = MultiMap.createLinked();
        Intrinsics.checkNotNullExpressionValue(multiMap, (String)"createLinked(...)");
        MultiMap<File, File> sourceToOutput = multiMap;
        for (GeneratedFile entry : generatedFiles) {
            for (File source : entry.getSourceFiles()) {
                sourceToOutput.putValue(source, entry.getOutputFile());
            }
        }
        for (Map.Entry entry : sourceToOutput.entrySet()) {
            Intrinsics.checkNotNull((Object)entry);
            File source = (File)entry.getKey();
            Collection outputs2 = (Collection)entry.getValue();
            Intrinsics.checkNotNull((Object)source);
            Intrinsics.checkNotNull((Object)outputs2);
            this.sourceToOutputMap.set(source, CollectionsKt.toSet((Iterable)outputs2));
        }
    }

    private static final String removeOutputForSourceFiles$lambda$1$lambda$0(File $it, File $sourceFile) {
        return "Deleting " + $it + " on clearing cache for " + $sourceFile;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/incremental/InputsCache$Companion;", "", "<init>", "()V", "SOURCE_SNAPSHOTS", "", "SOURCE_TO_OUTPUT_FILES", "incremental-compilation-impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

