/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics.rendering;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory3;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory4;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactoryForDeprecation;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactoryForDeprecation0;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactoryForDeprecation1;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactoryForDeprecation2;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactoryForDeprecation3;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactoryForDeprecation4;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticParameterRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticWithParameters1Renderer;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticWithParameters2Renderer;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticWithParameters3Renderer;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticWithParameters4Renderer;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticWithParametersMultiRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.MultiRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.SimpleDiagnosticRenderer;

public final class DiagnosticFactoryToRendererMap {
    private final Map<DiagnosticFactory<?>, DiagnosticRenderer<?>> map = new HashMap();
    private boolean immutable = false;
    private final String name;

    public DiagnosticFactoryToRendererMap(String name2) {
        this.name = name2;
    }

    public DiagnosticFactoryToRendererMap() {
        this("<unnamed>");
    }

    public String toString() {
        return "DiagnosticFactory#" + this.name;
    }

    private void checkMutability() {
        if (this.immutable) {
            throw new IllegalStateException("factory to renderer map is already immutable");
        }
    }

    public <E extends PsiElement> void put(@NotNull DiagnosticFactory0<E> factory, @NotNull String message2) {
        if (factory == null) {
            DiagnosticFactoryToRendererMap.$$$reportNull$$$0(0);
        }
        if (message2 == null) {
            DiagnosticFactoryToRendererMap.$$$reportNull$$$0(1);
        }
        this.checkMutability();
        this.map.put(factory, new SimpleDiagnosticRenderer(message2));
    }

    public <E extends PsiElement, A> void put(@NotNull DiagnosticFactory1<E, A> factory, @NotNull String message2, @Nullable DiagnosticParameterRenderer<? super A> rendererA) {
        if (factory == null) {
            DiagnosticFactoryToRendererMap.$$$reportNull$$$0(2);
        }
        if (message2 == null) {
            DiagnosticFactoryToRendererMap.$$$reportNull$$$0(3);
        }
        this.checkMutability();
        this.map.put(factory, new DiagnosticWithParameters1Renderer<A>(message2, rendererA));
    }

    public <E extends PsiElement, A> void put(@NotNull DiagnosticFactory1<E, A> factory, @NotNull String message2, @NotNull MultiRenderer<? super A> rendererA) {
        if (factory == null) {
            DiagnosticFactoryToRendererMap.$$$reportNull$$$0(4);
        }
        if (message2 == null) {
            DiagnosticFactoryToRendererMap.$$$reportNull$$$0(5);
        }
        if (rendererA == null) {
            DiagnosticFactoryToRendererMap.$$$reportNull$$$0(6);
        }
        this.checkMutability();
        this.map.put(factory, new DiagnosticWithParametersMultiRenderer<A>(message2, rendererA));
    }

    public <E extends PsiElement, A, B> void put(@NotNull DiagnosticFactory2<E, A, B> factory, @NotNull String message2, @Nullable DiagnosticParameterRenderer<? super A> rendererA, @Nullable DiagnosticParameterRenderer<? super B> rendererB) {
        if (factory == null) {
            DiagnosticFactoryToRendererMap.$$$reportNull$$$0(7);
        }
        if (message2 == null) {
            DiagnosticFactoryToRendererMap.$$$reportNull$$$0(8);
        }
        this.checkMutability();
        this.map.put(factory, new DiagnosticWithParameters2Renderer<A, B>(message2, rendererA, rendererB));
    }

    public <E extends PsiElement, A, B, C> void put(@NotNull DiagnosticFactory3<E, A, B, C> factory, @NotNull String message2, @Nullable DiagnosticParameterRenderer<? super A> rendererA, @Nullable DiagnosticParameterRenderer<? super B> rendererB, @Nullable DiagnosticParameterRenderer<? super C> rendererC) {
        if (factory == null) {
            DiagnosticFactoryToRendererMap.$$$reportNull$$$0(9);
        }
        if (message2 == null) {
            DiagnosticFactoryToRendererMap.$$$reportNull$$$0(10);
        }
        this.checkMutability();
        this.map.put(factory, new DiagnosticWithParameters3Renderer<A, B, C>(message2, rendererA, rendererB, rendererC));
    }

    public <E extends PsiElement, A, B, C, D> void put(@NotNull DiagnosticFactory4<E, A, B, C, D> factory, @NotNull String message2, @Nullable DiagnosticParameterRenderer<? super A> rendererA, @Nullable DiagnosticParameterRenderer<? super B> rendererB, @Nullable DiagnosticParameterRenderer<? super C> rendererC, @Nullable DiagnosticParameterRenderer<? super D> rendererD) {
        if (factory == null) {
            DiagnosticFactoryToRendererMap.$$$reportNull$$$0(11);
        }
        if (message2 == null) {
            DiagnosticFactoryToRendererMap.$$$reportNull$$$0(12);
        }
        this.checkMutability();
        this.map.put(factory, new DiagnosticWithParameters4Renderer<A, B, C, D>(message2, rendererA, rendererB, rendererC, rendererD));
    }

    public void put(@NotNull DiagnosticFactory<?> factory, @NotNull DiagnosticRenderer<?> renderer) {
        if (factory == null) {
            DiagnosticFactoryToRendererMap.$$$reportNull$$$0(13);
        }
        if (renderer == null) {
            DiagnosticFactoryToRendererMap.$$$reportNull$$$0(14);
        }
        this.checkMutability();
        this.map.put(factory, renderer);
    }

    public <E extends PsiElement> void put(@NotNull DiagnosticFactoryForDeprecation0<E> factory, @NotNull String message2) {
        if (factory == null) {
            DiagnosticFactoryToRendererMap.$$$reportNull$$$0(15);
        }
        if (message2 == null) {
            DiagnosticFactoryToRendererMap.$$$reportNull$$$0(16);
        }
        this.checkMutability();
        this.map.put((DiagnosticFactory<?>)factory.getErrorFactory(), new SimpleDiagnosticRenderer(message2));
        this.map.put((DiagnosticFactory<?>)factory.getWarningFactory(), new SimpleDiagnosticRenderer(DiagnosticFactoryToRendererMap.deprecationMessage(factory, message2)));
    }

    public <E extends PsiElement, A> void put(@NotNull DiagnosticFactoryForDeprecation1<E, A> factory, @NotNull String message2, @Nullable DiagnosticParameterRenderer<? super A> rendererA) {
        if (factory == null) {
            DiagnosticFactoryToRendererMap.$$$reportNull$$$0(17);
        }
        if (message2 == null) {
            DiagnosticFactoryToRendererMap.$$$reportNull$$$0(18);
        }
        this.checkMutability();
        this.map.put((DiagnosticFactory<?>)factory.getErrorFactory(), (DiagnosticRenderer<?>)new DiagnosticWithParameters1Renderer<A>(message2, rendererA));
        this.map.put((DiagnosticFactory<?>)factory.getWarningFactory(), (DiagnosticRenderer<?>)new DiagnosticWithParameters1Renderer<A>(DiagnosticFactoryToRendererMap.deprecationMessage(factory, message2), rendererA));
    }

    public <E extends PsiElement, A> void put(@NotNull DiagnosticFactoryForDeprecation1<E, A> factory, @NotNull String message2, @NotNull MultiRenderer<? super A> rendererA) {
        if (factory == null) {
            DiagnosticFactoryToRendererMap.$$$reportNull$$$0(19);
        }
        if (message2 == null) {
            DiagnosticFactoryToRendererMap.$$$reportNull$$$0(20);
        }
        if (rendererA == null) {
            DiagnosticFactoryToRendererMap.$$$reportNull$$$0(21);
        }
        this.checkMutability();
        this.map.put((DiagnosticFactory<?>)factory.getErrorFactory(), (DiagnosticRenderer<?>)new DiagnosticWithParametersMultiRenderer<A>(message2, rendererA));
        this.map.put((DiagnosticFactory<?>)factory.getWarningFactory(), (DiagnosticRenderer<?>)new DiagnosticWithParametersMultiRenderer<A>(DiagnosticFactoryToRendererMap.deprecationMessage(factory, message2), rendererA));
    }

    public <E extends PsiElement, A, B> void put(@NotNull DiagnosticFactoryForDeprecation2<E, A, B> factory, @NotNull String message2, @Nullable DiagnosticParameterRenderer<? super A> rendererA, @Nullable DiagnosticParameterRenderer<? super B> rendererB) {
        if (factory == null) {
            DiagnosticFactoryToRendererMap.$$$reportNull$$$0(22);
        }
        if (message2 == null) {
            DiagnosticFactoryToRendererMap.$$$reportNull$$$0(23);
        }
        this.checkMutability();
        this.map.put((DiagnosticFactory<?>)factory.getErrorFactory(), (DiagnosticRenderer<?>)new DiagnosticWithParameters2Renderer<A, B>(message2, rendererA, rendererB));
        this.map.put((DiagnosticFactory<?>)factory.getWarningFactory(), (DiagnosticRenderer<?>)new DiagnosticWithParameters2Renderer<A, B>(DiagnosticFactoryToRendererMap.deprecationMessage(factory, message2), rendererA, rendererB));
    }

    public <E extends PsiElement, A, B, C> void put(@NotNull DiagnosticFactoryForDeprecation3<E, A, B, C> factory, @NotNull String message2, @Nullable DiagnosticParameterRenderer<? super A> rendererA, @Nullable DiagnosticParameterRenderer<? super B> rendererB, @Nullable DiagnosticParameterRenderer<? super C> rendererC) {
        if (factory == null) {
            DiagnosticFactoryToRendererMap.$$$reportNull$$$0(24);
        }
        if (message2 == null) {
            DiagnosticFactoryToRendererMap.$$$reportNull$$$0(25);
        }
        this.checkMutability();
        this.map.put((DiagnosticFactory<?>)factory.getErrorFactory(), (DiagnosticRenderer<?>)new DiagnosticWithParameters3Renderer<A, B, C>(message2, rendererA, rendererB, rendererC));
        this.map.put((DiagnosticFactory<?>)factory.getWarningFactory(), (DiagnosticRenderer<?>)new DiagnosticWithParameters3Renderer<A, B, C>(DiagnosticFactoryToRendererMap.deprecationMessage(factory, message2), rendererA, rendererB, rendererC));
    }

    public <E extends PsiElement, A, B, C, D> void put(@NotNull DiagnosticFactoryForDeprecation4<E, A, B, C, D> factory, @NotNull String message2, @Nullable DiagnosticParameterRenderer<? super A> rendererA, @Nullable DiagnosticParameterRenderer<? super B> rendererB, @Nullable DiagnosticParameterRenderer<? super C> rendererC, @Nullable DiagnosticParameterRenderer<? super D> rendererD) {
        if (factory == null) {
            DiagnosticFactoryToRendererMap.$$$reportNull$$$0(26);
        }
        if (message2 == null) {
            DiagnosticFactoryToRendererMap.$$$reportNull$$$0(27);
        }
        this.checkMutability();
        this.map.put((DiagnosticFactory<?>)factory.getErrorFactory(), (DiagnosticRenderer<?>)new DiagnosticWithParameters4Renderer<A, B, C, D>(message2, rendererA, rendererB, rendererC, rendererD));
        this.map.put((DiagnosticFactory<?>)factory.getWarningFactory(), (DiagnosticRenderer<?>)new DiagnosticWithParameters4Renderer<A, B, C, D>(DiagnosticFactoryToRendererMap.deprecationMessage(factory, message2), rendererA, rendererB, rendererC, rendererD));
    }

    private static String deprecationMessage(DiagnosticFactoryForDeprecation<?, ?, ?> factory, String errorMessage) {
        LanguageVersion sinceVersion = factory.getDeprecatingFeature().getSinceVersion();
        StringBuilder builder = new StringBuilder();
        builder.append(errorMessage).append(". This will become an error");
        if (sinceVersion != null) {
            builder.append(" in Kotlin ").append(sinceVersion.getVersionString());
        } else {
            builder.append(" in a future release");
        }
        return builder.toString();
    }

    @Nullable
    public DiagnosticRenderer<?> get(@NotNull DiagnosticFactory<?> factory) {
        if (factory == null) {
            DiagnosticFactoryToRendererMap.$$$reportNull$$$0(28);
        }
        return this.map.get(factory);
    }

    public void setImmutable() {
        this.immutable = false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 16: 
            case 18: 
            case 20: 
            case 23: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 6: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rendererA";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/diagnostics/rendering/DiagnosticFactoryToRendererMap";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "put";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[2] = "get";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

