/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.JvmAnalysisFlags;
import org.jetbrains.kotlin.config.JvmDefaultMode;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.JavaMethodDescriptor;
import org.jetbrains.kotlin.load.kotlin.MethodSignatureMappingKt;
import org.jetbrains.kotlin.name.JvmStandardClassIds;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.LanguageVersionSettingsProvider;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;
import org.jetbrains.kotlin.resolve.jvm.checkers.JvmDefaultCheckerKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.util.DeclarationUtilKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J(\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J0\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0011H\u0002J\u0014\u0010\u0019\u001a\u00020\u0011*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0013H\u0002R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JvmDefaultChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "ideService", "Lorg/jetbrains/kotlin/resolve/LanguageVersionSettingsProvider;", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkJvmCompatibilityAnnotations", "", "jvmDefaultMode", "Lorg/jetbrains/kotlin/config/JvmDefaultMode;", "checkSpecializationInCompatibilityMode", "inheritedFun", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "actualImplementation", "performSpecializationCheck", "isCompiledToJvmDefaultWithProperMode", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "compilationDefaultMode", "frontend.java"})
@SourceDebugExtension(value={"SMAP\nJvmDefaultChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmDefaultChecker.kt\norg/jetbrains/kotlin/resolve/jvm/checkers/JvmDefaultChecker\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,152:1\n538#2:153\n523#2,6:154\n216#3,2:160\n*S KotlinDebug\n*F\n+ 1 JvmDefaultChecker.kt\norg/jetbrains/kotlin/resolve/jvm/checkers/JvmDefaultChecker\n*L\n57#1:153\n57#1:154,6\n58#1:160,2\n*E\n"})
public final class JvmDefaultChecker
implements DeclarationChecker {
    @Nullable
    private final LanguageVersionSettingsProvider ideService;

    public JvmDefaultChecker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.ideService = LanguageVersionSettingsProvider.Companion.getInstance(project);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor, @NotNull DeclarationCheckerContext context) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Map $this$filter$iv;
        boolean performSpecializationCheck;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        JvmDefaultMode jvmDefaultMode = context.getLanguageVersionSettings().getFlag(JvmAnalysisFlags.getJvmDefaultMode());
        if (this.checkJvmCompatibilityAnnotations(descriptor, declaration, context, jvmDefaultMode)) {
            return;
        }
        if (!jvmDefaultMode.isEnabled() || !(descriptor instanceof ClassDescriptor) || DescriptorUtils.isInterface(descriptor) || DescriptorUtils.isAnnotationClass(descriptor)) {
            return;
        }
        boolean bl = performSpecializationCheck = jvmDefaultMode == JvmDefaultMode.ALL_COMPATIBILITY && !JvmAnnotationUtilKt.hasJvmDefaultNoCompatibilityAnnotation(descriptor) && (((ClassDescriptor)descriptor).getModality() == Modality.OPEN || ((ClassDescriptor)descriptor).getModality() == Modality.ABSTRACT) && !DescriptorUtilsKt.isEffectivelyPrivateApi((DeclarationDescriptorWithVisibility)descriptor);
        if (DescriptorUtilsKt.getSuperClassNotAny((ClassDescriptor)descriptor) == null && !performSpecializationCheck) {
            return;
        }
        Map<CallableMemberDescriptor, CallableMemberDescriptor> map = DeclarationUtilKt.getNonPrivateTraitMembersForDelegation((ClassDescriptor)descriptor, true);
        boolean $i$f$filter = false;
        Iterator iterator2 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator3 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator3.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator3.next();
            boolean bl2 = false;
            CallableMemberDescriptor actualImplementation = (CallableMemberDescriptor)entry.getValue();
            if (!this.isCompiledToJvmDefaultWithProperMode(actualImplementation, jvmDefaultMode)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$filter$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator2.next();
            boolean bl3 = false;
            CallableMemberDescriptor inheritedMember = (CallableMemberDescriptor)entry.getKey();
            CallableMemberDescriptor actualImplementation = (CallableMemberDescriptor)entry.getValue();
            if (actualImplementation instanceof FunctionDescriptor && inheritedMember instanceof FunctionDescriptor) {
                this.checkSpecializationInCompatibilityMode((FunctionDescriptor)inheritedMember, (FunctionDescriptor)actualImplementation, context, declaration, performSpecializationCheck);
                continue;
            }
            if (!(actualImplementation instanceof PropertyDescriptor) || !(inheritedMember instanceof PropertyDescriptor)) continue;
            PropertyGetterDescriptor getterImpl = ((PropertyDescriptor)actualImplementation).getGetter();
            PropertyGetterDescriptor getterInherited = ((PropertyDescriptor)inheritedMember).getGetter();
            if (getterImpl != null && getterInherited != null && jvmDefaultMode == JvmDefaultMode.ALL_COMPATIBILITY && !this.checkSpecializationInCompatibilityMode(getterInherited, getterImpl, context, declaration, performSpecializationCheck) || !((PropertyDescriptor)actualImplementation).isVar() || !((PropertyDescriptor)inheritedMember).isVar()) continue;
            PropertySetterDescriptor setterImpl = ((PropertyDescriptor)actualImplementation).getSetter();
            PropertySetterDescriptor setterInherited = ((PropertyDescriptor)inheritedMember).getSetter();
            if (setterImpl == null || setterInherited == null) continue;
            this.checkSpecializationInCompatibilityMode(setterInherited, setterImpl, context, declaration, performSpecializationCheck);
        }
    }

    private final boolean checkJvmCompatibilityAnnotations(DeclarationDescriptor descriptor, KtDeclaration declaration, DeclarationCheckerContext context, JvmDefaultMode jvmDefaultMode) {
        KtElement reportOn;
        AnnotationDescriptor annotationDescriptor;
        AnnotationDescriptor annotationDescriptor2 = descriptor.getAnnotations().findAnnotation(JvmStandardClassIds.INSTANCE.getJVM_DEFAULT_NO_COMPATIBILITY_FQ_NAME());
        if (annotationDescriptor2 != null) {
            annotationDescriptor = annotationDescriptor2;
            boolean bl = false;
            KtAnnotationEntry ktAnnotationEntry = DescriptorToSourceUtils.getSourceFromAnnotation(annotationDescriptor);
            KtElement ktElement = reportOn = ktAnnotationEntry != null ? (KtElement)ktAnnotationEntry : (KtElement)declaration;
            if (!jvmDefaultMode.isEnabled()) {
                context.getTrace().report(ErrorsJvm.JVM_DEFAULT_IN_DECLARATION.on((KtElement)((PsiElement)reportOn), "JvmDefaultWithoutCompatibility"));
                return true;
            }
        }
        AnnotationDescriptor annotationDescriptor3 = descriptor.getAnnotations().findAnnotation(JvmAnnotationUtilKt.getJVM_DEFAULT_WITH_COMPATIBILITY_FQ_NAME());
        if (annotationDescriptor3 != null) {
            annotationDescriptor = annotationDescriptor3;
            boolean bl = false;
            KtAnnotationEntry ktAnnotationEntry = DescriptorToSourceUtils.getSourceFromAnnotation(annotationDescriptor);
            KtElement ktElement = reportOn = ktAnnotationEntry != null ? (KtElement)ktAnnotationEntry : (KtElement)declaration;
            if (jvmDefaultMode != JvmDefaultMode.ALL) {
                context.getTrace().report(ErrorsJvm.JVM_DEFAULT_WITH_COMPATIBILITY_IN_DECLARATION.on((KtElement)((PsiElement)reportOn)));
                return true;
            }
            if (!DescriptorUtils.isInterface(descriptor)) {
                context.getTrace().report(ErrorsJvm.JVM_DEFAULT_WITH_COMPATIBILITY_NOT_ON_INTERFACE.on((KtElement)((PsiElement)reportOn)));
                return true;
            }
        }
        return false;
    }

    private final boolean checkSpecializationInCompatibilityMode(FunctionDescriptor inheritedFun, FunctionDescriptor actualImplementation, DeclarationCheckerContext context, KtDeclaration declaration, boolean performSpecializationCheck) {
        if (!performSpecializationCheck || actualImplementation instanceof JavaMethodDescriptor) {
            return true;
        }
        String inheritedSignature = MethodSignatureMappingKt.computeJvmDescriptor(inheritedFun, true, false);
        FunctionDescriptor functionDescriptor = actualImplementation.getOriginal();
        Intrinsics.checkNotNullExpressionValue((Object)functionDescriptor, (String)"getOriginal(...)");
        FunctionDescriptor originalImplementation = functionDescriptor;
        String actualSignature = MethodSignatureMappingKt.computeJvmDescriptor(originalImplementation, true, false);
        if (!Intrinsics.areEqual((Object)inheritedSignature, (Object)actualSignature)) {
            context.getTrace().report(ErrorsJvm.EXPLICIT_OVERRIDE_REQUIRED_IN_COMPATIBILITY_MODE.on((KtDeclaration)((PsiElement)declaration), DescriptorUtils.getDirectMember(inheritedFun), DescriptorUtils.getDirectMember(originalImplementation)));
            return false;
        }
        return true;
    }

    private final boolean isCompiledToJvmDefaultWithProperMode(CallableMemberDescriptor $this$isCompiledToJvmDefaultWithProperMode, JvmDefaultMode compilationDefaultMode) {
        return JvmDefaultCheckerKt.isCompiledToJvmDefaultWithProperMode($this$isCompiledToJvmDefaultWithProperMode, this.ideService, compilationDefaultMode);
    }
}

