/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.snapshots;

import java.io.DataInput;
import java.io.DataOutput;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.util.io.DataExternalizer;
import org.jetbrains.kotlin.incremental.snapshots.FileSnapshot;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0010\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/incremental/snapshots/FileSnapshotExternalizer;", "Lorg/jetbrains/kotlin/com/intellij/util/io/DataExternalizer;", "Lorg/jetbrains/kotlin/incremental/snapshots/FileSnapshot;", "<init>", "()V", "save", "", "out", "Ljava/io/DataOutput;", "value", "read", "input", "Ljava/io/DataInput;", "incremental-compilation-impl"})
public final class FileSnapshotExternalizer
implements DataExternalizer<FileSnapshot> {
    @NotNull
    public static final FileSnapshotExternalizer INSTANCE = new FileSnapshotExternalizer();

    private FileSnapshotExternalizer() {
    }

    @Override
    public void save(@NotNull DataOutput out, @NotNull FileSnapshot value2) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        out.writeLong(value2.getLength());
        out.writeInt(value2.getHash().length);
        out.write(value2.getHash());
    }

    @Override
    @NotNull
    public FileSnapshot read(@NotNull DataInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        long length = input.readLong();
        int hashSize = input.readInt();
        byte[] hash = new byte[hashSize];
        input.readFully(hash);
        return new FileSnapshot(length, hash);
    }
}

