/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.contracts.description.KtBinaryLogicExpression;
import org.jetbrains.kotlin.contracts.description.KtCallsEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.KtConditionalEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.KtContractDescriptionElement;
import org.jetbrains.kotlin.contracts.description.KtContractDescriptionVisitor;
import org.jetbrains.kotlin.contracts.description.KtEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.KtErroneousCallsEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.KtErroneousConstantReference;
import org.jetbrains.kotlin.contracts.description.KtErroneousContractElement;
import org.jetbrains.kotlin.contracts.description.KtErroneousIsInstancePredicate;
import org.jetbrains.kotlin.contracts.description.KtErroneousValueParameterReference;
import org.jetbrains.kotlin.contracts.description.KtIsInstancePredicate;
import org.jetbrains.kotlin.contracts.description.KtIsNullPredicate;
import org.jetbrains.kotlin.contracts.description.KtLogicalNot;
import org.jetbrains.kotlin.contracts.description.KtReturnsEffectDeclaration;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirCastDiagnosticsHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.contracts.FirContractDescription;
import org.jetbrains.kotlin.fir.contracts.FirContractElementDeclaration;
import org.jetbrains.kotlin.fir.contracts.FirEffectDeclaration;
import org.jetbrains.kotlin.fir.contracts.FirErrorContractDescription;
import org.jetbrains.kotlin.fir.contracts.FirLegacyRawContractDescription;
import org.jetbrains.kotlin.fir.contracts.FirRawContractDescription;
import org.jetbrains.kotlin.fir.contracts.FirResolvedContractDescription;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirContractDescriptionOwner;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.diagnostics.ConeContractMayNotHaveLabel;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousFunctionExpression;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.impl.FirContractCallBlock;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeContractDescriptionError;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.utils.exceptions.FirExceptionUtilsKt;
import org.jetbrains.kotlin.fir.visitors.FirVisitorVoid;
import org.jetbrains.kotlin.utils.exceptions.ExceptionAttachmentBuilder;
import org.jetbrains.kotlin.utils.exceptions.KotlinExceptionWithAttachments;
import org.jetbrains.kotlin.utils.exceptions.KotlinIllegalArgumentExceptionWithAttachments;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0002!\"B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J(\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J(\u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J,\u0010\u001c\u001a\u00020\u000b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirContractChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunctionChecker;", "<init>", "()V", "EMPTY_CONTRACT_MESSAGE", "", "DUPLICATE_CALLS_IN_PLACE_MESSAGE", "INVALID_CONTRACT_BLOCK", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkAnnotationsNotAllowed", "contractCall", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "checkUnresolvedEffects", "contractDescription", "Lorg/jetbrains/kotlin/fir/contracts/FirResolvedContractDescription;", "checkContractNotAllowed", "", "Lorg/jetbrains/kotlin/fir/contracts/FirContractDescription;", "checkDuplicateCallsInPlace", "description", "checkDiagnosticsFromFirBuilder", "diagnostic", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "DiagnosticExtractor", "ErasedCastChecker", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirContractChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirContractChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirContractChecker\n+ 2 ExceptionAttachmentBuilder.kt\norg/jetbrains/kotlin/utils/exceptions/ExceptionAttachmentBuilderKt\n+ 3 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n+ 4 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,296:1\n81#2,7:297\n76#2,2:304\n57#2:306\n78#2:307\n43#3:308\n12#4,2:309\n37#4:311\n38#4:312\n21#4:313\n1617#5,9:314\n1869#5:323\n1870#5:325\n1626#5:326\n1#6:324\n*S KotlinDebug\n*F\n+ 1 FirContractChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirContractChecker\n*L\n71#1:297,7\n71#1:304,2\n71#1:306\n71#1:307\n82#1:308\n140#1:309,2\n140#1:311\n141#1:312\n142#1:313\n152#1:314,9\n152#1:323\n152#1:325\n152#1:326\n152#1:324\n*E\n"})
public final class FirContractChecker
extends FirDeclarationChecker<FirFunction> {
    @NotNull
    public static final FirContractChecker INSTANCE = new FirContractChecker();
    @NotNull
    private static final String EMPTY_CONTRACT_MESSAGE = "Empty contract block is not allowed";
    @NotNull
    private static final String DUPLICATE_CALLS_IN_PLACE_MESSAGE = "A value parameter may not be annotated with callsInPlace twice";
    @NotNull
    private static final String INVALID_CONTRACT_BLOCK = "Contract block could not be resolved";

    private FirContractChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull FirFunction declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        FirContractDescription firContractDescription;
        FirFunctionCall contractCall;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (!(declaration instanceof FirContractDescriptionOwner)) {
            return;
        }
        FirContractDescription firContractDescription2 = ((FirContractDescriptionOwner)((Object)declaration)).getContractDescription();
        if (firContractDescription2 == null) {
            return;
        }
        FirContractDescription contractDescription = firContractDescription2;
        boolean reportedNotAllowed = this.checkContractNotAllowed(declaration, contractDescription, context, reporter);
        if (reportedNotAllowed) {
            return;
        }
        Object object = declaration.getBody();
        FirStatement firStatement = object != null && (object = ((FirBlock)object).getStatements()) != null ? (FirStatement)CollectionsKt.firstOrNull((List)object) : null;
        FirContractCallBlock firContractCallBlock = firStatement instanceof FirContractCallBlock ? (FirContractCallBlock)firStatement : null;
        FirFunctionCall firFunctionCall = contractCall = firContractCallBlock != null ? firContractCallBlock.getCall() : null;
        if (contractCall != null) {
            this.checkAnnotationsNotAllowed(contractCall, context, reporter);
        }
        if ((firContractDescription = contractDescription) instanceof FirResolvedContractDescription) {
            this.checkUnresolvedEffects((FirResolvedContractDescription)contractDescription, declaration, context, reporter);
            this.checkDuplicateCallsInPlace((FirResolvedContractDescription)contractDescription, context, reporter);
            if (((FirResolvedContractDescription)contractDescription).getEffects().isEmpty() && ((FirResolvedContractDescription)contractDescription).getUnresolvedEffects().isEmpty()) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirResolvedContractDescription)contractDescription).getSource(), FirErrors.INSTANCE.getERROR_IN_CONTRACT_DESCRIPTION(), (Object)EMPTY_CONTRACT_MESSAGE, (DiagnosticContext)context, null, 16, null);
            }
            this.checkDiagnosticsFromFirBuilder(((FirResolvedContractDescription)contractDescription).getDiagnostic(), ((FirResolvedContractDescription)contractDescription).getSource(), context, reporter);
        } else if (firContractDescription instanceof FirErrorContractDescription) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirErrorContractDescription)contractDescription).getSource(), FirErrors.INSTANCE.getERROR_IN_CONTRACT_DESCRIPTION(), (Object)INVALID_CONTRACT_BLOCK, (DiagnosticContext)context, null, 16, null);
            this.checkDiagnosticsFromFirBuilder(((FirErrorContractDescription)contractDescription).getDiagnostic(), ((FirErrorContractDescription)contractDescription).getSource(), context, reporter);
        } else {
            if (firContractDescription instanceof FirRawContractDescription || firContractDescription instanceof FirLegacyRawContractDescription) {
                void $this$buildErrorWithAttachment_u24lambda_u240$iv$iv;
                ExceptionAttachmentBuilder exceptionAttachmentBuilder;
                String message$iv = "Unexpected contract description kind: " + Reflection.getOrCreateKotlinClass(contractDescription.getClass()).getSimpleName();
                Throwable cause$iv = null;
                String attachmentName$iv = "info.txt";
                boolean $i$f$errorWithAttachment = false;
                boolean $i$f$buildErrorWithAttachment = false;
                KotlinIllegalArgumentExceptionWithAttachments exception$iv$iv = new KotlinIllegalArgumentExceptionWithAttachments(message$iv, cause$iv);
                KotlinExceptionWithAttachments $this$buildAttachment$iv$iv$iv = exception$iv$iv;
                boolean $i$f$buildAttachment = false;
                ExceptionAttachmentBuilder exceptionAttachmentBuilder2 = exceptionAttachmentBuilder = new ExceptionAttachmentBuilder();
                String string2 = attachmentName$iv;
                KotlinExceptionWithAttachments kotlinExceptionWithAttachments = $this$buildAttachment$iv$iv$iv;
                boolean bl = false;
                void $this$check_u24lambda_u240 = $this$buildErrorWithAttachment_u24lambda_u240$iv$iv;
                boolean bl2 = false;
                FirExceptionUtilsKt.withFirEntry((ExceptionAttachmentBuilder)$this$check_u24lambda_u240, "declaration", declaration);
                kotlinExceptionWithAttachments.withAttachment(string2, exceptionAttachmentBuilder.buildString());
                throw (Throwable)exception$iv$iv;
            }
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void checkAnnotationsNotAllowed(FirFunctionCall contractCall, CheckerContext context, DiagnosticReporter reporter) {
        FirCall $this$arguments$iv = contractCall;
        boolean $i$f$getArguments = false;
        Object object = CollectionsKt.singleOrNull($this$arguments$iv.getArgumentList().getArguments());
        FirAnonymousFunctionExpression firAnonymousFunctionExpression = object instanceof FirAnonymousFunctionExpression ? (FirAnonymousFunctionExpression)object : null;
        if (firAnonymousFunctionExpression == null) {
            return;
        }
        FirAnonymousFunctionExpression argument = firAnonymousFunctionExpression;
        if (!argument.getAnonymousFunction().isLambda()) {
            return;
        }
        FirBlock firBlock = argument.getAnonymousFunction().getBody();
        if (firBlock == null) {
            return;
        }
        FirBlock lambdaBody = firBlock;
        lambdaBody.acceptChildren(new FirVisitorVoid(reporter, context){
            final /* synthetic */ DiagnosticReporter $reporter;
            final /* synthetic */ CheckerContext $context;
            {
                this.$reporter = $reporter;
                this.$context = $context;
            }

            public void visitElement(FirElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                element.acceptChildren(this);
            }

            public void visitAnnotation(FirAnnotation annotation) {
                Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
                KtDiagnosticReportHelpersKt.reportOn$default(this.$reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getANNOTATION_IN_CONTRACT_ERROR(), (DiagnosticContext)this.$context, null, 8, null);
            }

            public void visitAnnotationCall(FirAnnotationCall annotationCall) {
                Intrinsics.checkNotNullParameter((Object)annotationCall, (String)"annotationCall");
                KtDiagnosticReportHelpersKt.reportOn$default(this.$reporter, (AbstractKtSourceElement)annotationCall.getSource(), FirErrors.INSTANCE.getANNOTATION_IN_CONTRACT_ERROR(), (DiagnosticContext)this.$context, null, 8, null);
            }
        });
    }

    private final void checkUnresolvedEffects(FirResolvedContractDescription contractDescription, FirFunction declaration, CheckerContext context, DiagnosticReporter reporter) {
        ConeDiagnostic diagnostic;
        ErasedCastChecker erasedCastChecker = new ErasedCastChecker(declaration, context);
        for (FirContractElementDeclaration unresolvedEffect : contractDescription.getUnresolvedEffects()) {
            ConeDiagnostic coneDiagnostic = (ConeDiagnostic)unresolvedEffect.getEffect().accept(DiagnosticExtractor.INSTANCE, null);
            if (coneDiagnostic == null && (coneDiagnostic = (ConeDiagnostic)unresolvedEffect.getEffect().accept(erasedCastChecker, null)) == null) continue;
            diagnostic = coneDiagnostic;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)unresolvedEffect.getSource(), FirErrors.INSTANCE.getERROR_IN_CONTRACT_DESCRIPTION(), (Object)diagnostic.getReason(), (DiagnosticContext)context, null, 16, null);
        }
        for (FirEffectDeclaration resolvedEffect : contractDescription.getEffects()) {
            if ((ConeDiagnostic)resolvedEffect.getEffect().accept(erasedCastChecker, null) == null) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)resolvedEffect.getSource(), FirErrors.INSTANCE.getERROR_IN_CONTRACT_DESCRIPTION(), (Object)diagnostic.getReason(), (DiagnosticContext)context, null, 16, null);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final boolean checkContractNotAllowed(FirFunction declaration, FirContractDescription contractDescription, CheckerContext context, DiagnosticReporter reporter) {
        KtSourceElement source;
        block8: {
            block7: {
                KtSourceElement ktSourceElement = source = contractDescription.getSource();
                if (!((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtRealSourceElementKind)) {
                    return false;
                }
                if (declaration instanceof FirPropertyAccessor || declaration instanceof FirAnonymousFunction) {
                    FirContractChecker.checkContractNotAllowed$contractNotAllowed(reporter, source, context, "Contracts are only allowed for functions.");
                    return true;
                }
                FirMemberDeclaration $this$isAbstract$iv = declaration;
                boolean $i$f$isAbstract = false;
                if ($this$isAbstract$iv.getStatus().getModality() == Modality.ABSTRACT) break block7;
                FirMemberDeclaration $this$isOpen$iv = declaration;
                boolean $i$f$isOpen = false;
                if ($this$isOpen$iv.getStatus().getModality() == Modality.OPEN) break block7;
                FirMemberDeclaration $this$isOverride$iv = declaration;
                boolean $i$f$isOverride = false;
                if (!$this$isOverride$iv.getStatus().isOverride()) break block8;
            }
            FirContractChecker.checkContractNotAllowed$contractNotAllowed(reporter, source, context, "Contracts are not allowed for open or override functions.");
            return true;
        }
        FirMemberDeclaration $this$isOperator$iv = declaration;
        boolean $i$f$isOperator = false;
        if ($this$isOperator$iv.getStatus().isOperator()) {
            FirContractChecker.checkContractNotAllowed$contractNotAllowed(reporter, source, context, "Contracts are not allowed for operator functions.");
            return true;
        }
        if (!declaration.getSymbol().getCallableId().isLocal()) {
            FirMemberDeclaration $this$visibility$iv = declaration;
            boolean $i$f$getVisibility = false;
            if (!Intrinsics.areEqual((Object)$this$visibility$iv.getStatus().getVisibility(), (Object)Visibilities.Local.INSTANCE)) return false;
        }
        FirContractChecker.checkContractNotAllowed$contractNotAllowed(reporter, source, context, "Contracts are not allowed for local functions.");
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkDuplicateCallsInPlace(FirResolvedContractDescription description, CheckerContext context, DiagnosticReporter reporter) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = description.getEffects();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            KtCallsEffectDeclaration it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            FirEffectDeclaration it = (FirEffectDeclaration)element$iv$iv;
            boolean bl2 = false;
            KtEffectDeclaration<ConeKotlinType, ConeDiagnostic> ktEffectDeclaration = it.getEffect();
            if ((ktEffectDeclaration instanceof KtCallsEffectDeclaration ? (KtCallsEffectDeclaration)ktEffectDeclaration : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List callsInPlaceEffects = (List)destination$iv$iv;
        Set seenParameterIndices = new LinkedHashSet();
        for (KtCallsEffectDeclaration effect : callsInPlaceEffects) {
            int parameterIndex = effect.getValueParameterReference().getParameterIndex();
            if (seenParameterIndices.contains(parameterIndex)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)description.getSource(), FirErrors.INSTANCE.getERROR_IN_CONTRACT_DESCRIPTION(), (Object)DUPLICATE_CALLS_IN_PLACE_MESSAGE, (DiagnosticContext)context, null, 16, null);
                continue;
            }
            seenParameterIndices.add(parameterIndex);
        }
    }

    private final void checkDiagnosticsFromFirBuilder(ConeDiagnostic diagnostic, KtSourceElement source, CheckerContext context, DiagnosticReporter reporter) {
        if (Intrinsics.areEqual((Object)diagnostic, (Object)ConeContractMayNotHaveLabel.INSTANCE)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getERROR_IN_CONTRACT_DESCRIPTION(), (Object)ConeContractMayNotHaveLabel.INSTANCE.getReason(), (DiagnosticContext)context, null, 16, null);
        }
    }

    private static final void checkContractNotAllowed$contractNotAllowed(DiagnosticReporter $reporter, KtSourceElement source, CheckerContext $context, String message) {
        KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getCONTRACT_NOT_ALLOWED(), (Object)message, (DiagnosticContext)$context, null, 16, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u001e\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J,\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0016\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\tj\u0002`\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J,\u0010\f\u001a\u0004\u0018\u00010\u00022\u0016\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u000ej\u0002`\u000f2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J,\u0010\u0010\u001a\u0004\u0018\u00010\u00022\u0016\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u0012j\u0002`\u00132\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J,\u0010\u0014\u001a\u0004\u0018\u00010\u00022\u0016\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u0016j\u0002`\u00172\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J&\u0010\u0018\u001a\u00020\u00022\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u00192\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J,\u0010\u001a\u001a\u0004\u0018\u00010\u00022\u0016\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u001cj\u0002`\u001d2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J,\u0010\u001e\u001a\u0004\u0018\u00010\u00022\u0016\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020 j\u0002`!2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J,\u0010\"\u001a\u0004\u0018\u00010\u00022\u0016\u0010#\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020$j\u0002`%2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J&\u0010&\u001a\u00020\u00022\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020'2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J,\u0010(\u001a\u0004\u0018\u00010\u00022\u0016\u0010)\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020*j\u0002`+2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J&\u0010,\u001a\u00020\u00022\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020.2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J&\u0010/\u001a\u00020\u00022\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0002012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J&\u00102\u001a\u00020\u00022\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0002042\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a8\u00065"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirContractChecker$DiagnosticExtractor;", "Lorg/jetbrains/kotlin/contracts/description/KtContractDescriptionVisitor;", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "<init>", "()V", "visitContractDescriptionElement", "contractDescriptionElement", "Lorg/jetbrains/kotlin/contracts/description/KtContractDescriptionElement;", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeContractDescriptionElement;", "data", "visitConditionalEffectDeclaration", "conditionalEffect", "Lorg/jetbrains/kotlin/contracts/description/KtConditionalEffectDeclaration;", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeConditionalEffectDeclaration;", "visitReturnsEffectDeclaration", "returnsEffect", "Lorg/jetbrains/kotlin/contracts/description/KtReturnsEffectDeclaration;", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeReturnsEffectDeclaration;", "visitCallsEffectDeclaration", "callsEffect", "Lorg/jetbrains/kotlin/contracts/description/KtCallsEffectDeclaration;", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeCallsEffectDeclaration;", "visitErroneousCallsEffectDeclaration", "Lorg/jetbrains/kotlin/contracts/description/KtErroneousCallsEffectDeclaration;", "visitLogicalBinaryOperationContractExpression", "binaryLogicExpression", "Lorg/jetbrains/kotlin/contracts/description/KtBinaryLogicExpression;", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeBinaryLogicExpression;", "visitLogicalNot", "logicalNot", "Lorg/jetbrains/kotlin/contracts/description/KtLogicalNot;", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeLogicalNot;", "visitIsInstancePredicate", "isInstancePredicate", "Lorg/jetbrains/kotlin/contracts/description/KtIsInstancePredicate;", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeIsInstancePredicate;", "visitErroneousIsInstancePredicate", "Lorg/jetbrains/kotlin/contracts/description/KtErroneousIsInstancePredicate;", "visitIsNullPredicate", "isNullPredicate", "Lorg/jetbrains/kotlin/contracts/description/KtIsNullPredicate;", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeIsNullPredicate;", "visitErroneousConstantReference", "erroneousConstantReference", "Lorg/jetbrains/kotlin/contracts/description/KtErroneousConstantReference;", "visitErroneousValueParameterReference", "valueParameterReference", "Lorg/jetbrains/kotlin/contracts/description/KtErroneousValueParameterReference;", "visitErroneousElement", "element", "Lorg/jetbrains/kotlin/contracts/description/KtErroneousContractElement;", "checkers"})
    private static final class DiagnosticExtractor
    extends KtContractDescriptionVisitor {
        @NotNull
        public static final DiagnosticExtractor INSTANCE = new DiagnosticExtractor();

        private DiagnosticExtractor() {
        }

        @Nullable
        public ConeDiagnostic visitContractDescriptionElement(@NotNull KtContractDescriptionElement<ConeKotlinType, ConeDiagnostic> contractDescriptionElement, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(contractDescriptionElement, (String)"contractDescriptionElement");
            return null;
        }

        @Nullable
        public ConeDiagnostic visitConditionalEffectDeclaration(@NotNull KtConditionalEffectDeclaration<ConeKotlinType, ConeDiagnostic> conditionalEffect, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(conditionalEffect, (String)"conditionalEffect");
            ConeDiagnostic coneDiagnostic = (ConeDiagnostic)conditionalEffect.getEffect().accept(this, null);
            if (coneDiagnostic == null) {
                coneDiagnostic = (ConeDiagnostic)conditionalEffect.getCondition().accept(this, null);
            }
            return coneDiagnostic;
        }

        @Nullable
        public ConeDiagnostic visitReturnsEffectDeclaration(@NotNull KtReturnsEffectDeclaration<ConeKotlinType, ConeDiagnostic> returnsEffect, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(returnsEffect, (String)"returnsEffect");
            return (ConeDiagnostic)returnsEffect.getValue().accept(this, null);
        }

        @Nullable
        public ConeDiagnostic visitCallsEffectDeclaration(@NotNull KtCallsEffectDeclaration<ConeKotlinType, ConeDiagnostic> callsEffect, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(callsEffect, (String)"callsEffect");
            return (ConeDiagnostic)callsEffect.getValueParameterReference().accept(this, data);
        }

        @NotNull
        public ConeDiagnostic visitErroneousCallsEffectDeclaration(@NotNull KtErroneousCallsEffectDeclaration<ConeKotlinType, ConeDiagnostic> callsEffect, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(callsEffect, (String)"callsEffect");
            return callsEffect.getDiagnostic();
        }

        @Nullable
        public ConeDiagnostic visitLogicalBinaryOperationContractExpression(@NotNull KtBinaryLogicExpression<ConeKotlinType, ConeDiagnostic> binaryLogicExpression, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(binaryLogicExpression, (String)"binaryLogicExpression");
            ConeDiagnostic coneDiagnostic = (ConeDiagnostic)binaryLogicExpression.getLeft().accept(this, null);
            if (coneDiagnostic == null) {
                coneDiagnostic = (ConeDiagnostic)binaryLogicExpression.getRight().accept(this, null);
            }
            return coneDiagnostic;
        }

        @Nullable
        public ConeDiagnostic visitLogicalNot(@NotNull KtLogicalNot<ConeKotlinType, ConeDiagnostic> logicalNot, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(logicalNot, (String)"logicalNot");
            return (ConeDiagnostic)logicalNot.getArg().accept(this, null);
        }

        @Nullable
        public ConeDiagnostic visitIsInstancePredicate(@NotNull KtIsInstancePredicate<ConeKotlinType, ConeDiagnostic> isInstancePredicate, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(isInstancePredicate, (String)"isInstancePredicate");
            return (ConeDiagnostic)isInstancePredicate.getArg().accept(this, data);
        }

        @NotNull
        public ConeDiagnostic visitErroneousIsInstancePredicate(@NotNull KtErroneousIsInstancePredicate<ConeKotlinType, ConeDiagnostic> isInstancePredicate, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(isInstancePredicate, (String)"isInstancePredicate");
            return isInstancePredicate.getDiagnostic();
        }

        @Nullable
        public ConeDiagnostic visitIsNullPredicate(@NotNull KtIsNullPredicate<ConeKotlinType, ConeDiagnostic> isNullPredicate, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(isNullPredicate, (String)"isNullPredicate");
            return (ConeDiagnostic)isNullPredicate.getArg().accept(this, data);
        }

        @NotNull
        public ConeDiagnostic visitErroneousConstantReference(@NotNull KtErroneousConstantReference<ConeKotlinType, ConeDiagnostic> erroneousConstantReference, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(erroneousConstantReference, (String)"erroneousConstantReference");
            return erroneousConstantReference.getDiagnostic();
        }

        @NotNull
        public ConeDiagnostic visitErroneousValueParameterReference(@NotNull KtErroneousValueParameterReference<ConeKotlinType, ConeDiagnostic> valueParameterReference, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(valueParameterReference, (String)"valueParameterReference");
            return valueParameterReference.getDiagnostic();
        }

        @NotNull
        public ConeDiagnostic visitErroneousElement(@NotNull KtErroneousContractElement<ConeKotlinType, ConeDiagnostic> element, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(element, (String)"element");
            return element.getDiagnostic();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u001e\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ(\u0010\u000f\u001a\u0004\u0018\u00010\u00022\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u0016J(\u0010\u0013\u001a\u0004\u0018\u00010\u00022\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u00152\b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u0016J(\u0010\u0016\u001a\u0004\u0018\u00010\u00022\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u00182\b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u0016J(\u0010\u0019\u001a\u0004\u0018\u00010\u00022\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u001b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u0016J(\u0010\u001c\u001a\u0004\u0018\u00010\u00022\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u001e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u0016J\u0010\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020!H\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirContractChecker$ErasedCastChecker;", "Lorg/jetbrains/kotlin/contracts/description/KtContractDescriptionVisitor;", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "<init>", "(Lorg/jetbrains/kotlin/fir/declarations/FirFunction;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)V", "getDeclaration", "()Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "getContext", "()Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "visitContractDescriptionElement", "contractDescriptionElement", "Lorg/jetbrains/kotlin/contracts/description/KtContractDescriptionElement;", "data", "visitConditionalEffectDeclaration", "conditionalEffect", "Lorg/jetbrains/kotlin/contracts/description/KtConditionalEffectDeclaration;", "visitIsInstancePredicate", "isInstancePredicate", "Lorg/jetbrains/kotlin/contracts/description/KtIsInstancePredicate;", "visitLogicalBinaryOperationContractExpression", "binaryLogicExpression", "Lorg/jetbrains/kotlin/contracts/description/KtBinaryLogicExpression;", "visitLogicalNot", "logicalNot", "Lorg/jetbrains/kotlin/contracts/description/KtLogicalNot;", "getParameterType", "index", "", "checkers"})
    @SourceDebugExtension(value={"SMAP\nFirContractChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirContractChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirContractChecker$ErasedCastChecker\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,296:1\n280#2:297\n*S KotlinDebug\n*F\n+ 1 FirContractChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirContractChecker$ErasedCastChecker\n*L\n272#1:297\n*E\n"})
    private static final class ErasedCastChecker
    extends KtContractDescriptionVisitor {
        @NotNull
        private final FirFunction declaration;
        @NotNull
        private final CheckerContext context;

        public ErasedCastChecker(@NotNull FirFunction declaration, @NotNull CheckerContext context) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.declaration = declaration;
            this.context = context;
        }

        @NotNull
        public final FirFunction getDeclaration() {
            return this.declaration;
        }

        @NotNull
        public final CheckerContext getContext() {
            return this.context;
        }

        @Nullable
        public ConeDiagnostic visitContractDescriptionElement(@NotNull KtContractDescriptionElement<ConeKotlinType, ConeDiagnostic> contractDescriptionElement, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(contractDescriptionElement, (String)"contractDescriptionElement");
            return null;
        }

        @Nullable
        public ConeDiagnostic visitConditionalEffectDeclaration(@NotNull KtConditionalEffectDeclaration<ConeKotlinType, ConeDiagnostic> conditionalEffect, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(conditionalEffect, (String)"conditionalEffect");
            return (ConeDiagnostic)conditionalEffect.getCondition().accept(this, data);
        }

        @Nullable
        public ConeDiagnostic visitIsInstancePredicate(@NotNull KtIsInstancePredicate<ConeKotlinType, ConeDiagnostic> isInstancePredicate, @Nullable Void data) {
            ConeContractDescriptionError.ErasedIsCheck erasedIsCheck;
            Intrinsics.checkNotNullParameter(isInstancePredicate, (String)"isInstancePredicate");
            ConeKotlinType parameterType = this.getParameterType(isInstancePredicate.getArg().getParameterIndex());
            boolean $this$ifTrue$iv = FirCastDiagnosticsHelpersKt.isCastErased(parameterType, isInstancePredicate.getType(), this.context);
            boolean $i$f$ifTrue = false;
            if ($this$ifTrue$iv) {
                boolean bl = false;
                erasedIsCheck = ConeContractDescriptionError.ErasedIsCheck.INSTANCE;
            } else {
                erasedIsCheck = null;
            }
            return erasedIsCheck;
        }

        @Nullable
        public ConeDiagnostic visitLogicalBinaryOperationContractExpression(@NotNull KtBinaryLogicExpression<ConeKotlinType, ConeDiagnostic> binaryLogicExpression, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(binaryLogicExpression, (String)"binaryLogicExpression");
            ConeDiagnostic coneDiagnostic = (ConeDiagnostic)binaryLogicExpression.getLeft().accept(this, data);
            if (coneDiagnostic == null) {
                coneDiagnostic = (ConeDiagnostic)binaryLogicExpression.getRight().accept(this, data);
            }
            return coneDiagnostic;
        }

        @Nullable
        public ConeDiagnostic visitLogicalNot(@NotNull KtLogicalNot<ConeKotlinType, ConeDiagnostic> logicalNot, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(logicalNot, (String)"logicalNot");
            return (ConeDiagnostic)logicalNot.getArg().accept(this, data);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final ConeKotlinType getParameterType(int index) {
            Object object;
            if (index == -1) {
                object = this.declaration.getSymbol().getResolvedReceiverTypeRef();
                if (object != null && (object = ((FirResolvedTypeRef)object).getConeType()) != null) return object;
                ConeSimpleKotlinType coneSimpleKotlinType = this.declaration.getSymbol().getDispatchReceiverType();
                if (coneSimpleKotlinType == null) throw new IllegalStateException("Contract references non-existent receiver".toString());
                object = coneSimpleKotlinType;
                return object;
            } else {
                object = FirTypeUtilsKt.getConeType(this.declaration.getValueParameters().get(index).getReturnTypeRef());
            }
            return object;
        }
    }
}

