/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.functions.FunctionClassDescriptor;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.resolve.checkers.ClassifierUsageChecker;
import org.jetbrains.kotlin.resolve.checkers.ClassifierUsageCheckerContext;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/BigFunctionTypeAvailabilityChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/ClassifierUsageChecker;", "<init>", "()V", "check", "", "targetDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "element", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/ClassifierUsageCheckerContext;", "frontend"})
public final class BigFunctionTypeAvailabilityChecker
implements ClassifierUsageChecker {
    @NotNull
    public static final BigFunctionTypeAvailabilityChecker INSTANCE = new BigFunctionTypeAvailabilityChecker();

    private BigFunctionTypeAvailabilityChecker() {
    }

    @Override
    public void check(@NotNull ClassifierDescriptor targetDescriptor, @NotNull PsiElement element, @NotNull ClassifierUsageCheckerContext context) {
        Intrinsics.checkNotNullParameter((Object)targetDescriptor, (String)"targetDescriptor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.getLanguageVersionSettings().supportsFeature(LanguageFeature.FunctionTypesWithBigArity)) {
            return;
        }
        SimpleType simpleType = targetDescriptor.getDefaultType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getDefaultType(...)");
        if (TypeUtilsKt.contains(simpleType, (Function1<? super UnwrappedType, Boolean>)((Function1)BigFunctionTypeAvailabilityChecker::check$lambda$0))) {
            context.getTrace().report(Errors.UNSUPPORTED_FEATURE.on(element, (Pair<LanguageFeature, LanguageVersionSettings>)TuplesKt.to((Object)((Object)LanguageFeature.FunctionTypesWithBigArity), (Object)context.getLanguageVersionSettings())));
        }
    }

    private static final boolean check$lambda$0(UnwrappedType argumentType) {
        Intrinsics.checkNotNullParameter((Object)argumentType, (String)"argumentType");
        ClassifierDescriptor descriptor = argumentType.getConstructor().getDeclarationDescriptor();
        return descriptor instanceof FunctionClassDescriptor && ((FunctionClassDescriptor)descriptor).hasBigArity();
    }
}

