/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.export;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.JsLoweredDeclarationOrigin;
import org.jetbrains.kotlin.ir.backend.js.export.ErrorDeclaration;
import org.jetbrains.kotlin.ir.backend.js.export.ExportModelGenerator;
import org.jetbrains.kotlin.ir.backend.js.export.ExportModelGeneratorKt;
import org.jetbrains.kotlin.ir.backend.js.export.Exportability;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedClass;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedClassDeclarationsInfo;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedConstructor;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedDeclaration;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedFunction;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedModule;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedNamespace;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedObject;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedParameter;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedProperty;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedRegularClass;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedType;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedVisibility;
import org.jetbrains.kotlin.ir.backend.js.export.TransitiveExportCollector;
import org.jetbrains.kotlin.ir.backend.js.lower.ES6AddBoxParameterLoweringKt;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrJsUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrResolveUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.NameTablesKt;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrDynamicType;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrExceptionBuilder;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.serialization.js.ModuleKind;
import org.jetbrains.kotlin.utils.MemoryOptimizedCollectionUtilKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00f6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012J\u001e\u0010\u000e\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\b\b\u0002\u0010\u0017\u001a\u00020\u0018J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00102\u0006\u0010 \u001a\u00020!H\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010\u00102\u0006\u0010#\u001a\u00020$H\u0002J\u0018\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0005H\u0002J\u0012\u0010,\u001a\u0004\u0018\u00010\u00102\u0006\u0010-\u001a\u00020.H\u0002J\u001c\u0010/\u001a\u00020\u00102\u0006\u0010-\u001a\u00020.2\n\b\u0002\u00100\u001a\u0004\u0018\u000101H\u0002J$\u00102\u001a\u0002032\u0006\u00104\u001a\u0002052\u0012\u00106\u001a\u000e\u0012\u0004\u0012\u000208\u0012\u0004\u0012\u00020907H\u0002J\u0010\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\u001eH\u0002J\u001e\u0010=\u001a\u00020\u00102\u0006\u0010<\u001a\u00020\u001e2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020?0\u0015H\u0002J \u0010@\u001a\u0004\u0018\u00010\u00102\u0006\u0010<\u001a\u00020\u001e2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020?0\u0015H\u0002J \u0010A\u001a\u0004\u0018\u00010\u00102\u0006\u0010<\u001a\u00020\u001e2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020?0\u0015H\u0002J6\u0010B\u001a\u00020C2\u0006\u0010<\u001a\u00020\u001e2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020?0\u00152\u0016\b\u0002\u0010D\u001a\u0010\u0012\u0004\u0012\u00020F\u0012\u0006\u0012\u0004\u0018\u00010\u00100EH\u0002J\f\u0010G\u001a\u00020\u0005*\u00020\u001eH\u0002J\f\u0010H\u001a\u00020\u0005*\u00020(H\u0002J\u001a\u0010I\u001a\u00020\u0005*\u00020\u001e2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020?0\u0015H\u0002J\u001a\u0010J\u001a\u00020K*\b\u0012\u0004\u0012\u00020\u00100L2\u0006\u0010<\u001a\u00020\u001eH\u0002J(\u0010M\u001a\u00020K*\b\u0012\u0004\u0012\u00020\u00100L2\u0006\u0010<\u001a\u00020\u001e2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020?0\u0015H\u0002J\f\u0010N\u001a\u00020\u0005*\u00020?H\u0002J\f\u0010O\u001a\u00020\u0005*\u00020\u001eH\u0002J\f\u0010P\u001a\u000201*\u00020\u001eH\u0002J:\u0010\u001c\u001a\u00020\u00102\u0006\u0010<\u001a\u00020\u001e2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020?0\u00152\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020S0\u000fH\u0002J\u0012\u0010T\u001a\b\u0012\u0004\u0012\u00020?0U*\u00020VH\u0002J\f\u0010W\u001a\u00020\u0005*\u00020?H\u0002J&\u0010X\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001d\u001a\u00020F2\u0012\u0010Y\u001a\u000e\u0012\u0004\u0012\u000208\u0012\u0004\u0012\u00020907H\u0002J\f\u0010Z\u001a\u00020\u0005*\u00020?H\u0002J\u0010\u0010[\u001a\u0002012\u0006\u0010\\\u001a\u00020]H\u0002J\u000e\u0010^\u001a\u00020_2\u0006\u0010`\u001a\u00020aJ\u001a\u0010e\u001a\u0002012\u0006\u0010\\\u001a\u00020?2\b\b\u0002\u0010f\u001a\u00020\u0005H\u0002J\u0010\u0010g\u001a\u00020;2\u0006\u0010 \u001a\u00020!H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010)\u001a\u00020\u0005*\u00020(8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u001e\u0010b\u001a\u0012\u0012\u0004\u0012\u00020?0cj\b\u0012\u0004\u0012\u00020?`dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006h"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/export/ExportModelGenerator;", "", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "generateNamespacesForPackages", "", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;Z)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "getGenerateNamespacesForPackages", "()Z", "transitiveExportCollector", "Lorg/jetbrains/kotlin/ir/backend/js/export/TransitiveExportCollector;", "generateExport", "", "Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedDeclaration;", "file", "Lorg/jetbrains/kotlin/ir/declarations/IrPackageFragment;", "Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedModule;", "modules", "", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "moduleKind", "Lorg/jetbrains/kotlin/serialization/js/ModuleKind;", "exportDeclaration", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "exportClass", "candidate", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "exportFunction", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "exportConstructor", "constructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "exportParameter", "Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedParameter;", "parameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "hasDefaultValue", "getHasDefaultValue", "(Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;)Z", "exportProperty", "property", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "exportPropertyUnsafely", "specializeType", "Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedType;", "exportEnumEntry", "Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedProperty;", "field", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "enumEntries", "", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "", "classExportability", "Lorg/jetbrains/kotlin/ir/backend/js/export/Exportability;", "klass", "exportDeclarationImplicitly", "superTypes", "Lorg/jetbrains/kotlin/ir/types/IrType;", "exportOrdinaryClass", "exportEnumClass", "exportClassDeclarations", "Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedClassDeclarationsInfo;", "specialProcessing", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "shouldNotBeImplemented", "shouldBeExported", "shouldContainImplementationOfMagicProperty", "addMagicInterfaceProperty", "", "", "addMagicPropertyForInterfaceImplementation", "shouldAddMagicPropertyOfSuper", "isOwnMagicPropertyAdded", "generateTagType", "members", "nestedClasses", "Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedClass;", "collectSuperTransitiveHierarchy", "", "Lorg/jetbrains/kotlin/ir/types/IrSimpleType;", "shouldPresentInsideImplementsClause", "exportAsEnumMember", "enumEntriesToOrdinal", "canBeUsedAsSuperTypeOfExportedClasses", "exportTypeArgument", "type", "Lorg/jetbrains/kotlin/ir/types/IrTypeArgument;", "exportTypeParameter", "Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedType$TypeParameter;", "typeParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParameter;", "currentlyProcessedTypes", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "exportType", "shouldCalculateExportedSupertypeForImplicit", "functionExportability", "backend.js"})
@SourceDebugExtension(value={"SMAP\nExportModelGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExportModelGenerator.kt\norg/jetbrains/kotlin/ir/backend/js/export/ExportModelGenerator\n+ 2 MemoryOptimizedCollectionUtil.kt\norg/jetbrains/kotlin/utils/MemoryOptimizedCollectionUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 IrExceptionUtils.kt\norg/jetbrains/kotlin/ir/util/IrExceptionUtilsKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 7 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,919:1\n32#2:920\n40#2:933\n16#2:937\n24#2:944\n16#2:952\n16#2:962\n48#2:973\n16#2:1029\n48#2:1040\n48#2:1050\n16#2:1086\n16#2:1091\n16#2:1102\n1625#3:921\n1869#3:922\n1870#3:925\n1626#3:926\n1374#3:927\n1460#3,5:928\n1634#3,3:938\n774#3:941\n865#3,2:942\n1604#3,4:945\n827#3:949\n855#3,2:950\n1634#3,3:953\n1634#3,3:963\n774#3:966\n865#3,2:967\n1563#3:969\n1634#3,3:970\n865#3,2:974\n808#3,11:982\n1617#3,9:993\n1869#3:1002\n1870#3:1004\n1626#3:1005\n1761#3,3:1009\n774#3:1012\n865#3,2:1013\n1563#3:1015\n1634#3,3:1016\n2783#3,7:1019\n1761#3,3:1026\n1634#3,3:1030\n774#3:1033\n865#3,2:1034\n1563#3:1036\n1634#3,3:1037\n865#3,2:1041\n774#3:1043\n865#3,2:1044\n1563#3:1046\n1634#3,3:1047\n865#3,2:1051\n1563#3:1053\n1634#3,3:1054\n1563#3:1057\n1634#3,3:1058\n2851#3,7:1061\n2851#3,7:1072\n2783#3,7:1079\n1634#3,3:1087\n1634#3,3:1092\n2783#3,7:1095\n1634#3,3:1103\n1761#3,3:1109\n1761#3,3:1112\n1#4:923\n1#4:924\n1#4:935\n1#4:957\n1#4:960\n1#4:977\n1#4:980\n1#4:1003\n1#4:1007\n1#4:1107\n28#5:934\n29#5:936\n28#5:956\n29#5:958\n28#5:959\n29#5:961\n28#5:976\n29#5:978\n28#5:979\n29#5:981\n28#5:1006\n29#5:1008\n28#5:1106\n29#5:1108\n126#6:1068\n153#6,3:1069\n231#7:1090\n*S KotlinDebug\n*F\n+ 1 ExportModelGenerator.kt\norg/jetbrains/kotlin/ir/backend/js/export/ExportModelGenerator\n*L\n39#1:920\n54#1:933\n95#1:937\n103#1:944\n121#1:952\n245#1:962\n249#1:973\n462#1:1029\n467#1:1040\n472#1:1050\n626#1:1086\n642#1:1091\n657#1:1102\n39#1:921\n39#1:922\n39#1:925\n39#1:926\n54#1:927\n54#1:928,5\n95#1:938,3\n102#1:941\n102#1:942,2\n103#1:945,4\n120#1:949\n120#1:950,2\n121#1:953,3\n245#1:963,3\n247#1:966\n247#1:967,2\n248#1:969\n248#1:970,3\n249#1:974,2\n298#1:982,11\n299#1:993,9\n299#1:1002\n299#1:1004\n299#1:1005\n405#1:1009,3\n416#1:1012\n416#1:1013,2\n423#1:1015\n423#1:1016,3\n424#1:1019,7\n437#1:1026,3\n462#1:1030,3\n465#1:1033\n465#1:1034,2\n466#1:1036\n466#1:1037,3\n467#1:1041,2\n470#1:1043\n470#1:1044,2\n471#1:1046\n471#1:1047,3\n472#1:1051,2\n519#1:1053\n519#1:1054,3\n520#1:1057\n520#1:1058,3\n521#1:1061,7\n524#1:1072,7\n581#1:1079,7\n626#1:1087,3\n642#1:1092,3\n642#1:1095,7\n657#1:1103,3\n673#1:1109,3\n702#1:1112,3\n39#1:924\n68#1:935\n181#1:957\n215#1:960\n268#1:977\n288#1:980\n299#1:1003\n378#1:1007\n663#1:1107\n68#1:934\n68#1:936\n181#1:956\n181#1:958\n215#1:959\n215#1:961\n268#1:976\n268#1:978\n288#1:979\n288#1:981\n378#1:1006\n378#1:1008\n663#1:1106\n663#1:1108\n523#1:1068\n523#1:1069,3\n639#1:1090\n*E\n"})
public final class ExportModelGenerator {
    @NotNull
    private final JsIrBackendContext context;
    private final boolean generateNamespacesForPackages;
    @NotNull
    private final TransitiveExportCollector transitiveExportCollector;
    @NotNull
    private final HashSet<IrType> currentlyProcessedTypes;

    public ExportModelGenerator(@NotNull JsIrBackendContext context, boolean generateNamespacesForPackages) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.generateNamespacesForPackages = generateNamespacesForPackages;
        this.transitiveExportCollector = new TransitiveExportCollector(this.context);
        this.currentlyProcessedTypes = new HashSet();
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    public final boolean getGenerateNamespacesForPackages() {
        return this.generateNamespacesForPackages;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ExportedDeclaration> generateExport(@NotNull IrPackageFragment file2) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        FqName namespaceFqName = file2.getPackageFqName();
        Collection $this$memoryOptimizedMapNotNull$iv = file2.getDeclarations();
        boolean $i$f$memoryOptimizedMapNotNull = false;
        Iterable iterable = $this$memoryOptimizedMapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ExportedDeclaration exportedDeclaration;
            IrDeclaration irDeclaration2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            IrDeclaration declaration = (IrDeclaration)element$iv$iv;
            boolean bl2 = false;
            IrDeclaration it = irDeclaration2 = declaration;
            boolean bl3 = false;
            if ((!Intrinsics.areEqual((Object)AnnotationUtilsKt.couldBeConvertedToExplicitExport(it), (Object)true) ? irDeclaration2 : null) != null) {
                IrDeclaration p0;
                p0 = p0;
                boolean bl4 = false;
                exportedDeclaration = this.exportDeclaration(p0);
            } else {
                exportedDeclaration = null;
            }
            if (exportedDeclaration == null) continue;
            ExportedDeclaration it$iv$iv = exportedDeclaration;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List exports = org.jetbrains.kotlin.utils.CollectionsKt.compactIfPossible((List)destination$iv$iv);
        return exports.isEmpty() ? CollectionsKt.emptyList() : (!this.generateNamespacesForPackages || namespaceFqName.isRoot() ? exports : CollectionsKt.listOf((Object)new ExportedNamespace(namespaceFqName.toString(), exports, false, 4, null)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ExportedModule generateExport(@NotNull Iterable<? extends IrModuleFragment> modules2, @NotNull ModuleKind moduleKind) {
        void $this$memoryOptimizedFlatMap$iv;
        Iterable list$iv$iv;
        IrElementBase it;
        Iterable $this$flatMapTo$iv$iv;
        Collection $this$flatMap$iv;
        Intrinsics.checkNotNullParameter(modules2, (String)"modules");
        Intrinsics.checkNotNullParameter((Object)((Object)moduleKind), (String)"moduleKind");
        String string2 = this.context.getConfiguration().get(CommonConfigurationKeys.MODULE_NAME);
        Intrinsics.checkNotNull((Object)string2);
        Iterable<? extends IrModuleFragment> iterable = modules2;
        Collection<IrFile> collection = this.context.getExternalPackageFragment().values();
        ModuleKind moduleKind2 = moduleKind;
        String string3 = string2;
        boolean $i$f$flatMap = false;
        void var5_8 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (IrModuleFragment)element$iv$iv;
            boolean bl = false;
            list$iv$iv = it.getFiles();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list = (List)destination$iv$iv;
        $this$flatMap$iv = CollectionsKt.plus(collection, (Iterable)list);
        boolean $i$f$memoryOptimizedFlatMap = false;
        $this$flatMapTo$iv$iv = (Iterable)$this$memoryOptimizedFlatMap$iv;
        destination$iv$iv = new ArrayList();
        $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (IrFile)element$iv$iv;
            boolean bl = false;
            list$iv$iv = this.generateExport((IrPackageFragment)it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Collection<IrFile> collection2 = collection = org.jetbrains.kotlin.utils.CollectionsKt.compactIfPossible((List)destination$iv$iv);
        ModuleKind moduleKind3 = moduleKind2;
        String string4 = string3;
        return new ExportedModule(string4, moduleKind3, (List<? extends ExportedDeclaration>)collection2);
    }

    public static /* synthetic */ ExportedModule generateExport$default(ExportModelGenerator exportModelGenerator, Iterable iterable, ModuleKind moduleKind, int n, Object object) {
        if ((n & 2) != 0) {
            moduleKind = ModuleKind.PLAIN;
        }
        return exportModelGenerator.generateExport(iterable, moduleKind);
    }

    private final ExportedDeclaration exportDeclaration(IrDeclaration declaration) {
        ExportedDeclaration exportedDeclaration;
        IrDeclarationWithName irDeclarationWithName = ExportModelGeneratorKt.access$getExportCandidate(declaration);
        if (irDeclarationWithName == null) {
            return null;
        }
        IrDeclarationWithName candidate2 = irDeclarationWithName;
        if (!ExportModelGeneratorKt.access$shouldDeclarationBeExportedImplicitlyOrExplicitly(candidate2, this.context)) {
            return null;
        }
        IrDeclarationWithName irDeclarationWithName2 = candidate2;
        if (irDeclarationWithName2 instanceof IrSimpleFunction) {
            exportedDeclaration = this.exportFunction((IrSimpleFunction)candidate2);
        } else if (irDeclarationWithName2 instanceof IrProperty) {
            exportedDeclaration = this.exportProperty((IrProperty)candidate2);
        } else if (irDeclarationWithName2 instanceof IrClass) {
            exportedDeclaration = this.exportClass((IrClass)candidate2);
        } else if (irDeclarationWithName2 instanceof IrField) {
            exportedDeclaration = null;
        } else {
            IrExceptionBuilder irExceptionBuilder;
            String message$iv = "Can't export declaration";
            boolean $i$f$irError = false;
            IrExceptionBuilder $this$irError_u24lambda_u240$iv = irExceptionBuilder = new IrExceptionBuilder(message$iv);
            boolean bl = false;
            IrExceptionBuilder $this$exportDeclaration_u24lambda_u244 = $this$irError_u24lambda_u240$iv;
            boolean bl2 = false;
            $this$exportDeclaration_u24lambda_u244.withIrEntry("candidate", candidate2);
            IrExceptionBuilder builder$iv = irExceptionBuilder;
            throw new IllegalStateException(builder$iv.buildString().toString());
        }
        ExportedDeclaration exportedDeclaration2 = exportedDeclaration;
        return exportedDeclaration2 != null ? ExportModelGeneratorKt.withAttributesFor(exportedDeclaration2, candidate2) : null;
    }

    private final ExportedDeclaration exportClass(IrClass candidate2) {
        Set superTypes = SetsKt.plus(this.collectSuperTransitiveHierarchy(IrUtilsKt.getDefaultType(candidate2)), (Iterable)candidate2.getSuperTypes());
        return IrUtilsKt.isEnumClass(candidate2) ? this.exportEnumClass(candidate2, superTypes) : this.exportOrdinaryClass(candidate2, superTypes);
    }

    /*
     * Unable to fully structure code
     */
    private final ExportedDeclaration exportFunction(IrSimpleFunction function) {
        block7: {
            block9: {
                block8: {
                    block6: {
                        exportability = this.functionExportability(function);
                        if (!(exportability instanceof Exportability.NotNeeded) && !(exportability instanceof Exportability.Implicit)) break block6;
                        v0 = null;
                        break block7;
                    }
                    if (!(exportability instanceof Exportability.Prohibited)) break block8;
                    v0 = new ErrorDeclaration(((Exportability.Prohibited)exportability).getReason());
                    break block7;
                }
                if (!(exportability instanceof Exportability.Allowed)) break block9;
                parent = function.getParent();
                realOverrideTarget = IrResolveUtilsKt.getRealOverrideTarget(function);
                var5_5 = ExportModelGeneratorKt.getExportedIdentifier(function);
                var6_6 = ExportModelGenerator.exportType$default(this, function.getReturnType(), false, 2, null);
                $this$memoryOptimizedMap$iv = function.getTypeParameters();
                $i$f$memoryOptimizedMap = false;
                var10_10 = $this$memoryOptimizedMap$iv;
                destination$iv$iv = new ArrayList<E>($this$memoryOptimizedMap$iv.size());
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var15_19 = (IrTypeParameter)item$iv$iv;
                    var25_22 = destination$iv$iv;
                    $i$a$-memoryOptimizedMap-ExportModelGenerator$exportFunction$1 = false;
                    var25_22.add(this.exportTypeParameter((IrTypeParameter)p0));
                }
                var7_23 = org.jetbrains.kotlin.utils.CollectionsKt.compactIfPossible((List)destination$iv$iv);
                var8_8 = parent instanceof IrClass;
                var9_9 = ExportModelGeneratorKt.access$isStaticMethod(function);
                var10_11 = parent instanceof IrClass != false && IrUtilsKt.isInterface((IrClass)parent) == false && function.getModality() == Modality.ABSTRACT;
                var11_13 = Intrinsics.areEqual((Object)function.getVisibility(), (Object)DescriptorVisibilities.PROTECTED);
                var13_16 = CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull((Object)function.getExtensionReceiverParameter()), (Iterable)function.getValueParameters());
                $i$f$filter = false;
                p0 = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (IrValueParameter)element$iv$iv;
                    $i$a$-filter-ExportModelGenerator$exportFunction$2 = false;
                    if (!this.shouldBeExported(it)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                $i$f$memoryOptimizedMapIndexed = false;
                $this$filterTo$iv$iv = (Iterable)$this$memoryOptimizedMapIndexed$iv;
                destination$iv$iv = new ArrayList<E>($this$memoryOptimizedMapIndexed$iv.size());
                $i$f$mapIndexedTo = false;
                index$iv$iv = 0;
                for (T item$iv$iv : $this$mapIndexedTo$iv$iv) {
                    if ((var21_29 = index$iv$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    var22_30 = (IrValueParameter)item$iv$iv;
                    var23_31 = var21_29;
                    var25_22 = destination$iv$iv;
                    $i$a$-memoryOptimizedMapIndexed-ExportModelGenerator$exportFunction$3 = false;
                    if (this.getHasDefaultValue((IrValueParameter)it)) ** GOTO lbl-1000
                    v1 = (IrValueParameter)CollectionsKt.getOrNull(realOverrideTarget.getValueParameters(), (int)i);
                    v2 = v1 != null ? this.getHasDefaultValue(v1) : false;
                    if (v2) lbl-1000:
                    // 2 sources

                    {
                        v3 = true;
                    } else {
                        v3 = false;
                    }
                    var25_22.add(this.exportParameter((IrValueParameter)it, v3));
                }
                var12_15 = org.jetbrains.kotlin.utils.CollectionsKt.compactIfPossible((List)destination$iv$iv);
                v0 = new ExportedFunction(var5_5, var6_6, var12_15, var7_23, var8_8, var9_9, var10_11, var11_13, function);
                break block7;
            }
            throw new NoWhenBranchMatchedException();
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    private final ExportedDeclaration exportConstructor(IrConstructor constructor) {
        void $this$mapTo$iv$iv;
        IrValueParameter it;
        Iterable $this$filterNotTo$iv$iv;
        if (!constructor.isPrimary()) {
            return null;
        }
        List allValueParameters = CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull((Object)constructor.getExtensionReceiverParameter()), (Iterable)constructor.getValueParameters());
        Iterable $this$filterNot$iv = allValueParameters;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (IrValueParameter)element$iv$iv;
            boolean bl = false;
            if (ES6AddBoxParameterLoweringKt.isBoxParameter(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection $this$memoryOptimizedMap$iv = (List)destination$iv$iv;
        boolean $i$f$memoryOptimizedMap = false;
        $this$filterNotTo$iv$iv = $this$memoryOptimizedMap$iv;
        destination$iv$iv = new ArrayList($this$memoryOptimizedMap$iv.size());
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (IrValueParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.exportParameter(it, this.getHasDefaultValue(it)));
        }
        ExportedVisibility exportedVisibility = ExportModelGeneratorKt.toExportedVisibility(constructor.getVisibility());
        List<ExportedParameter> list = org.jetbrains.kotlin.utils.CollectionsKt.compactIfPossible((List)destination$iv$iv);
        return new ExportedConstructor(list, exportedVisibility);
    }

    private final ExportedParameter exportParameter(IrValueParameter parameter, boolean hasDefaultValue) {
        String string2 = parameter.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        String parameterName = NameTablesKt.sanitizeName(string2, false);
        if (ExportModelGeneratorKt.access$getAllReservedWords$p().contains(parameterName)) {
            parameterName = '_' + parameterName;
        }
        return new ExportedParameter(parameterName, ExportModelGenerator.exportType$default(this, parameter.getType(), false, 2, null), hasDefaultValue);
    }

    private final boolean getHasDefaultValue(IrValueParameter $this$hasDefaultValue) {
        return Intrinsics.areEqual((Object)$this$hasDefaultValue.getOrigin(), (Object)JsLoweredDeclarationOrigin.INSTANCE.getJS_SHADOWED_DEFAULT_PARAMETER());
    }

    private final ExportedDeclaration exportProperty(IrProperty property2) {
        Object[] objectArray = new IrSimpleFunction[]{property2.getGetter(), property2.getSetter()};
        for (IrSimpleFunction accessor : CollectionsKt.listOfNotNull((Object[])objectArray)) {
            if (accessor.getExtensionReceiverParameter() != null) {
                return null;
            }
            if (!accessor.isFakeOverride() || ExportModelGeneratorKt.isAllowedFakeOverriddenDeclaration(accessor, this.context)) continue;
            return null;
        }
        return ExportModelGenerator.exportPropertyUnsafely$default(this, property2, null, 2, null);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final ExportedDeclaration exportPropertyUnsafely(IrProperty property, ExportedType specializeType) {
        var4_3 = property.getParent();
        v0 = parentClass = var4_3 instanceof IrClass != false ? (IrClass)var4_3 : null;
        if (!IrUtilsKt.isEffectivelyExternal(property) || !(property.getParent() instanceof IrClass)) ** GOTO lbl-1000
        v1 /* !! */  = property.getGetter();
        v2 = v1 /* !! */  != null && (v1 /* !! */  = v1 /* !! */ .getReturnType()) != null ? IrTypeUtilsKt.isNullable((IrType)v1 /* !! */ ) : false;
        if (v2) {
            v3 = true;
        } else lbl-1000:
        // 2 sources

        {
            v3 = false;
        }
        isOptional = v3;
        var5_6 = ExportModelGeneratorKt.getExportedIdentifier(property);
        v4 = specializeType;
        if (v4 == null) {
            v5 = property.getGetter();
            Intrinsics.checkNotNull((Object)v5);
            v4 = ExportModelGenerator.exportType$default(this, v5.getReturnType(), false, 2, null);
        }
        var6_7 = v4;
        var7_8 = property.isVar();
        var8_9 = parentClass != null;
        v6 = parentClass;
        var9_10 = (v6 != null ? !IrUtilsKt.isInterface(v6) : false) != false && property.getModality() == Modality.ABSTRACT;
        var10_11 = Intrinsics.areEqual((Object)property.getVisibility(), (Object)DescriptorVisibilities.PROTECTED);
        v7 = parentClass;
        var11_12 = v7 != null ? IrUtilsKt.isInterface(v7) : false;
        var12_13 = property.getGetter();
        var13_14 = property.getSetter();
        v8 = property.getGetter();
        if (v8 == null) {
            v8 = property.getSetter();
        }
        var14_15 = v8 != null ? IrDeclarationsKt.isStaticMethodOfClass(v8) : false;
        return new ExportedProperty(var5_6, var6_7, var7_8, var8_9, var14_15, var9_10, var10_11, var11_12, var12_13, var13_14, isOptional);
    }

    static /* synthetic */ ExportedDeclaration exportPropertyUnsafely$default(ExportModelGenerator exportModelGenerator, IrProperty irProperty, ExportedType exportedType, int n, Object object) {
        if ((n & 2) != 0) {
            exportedType = null;
        }
        return exportModelGenerator.exportPropertyUnsafely(irProperty, exportedType);
    }

    /*
     * WARNING - void declaration
     */
    private final ExportedProperty exportEnumEntry(IrField field, Map<IrEnumEntry, Integer> enumEntries) {
        IrEnumEntry irEnumEntry = this.context.getMapping().getFieldToEnumEntry().get((IrField)((IrDeclaration)field));
        if (irEnumEntry == null) {
            IrExceptionBuilder irExceptionBuilder;
            String message$iv = "Unable to find enum entry";
            boolean $i$f$irError = false;
            IrExceptionBuilder $this$irError_u24lambda_u240$iv = irExceptionBuilder = new IrExceptionBuilder(message$iv);
            boolean bl = false;
            IrExceptionBuilder $this$exportEnumEntry_u24lambda_u2410 = $this$irError_u24lambda_u240$iv;
            boolean bl2 = false;
            $this$exportEnumEntry_u24lambda_u2410.withIrEntry("field", field);
            IrExceptionBuilder builder$iv = irExceptionBuilder;
            throw new IllegalStateException(builder$iv.buildString().toString());
        }
        IrEnumEntry irEnumEntry2 = irEnumEntry;
        IrDeclarationParent irDeclarationParent = field.getParent();
        Intrinsics.checkNotNull((Object)irDeclarationParent, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
        IrClass parentClass = (IrClass)irDeclarationParent;
        String name2 = ExportModelGeneratorKt.getExportedIdentifier(irEnumEntry2);
        int ordinal = ((Number)MapsKt.getValue(enumEntries, (Object)irEnumEntry2)).intValue();
        ExportedProperty nameProperty = ExportModelGenerator.exportEnumEntry$fakeProperty("name", new ExportedType.LiteralType.StringLiteralType(name2));
        ExportedProperty ordinalProperty = ExportModelGenerator.exportEnumEntry$fakeProperty("ordinal", new ExportedType.LiteralType.NumberLiteralType(ordinal));
        Object[] objectArray = new ExportedProperty[]{nameProperty, ordinalProperty};
        ExportedType.InlineInterfaceType type2 = new ExportedType.InlineInterfaceType(CollectionsKt.listOf((Object[])objectArray));
        String string2 = name2;
        ExportedType exportedType = new ExportedType.IntersectionType(ExportModelGenerator.exportType$default(this, IrUtilsKt.getDefaultType(parentClass), false, 2, null), type2);
        boolean bl = Intrinsics.areEqual((Object)parentClass.getVisibility(), (Object)DescriptorVisibilities.PROTECTED);
        IrSimpleFunction irSimpleFunction = this.context.getMapping().getEnumEntryToGetInstanceFun().get((IrEnumEntry)((IrDeclaration)irEnumEntry2));
        if (irSimpleFunction == null) {
            void $this$exportEnumEntry_u24lambda_u2411;
            IrExceptionBuilder irExceptionBuilder;
            String message$iv = "Unable to find get instance fun";
            boolean $i$f$irError = false;
            IrExceptionBuilder $this$irError_u24lambda_u240$iv = irExceptionBuilder = new IrExceptionBuilder(message$iv);
            boolean bl3 = false;
            IrExceptionBuilder irExceptionBuilder2 = $this$irError_u24lambda_u240$iv;
            boolean bl4 = false;
            boolean bl5 = bl;
            boolean bl6 = false;
            boolean bl7 = true;
            boolean bl8 = true;
            boolean bl9 = false;
            ExportedType exportedType2 = exportedType;
            String string3 = string2;
            boolean bl10 = false;
            $this$exportEnumEntry_u24lambda_u2411.withIrEntry("field", field);
            Unit unit = Unit.INSTANCE;
            String string4 = string3;
            ExportedType exportedType3 = exportedType2;
            boolean bl11 = bl9;
            boolean bl12 = bl8;
            boolean bl13 = bl7;
            boolean bl14 = bl6;
            boolean bl15 = bl5;
            boolean bl16 = bl4;
            IrExceptionBuilder builder$iv = irExceptionBuilder;
            throw new IllegalStateException(builder$iv.buildString().toString());
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 1696;
        boolean bl17 = false;
        IrFunction irFunction = null;
        IrFunction irFunction2 = irSimpleFunction;
        boolean bl18 = false;
        boolean bl19 = bl;
        boolean bl20 = false;
        boolean bl21 = true;
        boolean bl22 = true;
        boolean bl23 = false;
        ExportedType exportedType4 = exportedType;
        String string5 = string2;
        return new ExportedProperty(string5, exportedType4, bl23, bl22, bl21, bl20, bl19, bl18, irFunction2, irFunction, bl17, n, defaultConstructorMarker);
    }

    private final Exportability classExportability(IrClass klass) {
        switch (WhenMappings.$EnumSwitchMapping$0[klass.getKind().ordinal()]) {
            case 1: {
                return new Exportability.Prohibited("Class " + IrUtilsKt.getFqNameWhenAvailable(klass) + " with kind: " + (Object)((Object)klass.getKind()));
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        if (AnnotationUtilsKt.isJsImplicitExport(klass)) {
            return Exportability.Implicit.INSTANCE;
        }
        if (IrDeclarationsKt.isSingleFieldValueClass(klass)) {
            return new Exportability.Prohibited("Inline class " + IrUtilsKt.getFqNameWhenAvailable(klass));
        }
        return Exportability.Allowed.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private final ExportedDeclaration exportDeclarationImplicitly(IrClass klass, Iterable<? extends IrType> superTypes) {
        void $this$memoryOptimizedFilter$iv;
        Iterable $this$mapTo$iv$iv;
        Collection $this$map$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Collection $this$memoryOptimizedMap$iv = klass.getTypeParameters();
        boolean $i$f$memoryOptimizedMap22 = false;
        Iterable iterable = $this$memoryOptimizedMap$iv;
        Collection destination$iv$iv = new ArrayList($this$memoryOptimizedMap$iv.size());
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void p0;
            IrTypeParameter irTypeParameter = (IrTypeParameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.exportTypeParameter((IrTypeParameter)p0));
        }
        List<ExportedType.TypeParameter> typeParameters2 = org.jetbrains.kotlin.utils.CollectionsKt.compactIfPossible((List)destination$iv$iv);
        Iterable<? extends IrType> $i$f$memoryOptimizedMap22 = superTypes;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IrType it = (IrType)element$iv$iv;
            boolean bl = false;
            IrSymbolOwner irSymbolOwner = IrTypesKt.getClassifierOrFail(it).getOwner();
            IrDeclaration irDeclaration2 = irSymbolOwner instanceof IrDeclaration ? (IrDeclaration)irSymbolOwner : null;
            if (!(irDeclaration2 != null ? ExportModelGeneratorKt.isExportedImplicitlyOrExplicitly(irDeclaration2, this.context) : false)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IrType it = (IrType)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(ExportModelGenerator.exportType$default(this, it, false, 2, null));
        }
        $this$map$iv = (List)destination$iv$iv2;
        boolean $i$f$memoryOptimizedFilter = false;
        $this$mapTo$iv$iv = (Iterable)$this$memoryOptimizedFilter$iv;
        destination$iv$iv2 = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ExportedType it = (ExportedType)element$iv$iv;
            boolean bl = false;
            if (!(!(it instanceof ExportedType.ErrorType))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List superInterfaces = org.jetbrains.kotlin.utils.CollectionsKt.compactIfPossible((List)destination$iv$iv2);
        String name2 = ExportModelGeneratorKt.getExportedIdentifier(klass);
        ExportedClassDeclarationsInfo exportedClassDeclarationsInfo = ExportModelGenerator.exportClassDeclarations$default(this, klass, superTypes, null, 4, null);
        List<ExportedDeclaration> members = exportedClassDeclarationsInfo.component1();
        List<ExportedClass> nestedClasses = exportedClassDeclarationsInfo.component2();
        return new ExportedRegularClass(name2, true, false, CollectionsKt.emptyList(), superInterfaces, typeParameters2, members, nestedClasses, klass);
    }

    private final ExportedDeclaration exportOrdinaryClass(IrClass klass, Iterable<? extends IrType> superTypes) {
        Exportability exportability = this.classExportability(klass);
        if (exportability instanceof Exportability.Prohibited) {
            IrExceptionBuilder irExceptionBuilder;
            String message$iv = ((Exportability.Prohibited)exportability).getReason();
            boolean $i$f$irError = false;
            IrExceptionBuilder $this$irError_u24lambda_u240$iv = irExceptionBuilder = new IrExceptionBuilder(message$iv);
            boolean bl = false;
            IrExceptionBuilder $this$exportOrdinaryClass_u24lambda_u2416 = $this$irError_u24lambda_u240$iv;
            boolean bl2 = false;
            $this$exportOrdinaryClass_u24lambda_u2416.withIrEntry("klass", klass);
            IrExceptionBuilder builder$iv = irExceptionBuilder;
            throw new IllegalStateException(builder$iv.buildString().toString());
        }
        if (Intrinsics.areEqual((Object)exportability, (Object)Exportability.NotNeeded.INSTANCE)) {
            return null;
        }
        if (Intrinsics.areEqual((Object)exportability, (Object)Exportability.Implicit.INSTANCE)) {
            return this.exportDeclarationImplicitly(klass, superTypes);
        }
        if (!Intrinsics.areEqual((Object)exportability, (Object)Exportability.Allowed.INSTANCE)) {
            throw new NoWhenBranchMatchedException();
        }
        ExportedClassDeclarationsInfo exportedClassDeclarationsInfo = ExportModelGenerator.exportClassDeclarations$default(this, klass, superTypes, null, 4, null);
        List<ExportedDeclaration> members = exportedClassDeclarationsInfo.component1();
        List<ExportedClass> nestedClasses = exportedClassDeclarationsInfo.component2();
        return this.exportClass(klass, superTypes, members, nestedClasses);
    }

    /*
     * WARNING - void declaration
     */
    private final ExportedDeclaration exportEnumClass(IrClass klass, Iterable<? extends IrType> superTypes) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        Exportability exportability = this.classExportability(klass);
        if (exportability instanceof Exportability.Prohibited) {
            IrExceptionBuilder irExceptionBuilder;
            String message$iv = ((Exportability.Prohibited)exportability).getReason();
            boolean $i$f$irError = false;
            IrExceptionBuilder $this$irError_u24lambda_u240$iv = irExceptionBuilder = new IrExceptionBuilder(message$iv);
            boolean bl = false;
            IrExceptionBuilder $this$exportEnumClass_u24lambda_u2417 = $this$irError_u24lambda_u240$iv;
            boolean bl2 = false;
            $this$exportEnumClass_u24lambda_u2417.withIrEntry("klass", klass);
            IrExceptionBuilder builder$iv = irExceptionBuilder;
            throw new IllegalStateException(builder$iv.buildString().toString());
        }
        if (Intrinsics.areEqual((Object)exportability, (Object)Exportability.NotNeeded.INSTANCE)) {
            return null;
        }
        if (Intrinsics.areEqual((Object)exportability, (Object)Exportability.Implicit.INSTANCE)) {
            return this.exportDeclarationImplicitly(klass, superTypes);
        }
        if (!Intrinsics.areEqual((Object)exportability, (Object)Exportability.Allowed.INSTANCE)) {
            throw new NoWhenBranchMatchedException();
        }
        Iterable message$iv = klass.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        void var6_10 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrField)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterIsInstanceTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            IrEnumEntry it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            IrField it = (IrField)element$iv$iv;
            boolean bl3 = false;
            if (this.context.getMapping().getFieldToEnumEntry().get((IrField)((IrDeclaration)it)) == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List enumEntries = (List)destination$iv$iv;
        Map enumEntriesToOrdinal2 = org.jetbrains.kotlin.utils.CollectionsKt.keysToMap(enumEntries, (Function1)new Function1<IrEnumEntry, Integer>((Object)enumEntries){

            public final Integer invoke(IrEnumEntry p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((List)this.receiver).indexOf(p0);
            }
        });
        ExportedClassDeclarationsInfo exportedClassDeclarationsInfo = this.exportClassDeclarations(klass, superTypes, (Function1<? super IrDeclarationWithName, ? extends ExportedDeclaration>)((Function1)arg_0 -> ExportModelGenerator.exportEnumClass$lambda$19(this, enumEntriesToOrdinal2, arg_0)));
        List<ExportedDeclaration> members = exportedClassDeclarationsInfo.component1();
        List<ExportedClass> nestedClasses = exportedClassDeclarationsInfo.component2();
        ExportedConstructor privateConstructor = new ExportedConstructor(CollectionsKt.emptyList(), ExportedVisibility.PRIVATE);
        return this.exportClass(klass, superTypes, MemoryOptimizedCollectionUtilKt.memoryOptimizedPlus(CollectionsKt.listOf((Object)privateConstructor), members), nestedClasses);
    }

    /*
     * Unable to fully structure code
     */
    private final ExportedClassDeclarationsInfo exportClassDeclarations(IrClass klass, Iterable<? extends IrType> superTypes, Function1<? super IrDeclarationWithName, ? extends ExportedDeclaration> specialProcessing) {
        members = new ArrayList<E>();
        specialMembers = new ArrayList<E>();
        nestedClasses = new ArrayList<E>();
        isImplicitlyExportedClass = AnnotationUtilsKt.isJsImplicitExport(klass);
        for (IrDeclaration declaration : klass.getDeclarations()) {
            block12: {
                block13: {
                    if (ExportModelGeneratorKt.access$getExportCandidate(declaration) == null || isImplicitlyExportedClass && !(candidate instanceof IrClass) || !ExportModelGeneratorKt.access$shouldDeclarationBeExportedImplicitlyOrExplicitly(candidate, this.context) || IrFakeOverrideUtilsKt.isFakeOverride(candidate) && IrUtilsKt.isInterface(klass)) continue;
                    processingResult = (ExportedDeclaration)specialProcessing.invoke((Object)candidate);
                    if (processingResult != null) {
                        specialMembers.add(processingResult);
                        continue;
                    }
                    var12_12 = candidate;
                    if (var12_12 instanceof IrSimpleFunction) {
                        v0 = this.exportFunction((IrSimpleFunction)candidate);
                        org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull(members, v0 != null ? ExportModelGeneratorKt.withAttributesFor(v0, candidate) : null);
                        continue;
                    }
                    if (var12_12 instanceof IrConstructor) {
                        v1 = this.exportConstructor((IrConstructor)candidate);
                        org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull(members, v1 != null ? ExportModelGeneratorKt.withAttributesFor(v1, candidate) : null);
                        continue;
                    }
                    if (var12_12 instanceof IrProperty) {
                        v2 = this.exportProperty((IrProperty)candidate);
                        org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull(members, v2 != null ? ExportModelGeneratorKt.withAttributesFor(v2, candidate) : null);
                        continue;
                    }
                    if (!(var12_12 instanceof IrClass)) break block12;
                    if (!IrUtilsKt.isInterface(klass)) break block13;
                    v3 = nestedClasses;
                    v4 = AdditionalIrUtilsKt.companionObject(klass);
                    if (v4 == null) ** GOTO lbl-1000
                    var16_15 = v4;
                    var21_18 = v3;
                    $i$a$-let-ExportModelGenerator$exportClassDeclarations$2 = false;
                    var18_17 = this.exportClass((IrClass)it);
                    v5 = var18_17 instanceof ExportedClass != false ? (ExportedClass)var18_17 : null;
                    v3 = var21_18;
                    v4 = v5;
                    if (v5 != null) {
                        v6 = (ExportedClass)ExportModelGeneratorKt.withAttributesFor((ExportedDeclaration)v4, candidate);
                    } else lbl-1000:
                    // 2 sources

                    {
                        v6 = null;
                    }
                    org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull(v3, v6);
                    continue;
                }
                v7 = this.exportClass((IrClass)candidate);
                v8 = ec = v7 != null ? ExportModelGeneratorKt.withAttributesFor(v7, candidate) : null;
                if (ec instanceof ExportedClass) {
                    nestedClasses.add(ec);
                    continue;
                }
                org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull(members, ec);
                continue;
            }
            if (var12_12 instanceof IrField) {
                v9 = ec = Intrinsics.areEqual((Object)candidate.getOrigin(), (Object)IrDeclarationOrigin.Companion.getFIELD_FOR_OBJECT_INSTANCE()) != false || Intrinsics.areEqual((Object)candidate.getOrigin(), (Object)IrDeclarationOrigin.Companion.getFIELD_FOR_OUTER_THIS()) != false || ((IrField)candidate).getCorrespondingPropertySymbol() != null;
                if (!_Assertions.ENABLED || ec) continue;
                $i$a$-assert-ExportModelGenerator$exportClassDeclarations$3 = false;
                $i$a$-assert-ExportModelGenerator$exportClassDeclarations$3 = "Unexpected field without property " + IrUtilsKt.getFqNameWhenAvailable(candidate);
                throw new AssertionError((Object)$i$a$-assert-ExportModelGenerator$exportClassDeclarations$3);
            }
            message$iv = "Can't export member declaration";
            $i$f$irError = false;
            $this$irError_u24lambda_u240$iv = var15_22 = new IrExceptionBuilder(message$iv);
            $i$a$-apply-IrExceptionUtilsKt$irError$builder$1$iv = false;
            $this$exportClassDeclarations_u24lambda_u2422 = $this$irError_u24lambda_u240$iv;
            $i$a$-irError-ExportModelGenerator$exportClassDeclarations$4 = false;
            $this$exportClassDeclarations_u24lambda_u2422.withIrEntry("declaration", declaration);
            builder$iv = var15_22;
            throw new IllegalStateException(builder$iv.buildString().toString());
        }
        if (this.shouldContainImplementationOfMagicProperty(klass, superTypes)) {
            this.addMagicPropertyForInterfaceImplementation(members, klass, superTypes);
        } else if (this.shouldNotBeImplemented(klass)) {
            this.addMagicInterfaceProperty(members, klass);
        }
        return new ExportedClassDeclarationsInfo(CollectionsKt.plus((Collection)specialMembers, (Iterable)members), nestedClasses);
    }

    static /* synthetic */ ExportedClassDeclarationsInfo exportClassDeclarations$default(ExportModelGenerator exportModelGenerator, IrClass irClass, Iterable iterable, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = exportClassDeclarations.1.INSTANCE;
        }
        return exportModelGenerator.exportClassDeclarations(irClass, iterable, (Function1<? super IrDeclarationWithName, ? extends ExportedDeclaration>)function1);
    }

    private final boolean shouldNotBeImplemented(IrClass $this$shouldNotBeImplemented) {
        return IrUtilsKt.isInterface($this$shouldNotBeImplemented) && !$this$shouldNotBeImplemented.isExternal() || AnnotationUtilsKt.isJsImplicitExport($this$shouldNotBeImplemented);
    }

    private final boolean shouldBeExported(IrValueParameter $this$shouldBeExported) {
        return !Intrinsics.areEqual((Object)$this$shouldBeExported.getOrigin(), (Object)JsLoweredDeclarationOrigin.INSTANCE.getJS_SUPER_CONTEXT_PARAMETER()) && !Intrinsics.areEqual((Object)$this$shouldBeExported.getOrigin(), (Object)ES6AddBoxParameterLoweringKt.getES6_BOX_PARAMETER());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldContainImplementationOfMagicProperty(IrClass $this$shouldContainImplementationOfMagicProperty, Iterable<? extends IrType> superTypes) {
        boolean bl;
        if ($this$shouldContainImplementationOfMagicProperty.isExternal()) return false;
        Iterable<? extends IrType> $this$any$iv = superTypes;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator<? extends IrType> iterator2 = $this$any$iv.iterator();
        do {
            IrType element$iv;
            if (!iterator2.hasNext()) return false;
            IrType it = element$iv = iterator2.next();
            boolean bl2 = false;
            Object object = IrTypesKt.getClassOrNull(it);
            if (object == null || (object = (IrClass)object.getOwner()) == null) {
                bl = false;
                continue;
            }
            Object superClass = object;
            if (IrUtilsKt.isInterface((IrClass)superClass)) {
                if (this.shouldAddMagicPropertyOfSuper(it)) return true;
            }
            if (AnnotationUtilsKt.isJsImplicitExport((IrAnnotationContainer)superClass)) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private final void addMagicInterfaceProperty(List<ExportedDeclaration> $this$addMagicInterfaceProperty, IrClass klass) {
        $this$addMagicInterfaceProperty.add(new ExportedProperty("__doNotUseOrImplementIt", this.generateTagType(klass), false, true, false, false, false, true, null, null, false, 1904, null));
    }

    /*
     * WARNING - void declaration
     */
    private final void addMagicPropertyForInterfaceImplementation(List<ExportedDeclaration> $this$addMagicPropertyForInterfaceImplementation, IrClass klass, Iterable<? extends IrType> superTypes) {
        void $this$reduce$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        void $this$filterTo$iv$iv;
        Iterable<? extends IrType> $this$filter$iv = superTypes;
        boolean $i$f$filter22 = false;
        Iterable<? extends IrType> iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IrType it = (IrType)element$iv$iv;
            boolean bl = false;
            if (!this.shouldAddMagicPropertyOfSuper(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List allSuperTypesWithMagicProperty = (List)destination$iv$iv;
        if (allSuperTypesWithMagicProperty.isEmpty()) {
            return;
        }
        Iterable $i$f$filter22 = allSuperTypesWithMagicProperty;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrType bl = (IrType)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(new ExportedType.PropertyType(ExportModelGenerator.exportType$default(this, (IrType)it, false, 2, null), new ExportedType.LiteralType.StringLiteralType("__doNotUseOrImplementIt")));
        }
        $this$map$iv = (List)destination$iv$iv2;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void p1;
            ExportedType $i$f$mapTo2 = (ExportedType)iterator$iv.next();
            ExportedType p0 = (ExportedType)accumulator$iv;
            boolean bl = false;
            accumulator$iv = new ExportedType.IntersectionType(p0, (ExportedType)p1);
        }
        ExportedType it = (ExportedType)accumulator$iv;
        boolean bl = false;
        ExportedType intersectionOfTypes = this.shouldNotBeImplemented(klass) ? (ExportedType)new ExportedType.IntersectionType(this.generateTagType(klass), it) : it;
        $this$addMagicPropertyForInterfaceImplementation.add(new ExportedProperty("__doNotUseOrImplementIt", intersectionOfTypes, false, true, false, false, false, true, null, null, false, 1904, null));
    }

    private final boolean shouldAddMagicPropertyOfSuper(IrType $this$shouldAddMagicPropertyOfSuper) {
        Object object = IrTypesKt.getClassOrNull($this$shouldAddMagicPropertyOfSuper);
        return object != null && (object = (IrClass)object.getOwner()) != null ? this.isOwnMagicPropertyAdded((IrClass)object) : false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isOwnMagicPropertyAdded(IrClass $this$isOwnMagicPropertyAdded) {
        boolean bl;
        if (AnnotationUtilsKt.isJsImplicitExport($this$isOwnMagicPropertyAdded)) {
            return true;
        }
        if (!ExportModelGeneratorKt.isExported($this$isOwnMagicPropertyAdded, this.context)) {
            return false;
        }
        if (IrUtilsKt.isInterface($this$isOwnMagicPropertyAdded)) {
            if (!$this$isOwnMagicPropertyAdded.isExternal()) return true;
        }
        Iterable $this$any$iv = $this$isOwnMagicPropertyAdded.getSuperTypes();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            IrType it = (IrType)element$iv;
            boolean bl2 = false;
            Object object = IrTypesKt.getClassOrNull(it);
            if (object != null && (object = (IrClass)object.getOwner()) != null) {
                if (this.isOwnMagicPropertyAdded((IrClass)object)) {
                    return true;
                }
                bl = false;
                continue;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private final ExportedType generateTagType(IrClass $this$generateTagType) {
        return new ExportedType.InlineInterfaceType(CollectionsKt.listOf((Object)new ExportedProperty(IrJsUtilsKt.getFqNameWithJsNameWhenAvailable($this$generateTagType, true).asString(), ExportedType.Primitive.UniqueSymbol.INSTANCE, false, true, false, false, false, true, null, null, false, 1904, null)));
    }

    /*
     * WARNING - void declaration
     */
    private final ExportedDeclaration exportClass(IrClass klass, Iterable<? extends IrType> superTypes, List<? extends ExportedDeclaration> members, List<? extends ExportedClass> nestedClasses) {
        void $this$memoryOptimizedFilter$iv;
        Iterable $this$mapTo$iv$iv;
        Collection $this$map$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$memoryOptimizedFilter$iv2;
        Iterable $this$mapTo$iv$iv2;
        Collection $this$map$iv2;
        void $this$filterTo$iv$iv2;
        Iterable $this$filter$iv2;
        Collection collection;
        void $this$mapTo$iv$iv3;
        Collection $this$memoryOptimizedMap$iv = klass.getTypeParameters();
        boolean $i$f$memoryOptimizedMap22 = false;
        Iterable iterable = $this$memoryOptimizedMap$iv;
        Collection destination$iv$iv = new ArrayList($this$memoryOptimizedMap$iv.size());
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void p0;
            Iterator iterator2 = (IrTypeParameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.exportTypeParameter((IrTypeParameter)p0));
        }
        List<ExportedType.TypeParameter> typeParameters2 = org.jetbrains.kotlin.utils.CollectionsKt.compactIfPossible((List)destination$iv$iv);
        Iterable<? extends IrType> $i$f$memoryOptimizedMap22 = superTypes;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            IrType it = (IrType)element$iv$iv;
            boolean bl = false;
            if (!(!ExportModelGeneratorKt.access$isInterface(IrTypesKt.getClassifierOrFail(it)) && this.canBeUsedAsSuperTypeOfExportedClasses(it))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv2 = (List)destination$iv$iv2;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv2 = $this$map$iv2;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            IrType it = (IrType)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(this.exportType(it, false));
        }
        $this$map$iv2 = (List)destination$iv$iv2;
        boolean $i$f$memoryOptimizedFilter22 = false;
        $this$mapTo$iv$iv2 = (Iterable)$this$memoryOptimizedFilter$iv2;
        destination$iv$iv2 = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            ExportedType it = (ExportedType)element$iv$iv;
            boolean bl = false;
            if (!(!(it instanceof ExportedType.ErrorType))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List superClasses = org.jetbrains.kotlin.utils.CollectionsKt.compactIfPossible((List)destination$iv$iv2);
        Iterable<? extends IrType> $i$f$memoryOptimizedFilter22 = superTypes;
        boolean $i$f$filter2 = false;
        destination$iv$iv2 = $this$filter$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IrType it = (IrType)element$iv$iv;
            boolean bl = false;
            if (!this.shouldPresentInsideImplementsClause(it)) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv3;
        boolean $i$f$map2 = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IrType it = (IrType)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl = false;
            collection.add(this.exportType(it, false));
        }
        $this$map$iv = (List)destination$iv$iv3;
        boolean $i$f$memoryOptimizedFilter = false;
        $this$mapTo$iv$iv = (Iterable)$this$memoryOptimizedFilter$iv;
        destination$iv$iv3 = new ArrayList();
        $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ExportedType it = (ExportedType)element$iv$iv;
            boolean bl = false;
            if (!(!(it instanceof ExportedType.ErrorType))) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        List superInterfaces = org.jetbrains.kotlin.utils.CollectionsKt.compactIfPossible((List)destination$iv$iv3);
        String name2 = ExportModelGeneratorKt.getExportedIdentifierForClass(klass);
        if (klass.getKind() == ClassKind.OBJECT) {
            IrSimpleFunction irSimpleFunction = this.context.getMapping().getObjectToGetInstanceFunction().get((IrClass)((IrDeclaration)klass));
            Intrinsics.checkNotNull((Object)irSimpleFunction);
            IrSimpleFunction irSimpleFunction2 = irSimpleFunction;
            return new ExportedObject(name2, superClasses, superInterfaces, members, nestedClasses, klass, irSimpleFunction2);
        }
        return new ExportedRegularClass(name2, IrUtilsKt.isInterface(klass), klass.getModality() == Modality.ABSTRACT || klass.getModality() == Modality.SEALED || IrUtilsKt.isEnumClass(klass), superClasses, superInterfaces, typeParameters2, members, nestedClasses, klass);
    }

    private final Set<IrType> collectSuperTransitiveHierarchy(IrSimpleType $this$collectSuperTransitiveHierarchy) {
        return this.transitiveExportCollector.collectSuperTypesTransitiveHierarchyFor($this$collectSuperTransitiveHierarchy);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldPresentInsideImplementsClause(IrType $this$shouldPresentInsideImplementsClause) {
        IrClassifierSymbol classifier = IrTypesKt.getClassifierOrFail($this$shouldPresentInsideImplementsClause);
        if (ExportModelGeneratorKt.access$isInterface(classifier)) return true;
        IrSymbolOwner irSymbolOwner = classifier.getOwner();
        if (!(irSymbolOwner instanceof IrDeclaration)) return false;
        IrDeclaration irDeclaration2 = (IrDeclaration)irSymbolOwner;
        if (irDeclaration2 == null) return false;
        if (!AnnotationUtilsKt.isJsImplicitExport(irDeclaration2)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final ExportedDeclaration exportAsEnumMember(IrDeclarationWithName candidate2, Map<IrEnumEntry, Integer> enumEntriesToOrdinal2) {
        ExportedDeclaration exportedDeclaration;
        Set<IrEnumEntry> enumEntries = enumEntriesToOrdinal2.keySet();
        IrDeclarationWithName irDeclarationWithName = candidate2;
        if (irDeclarationWithName instanceof IrProperty) {
            if (ExportModelGeneratorKt.isAllowedFakeOverriddenDeclaration((IrOverridableDeclaration)candidate2, this.context)) {
                ExportedType exportedType;
                Object acc;
                Object accumulator$iv;
                Iterator iterator$iv;
                Map<IrEnumEntry, Integer> $this$reduceOrNull$iv;
                boolean $i$f$reduceOrNull;
                Collection collection;
                Object object;
                Iterable $this$mapTo$iv$iv;
                Collection destination$iv$iv;
                Iterable $this$map$iv;
                boolean $i$f$map;
                String string2 = ExportModelGeneratorKt.getExportedIdentifier(candidate2);
                if (Intrinsics.areEqual((Object)string2, (Object)"name")) {
                    Object v0;
                    String it;
                    Iterable iterable = enumEntries;
                    $i$f$map = false;
                    void var9_8 = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        object = (IrEnumEntry)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(ExportModelGeneratorKt.getExportedIdentifier((IrDeclarationWithName)((Object)it)));
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    $i$f$map = false;
                    $this$mapTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        it = (String)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(new ExportedType.LiteralType.StringLiteralType(it));
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    $i$f$reduceOrNull = false;
                    iterator$iv = $this$reduceOrNull$iv.iterator();
                    if (!iterator$iv.hasNext()) {
                        v0 = null;
                    } else {
                        accumulator$iv = iterator$iv.next();
                        while (iterator$iv.hasNext()) {
                            void s;
                            ExportedType $i$f$mapTo2 = (ExportedType)iterator$iv.next();
                            acc = (ExportedType)accumulator$iv;
                            boolean bl = false;
                            accumulator$iv = new ExportedType.UnionType((ExportedType)acc, (ExportedType)s);
                        }
                        v0 = accumulator$iv;
                    }
                    if ((exportedType = (ExportedType)v0) == null) {
                        return null;
                    }
                } else if (Intrinsics.areEqual((Object)string2, (Object)"ordinal")) {
                    Object v2;
                    $this$reduceOrNull$iv = enumEntriesToOrdinal2;
                    $i$f$map = false;
                    iterator$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList($this$map$iv.size());
                    boolean $i$f$mapTo3 = false;
                    for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
                        object = item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        int ordinal = ((Number)object.getValue()).intValue();
                        collection.add(new ExportedType.LiteralType.NumberLiteralType(ordinal));
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    $i$f$reduceOrNull = false;
                    iterator$iv = $this$reduceOrNull$iv.iterator();
                    if (!iterator$iv.hasNext()) {
                        v2 = null;
                    } else {
                        accumulator$iv = iterator$iv.next();
                        while (iterator$iv.hasNext()) {
                            void s;
                            ExportedType $i$f$mapTo3 = (ExportedType)iterator$iv.next();
                            acc = (ExportedType)accumulator$iv;
                            boolean bl = false;
                            accumulator$iv = new ExportedType.UnionType((ExportedType)acc, (ExportedType)s);
                        }
                        v2 = accumulator$iv;
                    }
                    if ((exportedType = (ExportedType)v2) == null) {
                        return null;
                    }
                } else {
                    return null;
                }
                ExportedType type2 = exportedType;
                exportedDeclaration = this.exportPropertyUnsafely((IrProperty)candidate2, type2);
            } else {
                exportedDeclaration = null;
            }
        } else {
            exportedDeclaration = irDeclarationWithName instanceof IrField ? (ExportedDeclaration)(Intrinsics.areEqual((Object)candidate2.getOrigin(), (Object)IrDeclarationOrigin.Companion.getFIELD_FOR_ENUM_ENTRY()) ? this.exportEnumEntry((IrField)candidate2, enumEntriesToOrdinal2) : null) : null;
        }
        return exportedDeclaration;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean canBeUsedAsSuperTypeOfExportedClasses(IrType $this$canBeUsedAsSuperTypeOfExportedClasses) {
        if (IrTypePredicatesKt.isAny($this$canBeUsedAsSuperTypeOfExportedClasses)) return false;
        if (Intrinsics.areEqual((Object)IrTypesKt.getClassifierOrNull($this$canBeUsedAsSuperTypeOfExportedClasses), (Object)this.context.getIrBuiltIns().getEnumClass())) return false;
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull($this$canBeUsedAsSuperTypeOfExportedClasses);
        IrSymbolOwner irSymbolOwner = irClassifierSymbol != null ? irClassifierSymbol.getOwner() : null;
        if (!(irSymbolOwner instanceof IrDeclaration)) return true;
        IrDeclaration irDeclaration2 = (IrDeclaration)irSymbolOwner;
        if (irDeclaration2 == null) return true;
        if (!AnnotationUtilsKt.isJsImplicitExport(irDeclaration2)) return true;
        return false;
    }

    private final ExportedType exportTypeArgument(IrTypeArgument type2) {
        if (type2 instanceof IrTypeProjection) {
            return ExportModelGenerator.exportType$default(this, ((IrTypeProjection)type2).getType(), false, 2, null);
        }
        if (type2 instanceof IrType) {
            return ExportModelGenerator.exportType$default(this, (IrType)type2, false, 2, null);
        }
        return new ExportedType.ErrorType("UnknownType " + RenderIrElementKt.render$default(type2, null, 1, null));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ExportedType.TypeParameter exportTypeParameter(@NotNull IrTypeParameter typeParameter) {
        ExportedType exportedType;
        void $this$exportTypeParameter_u24lambda_u2445;
        Intrinsics.checkNotNullParameter((Object)typeParameter, (String)"typeParameter");
        List constraint = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)typeParameter.getSuperTypes()), arg_0 -> ExportModelGenerator.exportTypeParameter$lambda$41(this, arg_0)), arg_0 -> ExportModelGenerator.exportTypeParameter$lambda$42(this, arg_0)), ExportModelGenerator::exportTypeParameter$lambda$43));
        String string2 = typeParameter.getName().getIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getIdentifier(...)");
        List list = constraint;
        String string3 = string2;
        boolean bl = false;
        switch ($this$exportTypeParameter_u24lambda_u2445.size()) {
            case 0: {
                exportedType = null;
                break;
            }
            case 1: {
                exportedType = (ExportedType)CollectionsKt.single((List)$this$exportTypeParameter_u24lambda_u2445);
                break;
            }
            default: {
                Iterable $this$reduce$iv = (Iterable)$this$exportTypeParameter_u24lambda_u2445;
                boolean $i$f$reduce = false;
                Iterator iterator$iv = $this$reduce$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    throw new UnsupportedOperationException("Empty collection can't be reduced.");
                }
                Object accumulator$iv = iterator$iv.next();
                while (iterator$iv.hasNext()) {
                    void p1;
                    ExportedType exportedType2 = (ExportedType)iterator$iv.next();
                    ExportedType p0 = (ExportedType)accumulator$iv;
                    boolean bl2 = false;
                    accumulator$iv = new ExportedType.IntersectionType(p0, (ExportedType)p1);
                }
                exportedType = (ExportedType)accumulator$iv;
            }
        }
        ExportedType exportedType3 = exportedType;
        String string4 = string3;
        return new ExportedType.TypeParameter(string4, exportedType3);
    }

    /*
     * WARNING - void declaration
     */
    private final ExportedType exportType(IrType type2, boolean shouldCalculateExportedSupertypeForImplicit) {
        ExportedType exportedType;
        Object object;
        ExportedType exportedType2;
        if (type2 instanceof IrDynamicType || this.currentlyProcessedTypes.contains(type2)) {
            return ExportedType.Primitive.Any.INSTANCE;
        }
        if (!(type2 instanceof IrSimpleType)) {
            return new ExportedType.ErrorType("NonSimpleType " + RenderIrElementKt.render$default(type2, null, 1, null));
        }
        this.currentlyProcessedTypes.add(type2);
        IrClassifierSymbol classifier = ((IrSimpleType)type2).getClassifier();
        boolean isMarkedNullable = IrTypePredicatesKt.isMarkedNullable((IrSimpleType)type2);
        IrType irType = IrTypesKt.makeNotNull(type2);
        Intrinsics.checkNotNull((Object)irType, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
        IrSimpleType nonNullType = (IrSimpleType)irType;
        if (IrTypePredicatesKt.isBoolean(nonNullType)) {
            exportedType2 = ExportedType.Primitive.Boolean.INSTANCE;
        } else if (IrTypePredicatesKt.isPrimitiveType$default(nonNullType, false, 1, null) && !IrTypePredicatesKt.isLong(nonNullType) && !IrTypePredicatesKt.isChar(nonNullType)) {
            exportedType2 = ExportedType.Primitive.Number.INSTANCE;
        } else if (IrTypePredicatesKt.isByteArray(nonNullType)) {
            exportedType2 = ExportedType.Primitive.ByteArray.INSTANCE;
        } else if (IrTypePredicatesKt.isShortArray(nonNullType)) {
            exportedType2 = ExportedType.Primitive.ShortArray.INSTANCE;
        } else if (IrTypePredicatesKt.isIntArray(nonNullType)) {
            exportedType2 = ExportedType.Primitive.IntArray.INSTANCE;
        } else if (IrTypePredicatesKt.isFloatArray(nonNullType)) {
            exportedType2 = ExportedType.Primitive.FloatArray.INSTANCE;
        } else if (IrTypePredicatesKt.isDoubleArray(nonNullType)) {
            exportedType2 = ExportedType.Primitive.DoubleArray.INSTANCE;
        } else if (IrTypePredicatesKt.isBooleanArray(nonNullType)) {
            exportedType2 = new ExportedType.ErrorType("BooleanArray");
        } else if (IrTypePredicatesKt.isLongArray(nonNullType)) {
            exportedType2 = new ExportedType.ErrorType("LongArray");
        } else if (IrTypePredicatesKt.isCharArray(nonNullType)) {
            exportedType2 = new ExportedType.ErrorType("CharArray");
        } else if (IrTypePredicatesKt.isString(nonNullType)) {
            exportedType2 = ExportedType.Primitive.String.INSTANCE;
        } else if (IrTypeUtilsKt.isThrowable(nonNullType)) {
            exportedType2 = ExportedType.Primitive.Throwable.INSTANCE;
        } else if (IrTypePredicatesKt.isAny(nonNullType)) {
            exportedType2 = ExportedType.Primitive.Any.INSTANCE;
        } else if (IrTypePredicatesKt.isUnit(nonNullType)) {
            exportedType2 = ExportedType.Primitive.Unit.INSTANCE;
        } else if (IrTypePredicatesKt.isNothing(nonNullType)) {
            exportedType2 = ExportedType.Primitive.Nothing.INSTANCE;
        } else if (IrTypePredicatesKt.isArray(nonNullType)) {
            exportedType2 = new ExportedType.Array(this.exportTypeArgument(nonNullType.getArguments().get(0)));
        } else if (IrTypeUtilsKt.isSuspendFunction(nonNullType)) {
            exportedType2 = new ExportedType.ErrorType("Suspend functions are not supported");
        } else if (IrTypeUtilsKt.isFunction(nonNullType)) {
            void $this$mapTo$iv$iv;
            Collection $this$memoryOptimizedMap$iv = CollectionsKt.dropLast(nonNullType.getArguments(), (int)1);
            boolean $i$f$memoryOptimizedMap = false;
            Iterable iterable = $this$memoryOptimizedMap$iv;
            Collection destination$iv$iv = new ArrayList($this$memoryOptimizedMap$iv.size());
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IrTypeArgument irTypeArgument = (IrTypeArgument)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                object.add(this.exportTypeArgument((IrTypeArgument)it));
            }
            ExportedType exportedType3 = this.exportTypeArgument((IrTypeArgument)CollectionsKt.last(nonNullType.getArguments()));
            List list = org.jetbrains.kotlin.utils.CollectionsKt.compactIfPossible((List)destination$iv$iv);
            exportedType2 = new ExportedType.Function(list, exportedType3);
        } else if (classifier instanceof IrTypeParameterSymbol) {
            String string2 = ((IrTypeParameter)((IrTypeParameterSymbol)classifier).getOwner()).getName().getIdentifier();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getIdentifier(...)");
            exportedType2 = new ExportedType.TypeParameter(string2, null, 2, null);
        } else if (classifier instanceof IrClassSymbol) {
            ExportedType exportedType4;
            ExportedType exportedType5;
            ExportedType exportedType6;
            Iterable<IrType> transitiveExportedType;
            IrClass klass = (IrClass)((IrClassSymbol)classifier).getOwner();
            boolean isExported = ExportModelGeneratorKt.isExportedImplicitlyOrExplicitly(klass, this.context);
            boolean isImplicitlyExported = !isExported && !klass.isExternal();
            boolean isNonExportedExternal = klass.isExternal() && !isExported;
            String name2 = IrJsUtilsKt.getFqNameWithJsNameWhenAvailable(klass, !isNonExportedExternal && this.generateNamespacesForPackages).asString();
            boolean condition$iv = shouldCalculateExportedSupertypeForImplicit && isImplicitlyExported;
            boolean $i$f$runIf2 = false;
            if (condition$iv) {
                boolean bl = false;
                transitiveExportedType = this.collectSuperTransitiveHierarchy(nonNullType);
                if (transitiveExportedType.isEmpty()) {
                    exportedType6 = null;
                } else {
                    void $this$reduce$iv;
                    void $this$mapTo$iv$iv;
                    Iterable $this$memoryOptimizedMap$iv = transitiveExportedType;
                    boolean $i$f$memoryOptimizedMap = false;
                    Iterable iterable = $this$memoryOptimizedMap$iv;
                    Collection destination$iv$iv = new ArrayList($this$memoryOptimizedMap$iv.size());
                    boolean $i$f$mapTo2 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void p0;
                        IrType irType2 = (IrType)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl2 = false;
                        collection.add(ExportModelGenerator.exportType$default(this, (IrType)p0, false, 2, null));
                    }
                    $this$memoryOptimizedMap$iv = org.jetbrains.kotlin.utils.CollectionsKt.compactIfPossible((List)destination$iv$iv);
                    boolean $i$f$reduce = false;
                    Iterator iterator$iv = $this$reduce$iv.iterator();
                    if (!iterator$iv.hasNext()) {
                        throw new UnsupportedOperationException("Empty collection can't be reduced.");
                    }
                    Object accumulator$iv = iterator$iv.next();
                    while (iterator$iv.hasNext()) {
                        void p1;
                        ExportedType $i$f$mapTo2 = (ExportedType)iterator$iv.next();
                        ExportedType p0 = (ExportedType)accumulator$iv;
                        boolean bl3 = false;
                        accumulator$iv = new ExportedType.IntersectionType(p0, (ExportedType)p1);
                    }
                    exportedType6 = (ExportedType)accumulator$iv;
                }
            } else {
                exportedType6 = exportedType5 = null;
            }
            if (exportedType6 == null) {
                exportedType5 = ExportedType.Primitive.Any.INSTANCE;
            }
            ExportedType exportedSupertype = exportedType5;
            switch (WhenMappings.$EnumSwitchMapping$0[klass.getKind().ordinal()]) {
                case 1: 
                case 6: {
                    exportedType4 = new ExportedType.ErrorType("Class " + name2 + " with kind: " + (Object)((Object)klass.getKind()));
                    break;
                }
                case 2: {
                    exportedType4 = new ExportedType.TypeOf(name2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    void $this$mapTo$iv$iv;
                    void $this$memoryOptimizedMap$iv;
                    Collection $i$f$runIf2 = ((IrSimpleType)type2).getArguments();
                    object = name2;
                    boolean $i$f$memoryOptimizedMap = false;
                    transitiveExportedType = (Iterable)$this$memoryOptimizedMap$iv;
                    Collection destination$iv$iv = new ArrayList($this$memoryOptimizedMap$iv.size());
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        IrTypeArgument p1 = (IrTypeArgument)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(this.exportTypeArgument((IrTypeArgument)it));
                    }
                    IrClass irClass = klass;
                    List list = org.jetbrains.kotlin.utils.CollectionsKt.compactIfPossible((List)destination$iv$iv);
                    Object object2 = object;
                    exportedType4 = new ExportedType.ClassType((String)object2, list, irClass);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            exportedType2 = exportedType4.withImplicitlyExported(isImplicitlyExported, exportedSupertype);
        } else {
            IrExceptionBuilder isImplicitlyExported;
            String message$iv = "Unexpected classifier";
            boolean $i$f$irError = false;
            IrExceptionBuilder $this$irError_u24lambda_u240$iv = isImplicitlyExported = new IrExceptionBuilder(message$iv);
            boolean bl = false;
            IrExceptionBuilder $this$exportType_u24lambda_u2450 = $this$irError_u24lambda_u240$iv;
            boolean bl4 = false;
            $this$exportType_u24lambda_u2450.withIrEntry("classifier.owner", classifier.getOwner());
            IrExceptionBuilder builder$iv = isImplicitlyExported;
            throw new IllegalStateException(builder$iv.buildString().toString());
        }
        ExportedType exportedType7 = exportedType2;
        ExportedType it = exportedType = exportedType7.withNullability(isMarkedNullable);
        boolean bl = false;
        this.currentlyProcessedTypes.remove(type2);
        return exportedType;
    }

    static /* synthetic */ ExportedType exportType$default(ExportModelGenerator exportModelGenerator, IrType irType, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return exportModelGenerator.exportType(irType, bl);
    }

    private final Exportability functionExportability(IrSimpleFunction function2) {
        IrClass parentClass;
        if (function2.isInline()) {
            boolean bl;
            block16: {
                Iterable $this$any$iv = function2.getTypeParameters();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        IrTypeParameter it = (IrTypeParameter)element$iv;
                        boolean bl2 = false;
                        if (!it.isReified()) continue;
                        bl = true;
                        break block16;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return new Exportability.Prohibited("Inline reified function");
            }
        }
        if (function2.isSuspend()) {
            return new Exportability.Prohibited("Suspend function");
        }
        if (function2.isFakeOverride() && !ExportModelGeneratorKt.isAllowedFakeOverriddenDeclaration(function2, this.context)) {
            return Exportability.NotNeeded.INSTANCE;
        }
        if (Intrinsics.areEqual((Object)function2.getOrigin(), (Object)JsLoweredDeclarationOrigin.INSTANCE.getBRIDGE_WITHOUT_STABLE_NAME()) || Intrinsics.areEqual((Object)function2.getOrigin(), (Object)JsLoweredDeclarationOrigin.INSTANCE.getBRIDGE_PROPERTY_ACCESSOR()) || Intrinsics.areEqual((Object)function2.getOrigin(), (Object)JsLoweredDeclarationOrigin.INSTANCE.getBRIDGE_WITH_STABLE_NAME()) || Intrinsics.areEqual((Object)function2.getOrigin(), (Object)JsLoweredDeclarationOrigin.INSTANCE.getOBJECT_GET_INSTANCE_FUNCTION()) || Intrinsics.areEqual((Object)function2.getOrigin(), (Object)JsLoweredDeclarationOrigin.INSTANCE.getJS_SHADOWED_EXPORT()) || Intrinsics.areEqual((Object)function2.getOrigin(), (Object)JsLoweredDeclarationOrigin.INSTANCE.getENUM_GET_INSTANCE_FUNCTION())) {
            return Exportability.NotNeeded.INSTANCE;
        }
        IrDeclarationParent $i$f$any = function2.getParent();
        IrClass irClass = parentClass = $i$f$any instanceof IrClass ? (IrClass)$i$f$any : null;
        if (parentClass != null && Intrinsics.areEqual((Object)this.context.getMapping().getEnumClassToInitEntryInstancesFun().get((IrClass)((IrDeclaration)parentClass)), (Object)function2)) {
            return Exportability.NotNeeded.INSTANCE;
        }
        String string2 = function2.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        String nameString = string2;
        if (StringsKt.endsWith$default((String)nameString, (String)"-impl", (boolean)false, (int)2, null)) {
            return Exportability.NotNeeded.INSTANCE;
        }
        if (StringsKt.endsWith$default((String)nameString, (String)"$", (boolean)false, (int)2, null)) {
            boolean bl;
            block17: {
                Iterable $this$any$iv = function2.getValueParameters();
                boolean $i$f$any2 = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        IrValueParameter it = (IrValueParameter)element$iv;
                        boolean bl3 = false;
                        String string3 = it.getName().asString();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"asString(...)");
                        if (!StringsKt.contains$default((CharSequence)string3, (CharSequence)"$mask", (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block17;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return Exportability.NotNeeded.INSTANCE;
            }
        }
        String name2 = ExportModelGeneratorKt.getExportedIdentifier(function2);
        if (parentClass == null && ExportModelGeneratorKt.access$getAllReservedWords$p().contains(name2)) {
            return new Exportability.Prohibited("Name is a reserved word");
        }
        return Exportability.Allowed.INSTANCE;
    }

    private static final ExportedProperty exportEnumEntry$fakeProperty(String name2, ExportedType type2) {
        return new ExportedProperty(name2, type2, false, true, false, false, false, false, null, null, false, 2032, null);
    }

    private static final ExportedDeclaration exportEnumClass$lambda$19(ExportModelGenerator this$0, Map $enumEntriesToOrdinal, IrDeclarationWithName candidate2) {
        Intrinsics.checkNotNullParameter((Object)candidate2, (String)"candidate");
        ExportedDeclaration enumExportedMember = this$0.exportAsEnumMember(candidate2, $enumEntriesToOrdinal);
        return enumExportedMember;
    }

    private static final boolean exportTypeParameter$lambda$41(ExportModelGenerator this$0, IrType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !Intrinsics.areEqual((Object)it, (Object)this$0.context.getIrBuiltIns().getAnyNType());
    }

    private static final ExportedType exportTypeParameter$lambda$42(ExportModelGenerator this$0, IrType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ExportedType exportedType = ExportModelGenerator.exportType$default(this$0, it, false, 2, null);
        return exportedType instanceof ExportedType.ImplicitlyExportedType && Intrinsics.areEqual((Object)((ExportedType.ImplicitlyExportedType)exportedType).getExportedSupertype(), (Object)ExportedType.Primitive.Any.INSTANCE) ? (ExportedType)ExportedType.ImplicitlyExportedType.copy$default((ExportedType.ImplicitlyExportedType)exportedType, null, ExportedType.Primitive.Unknown.INSTANCE, 1, null) : exportedType;
    }

    private static final boolean exportTypeParameter$lambda$43(ExportedType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !(it instanceof ExportedType.ErrorType);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ClassKind.values().length];
            try {
                nArray[ClassKind.ANNOTATION_CLASS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.OBJECT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.CLASS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.INTERFACE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.ENUM_CLASS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.ENUM_ENTRY.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

