/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.util.containers.Interner;
import org.jetbrains.kotlin.com.intellij.util.containers.MultiMap;
import org.jetbrains.kotlin.incremental.LookupSymbol;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.incremental.components.Position;
import org.jetbrains.kotlin.incremental.components.ScopeKind;
import org.jetbrains.kotlin.utils.PlatformUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J0\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\t2\u0006\u00100\u001a\u00020\u001c2\u0006\u00101\u001a\u00020\t2\u0006\u00102\u001a\u00020%2\u0006\u00103\u001a\u00020\tH\u0016J\b\u00104\u001a\u00020.H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0005\u001a#\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \b*\u0004\u0018\u00010\t0\t0\u0006\u00a2\u0006\u0002\b\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0018\"\u0004\b#\u0010\u001aR\u001c\u0010$\u001a\u0004\u0018\u00010%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001a\u0010*\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u0018\"\u0004\b,\u0010\u001a\u00a8\u00065"}, d2={"Lorg/jetbrains/kotlin/incremental/LookupTrackerImpl;", "Lorg/jetbrains/kotlin/incremental/components/LookupTracker;", "delegate", "<init>", "(Lorg/jetbrains/kotlin/incremental/components/LookupTracker;)V", "lookups", "Lorg/jetbrains/kotlin/com/intellij/util/containers/MultiMap;", "Lorg/jetbrains/kotlin/incremental/LookupSymbol;", "kotlin.jvm.PlatformType", "", "Lorg/jetbrains/annotations/NotNull;", "getLookups", "()Lcom/intellij/util/containers/MultiMap;", "pathInterner", "Lorg/jetbrains/kotlin/com/intellij/util/containers/Interner;", "getPathInterner", "()Lcom/intellij/util/containers/Interner;", "interner", "requiresPosition", "", "getRequiresPosition", "()Z", "prevFilePath", "getPrevFilePath", "()Ljava/lang/String;", "setPrevFilePath", "(Ljava/lang/String;)V", "prevPosition", "Lorg/jetbrains/kotlin/incremental/components/Position;", "getPrevPosition", "()Lorg/jetbrains/kotlin/incremental/components/Position;", "setPrevPosition", "(Lorg/jetbrains/kotlin/incremental/components/Position;)V", "prevScopeFqName", "getPrevScopeFqName", "setPrevScopeFqName", "prevScopeKind", "Lorg/jetbrains/kotlin/incremental/components/ScopeKind;", "getPrevScopeKind", "()Lorg/jetbrains/kotlin/incremental/components/ScopeKind;", "setPrevScopeKind", "(Lorg/jetbrains/kotlin/incremental/components/ScopeKind;)V", "prevName", "getPrevName", "setPrevName", "record", "", "filePath", "position", "scopeFqName", "scopeKind", "name", "clear", "kotlin-build-common"})
public final class LookupTrackerImpl
implements LookupTracker {
    @NotNull
    private final LookupTracker delegate;
    @NotNull
    private final MultiMap<LookupSymbol, String> lookups;
    @NotNull
    private final Interner<String> pathInterner;
    @NotNull
    private final Interner<String> interner;
    @NotNull
    private String prevFilePath;
    @Nullable
    private Position prevPosition;
    @NotNull
    private String prevScopeFqName;
    @Nullable
    private ScopeKind prevScopeKind;
    @NotNull
    private String prevName;

    public LookupTrackerImpl(@NotNull LookupTracker delegate) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        this.delegate = delegate;
        MultiMap multiMap = MultiMap.createSet();
        Intrinsics.checkNotNullExpressionValue(multiMap, (String)"createSet(...)");
        this.lookups = multiMap;
        this.pathInterner = PlatformUtilsKt.createStringInterner();
        this.interner = PlatformUtilsKt.createStringInterner();
        this.prevFilePath = "";
        this.prevScopeFqName = "";
        this.prevName = "";
    }

    @NotNull
    public final MultiMap<LookupSymbol, String> getLookups() {
        return this.lookups;
    }

    @NotNull
    public final Interner<String> getPathInterner() {
        return this.pathInterner;
    }

    @Override
    public boolean getRequiresPosition() {
        return this.delegate.getRequiresPosition();
    }

    @NotNull
    public final String getPrevFilePath() {
        return this.prevFilePath;
    }

    public final void setPrevFilePath(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
        this.prevFilePath = string2;
    }

    @Nullable
    public final Position getPrevPosition() {
        return this.prevPosition;
    }

    public final void setPrevPosition(@Nullable Position position) {
        this.prevPosition = position;
    }

    @NotNull
    public final String getPrevScopeFqName() {
        return this.prevScopeFqName;
    }

    public final void setPrevScopeFqName(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
        this.prevScopeFqName = string2;
    }

    @Nullable
    public final ScopeKind getPrevScopeKind() {
        return this.prevScopeKind;
    }

    public final void setPrevScopeKind(@Nullable ScopeKind scopeKind) {
        this.prevScopeKind = scopeKind;
    }

    @NotNull
    public final String getPrevName() {
        return this.prevName;
    }

    public final void setPrevName(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
        this.prevName = string2;
    }

    @Override
    public void record(@NotNull String filePath, @NotNull Position position, @NotNull String scopeFqName, @NotNull ScopeKind scopeKind, @NotNull String name2) {
        boolean lookupChanged;
        boolean bl;
        boolean fqNameChanged;
        boolean bl2;
        boolean nameChanged;
        boolean bl3;
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)scopeFqName, (String)"scopeFqName");
        Intrinsics.checkNotNullParameter((Object)((Object)scopeKind), (String)"scopeKind");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        if (!Intrinsics.areEqual((Object)name2, (Object)this.prevName)) {
            String string2 = this.interner.intern(name2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"intern(...)");
            this.prevName = string2;
            bl3 = true;
        } else {
            bl3 = nameChanged = false;
        }
        if (!Intrinsics.areEqual((Object)scopeFqName, (Object)this.prevScopeFqName)) {
            String string3 = this.interner.intern(scopeFqName);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"intern(...)");
            this.prevScopeFqName = string3;
            bl2 = true;
        } else {
            bl2 = fqNameChanged = false;
        }
        if (!Intrinsics.areEqual((Object)filePath, (Object)this.prevFilePath)) {
            String string4 = this.pathInterner.intern(filePath);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"intern(...)");
            this.prevFilePath = string4;
            bl = true;
        } else {
            bl = false;
        }
        boolean filePathChanged = bl;
        boolean bl4 = lookupChanged = nameChanged || fqNameChanged || filePathChanged;
        if (lookupChanged) {
            this.lookups.putValue(new LookupSymbol(this.prevName, this.prevScopeFqName), this.prevFilePath);
        }
        if (lookupChanged || !Intrinsics.areEqual((Object)this.prevPosition, (Object)position) || this.prevScopeKind != scopeKind) {
            this.prevPosition = position;
            this.prevScopeKind = scopeKind;
            this.delegate.record(this.prevFilePath, position, this.prevScopeFqName, scopeKind, this.prevName);
        }
    }

    @Override
    public void clear() {
        this.lookups.clear();
        this.prevFilePath = "";
        this.prevPosition = null;
        this.prevScopeFqName = "";
        this.prevScopeKind = null;
        this.prevName = "";
    }
}

