/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava.elements;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForFacade;
import org.jetbrains.kotlin.com.intellij.lang.java.JavaLanguage;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.fileEditor.FileDocumentManager;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiFileFactory;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsFileImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.ClsStubPsiFactory;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.impl.PsiJavaFileStubImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiFileImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.util.AstLoadingFilter;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPackageDirective;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\u0013\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\u0003H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020%H\u0016J\u0013\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010\u001fH\u0096\u0002J\u0012\u0010)\u001a\u00020'2\b\u0010*\u001a\u0004\u0018\u00010!H\u0016J\u0010\u0010+\u001a\u00020\u00182\u0006\u0010,\u001a\u00020\u000fH\u0016J\b\u0010-\u001a\u00020'H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/asJava/elements/FakeFileForLightClass;", "Lorg/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsFileImpl;", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "lightClass", "Lorg/jetbrains/kotlin/asJava/classes/KtLightClass;", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtFile;Lorg/jetbrains/kotlin/asJava/classes/KtLightClass;Lorg/jetbrains/kotlin/name/FqName;)V", "getKtFile", "()Lorg/jetbrains/kotlin/psi/KtFile;", "getVirtualFile", "Lorg/jetbrains/kotlin/com/intellij/openapi/vfs/VirtualFile;", "getPackageName", "", "createFakeJavaFileStub", "Lorg/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/PsiJavaFileStub;", "getStub", "getClasses", "", "()[Lorg/jetbrains/kotlin/asJava/classes/KtLightClass;", "getNavigationElement", "accept", "", "visitor", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElementVisitor;", "myMirrorFileElement", "Ljava/lang/ref/Reference;", "Lorg/jetbrains/kotlin/com/intellij/psi/impl/source/tree/TreeElement;", "myMirrorLock", "", "getMirror", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "getLanguageLevel", "Lorg/jetbrains/kotlin/com/intellij/pom/java/LanguageLevel;", "hashCode", "", "equals", "", "other", "isEquivalentTo", "another", "setPackageName", "packageName", "isPhysical", "light-classes-base"})
@SourceDebugExtension(value={"SMAP\nFakeFileForLightClass.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FakeFileForLightClass.kt\norg/jetbrains/kotlin/asJava/elements/FakeFileForLightClass\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,116:1\n1#2:117\n*E\n"})
public class FakeFileForLightClass
extends ClsFileImpl {
    @NotNull
    private final KtFile ktFile;
    @NotNull
    private final KtLightClass lightClass;
    @NotNull
    private final FqName packageFqName;
    @Nullable
    private volatile Reference<TreeElement> myMirrorFileElement;
    @NotNull
    private final Object myMirrorLock;

    public FakeFileForLightClass(@NotNull KtFile ktFile, @NotNull KtLightClass lightClass, @NotNull FqName packageFqName) {
        Intrinsics.checkNotNullParameter((Object)ktFile, (String)"ktFile");
        Intrinsics.checkNotNullParameter((Object)lightClass, (String)"lightClass");
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        super(ktFile.getViewProvider());
        this.ktFile = ktFile;
        this.lightClass = lightClass;
        this.packageFqName = packageFqName;
        this.myMirrorLock = new Object();
    }

    public /* synthetic */ FakeFileForLightClass(KtFile ktFile, KtLightClass ktLightClass, FqName fqName, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            fqName = ktFile.getPackageFqName();
        }
        this(ktFile, ktLightClass, fqName);
    }

    @NotNull
    public final KtFile getKtFile() {
        return this.ktFile;
    }

    @Override
    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.ktFile.getVirtualFile();
        if (virtualFile == null && (virtualFile = this.ktFile.getOriginalFile().getVirtualFile()) == null) {
            VirtualFile virtualFile2 = super.getVirtualFile();
            virtualFile = virtualFile2;
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getVirtualFile(...)");
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public String getPackageName() {
        return this.packageFqName.asString();
    }

    private final PsiJavaFileStub createFakeJavaFileStub() {
        PsiJavaFileStubImpl javaFileStub = new PsiJavaFileStubImpl(this.packageFqName.asString(), true);
        javaFileStub.setPsiFactory(ClsStubPsiFactory.INSTANCE);
        javaFileStub.setPsi((PsiFile)this);
        return javaFileStub;
    }

    @NotNull
    public PsiJavaFileStub getStub() {
        return this.createFakeJavaFileStub();
    }

    @NotNull
    public KtLightClass[] getClasses() {
        KtLightClass[] ktLightClassArray = new KtLightClass[]{this.lightClass};
        return ktLightClassArray;
    }

    @Override
    @NotNull
    public KtFile getNavigationElement() {
        return this.ktFile;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public PsiElement getMirror() {
        Reference<TreeElement> reference2;
        TreeElement treeElement;
        Reference<TreeElement> reference3 = this.myMirrorFileElement;
        if (reference3 != null && (treeElement = reference3.get()) != null) {
            TreeElement it = treeElement;
            boolean bl = false;
            PsiElement psiElement = it.getPsi();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPsi(...)");
            return psiElement;
        }
        Object object = this.myMirrorLock;
        synchronized (object) {
            Reference<TreeElement> reference4;
            boolean bl = false;
            Reference<TreeElement> reference5 = this.myMirrorFileElement;
            if (reference5 != null && (reference5 = reference5.get()) != null) {
                Reference<TreeElement> it = reference5;
                boolean bl2 = false;
                reference4 = it;
            } else {
                TreeElement treeElement2;
                VirtualFile file2 = this.getVirtualFile();
                AstLoadingFilter.assertTreeLoadingAllowed(file2);
                KtLightClass[] classes = this.getClasses();
                String fileName = (!(classes.length == 0) ? classes[0].getName() : file2.getNameWithoutExtension()) + ".java";
                Document document = FileDocumentManager.getInstance().getDocument(file2);
                if (document == null) {
                    String string2 = file2.getUrl();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getUrl(...)");
                    String string3 = string2;
                    throw new IllegalStateException(string3.toString());
                }
                Document document2 = document;
                PsiFileFactory factory = PsiFileFactory.getInstance(this.getManager().getProject());
                PsiFile mirror = factory.createFileFromText(fileName, JavaLanguage.INSTANCE, document2.getImmutableCharSequence(), false, false, true);
                mirror.putUserData(PsiUtil.FILE_LANGUAGE_LEVEL_KEY, this.getLanguageLevel());
                TreeElement treeElement3 = SourceTreeToPsiMap.psiToTreeNotNull(mirror);
                Intrinsics.checkNotNullExpressionValue((Object)treeElement3, (String)"psiToTreeNotNull(...)");
                TreeElement mirrorTreeElement = treeElement3;
                if (mirror instanceof PsiFileImpl) {
                    ((PsiFileImpl)mirror).setOriginalFile(this);
                }
                TreeElement it = treeElement2 = mirrorTreeElement;
                boolean bl3 = false;
                this.myMirrorFileElement = new SoftReference<TreeElement>(it);
                reference4 = treeElement2;
            }
            reference2 = reference4;
        }
        Reference<TreeElement> mirrorElement = reference2;
        PsiElement psiElement = mirrorElement.getPsi();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPsi(...)");
        return psiElement;
    }

    @Override
    @NotNull
    public LanguageLevel getLanguageLevel() {
        return LanguageLevel.JDK_1_8;
    }

    public int hashCode() {
        KtLightClass ktLightClass;
        KtLightClass it = ktLightClass = this.lightClass;
        boolean bl = false;
        KtLightClass ktLightClass2 = it instanceof KtLightClassForFacade && ((KtLightClassForFacade)it).getFiles().size() > 1 ? ktLightClass : null;
        return (ktLightClass2 != null ? (PsiElement)ktLightClass2 : (PsiElement)this.ktFile).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FakeFileForLightClass)) {
            return false;
        }
        return this.lightClass instanceof KtLightClassForFacade && ((KtLightClassForFacade)this.lightClass).getFiles().size() > 1 && Intrinsics.areEqual((Object)this.lightClass, (Object)((FakeFileForLightClass)other).lightClass) || Intrinsics.areEqual((Object)this.ktFile, (Object)((FakeFileForLightClass)other).ktFile);
    }

    @Override
    public boolean isEquivalentTo(@Nullable PsiElement another) {
        return Intrinsics.areEqual((Object)this, (Object)another);
    }

    @Override
    public void setPackageName(@NotNull String packageName2) {
        Intrinsics.checkNotNullParameter((Object)packageName2, (String)"packageName");
        if (this.lightClass instanceof KtLightClassForFacade) {
            KtPackageDirective ktPackageDirective = this.ktFile.getPackageDirective();
            if (ktPackageDirective != null) {
                ktPackageDirective.setFqName(new FqName(packageName2));
            }
        } else {
            super.setPackageName(packageName2);
        }
    }

    @Override
    public boolean isPhysical() {
        return false;
    }
}

