/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.inline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KMutableProperty0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.ErrorReportingContextKt;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.inline.KlibSyntheticAccessorGenerator;
import org.jetbrains.kotlin.config.KlibConfigurationKeys;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.inline.FunctionInliningKt;
import org.jetbrains.kotlin.ir.inline.GeneratedAccessor;
import org.jetbrains.kotlin.ir.inline.GeneratedAccessors;
import org.jetbrains.kotlin.ir.inline.SyntheticAccessorLoweringKt;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrExceptionBuilder;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrTransformer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0004\u0018\u0000 \u001b2\u00020\u0001:\u0003\u0019\u001a\u001bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0006\u001a\u00020\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u0016\u0010\u0014\u001a\u00020\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u001e\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/ir/inline/SyntheticAccessorLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "narrowAccessorVisibilities", "", "accessorGenerator", "Lorg/jetbrains/kotlin/backend/common/lower/inline/KlibSyntheticAccessorGenerator;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "lowerWithoutAddingAccessorsToParents", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "accessors", "", "Lorg/jetbrains/kotlin/ir/inline/GeneratedAccessor;", "addAccessorsToParents", "addAccessorsToParent", "parent", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationContainer;", "", "TransformerData", "Transformer", "Companion", "ir.inline"})
@SourceDebugExtension(value={"SMAP\nSyntheticAccessorLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SyntheticAccessorLowering.kt\norg/jetbrains/kotlin/ir/inline/SyntheticAccessorLowering\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 IrExceptionUtils.kt\norg/jetbrains/kotlin/ir/util/IrExceptionUtilsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,291:1\n227#2:292\n227#2:293\n1485#3:294\n1510#3,3:295\n1513#3,3:305\n1187#3,2:308\n1261#3,4:310\n1628#3,3:314\n1872#3,3:319\n381#4,7:298\n28#5:317\n29#5:322\n1#6:318\n*S KotlinDebug\n*F\n+ 1 SyntheticAccessorLowering.kt\norg/jetbrains/kotlin/ir/inline/SyntheticAccessorLowering\n*L\n53#1:292\n54#1:293\n106#1:294\n106#1:295,3\n106#1:305,3\n122#1:308,2\n122#1:310,4\n126#1:314,3\n149#1:319,3\n106#1:298,7\n145#1:317\n145#1:322\n145#1:318\n*E\n"})
public final class SyntheticAccessorLowering
implements FileLoweringPass {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CommonBackendContext context;
    private final boolean narrowAccessorVisibilities;
    @NotNull
    private final KlibSyntheticAccessorGenerator accessorGenerator;

    public SyntheticAccessorLowering(@NotNull CommonBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.narrowAccessorVisibilities = this.context.getConfiguration().getBoolean(KlibConfigurationKeys.SYNTHETIC_ACCESSORS_WITH_NARROWED_VISIBILITY);
        this.accessorGenerator = new KlibSyntheticAccessorGenerator(this.context);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void lower(@NotNull IrFile irFile) {
        void condition$iv;
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        Transformer transformer2 = new Transformer(irFile);
        irFile.transformChildren(transformer2, null);
        Collection<GeneratedAccessor> accessors = transformer2.getGeneratedAccessors().freezeAndGetAccessors();
        boolean bl = !accessors.isEmpty();
        boolean $i$f$runIf = false;
        if (condition$iv != false) {
            boolean bl2 = false;
            boolean condition$iv2 = this.narrowAccessorVisibilities;
            boolean $i$f$runIf2 = false;
            if (condition$iv2) {
                boolean bl3 = false;
                this.narrowAccessorVisibilities(accessors);
            }
            this.addAccessorsToParents(accessors);
        }
    }

    public final void lowerWithoutAddingAccessorsToParents(@NotNull IrFunction irFunction) {
        Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
        irFunction.accept(new Transformer(IrUtilsKt.getFile(irFunction)), null);
    }

    private final void narrowAccessorVisibilities(Collection<GeneratedAccessor> accessors) {
        for (GeneratedAccessor accessor : accessors) {
            accessor.getAccessorFunction().setVisibility(accessor.computeNarrowedVisibility());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addAccessorsToParents(Collection<GeneratedAccessor> accessors) {
        void $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = accessors;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            GeneratedAccessor it = (GeneratedAccessor)element$iv$iv;
            boolean bl = false;
            IrDeclarationParent key$iv$iv = it.getAccessorFunction().getParent();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        for (Map.Entry entry : destination$iv$iv.entrySet()) {
            IrDeclarationParent parent2 = (IrDeclarationParent)entry.getKey();
            List accessorsInParent = (List)entry.getValue();
            Intrinsics.checkNotNull((Object)parent2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer");
            this.addAccessorsToParent((IrDeclarationContainer)parent2, accessorsInParent);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addAccessorsToParent(IrDeclarationContainer parent2, List<GeneratedAccessor> accessors) {
        String $this$mapTo$iv;
        void $this$associateTo$iv$iv;
        if (accessors.size() == 1) {
            ((Collection)parent2.getDeclarations()).add(accessors.get(0).getAccessorFunction());
            return;
        }
        Iterable $this$associate$iv = accessors;
        boolean $i$f$associate22 = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Object destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            GeneratedAccessor accessor = (GeneratedAccessor)element$iv$iv;
            boolean bl = false;
            IrSymbolOwner irSymbolOwner = accessor.getTargetSymbol().getOwner();
            Intrinsics.checkNotNull((Object)irSymbolOwner, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclaration");
            accessor = TuplesKt.to((Object)((IrDeclaration)irSymbolOwner), (Object)accessor.getAccessorFunction());
            map.put(accessor.getFirst(), accessor.getSecond());
        }
        Map targetToAccessorFunction = destination$iv$iv;
        Iterable $i$f$associate22 = accessors;
        Collection destination$iv = new HashSet();
        boolean $i$f$mapTo = false;
        destination$iv$iv = $this$mapTo$iv.iterator();
        while (destination$iv$iv.hasNext()) {
            void p0;
            Object item$iv = destination$iv$iv.next();
            GeneratedAccessor generatedAccessor = (GeneratedAccessor)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(p0.getAccessorFunction());
        }
        Set remainingAccessorFunctions = (Set)destination$iv;
        for (IrDeclaration maybeTarget : CollectionsKt.toList((Iterable)parent2.getDeclarations())) {
            SyntheticAccessorLowering.addAccessorsToParent$addAccessorFunctionToParent(targetToAccessorFunction, parent2, remainingAccessorFunctions, maybeTarget);
            if (!(maybeTarget instanceof IrProperty)) continue;
            SyntheticAccessorLowering.addAccessorsToParent$addAccessorFunctionToParent(targetToAccessorFunction, parent2, remainingAccessorFunctions, ((IrProperty)maybeTarget).getGetter());
            SyntheticAccessorLowering.addAccessorsToParent$addAccessorFunctionToParent(targetToAccessorFunction, parent2, remainingAccessorFunctions, ((IrProperty)maybeTarget).getSetter());
            SyntheticAccessorLowering.addAccessorsToParent$addAccessorFunctionToParent(targetToAccessorFunction, parent2, remainingAccessorFunctions, ((IrProperty)maybeTarget).getBackingField());
        }
        if (!((Collection)remainingAccessorFunctions).isEmpty()) {
            void message$iv;
            IrExceptionBuilder irExceptionBuilder;
            $this$mapTo$iv = "There are " + remainingAccessorFunctions.size() + " synthetic accessors in file " + IrUtilsKt.getFile((IrDeclaration)CollectionsKt.first((Iterable)remainingAccessorFunctions)).getFileEntry().getName() + " that have been generated but it's not possible to compute the proper order for them";
            boolean $i$f$irError = false;
            IrExceptionBuilder $this$irError_u24lambda_u240$iv = irExceptionBuilder = new IrExceptionBuilder((String)message$iv);
            boolean bl = false;
            IrExceptionBuilder $this$addAccessorsToParent_u24lambda_u245 = $this$irError_u24lambda_u240$iv;
            boolean bl2 = false;
            Iterable $this$forEachIndexed$iv = remainingAccessorFunctions;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void accessor;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                IrFunction irFunction = (IrFunction)item$iv;
                int index = n;
                boolean bl3 = false;
                $this$addAccessorsToParent_u24lambda_u245.withIrEntry("accessor" + index, (IrElement)accessor);
            }
            IrExceptionBuilder builder$iv = irExceptionBuilder;
            throw new IllegalStateException(builder$iv.buildString().toString());
        }
    }

    private static final void addAccessorsToParent$addAccessorFunctionToParent(Map<IrDeclaration, ? extends IrFunction> targetToAccessorFunction, IrDeclarationContainer $parent, Set<IrFunction> remainingAccessorFunctions, IrDeclaration maybeTarget) {
        if (maybeTarget == null) {
            return;
        }
        IrFunction irFunction = targetToAccessorFunction.get(maybeTarget);
        if (irFunction == null) {
            return;
        }
        IrFunction accessorFunction = irFunction;
        ((Collection)$parent.getDeclarations()).add(accessorFunction);
        ((Collection)remainingAccessorFunctions).remove(accessorFunction);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0006H\u0002J\f\u0010\u0007\u001a\u00020\u0005*\u00020\bH\u0002\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/ir/inline/SyntheticAccessorLowering$Companion;", "", "<init>", "()V", "isNonLocalPrivateFunction", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "isNonLocalBackingField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "ir.inline"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isNonLocalPrivateFunction(IrFunction $this$isNonLocalPrivateFunction) {
            return DescriptorVisibilities.isPrivate($this$isNonLocalPrivateFunction.getVisibility()) && !AdditionalIrUtilsKt.isLocal($this$isNonLocalPrivateFunction);
        }

        private final boolean isNonLocalBackingField(IrField $this$isNonLocalBackingField) {
            Object object = $this$isNonLocalBackingField.getCorrespondingPropertySymbol();
            return object != null && (object = (IrProperty)object.getOwner()) != null ? !AdditionalIrUtilsKt.isLocal((IrDeclaration)object) : false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u000f\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00162\b\u0010\u000f\u001a\u0004\u0018\u00010\u0002H\u0016J\f\u0010\u0017\u001a\u00020\u0018*\u00020\u0019H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/ir/inline/SyntheticAccessorLowering$Transformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrTransformer;", "Lorg/jetbrains/kotlin/ir/inline/SyntheticAccessorLowering$TransformerData;", "currentFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "<init>", "(Lorg/jetbrains/kotlin/ir/inline/SyntheticAccessorLowering;Lorg/jetbrains/kotlin/ir/declarations/IrFile;)V", "generatedAccessors", "Lorg/jetbrains/kotlin/ir/inline/GeneratedAccessors;", "getGeneratedAccessors", "()Lorg/jetbrains/kotlin/ir/inline/GeneratedAccessors;", "visitFunction", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "data", "visitFunctionAccess", "Lorg/jetbrains/kotlin/ir/IrElement;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "visitGetField", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "Lorg/jetbrains/kotlin/ir/expressions/IrGetField;", "checkIncorrectCrossFileDeclarationAccess", "", "Lorg/jetbrains/kotlin/ir/expressions/IrDeclarationReference;", "ir.inline"})
    @SourceDebugExtension(value={"SMAP\nSyntheticAccessorLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SyntheticAccessorLowering.kt\norg/jetbrains/kotlin/ir/inline/SyntheticAccessorLowering$Transformer\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,291:1\n395#2,3:292\n227#2:295\n*S KotlinDebug\n*F\n+ 1 SyntheticAccessorLowering.kt\norg/jetbrains/kotlin/ir/inline/SyntheticAccessorLowering$Transformer\n*L\n157#1:292,3\n160#1:295\n*E\n"})
    private final class Transformer
    extends IrTransformer<TransformerData> {
        @NotNull
        private final IrFile currentFile;
        @NotNull
        private final GeneratedAccessors generatedAccessors;

        public Transformer(IrFile currentFile) {
            Intrinsics.checkNotNullParameter((Object)currentFile, (String)"currentFile");
            this.currentFile = currentFile;
            Transformer transformer2 = this;
            KMutableProperty0 $this$getOrSetIfNull$iv = (KMutableProperty0)new MutablePropertyReference0Impl(this.currentFile){

                public Object get() {
                    return SyntheticAccessorLoweringKt.access$getGeneratedAccessors((IrFile)this.receiver);
                }

                public void set(Object value2) {
                    SyntheticAccessorLoweringKt.access$setGeneratedAccessors((IrFile)this.receiver, (GeneratedAccessors)value2);
                }
            };
            boolean $i$f$getOrSetIfNull = false;
            Object object = $this$getOrSetIfNull$iv.get();
            if (object == null) {
                GeneratedAccessors generatedAccessors2;
                Transformer transformer3 = transformer2;
                boolean bl = false;
                transformer2 = transformer3;
                GeneratedAccessors it$iv = generatedAccessors2 = new GeneratedAccessors();
                boolean bl2 = false;
                $this$getOrSetIfNull$iv.set((Object)it$iv);
                object = generatedAccessors2;
            }
            transformer2.generatedAccessors = (GeneratedAccessors)object;
        }

        @NotNull
        public final GeneratedAccessors getGeneratedAccessors() {
            return this.generatedAccessors;
        }

        @Override
        @NotNull
        public IrStatement visitFunction(@NotNull IrFunction declaration, @Nullable TransformerData data) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            TransformerData transformerData = data;
            if (transformerData == null) {
                boolean condition$iv = declaration.isInline() && !FunctionInliningKt.isConsideredAsPrivateForInlining(declaration);
                boolean $i$f$runIf = false;
                if (condition$iv) {
                    boolean bl = false;
                    transformerData = new TransformerData(declaration);
                } else {
                    transformerData = null;
                }
            }
            TransformerData newData = transformerData;
            return super.visitFunction(declaration, newData);
        }

        @Override
        @NotNull
        public IrElement visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable TransformerData data) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            if (data == null) {
                return super.visitFunctionAccess(expression2, (Object)null);
            }
            IrFunction targetFunction = ((IrFunctionSymbol)expression2.getSymbol()).getOwner();
            if (!Companion.isNonLocalPrivateFunction(targetFunction) || this.checkIncorrectCrossFileDeclarationAccess(expression2)) {
                return super.visitFunctionAccess(expression2, data);
            }
            IrFunction accessor = (IrFunction)targetFunction.getFactory().getStageController().restrictTo(targetFunction, () -> Transformer.visitFunctionAccess$lambda$1(SyntheticAccessorLowering.this, expression2));
            this.generatedAccessors.memoize(accessor, (IrSymbol)expression2.getSymbol(), data.getCurrentInlineFunction());
            return (IrElement)super.visitExpression((IrExpression)SyntheticAccessorLowering.this.accessorGenerator.modifyFunctionAccessExpression(expression2, accessor.getSymbol()), data);
        }

        @Override
        @NotNull
        public IrExpression visitGetField(@NotNull IrGetField expression2, @Nullable TransformerData data) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            if (data == null) {
                return super.visitGetField(expression2, (Object)null);
            }
            IrField targetField = (IrField)expression2.getSymbol().getOwner();
            if (!Companion.isNonLocalBackingField(targetField) || this.checkIncorrectCrossFileDeclarationAccess(expression2)) {
                return super.visitGetField(expression2, data);
            }
            IrSimpleFunction accessor = (IrSimpleFunction)targetField.getFactory().getStageController().restrictTo(targetField, () -> Transformer.visitGetField$lambda$2(SyntheticAccessorLowering.this, expression2));
            this.generatedAccessors.memoize(accessor, expression2.getSymbol(), data.getCurrentInlineFunction());
            return super.visitExpression((IrExpression)SyntheticAccessorLowering.this.accessorGenerator.modifyGetterExpression(expression2, accessor.getSymbol()), data);
        }

        private final boolean checkIncorrectCrossFileDeclarationAccess(IrDeclarationReference $this$checkIncorrectCrossFileDeclarationAccess) {
            boolean isIncorrect;
            IrSymbolOwner irSymbolOwner = $this$checkIncorrectCrossFileDeclarationAccess.getSymbol().getOwner();
            IrDeclaration irDeclaration2 = irSymbolOwner instanceof IrDeclaration ? (IrDeclaration)irSymbolOwner : null;
            if (irDeclaration2 == null) {
                return false;
            }
            IrDeclaration callee = irDeclaration2;
            boolean bl = isIncorrect = !Intrinsics.areEqual((Object)IrUtilsKt.getFileOrNull(callee), (Object)this.currentFile);
            if (isIncorrect) {
                ErrorReportingContextKt.reportWarning(SyntheticAccessorLowering.this.context, "Accessing a private declaration from another file is not permitted. This is likely caused by invalid IR generated by a compiler plugin. Please file a bug on https://kotl.in/issue. Offending access: " + RenderIrElementKt.render$default($this$checkIncorrectCrossFileDeclarationAccess, null, 1, null), this.currentFile, $this$checkIncorrectCrossFileDeclarationAccess);
            }
            return isIncorrect;
        }

        private static final IrFunction visitFunctionAccess$lambda$1(SyntheticAccessorLowering this$0, IrFunctionAccessExpression $expression) {
            return this$0.accessorGenerator.getSyntheticFunctionAccessor($expression, null);
        }

        private static final IrSimpleFunction visitGetField$lambda$2(SyntheticAccessorLowering this$0, IrGetField $expression) {
            return this$0.accessorGenerator.getSyntheticGetter($expression, null);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/ir/inline/SyntheticAccessorLowering$TransformerData;", "", "currentInlineFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "<init>", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)V", "getCurrentInlineFunction", "()Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "ir.inline"})
    private static final class TransformerData {
        @NotNull
        private final IrFunction currentInlineFunction;

        public TransformerData(@NotNull IrFunction currentInlineFunction) {
            Intrinsics.checkNotNullParameter((Object)currentInlineFunction, (String)"currentInlineFunction");
            this.currentInlineFunction = currentInlineFunction;
        }

        @NotNull
        public final IrFunction getCurrentInlineFunction() {
            return this.currentInlineFunction;
        }
    }
}

