/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrFileEntry;
import org.jetbrains.kotlin.ir.LineAndColumn;
import org.jetbrains.kotlin.ir.backend.js.utils.IrNamer;
import org.jetbrains.kotlin.ir.backend.js.utils.JsStaticContext;
import org.jetbrains.kotlin.ir.backend.js.utils.LocalNameGenerator;
import org.jetbrains.kotlin.ir.backend.js.utils.NameTablesKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrReturnableBlock;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.util.IrExceptionBuilder;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.js.backend.ast.JsLocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BW\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0014\b\u0002\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0016\u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u0005J\u001e\u0010%\u001a\u00020\u00002\n\b\u0002\u0010&\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nJ\u000e\u0010'\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020)J\u0010\u0010*\u001a\u0004\u0018\u00010\u000e2\u0006\u0010+\u001a\u00020,J\u0010\u0010-\u001a\u0004\u0018\u00010\u000e2\u0006\u0010.\u001a\u00020/J\u000e\u00100\u001a\u00020\u00102\u0006\u00101\u001a\u000202J\u000e\u00103\u001a\u00020\u00102\u0006\u00101\u001a\u000202J\u001c\u00104\u001a\u0004\u0018\u00010\u001f2\u0006\u00105\u001a\u00020\r2\n\b\u0002\u00106\u001a\u0004\u0018\u000107J\u001c\u00108\u001a\u0004\u0018\u00010\u001f2\u0006\u00105\u001a\u00020\r2\n\b\u0002\u00106\u001a\u0004\u0018\u000107JJ\u00109\u001a\u0004\u0018\u00010\u001f2\u0006\u00105\u001a\u00020\r2\b\u00106\u001a\u0004\u0018\u0001072\u0012\u0010:\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f0\f2\u0017\u0010;\u001a\u0013\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u001e0<\u00a2\u0006\u0002\b=H\u0082\bJ\u0018\u0010>\u001a\u0004\u0018\u00010\u001e2\u0006\u0010?\u001a\u00020@H\u0096\u0001\u00a2\u0006\u0002\u0010AJ\u0011\u0010B\u001a\u00020\u000e2\u0006\u0010C\u001a\u00020@H\u0096\u0001J\u0011\u0010D\u001a\u00020\u000e2\u0006\u0010E\u001a\u00020FH\u0096\u0001J\u0011\u0010G\u001a\u00020\u000e2\u0006\u0010H\u001a\u00020IH\u0096\u0001J\u0011\u0010J\u001a\u00020\u000e2\u0006\u0010H\u001a\u00020IH\u0096\u0001J\u0011\u0010K\u001a\u00020\u000e2\u0006\u0010L\u001a\u00020MH\u0096\u0001J\u0011\u0010N\u001a\u00020\u000e2\u0006\u0010O\u001a\u00020PH\u0096\u0001J\u0011\u0010Q\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020)H\u0096\u0001J\u0011\u0010R\u001a\u00020\u000e2\u0006\u0010L\u001a\u00020MH\u0096\u0001J\u0011\u0010S\u001a\u00020T2\u0006\u0010C\u001a\u00020@H\u0096\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u001c\u001a\u001e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f0\u001dj\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f` X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010!\u001a\u001e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f0\u001dj\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f` X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006U"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/utils/JsGenerationContext;", "Lorg/jetbrains/kotlin/ir/backend/js/utils/IrNamer;", "currentFileEntry", "Lorg/jetbrains/kotlin/ir/IrFileEntry;", "currentFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "currentInlineFunction", "staticContext", "Lorg/jetbrains/kotlin/ir/backend/js/utils/JsStaticContext;", "localNames", "Lorg/jetbrains/kotlin/ir/backend/js/utils/LocalNameGenerator;", "nameCache", "", "Lorg/jetbrains/kotlin/ir/IrElement;", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "useBareParameterNames", "", "<init>", "(Lorg/jetbrains/kotlin/ir/IrFileEntry;Lorg/jetbrains/kotlin/ir/declarations/IrFunction;Lorg/jetbrains/kotlin/ir/declarations/IrFunction;Lorg/jetbrains/kotlin/ir/backend/js/utils/JsStaticContext;Lorg/jetbrains/kotlin/ir/backend/js/utils/LocalNameGenerator;Ljava/util/Map;Z)V", "getCurrentFileEntry", "()Lorg/jetbrains/kotlin/ir/IrFileEntry;", "getCurrentFunction", "()Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "getCurrentInlineFunction", "getStaticContext", "()Lorg/jetbrains/kotlin/ir/backend/js/utils/JsStaticContext;", "getLocalNames", "()Lorg/jetbrains/kotlin/ir/backend/js/utils/LocalNameGenerator;", "startLocationCache", "Ljava/util/HashMap;", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsLocation;", "Lkotlin/collections/HashMap;", "endLocationCache", "newInlineFunction", "fileEntry", "inlineFun", "newDeclaration", "func", "getNameForValueDeclaration", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "getNameForLoop", "loop", "Lorg/jetbrains/kotlin/ir/expressions/IrLoop;", "getNameForReturnableBlock", "block", "Lorg/jetbrains/kotlin/ir/expressions/IrReturnableBlock;", "checkIfJsCode", "symbol", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "checkIfHasAssociatedJsCode", "getStartLocationForIrElement", "irElement", "originalName", "", "getEndLocationForIrElement", "getLocationForIrElement", "cache", "offsetSelector", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "getAssociatedObjectKey", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)Ljava/lang/Integer;", "getNameForClass", "klass", "getNameForConstructor", "constructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "getNameForField", "field", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "getNameForMemberField", "getNameForMemberFunction", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "getNameForProperty", "property", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "getNameForStaticDeclaration", "getNameForStaticFunction", "getRefForExternalClass", "Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;", "backend.js"})
@SourceDebugExtension(value={"SMAP\nJsGenerationContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsGenerationContext.kt\norg/jetbrains/kotlin/ir/backend/js/utils/JsGenerationContext\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 IrExceptionUtils.kt\norg/jetbrains/kotlin/ir/util/IrExceptionUtilsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 jsAstUtils.kt\norg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsAstUtilsKt\n*L\n1#1,120:1\n116#1:145\n117#1:149\n118#1:159\n116#1:160\n117#1:164\n118#1:174\n381#2,3:121\n384#2,4:127\n381#2,7:131\n381#2,7:138\n381#2,3:146\n384#2,4:155\n381#2,3:161\n384#2,4:170\n381#2,3:175\n384#2,4:183\n28#3:124\n29#3:126\n1#4:125\n641#5,5:150\n641#5,5:165\n641#5,5:178\n*S KotlinDebug\n*F\n+ 1 JsGenerationContext.kt\norg/jetbrains/kotlin/ir/backend/js/utils/JsGenerationContext\n*L\n106#1:145\n106#1:149\n106#1:159\n109#1:160\n109#1:164\n109#1:174\n71#1:121,3\n71#1:127,4\n85#1:131,7\n92#1:138,7\n106#1:146,3\n106#1:155,4\n109#1:161,3\n109#1:170,4\n116#1:175,3\n116#1:183,4\n76#1:124\n76#1:126\n76#1:125\n106#1:150,5\n109#1:165,5\n117#1:178,5\n*E\n"})
public final class JsGenerationContext
implements IrNamer {
    @NotNull
    private final IrFileEntry currentFileEntry;
    @Nullable
    private final IrFunction currentFunction;
    @Nullable
    private final IrFunction currentInlineFunction;
    @NotNull
    private final JsStaticContext staticContext;
    @Nullable
    private final LocalNameGenerator localNames;
    @NotNull
    private final Map<IrElement, JsName> nameCache;
    private final boolean useBareParameterNames;
    @NotNull
    private final HashMap<Integer, JsLocation> startLocationCache;
    @NotNull
    private final HashMap<Integer, JsLocation> endLocationCache;

    public JsGenerationContext(@NotNull IrFileEntry currentFileEntry, @Nullable IrFunction currentFunction, @Nullable IrFunction currentInlineFunction, @NotNull JsStaticContext staticContext, @Nullable LocalNameGenerator localNames, @NotNull Map<IrElement, JsName> nameCache, boolean useBareParameterNames) {
        Intrinsics.checkNotNullParameter((Object)currentFileEntry, (String)"currentFileEntry");
        Intrinsics.checkNotNullParameter((Object)staticContext, (String)"staticContext");
        Intrinsics.checkNotNullParameter(nameCache, (String)"nameCache");
        this.currentFileEntry = currentFileEntry;
        this.currentFunction = currentFunction;
        this.currentInlineFunction = currentInlineFunction;
        this.staticContext = staticContext;
        this.localNames = localNames;
        this.nameCache = nameCache;
        this.useBareParameterNames = useBareParameterNames;
        this.startLocationCache = new HashMap();
        this.endLocationCache = new HashMap();
    }

    public /* synthetic */ JsGenerationContext(IrFileEntry irFileEntry, IrFunction irFunction, IrFunction irFunction2, JsStaticContext jsStaticContext, LocalNameGenerator localNameGenerator, Map map, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            localNameGenerator = null;
        }
        if ((n & 0x20) != 0) {
            map = new HashMap();
        }
        if ((n & 0x40) != 0) {
            bl = false;
        }
        this(irFileEntry, irFunction, irFunction2, jsStaticContext, localNameGenerator, map, bl);
    }

    @NotNull
    public final IrFileEntry getCurrentFileEntry() {
        return this.currentFileEntry;
    }

    @Nullable
    public final IrFunction getCurrentFunction() {
        return this.currentFunction;
    }

    @Nullable
    public final IrFunction getCurrentInlineFunction() {
        return this.currentInlineFunction;
    }

    @NotNull
    public final JsStaticContext getStaticContext() {
        return this.staticContext;
    }

    @Nullable
    public final LocalNameGenerator getLocalNames() {
        return this.localNames;
    }

    @NotNull
    public final JsGenerationContext newInlineFunction(@NotNull IrFileEntry fileEntry, @NotNull IrFunction inlineFun) {
        Intrinsics.checkNotNullParameter((Object)fileEntry, (String)"fileEntry");
        Intrinsics.checkNotNullParameter((Object)inlineFun, (String)"inlineFun");
        return new JsGenerationContext(fileEntry, this.currentFunction, inlineFun, this.staticContext, this.localNames, this.nameCache, this.useBareParameterNames);
    }

    @NotNull
    public final JsGenerationContext newDeclaration(@Nullable IrFunction func, @Nullable LocalNameGenerator localNames) {
        return new JsGenerationContext(this.currentFileEntry, func, this.currentInlineFunction, this.staticContext, localNames, this.nameCache, this.useBareParameterNames);
    }

    public static /* synthetic */ JsGenerationContext newDeclaration$default(JsGenerationContext jsGenerationContext, IrFunction irFunction, LocalNameGenerator localNameGenerator, int n, Object object) {
        if ((n & 1) != 0) {
            irFunction = null;
        }
        if ((n & 2) != 0) {
            localNameGenerator = null;
        }
        return jsGenerationContext.newDeclaration(irFunction, localNameGenerator);
    }

    @NotNull
    public final JsName getNameForValueDeclaration(@NotNull IrDeclarationWithName declaration) {
        JsName jsName;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Map<IrElement, JsName> $this$getOrPut$iv = this.nameCache;
        boolean $i$f$getOrPut = false;
        JsName value$iv = $this$getOrPut$iv.get(declaration);
        if (value$iv == null) {
            JsName jsName2;
            boolean bl = false;
            if (this.useBareParameterNames) {
                String string2 = declaration.getName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
                jsName2 = new JsName(NameTablesKt.sanitizeName$default(string2, false, 2, null), true);
            } else {
                LocalNameGenerator localNameGenerator = this.localNames;
                Intrinsics.checkNotNull((Object)localNameGenerator);
                String string3 = localNameGenerator.getVariableNames().getNames().get(declaration);
                if (string3 == null) {
                    IrExceptionBuilder irExceptionBuilder;
                    String message$iv = "Variable name is not found";
                    boolean $i$f$irError = false;
                    IrExceptionBuilder $this$irError_u24lambda_u240$iv = irExceptionBuilder = new IrExceptionBuilder(message$iv);
                    boolean bl2 = false;
                    IrExceptionBuilder $this$getNameForValueDeclaration_u24lambda_u241_u24lambda_u240 = $this$irError_u24lambda_u240$iv;
                    boolean bl3 = false;
                    $this$getNameForValueDeclaration_u24lambda_u241_u24lambda_u240.withIrEntry("declaration", declaration);
                    IrExceptionBuilder builder$iv = irExceptionBuilder;
                    throw new IllegalStateException(builder$iv.buildString().toString());
                }
                String name2 = string3;
                jsName2 = new JsName(name2, true);
            }
            JsName answer$iv = jsName2;
            $this$getOrPut$iv.put(declaration, answer$iv);
            jsName = answer$iv;
        } else {
            jsName = value$iv;
        }
        return jsName;
    }

    @Nullable
    public final JsName getNameForLoop(@NotNull IrLoop loop) {
        JsName jsName;
        Intrinsics.checkNotNullParameter((Object)loop, (String)"loop");
        Map<IrElement, JsName> $this$getOrPut$iv = this.nameCache;
        boolean $i$f$getOrPut = false;
        JsName value$iv = $this$getOrPut$iv.get(loop);
        if (value$iv == null) {
            boolean bl = false;
            LocalNameGenerator localNameGenerator = this.localNames;
            Intrinsics.checkNotNull((Object)localNameGenerator);
            String string2 = localNameGenerator.getLocalLoopNames().getNames().get(loop);
            if (string2 == null) {
                return null;
            }
            String name2 = string2;
            JsName answer$iv = new JsName(name2, true);
            $this$getOrPut$iv.put(loop, answer$iv);
            jsName = answer$iv;
        } else {
            jsName = value$iv;
        }
        return jsName;
    }

    @Nullable
    public final JsName getNameForReturnableBlock(@NotNull IrReturnableBlock block) {
        JsName jsName;
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Map<IrElement, JsName> $this$getOrPut$iv = this.nameCache;
        boolean $i$f$getOrPut = false;
        JsName value$iv = $this$getOrPut$iv.get(block);
        if (value$iv == null) {
            boolean bl = false;
            LocalNameGenerator localNameGenerator = this.localNames;
            Intrinsics.checkNotNull((Object)localNameGenerator);
            String string2 = localNameGenerator.getLocalReturnableBlockNames().getNames().get(block);
            if (string2 == null) {
                return null;
            }
            String name2 = string2;
            JsName answer$iv = new JsName(name2, true);
            $this$getOrPut$iv.put(block, answer$iv);
            jsName = answer$iv;
        } else {
            jsName = value$iv;
        }
        return jsName;
    }

    public final boolean checkIfJsCode(@NotNull IrFunctionSymbol symbol) {
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        return Intrinsics.areEqual((Object)symbol, (Object)this.staticContext.getBackendContext().getIntrinsics().getJsCode());
    }

    public final boolean checkIfHasAssociatedJsCode(@NotNull IrFunctionSymbol symbol) {
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        IrFunctionSymbol originalSymbol = IrUtilsKt.getOriginalFunction(symbol.getOwner()).getSymbol();
        return this.staticContext.getBackendContext().getJsCodeForFunction(originalSymbol) != null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final JsLocation getStartLocationForIrElement(@NotNull IrElement irElement, @Nullable String originalName) {
        JsLocation jsLocation;
        block4: {
            Object v;
            block5: {
                Object value$iv$iv;
                block2: {
                    JsLocation jsLocation2;
                    void $this$getOrPut$iv$iv;
                    Integer key$iv$iv;
                    block3: {
                        void $this$getSourceLocation$iv$iv;
                        void this_$iv;
                        Intrinsics.checkNotNullParameter((Object)irElement, (String)"irElement");
                        JsGenerationContext jsGenerationContext = this;
                        Map cache$iv = this.startLocationCache;
                        boolean $i$f$getLocationForIrElement = false;
                        Map map = cache$iv;
                        IrElement $this$getStartLocationForIrElement_u24lambda_u244 = irElement;
                        boolean bl = false;
                        key$iv$iv = $this$getStartLocationForIrElement_u24lambda_u244.getStartOffset();
                        boolean $i$f$getOrPut = false;
                        value$iv$iv = $this$getOrPut$iv$iv.get(key$iv$iv);
                        if (value$iv$iv != null) break block2;
                        boolean bl2 = false;
                        IrElement irElement2 = irElement;
                        IrFileEntry fileEntry$iv$iv = this_$iv.currentFileEntry;
                        boolean $i$f$getSourceLocation = false;
                        if ($this$getSourceLocation$iv$iv.getStartOffset() == -1 || $this$getSourceLocation$iv$iv.getEndOffset() == -1) {
                            jsLocation2 = null;
                        } else {
                            String path$iv$iv = fileEntry$iv$iv.getName();
                            void $this$getStartLocationForIrElement_u24lambda_u2442 = $this$getSourceLocation$iv$iv;
                            $i$a$-getLocationForIrElement-JsGenerationContext$getStartLocationForIrElement$1 = false;
                            int offset$iv$iv = $this$getStartLocationForIrElement_u24lambda_u2442.getStartOffset();
                            LineAndColumn lineAndColumn = fileEntry$iv$iv.getLineAndColumnNumbers(offset$iv$iv);
                            int startLine$iv$iv = lineAndColumn.component1();
                            int startColumn$iv$iv = lineAndColumn.component2();
                            jsLocation2 = new JsLocation(path$iv$iv, startLine$iv$iv, startColumn$iv$iv, null, 8, null);
                        }
                        if (jsLocation2 != null) break block3;
                        jsLocation = null;
                        break block4;
                    }
                    JsLocation answer$iv$iv = jsLocation2;
                    $this$getOrPut$iv$iv.put(key$iv$iv, answer$iv$iv);
                    v = answer$iv$iv;
                    break block5;
                }
                v = value$iv$iv;
            }
            jsLocation = JsLocation.copy$default((JsLocation)v, null, 0, 0, originalName, 7, null);
        }
        return jsLocation;
    }

    public static /* synthetic */ JsLocation getStartLocationForIrElement$default(JsGenerationContext jsGenerationContext, IrElement irElement, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return jsGenerationContext.getStartLocationForIrElement(irElement, string2);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final JsLocation getEndLocationForIrElement(@NotNull IrElement irElement, @Nullable String originalName) {
        JsLocation jsLocation;
        block4: {
            Object v;
            block5: {
                Object value$iv$iv;
                block2: {
                    JsLocation jsLocation2;
                    void $this$getOrPut$iv$iv;
                    Integer key$iv$iv;
                    block3: {
                        void $this$getSourceLocation$iv$iv;
                        void this_$iv;
                        Intrinsics.checkNotNullParameter((Object)irElement, (String)"irElement");
                        JsGenerationContext jsGenerationContext = this;
                        Map cache$iv = this.endLocationCache;
                        boolean $i$f$getLocationForIrElement = false;
                        Map map = cache$iv;
                        IrElement $this$getEndLocationForIrElement_u24lambda_u245 = irElement;
                        boolean bl = false;
                        key$iv$iv = $this$getEndLocationForIrElement_u24lambda_u245.getEndOffset();
                        boolean $i$f$getOrPut = false;
                        value$iv$iv = $this$getOrPut$iv$iv.get(key$iv$iv);
                        if (value$iv$iv != null) break block2;
                        boolean bl2 = false;
                        IrElement irElement2 = irElement;
                        IrFileEntry fileEntry$iv$iv = this_$iv.currentFileEntry;
                        boolean $i$f$getSourceLocation = false;
                        if ($this$getSourceLocation$iv$iv.getStartOffset() == -1 || $this$getSourceLocation$iv$iv.getEndOffset() == -1) {
                            jsLocation2 = null;
                        } else {
                            String path$iv$iv = fileEntry$iv$iv.getName();
                            void $this$getEndLocationForIrElement_u24lambda_u2452 = $this$getSourceLocation$iv$iv;
                            $i$a$-getLocationForIrElement-JsGenerationContext$getEndLocationForIrElement$1 = false;
                            int offset$iv$iv = $this$getEndLocationForIrElement_u24lambda_u2452.getEndOffset();
                            LineAndColumn lineAndColumn = fileEntry$iv$iv.getLineAndColumnNumbers(offset$iv$iv);
                            int startLine$iv$iv = lineAndColumn.component1();
                            int startColumn$iv$iv = lineAndColumn.component2();
                            jsLocation2 = new JsLocation(path$iv$iv, startLine$iv$iv, startColumn$iv$iv, null, 8, null);
                        }
                        if (jsLocation2 != null) break block3;
                        jsLocation = null;
                        break block4;
                    }
                    JsLocation answer$iv$iv = jsLocation2;
                    $this$getOrPut$iv$iv.put(key$iv$iv, answer$iv$iv);
                    v = answer$iv$iv;
                    break block5;
                }
                v = value$iv$iv;
            }
            jsLocation = JsLocation.copy$default((JsLocation)v, null, 0, 0, originalName, 7, null);
        }
        return jsLocation;
    }

    public static /* synthetic */ JsLocation getEndLocationForIrElement$default(JsGenerationContext jsGenerationContext, IrElement irElement, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return jsGenerationContext.getEndLocationForIrElement(irElement, string2);
    }

    @Override
    @NotNull
    public JsName getNameForMemberFunction(@NotNull IrSimpleFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        return this.staticContext.getNameForMemberFunction(function2);
    }

    @Override
    @NotNull
    public JsName getNameForMemberField(@NotNull IrField field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        return this.staticContext.getNameForMemberField(field);
    }

    @Override
    @NotNull
    public JsName getNameForStaticDeclaration(@NotNull IrDeclarationWithName declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        return this.staticContext.getNameForStaticDeclaration(declaration);
    }

    @Override
    @NotNull
    public JsName getNameForStaticFunction(@NotNull IrSimpleFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        return this.staticContext.getNameForStaticFunction(function2);
    }

    @Override
    @NotNull
    public JsName getNameForField(@NotNull IrField field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        return this.staticContext.getNameForField(field);
    }

    @Override
    @NotNull
    public JsName getNameForConstructor(@NotNull IrConstructor constructor) {
        Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
        return this.staticContext.getNameForConstructor(constructor);
    }

    @Override
    @NotNull
    public JsName getNameForClass(@NotNull IrClass klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        return this.staticContext.getNameForClass(klass);
    }

    @Override
    @NotNull
    public JsNameRef getRefForExternalClass(@NotNull IrClass klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        return this.staticContext.getRefForExternalClass(klass);
    }

    @Override
    @NotNull
    public JsName getNameForProperty(@NotNull IrProperty property2) {
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        return this.staticContext.getNameForProperty(property2);
    }

    @Override
    @Nullable
    public Integer getAssociatedObjectKey(@NotNull IrClass irClass) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        return this.staticContext.getAssociatedObjectKey(irClass);
    }
}

