/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.lower;

import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.DeclarationGeneratorKt;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.impl.IrTryImpl;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/lower/InvokeOnExportedFunctionExitLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "invokeOnExportedFunctionExit", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "getInvokeOnExportedFunctionExit", "()Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "irBooleanType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "isNotFirstWasmExportCallGetter", "isNotFirstWasmExportCallSetter", "processExportFunction", "", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "lower", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\nInvokeOnExportedFunctionExitLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InvokeOnExportedFunctionExitLowering.kt\norg/jetbrains/kotlin/backend/wasm/lower/InvokeOnExportedFunctionExitLowering\n+ 2 WasmBackendContext.kt\norg/jetbrains/kotlin/backend/wasm/WasmBackendContext\n+ 3 ExpressionHelpers.kt\norg/jetbrains/kotlin/ir/builders/ExpressionHelpersKt\n+ 4 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBuilder\n*L\n1#1,134:1\n85#2:135\n397#3,13:136\n397#3,13:151\n397#3,13:166\n98#4,2:149\n98#4,2:164\n98#4,2:179\n*S KotlinDebug\n*F\n+ 1 InvokeOnExportedFunctionExitLowering.kt\norg/jetbrains/kotlin/backend/wasm/lower/InvokeOnExportedFunctionExitLowering\n*L\n57#1:135\n79#1:136,13\n89#1:151,13\n112#1:166,13\n79#1:149,2\n89#1:164,2\n112#1:179,2\n*E\n"})
public final class InvokeOnExportedFunctionExitLowering
implements FileLoweringPass {
    @NotNull
    private final WasmBackendContext context;
    @NotNull
    private final IrType irBooleanType;
    @NotNull
    private final IrSimpleFunctionSymbol isNotFirstWasmExportCallGetter;
    @NotNull
    private final IrSimpleFunctionSymbol isNotFirstWasmExportCallSetter;

    public InvokeOnExportedFunctionExitLowering(@NotNull WasmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.irBooleanType = this.context.getWasmSymbols().getIrBuiltIns().getBooleanType();
        IrSimpleFunction irSimpleFunction = ((IrProperty)this.context.getWasmSymbols().isNotFirstWasmExportCall$backend_wasm().getOwner()).getGetter();
        Intrinsics.checkNotNull((Object)irSimpleFunction);
        this.isNotFirstWasmExportCallGetter = irSimpleFunction.getSymbol();
        IrSimpleFunction irSimpleFunction2 = ((IrProperty)this.context.getWasmSymbols().isNotFirstWasmExportCall$backend_wasm().getOwner()).getSetter();
        Intrinsics.checkNotNull((Object)irSimpleFunction2);
        this.isNotFirstWasmExportCallSetter = irSimpleFunction2.getSymbol();
    }

    @NotNull
    public final WasmBackendContext getContext() {
        return this.context;
    }

    private final IrSimpleFunctionSymbol getInvokeOnExportedFunctionExit() {
        return this.context.getWasmSymbols().getInvokeOnExportedFunctionExit();
    }

    /*
     * WARNING - void declaration
     */
    private final void processExportFunction(IrFunction irFunction) {
        void this_$iv$iv;
        void $this$irComposite_u24default$iv;
        void this_$iv$iv2;
        IrType irType;
        IrBody irBody;
        void this_$iv;
        IrBody irBody2 = irFunction.getBody();
        if (irBody2 == null) {
            return;
        }
        IrBody body2 = irBody2;
        if (body2 instanceof IrBlockBody && ((IrBlockBody)body2).getStatements().isEmpty()) {
            return;
        }
        WasmBackendContext wasmBackendContext = this.context;
        IrFile irFile$iv = IrUtilsKt.getFile(irFunction);
        boolean $i$f$applyIfDefined = false;
        WasmBackendContext.CrossFileContext crossFileContext = this_$iv.getFileContexts().get(irFile$iv);
        if (crossFileContext != null) {
            WasmBackendContext.CrossFileContext crossFileContext2;
            WasmBackendContext.CrossFileContext it = crossFileContext2 = crossFileContext;
            boolean bl = false;
            if (CollectionsKt.contains((Iterable)it.getClosureCallExports().values(), (Object)irFunction)) {
                return;
            }
        }
        if ((irBody = body2) instanceof IrExpressionBody) {
            irType = ((IrExpressionBody)body2).getExpression().getType();
        } else if (irBody instanceof IrBlockBody) {
            irType = this.context.getIrBuiltIns().getUnitType();
        } else {
            if (irBody instanceof IrSyntheticBody) {
                org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.syntheticBodyIsNotSupported(irFunction);
                throw new KotlinNothingValueException();
            }
            throw new NoWhenBranchMatchedException();
        }
        IrType bodyType = irType;
        DeclarationIrBuilder $this$processExportFunction_u24lambda_u245 = LowerUtilsKt.createIrBuilder$default(this.context, (IrSymbol)irFunction.getSymbol(), 0, 0, 6, null);
        boolean bl = false;
        IrDeclarationParent irDeclarationParent = irFunction;
        IrDeclarationOrigin irDeclarationOrigin = IrDeclarationOrigin.Companion.getIR_TEMPORARY_VARIABLE();
        Name name2 = Name.identifier("currentIsNotFirstWasmExportCall");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        IrVariable currentIsNotFirstWasmExportCall = DeclarationBuildersKt.buildVariable$default(irDeclarationParent, -1, -1, irDeclarationOrigin, name2, this.irBooleanType, false, false, false, 448, null);
        currentIsNotFirstWasmExportCall.setInitializer(ExpressionHelpersKt.irGet($this$processExportFunction_u24lambda_u245, this.irBooleanType, null, this.isNotFirstWasmExportCallGetter));
        IrBuilderWithScope $this$irComposite_u24default$iv2 = $this$processExportFunction_u24lambda_u245;
        int startOffset$iv22 = $this$irComposite_u24default$iv2.getStartOffset();
        int endOffset$iv = $this$irComposite_u24default$iv2.getEndOffset();
        IrStatementOrigin origin$iv = null;
        IrType resultType$iv = null;
        boolean $i$f$irComposite = false;
        IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irComposite_u24default$iv2.getContext(), $this$irComposite_u24default$iv2.getScope(), startOffset$iv22, endOffset$iv, origin$iv, resultType$iv, true);
        boolean $i$f$block22 = false;
        void $this$processExportFunction_u24lambda_u245_u24lambda_u241 = this_$iv$iv2;
        boolean bl2 = false;
        $this$processExportFunction_u24lambda_u245_u24lambda_u241.unaryPlus(ExpressionHelpersKt.irSet((IrBuilderWithScope)$this$processExportFunction_u24lambda_u245_u24lambda_u241, ((IrSimpleFunction)this.isNotFirstWasmExportCallSetter.getOwner()).getReturnType(), null, this.isNotFirstWasmExportCallSetter, IrUtilsKt.toIrConst$default(true, this.irBooleanType, 0, 0, 6, null)));
        $this$processExportFunction_u24lambda_u245_u24lambda_u241.unaryPlus(IrUtilsKt.getStatements(body2));
        IrExpression tryBody = this_$iv$iv2.doBuild();
        IrBuilderWithScope startOffset$iv22 = $this$processExportFunction_u24lambda_u245;
        IrType resultType$iv2 = $this$processExportFunction_u24lambda_u245.getContext().getIrBuiltIns().getUnitType();
        int startOffset$iv = $this$irComposite_u24default$iv.getStartOffset();
        int endOffset$iv2 = $this$irComposite_u24default$iv.getEndOffset();
        IrStatementOrigin origin$iv2 = null;
        boolean $i$f$irComposite2 = false;
        IrBlockBuilder $i$f$block22 = new IrBlockBuilder($this$irComposite_u24default$iv.getContext(), $this$irComposite_u24default$iv.getScope(), startOffset$iv, endOffset$iv2, origin$iv2, resultType$iv2, true);
        boolean $i$f$block = false;
        IrBlockBuilder $this$processExportFunction_u24lambda_u245_u24lambda_u242 = this_$iv$iv;
        boolean bl3 = false;
        $this$processExportFunction_u24lambda_u245_u24lambda_u242.unaryPlus(ExpressionHelpersKt.irSet($this$processExportFunction_u24lambda_u245_u24lambda_u242, ((IrSimpleFunction)this.isNotFirstWasmExportCallSetter.getOwner()).getReturnType(), null, this.isNotFirstWasmExportCallSetter, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$processExportFunction_u24lambda_u245_u24lambda_u242, currentIsNotFirstWasmExportCall, this.irBooleanType)));
        $this$processExportFunction_u24lambda_u245_u24lambda_u242.unaryPlus(ExpressionHelpersKt.irIfThen$default($this$processExportFunction_u24lambda_u245_u24lambda_u242, $this$processExportFunction_u24lambda_u245_u24lambda_u242.getContext().getIrBuiltIns().getUnitType(), LowerUtilsKt.irNot($this$processExportFunction_u24lambda_u245_u24lambda_u242, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$processExportFunction_u24lambda_u245_u24lambda_u242, currentIsNotFirstWasmExportCall, this.irBooleanType)), ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$processExportFunction_u24lambda_u245_u24lambda_u242, this.getInvokeOnExportedFunctionExit()), null, 8, null));
        IrExpression irExpression = this_$iv$iv.doBuild();
        IrTryImpl tryWrap = ExpressionHelpersKt.irTry($this$processExportFunction_u24lambda_u245, bodyType, tryBody, CollectionsKt.emptyList(), irExpression);
        IrBody irBody3 = body2;
        if (irBody3 instanceof IrExpressionBody) {
            void $this$processExportFunction_u24lambda_u245_u24lambda_u243;
            void this_$iv$iv3;
            IrBuilderWithScope $this$irComposite_u24default$iv3 = $this$processExportFunction_u24lambda_u245;
            int startOffset$iv3 = $this$irComposite_u24default$iv3.getStartOffset();
            int endOffset$iv3 = $this$irComposite_u24default$iv3.getEndOffset();
            IrStatementOrigin origin$iv3 = null;
            IrType resultType$iv3 = null;
            boolean $i$f$irComposite3 = false;
            $this$processExportFunction_u24lambda_u245_u24lambda_u242 = new IrBlockBuilder($this$irComposite_u24default$iv3.getContext(), $this$irComposite_u24default$iv3.getScope(), startOffset$iv3, endOffset$iv3, origin$iv3, resultType$iv3, true);
            boolean $i$f$block3 = false;
            void var20_36 = this_$iv$iv3;
            IrExpressionBody irExpressionBody = (IrExpressionBody)body2;
            boolean bl4 = false;
            $this$processExportFunction_u24lambda_u245_u24lambda_u243.unaryPlus(currentIsNotFirstWasmExportCall);
            $this$processExportFunction_u24lambda_u245_u24lambda_u243.unaryPlus(tryWrap);
            irExpressionBody.setExpression(this_$iv$iv3.doBuild());
        } else if (irBody3 instanceof IrBlockBody) {
            List<IrStatement> $this$processExportFunction_u24lambda_u245_u24lambda_u244 = ((IrBlockBody)body2).getStatements();
            boolean bl5 = false;
            $this$processExportFunction_u24lambda_u245_u24lambda_u244.clear();
            $this$processExportFunction_u24lambda_u245_u24lambda_u244.add(currentIsNotFirstWasmExportCall);
            $this$processExportFunction_u24lambda_u245_u24lambda_u244.add(tryWrap);
        } else {
            if (irBody3 instanceof IrSyntheticBody) {
                org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.syntheticBodyIsNotSupported(irFunction);
                throw new KotlinNothingValueException();
            }
            throw new NoWhenBranchMatchedException();
        }
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        if (this.context.isWasmJsTarget()) {
            return;
        }
        for (IrDeclaration declaration : irFile.getDeclarations()) {
            if (!(declaration instanceof IrFunction) || !DeclarationGeneratorKt.isExported((IrFunction)declaration) && !Intrinsics.areEqual((Object)declaration, (Object)this.context.getFileContext(irFile).getMainFunctionWrapper())) continue;
            this.processExportFunction((IrFunction)declaration);
        }
    }
}

