/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.konan.serialization;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.serialization.CompatibilityMode;
import org.jetbrains.kotlin.backend.common.serialization.DeclarationTable;
import org.jetbrains.kotlin.backend.common.serialization.IrFileSerializer;
import org.jetbrains.kotlin.backend.konan.serialization.KonanFakeOverrideClassFilter;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.NativeRuntimeNames;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/backend/konan/serialization/KonanIrFileSerializer;", "Lorg/jetbrains/kotlin/backend/common/serialization/IrFileSerializer;", "declarationTable", "Lorg/jetbrains/kotlin/backend/common/serialization/DeclarationTable;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "bodiesOnlyForInlines", "", "compatibilityMode", "Lorg/jetbrains/kotlin/backend/common/serialization/CompatibilityMode;", "normalizeAbsolutePaths", "sourceBaseDirs", "", "", "publicAbiOnly", "<init>", "(Lorg/jetbrains/kotlin/backend/common/serialization/DeclarationTable;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;ZLorg/jetbrains/kotlin/backend/common/serialization/CompatibilityMode;ZLjava/util/Collection;Z)V", "backendSpecificExplicitRoot", "node", "Lorg/jetbrains/kotlin/ir/declarations/IrAnnotationContainer;", "backendSpecificSerializeAllMembers", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "ir.serialization.native"})
public final class KonanIrFileSerializer
extends IrFileSerializer {
    public KonanIrFileSerializer(@NotNull DeclarationTable declarationTable, @NotNull LanguageVersionSettings languageVersionSettings, boolean bodiesOnlyForInlines, @NotNull CompatibilityMode compatibilityMode, boolean normalizeAbsolutePaths, @NotNull Collection<String> sourceBaseDirs, boolean publicAbiOnly) {
        Intrinsics.checkNotNullParameter((Object)declarationTable, (String)"declarationTable");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkNotNullParameter((Object)compatibilityMode, (String)"compatibilityMode");
        Intrinsics.checkNotNullParameter(sourceBaseDirs, (String)"sourceBaseDirs");
        super(declarationTable, compatibilityMode, languageVersionSettings, bodiesOnlyForInlines, normalizeAbsolutePaths, publicAbiOnly, sourceBaseDirs);
    }

    public /* synthetic */ KonanIrFileSerializer(DeclarationTable declarationTable, LanguageVersionSettings languageVersionSettings, boolean bl, CompatibilityMode compatibilityMode, boolean bl2, Collection collection, boolean bl3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 0x40) != 0) {
            bl3 = false;
        }
        this(declarationTable, languageVersionSettings, bl, compatibilityMode, bl2, collection, bl3);
    }

    @Override
    public boolean backendSpecificExplicitRoot(@NotNull IrAnnotationContainer node) {
        ClassId classId;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        IrAnnotationContainer irAnnotationContainer = node;
        if (irAnnotationContainer instanceof IrFunction) {
            classId = NativeRuntimeNames.Annotations.INSTANCE.getExportForCppRuntimeClassId();
        } else if (irAnnotationContainer instanceof IrClass) {
            classId = NativeRuntimeNames.Annotations.INSTANCE.getExportTypeInfoClassId();
        } else {
            return false;
        }
        ClassId classId2 = classId;
        return IrUtilsKt.hasAnnotation(node, classId2);
    }

    @Override
    public boolean backendSpecificSerializeAllMembers(@NotNull IrClass irClass) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        return !KonanFakeOverrideClassFilter.INSTANCE.needToConstructFakeOverrides(irClass);
    }
}

