/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.JsCommonBackendContext;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.JsLoweredDeclarationOrigin;
import org.jetbrains.kotlin.ir.backend.js.export.ExportModelGeneratorKt;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0012\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\n\u0010\t\u001a\u00020\u0005*\u00020\u0006\u001a\n\u0010\n\u001a\u00020\u0005*\u00020\u000b\u001a\u0012\u0010\u000f\u001a\u00020\u0010*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u001a\n\u0010\u0014\u001a\u00020\u0015*\u00020\u0016\u001a\n\u0010\u0017\u001a\u00020\u0018*\u00020\u0016\u001a\n\u0010\u001c\u001a\u00020\u0005*\u00020\u000b\u001a\u000e\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013\"\u0015\u0010\f\u001a\u00020\u0005*\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000e\"\u0015\u0010\u0019\u001a\u00020\u0005*\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001e"}, d2={"TODO", "", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "hasStableJsName", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "isEqualsInheritedFromAny", "hasStaticDispatch", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "isDispatchReceiver", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "(Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;)Z", "prependFunctionCall", "", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "findUnitGetInstanceFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "Lorg/jetbrains/kotlin/ir/backend/js/JsCommonBackendContext;", "findUnitInstanceField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "compileSuspendAsJsGenerator", "getCompileSuspendAsJsGenerator", "(Lorg/jetbrains/kotlin/ir/backend/js/JsCommonBackendContext;)Z", "isImportedFromModuleOnly", "invokeFunForLambda", "backend.js"})
public final class MiscKt {
    @NotNull
    public static final Void TODO(@NotNull IrElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String string2 = element.getClass().getSimpleName() + " is not supported yet here";
        throw new NotImplementedError("An operation is not implemented: " + string2);
    }

    public static final boolean hasStableJsName(@NotNull IrFunction $this$hasStableJsName, @NotNull JsIrBackendContext context) {
        boolean bl;
        block11: {
            block10: {
                Intrinsics.checkNotNullParameter((Object)$this$hasStableJsName, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                if (Intrinsics.areEqual((Object)$this$hasStableJsName.getOrigin(), (Object)JsLoweredDeclarationOrigin.INSTANCE.getBRIDGE_WITH_STABLE_NAME())) break block10;
                IrSimpleFunction irSimpleFunction = $this$hasStableJsName instanceof IrSimpleFunction ? (IrSimpleFunction)$this$hasStableJsName : null;
                boolean bl2 = irSimpleFunction != null ? IrUtilsKt.isMethodOfAny(irSimpleFunction) : false;
                if (!bl2) break block11;
            }
            return true;
        }
        if (Intrinsics.areEqual((Object)$this$hasStableJsName.getOrigin(), (Object)JsLoweredDeclarationOrigin.INSTANCE.getJS_SHADOWED_EXPORT()) || Intrinsics.areEqual((Object)$this$hasStableJsName.getOrigin(), (Object)JsLoweredDeclarationOrigin.INSTANCE.getBRIDGE_WITHOUT_STABLE_NAME()) || Intrinsics.areEqual((Object)$this$hasStableJsName.getOrigin(), (Object)JsLoweredDeclarationOrigin.INSTANCE.getBRIDGE_PROPERTY_ACCESSOR())) {
            return false;
        }
        IrFunction irFunction = $this$hasStableJsName;
        if (irFunction instanceof IrSimpleFunction) {
            IrProperty owner;
            IrPropertySymbol irPropertySymbol = ((IrSimpleFunction)$this$hasStableJsName).getCorrespondingPropertySymbol();
            IrProperty irProperty = owner = irPropertySymbol != null ? (IrProperty)irPropertySymbol.getOwner() : null;
            if (owner == null) {
                bl = true;
            } else {
                IrSimpleFunction irSimpleFunction = owner.getGetter();
                bl = (irSimpleFunction != null ? AnnotationUtilsKt.getJsName(irSimpleFunction) : null) != null;
            }
        } else if (irFunction instanceof IrConstructor) {
            bl = true;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        boolean namedOrMissingGetter = bl;
        return (IrUtilsKt.isEffectivelyExternal($this$hasStableJsName) || AnnotationUtilsKt.getJsName($this$hasStableJsName) != null || ExportModelGeneratorKt.isExported($this$hasStableJsName, context)) && namedOrMissingGetter;
    }

    public static final boolean isEqualsInheritedFromAny(@NotNull IrFunction $this$isEqualsInheritedFromAny) {
        Intrinsics.checkNotNullParameter((Object)$this$isEqualsInheritedFromAny, (String)"<this>");
        return Intrinsics.areEqual((Object)$this$isEqualsInheritedFromAny.getName(), (Object)OperatorNameConventions.EQUALS) && $this$isEqualsInheritedFromAny.getDispatchReceiverParameter() != null && $this$isEqualsInheritedFromAny.getExtensionReceiverParameter() == null && $this$isEqualsInheritedFromAny.getValueParameters().size() == 1 && IrTypePredicatesKt.isNullableAny($this$isEqualsInheritedFromAny.getValueParameters().get(0).getType());
    }

    public static final boolean hasStaticDispatch(@NotNull IrDeclaration $this$hasStaticDispatch) {
        Intrinsics.checkNotNullParameter((Object)$this$hasStaticDispatch, (String)"<this>");
        IrDeclaration irDeclaration2 = $this$hasStaticDispatch;
        return irDeclaration2 instanceof IrSimpleFunction ? ((IrSimpleFunction)$this$hasStaticDispatch).getDispatchReceiverParameter() == null : (irDeclaration2 instanceof IrProperty ? AdditionalIrUtilsKt.isTopLevelDeclaration($this$hasStaticDispatch) : (irDeclaration2 instanceof IrField ? ((IrField)$this$hasStaticDispatch).isStatic() : true));
    }

    public static final boolean isDispatchReceiver(@NotNull IrValueDeclaration $this$isDispatchReceiver) {
        Intrinsics.checkNotNullParameter((Object)$this$isDispatchReceiver, (String)"<this>");
        IrDeclarationParent parent2 = $this$isDispatchReceiver.getParent();
        if (parent2 instanceof IrClass) {
            return true;
        }
        return parent2 instanceof IrFunction && Intrinsics.areEqual((Object)((IrFunction)parent2).getDispatchReceiverParameter(), (Object)$this$isDispatchReceiver);
    }

    public static final void prependFunctionCall(@NotNull IrBody $this$prependFunctionCall, @NotNull IrCall call2) {
        Intrinsics.checkNotNullParameter((Object)$this$prependFunctionCall, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
        IrBody irBody = $this$prependFunctionCall;
        if (irBody instanceof IrExpressionBody) {
            Object[] objectArray = new IrExpression[]{call2, ((IrExpressionBody)$this$prependFunctionCall).getExpression()};
            ((IrExpressionBody)$this$prependFunctionCall).setExpression(JsIrBuilder.INSTANCE.buildComposite(((IrExpressionBody)$this$prependFunctionCall).getExpression().getType(), CollectionsKt.listOf((Object[])objectArray)));
        } else if (irBody instanceof IrBlockBody) {
            ((IrBlockBody)$this$prependFunctionCall).getStatements().add(0, call2);
        } else if (!(irBody instanceof IrSyntheticBody)) {
            throw new NoWhenBranchMatchedException();
        }
    }

    @NotNull
    public static final IrSimpleFunction findUnitGetInstanceFunction(@NotNull JsCommonBackendContext $this$findUnitGetInstanceFunction) {
        Intrinsics.checkNotNullParameter((Object)$this$findUnitGetInstanceFunction, (String)"<this>");
        IrSimpleFunction irSimpleFunction = $this$findUnitGetInstanceFunction.getMapping().getObjectToGetInstanceFunction().get((IrClass)((IrDeclaration)$this$findUnitGetInstanceFunction.getIrBuiltIns().getUnitClass().getOwner()));
        Intrinsics.checkNotNull((Object)irSimpleFunction);
        return irSimpleFunction;
    }

    @NotNull
    public static final IrField findUnitInstanceField(@NotNull JsCommonBackendContext $this$findUnitInstanceField) {
        Intrinsics.checkNotNullParameter((Object)$this$findUnitInstanceField, (String)"<this>");
        IrField irField = $this$findUnitInstanceField.getMapping().getObjectToInstanceField().get((IrClass)((IrDeclaration)$this$findUnitInstanceField.getIrBuiltIns().getUnitClass().getOwner()));
        Intrinsics.checkNotNull((Object)irField);
        return irField;
    }

    public static final boolean getCompileSuspendAsJsGenerator(@NotNull JsCommonBackendContext $this$compileSuspendAsJsGenerator) {
        Intrinsics.checkNotNullParameter((Object)$this$compileSuspendAsJsGenerator, (String)"<this>");
        return $this$compileSuspendAsJsGenerator instanceof JsIrBackendContext && Intrinsics.areEqual((Object)((JsIrBackendContext)$this$compileSuspendAsJsGenerator).getConfiguration().get(JSConfigurationKeys.COMPILE_SUSPEND_AS_JS_GENERATOR), (Object)true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isImportedFromModuleOnly(@NotNull IrDeclaration $this$isImportedFromModuleOnly) {
        IrDeclarationParent irDeclarationParent;
        Intrinsics.checkNotNullParameter((Object)$this$isImportedFromModuleOnly, (String)"<this>");
        if (!IrUtilsKt.isTopLevel($this$isImportedFromModuleOnly)) return false;
        if (!IrUtilsKt.isEffectivelyExternal($this$isImportedFromModuleOnly)) return false;
        if (AnnotationUtilsKt.getJsModule($this$isImportedFromModuleOnly) != null) {
            if (!AnnotationUtilsKt.isJsNonModule($this$isImportedFromModuleOnly)) return true;
        }
        if (!((irDeclarationParent = $this$isImportedFromModuleOnly.getParent()) instanceof IrAnnotationContainer)) return false;
        IrAnnotationContainer irAnnotationContainer = (IrAnnotationContainer)((Object)irDeclarationParent);
        if (irAnnotationContainer == null) return false;
        String string2 = AnnotationUtilsKt.getJsModule(irAnnotationContainer);
        if (string2 == null) return false;
        return true;
    }

    @NotNull
    public static final IrSimpleFunction invokeFunForLambda(@NotNull IrCall call2) {
        Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
        IrExpression irExpression = call2.getExtensionReceiver();
        Intrinsics.checkNotNull((Object)irExpression);
        IrClass irClass = IrTypesKt.getClass(irExpression.getType());
        Intrinsics.checkNotNull((Object)irClass);
        IrSimpleFunction irSimpleFunction = IrUtilsKt.getInvokeFun(irClass);
        Intrinsics.checkNotNull((Object)irSimpleFunction);
        return irSimpleFunction;
    }
}

