/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.build.report.ICReporter;
import org.jetbrains.kotlin.incremental.BuildUtilKt;
import org.jetbrains.kotlin.incremental.FileUtilsKt;
import org.jetbrains.kotlin.incremental.IncrementalCachesManager;
import org.jetbrains.kotlin.incremental.LookupSymbol;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B)\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\r0\u0012j\b\u0012\u0004\u0012\u00020\r`\u0013J\u001e\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\bJ\u0014\u0010\u0019\u001a\u00020\u00152\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bJ\u0014\u0010\u001d\u001a\u00020\u00152\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001bR\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r0\fj\b\u0012\u0004\u0012\u00020\r`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/incremental/DirtyFilesContainer;", "", "caches", "Lorg/jetbrains/kotlin/incremental/IncrementalCachesManager;", "reporter", "Lorg/jetbrains/kotlin/build/report/ICReporter;", "sourceFilesExtensions", "", "", "<init>", "(Lorg/jetbrains/kotlin/incremental/IncrementalCachesManager;Lorg/jetbrains/kotlin/build/report/ICReporter;Ljava/util/Set;)V", "myDirtyFiles", "Ljava/util/HashSet;", "Ljava/io/File;", "Lkotlin/collections/HashSet;", "isEmpty", "", "toMutableLinkedSet", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "add", "", "files", "", "reason", "addByDirtySymbols", "lookupSymbols", "", "Lorg/jetbrains/kotlin/incremental/LookupSymbol;", "addByDirtyClasses", "dirtyClassesFqNames", "Lorg/jetbrains/kotlin/name/FqName;", "incremental-compilation-impl"})
@SourceDebugExtension(value={"SMAP\nDirtyFilesContainer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DirtyFilesContainer.kt\norg/jetbrains/kotlin/incremental/DirtyFilesContainer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,57:1\n774#2:58\n865#2,2:59\n1368#2:61\n1454#2,5:62\n*S KotlinDebug\n*F\n+ 1 DirtyFilesContainer.kt\norg/jetbrains/kotlin/incremental/DirtyFilesContainer\n*L\n25#1:58\n25#1:59,2\n45#1:61\n45#1:62,5\n*E\n"})
public final class DirtyFilesContainer {
    @NotNull
    private final IncrementalCachesManager<?> caches;
    @NotNull
    private final ICReporter reporter;
    @NotNull
    private final Set<String> sourceFilesExtensions;
    @NotNull
    private final HashSet<File> myDirtyFiles;

    public DirtyFilesContainer(@NotNull IncrementalCachesManager<?> caches, @NotNull ICReporter reporter, @NotNull Set<String> sourceFilesExtensions) {
        Intrinsics.checkNotNullParameter(caches, (String)"caches");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter(sourceFilesExtensions, (String)"sourceFilesExtensions");
        this.caches = caches;
        this.reporter = reporter;
        this.sourceFilesExtensions = sourceFilesExtensions;
        this.myDirtyFiles = new HashSet();
    }

    public final boolean isEmpty() {
        return this.myDirtyFiles.isEmpty();
    }

    @NotNull
    public final LinkedHashSet<File> toMutableLinkedSet() {
        return new LinkedHashSet<File>((Collection)this.myDirtyFiles);
    }

    /*
     * WARNING - void declaration
     */
    public final void add(@NotNull Iterable<? extends File> files2, @Nullable String reason) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        Iterable<? extends File> $this$filter$iv = files2;
        boolean $i$f$filter = false;
        Iterable<? extends File> iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File it = (File)element$iv$iv;
            boolean bl = false;
            if (!FileUtilsKt.isKotlinFile(it, (Collection<String>)this.sourceFilesExtensions)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List existingKotlinFiles = (List)destination$iv$iv;
        if (!((Collection)existingKotlinFiles).isEmpty()) {
            this.myDirtyFiles.addAll(existingKotlinFiles);
            if (reason != null) {
                this.reporter.reportMarkDirty(existingKotlinFiles, reason);
            }
        }
    }

    public final void addByDirtySymbols(@NotNull Collection<LookupSymbol> lookupSymbols) {
        Intrinsics.checkNotNullParameter(lookupSymbols, (String)"lookupSymbols");
        if (lookupSymbols.isEmpty()) {
            return;
        }
        Set dirtyFilesFromLookups = BuildUtilKt.mapLookupSymbolsToFiles$default(this.caches.getLookupCache(), lookupSymbols, this.reporter, null, 8, null);
        this.add(dirtyFilesFromLookups, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void addByDirtyClasses(@NotNull Collection<FqName> dirtyClassesFqNames) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(dirtyClassesFqNames, (String)"dirtyClassesFqNames");
        if (dirtyClassesFqNames.isEmpty()) {
            return;
        }
        Iterable $this$flatMap$iv = dirtyClassesFqNames;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            FqName it = (FqName)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = BuildUtilKt.withSubtypes(it, CollectionsKt.listOf(this.caches.getPlatformCache()));
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List fqNamesWithSubtypes = (List)destination$iv$iv;
        Set dirtyFilesFromFqNames = BuildUtilKt.mapClassesFqNamesToFiles$default(CollectionsKt.listOf(this.caches.getPlatformCache()), fqNamesWithSubtypes, this.reporter, null, 8, null);
        this.add(dirtyFilesFromFqNames, null);
    }
}

