/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.type;

import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirAnnotationHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.type.FirTypeChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FunctionalTypeUtilsKt;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirTypeAnnotationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirTypeChecker;", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirResolvedTypeRefChecker;", "<init>", "()V", "check", "", "typeRef", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirTypeAnnotationChecker
extends FirTypeChecker<FirResolvedTypeRef> {
    @NotNull
    public static final FirTypeAnnotationChecker INSTANCE = new FirTypeAnnotationChecker();

    private FirTypeAnnotationChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirResolvedTypeRef typeRef, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)typeRef, (String)"typeRef");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        for (FirAnnotation annotation : typeRef.getAnnotations()) {
            if (annotation.getSource() == null) continue;
            AnnotationUseSiteTarget useSiteTarget = annotation.getUseSiteTarget();
            Set<KotlinTarget> annotationTargets = FirAnnotationHelpersKt.getAllowedAnnotationTargets(annotation, context.getSession());
            if (useSiteTarget != null) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getWRONG_ANNOTATION_TARGET_WITH_USE_SITE_TARGET(), (Object)"type usage", (Object)useSiteTarget.getRenderName(), annotationTargets, (DiagnosticContext)context, null, 64, null);
            } else if (!annotationTargets.contains((Object)KotlinTarget.TYPE)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getWRONG_ANNOTATION_TARGET(), (Object)"type usage", annotationTargets, (DiagnosticContext)context, null, 32, null);
            }
            if (!Intrinsics.areEqual((Object)FirAnnotationUtilsKt.toAnnotationClassId(annotation, context.getSession()), (Object)StandardClassIds.Annotations.INSTANCE.getExtensionFunctionType())) continue;
            if (!FunctionalTypeUtilsKt.isSomeFunctionType(typeRef.getConeType(), context.getSession())) {
                if (context.getLanguageVersionSettings().supportsFeature(LanguageFeature.ForbidExtensionFunctionTypeOnNonFunctionTypes)) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getWRONG_EXTENSION_FUNCTION_TYPE(), (DiagnosticContext)context, null, 8, null);
                    continue;
                }
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getWRONG_EXTENSION_FUNCTION_TYPE_WARNING(), (DiagnosticContext)context, null, 8, null);
                continue;
            }
            if (typeRef.getConeType().getTypeArguments().length > 1) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getWRONG_EXTENSION_FUNCTION_TYPE(), (DiagnosticContext)context, null, 8, null);
        }
    }
}

