/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.native.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.native.FirNativeErrors;
import org.jetbrains.kotlin.fir.backend.native.interop.FirObjCInteropKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.NativeStandardInteropNames;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCActionChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.native"})
@SourceDebugExtension(value={"SMAP\nFirNativeObjCActionChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirNativeObjCActionChecker.kt\norg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCActionChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,70:1\n37#2:71\n1863#3,2:72\n*S KotlinDebug\n*F\n+ 1 FirNativeObjCActionChecker.kt\norg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCActionChecker\n*L\n65#1:71\n45#1:72,2\n*E\n"})
public final class FirNativeObjCActionChecker
extends FirDeclarationChecker<FirClass> {
    @NotNull
    public static final FirNativeObjCActionChecker INSTANCE = new FirNativeObjCActionChecker();

    private FirNativeObjCActionChecker() {
        super(MppCheckerKind.Platform);
    }

    @Override
    public void check(@NotNull FirClass declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirSession session2 = context2.getSession();
        FirMemberDeclaration $this$isExpect$iv = declaration;
        boolean $i$f$isExpect = false;
        if (!$this$isExpect$iv.getStatus().isExpect() && FirObjCInteropKt.isKotlinObjCClass(declaration.getSymbol(), context2.getSession())) {
            FirNativeObjCActionChecker.check$checkKotlinObjCClass(session2, reporter, context2, declaration);
        }
    }

    private static final void check$checkCanGenerateFunctionImp(DiagnosticReporter $reporter, CheckerContext $context, FirSimpleFunction function2) {
        if (function2.getValueParameters().size() > 2) {
            KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)function2.getSource(), FirNativeErrors.INSTANCE.getTWO_OR_LESS_PARAMETERS_ARE_SUPPORTED_HERE(), (DiagnosticContext)$context, null, 8, null);
        }
    }

    private static final void check$checkCanGenerateActionImp(DiagnosticReporter $reporter, CheckerContext $context, FirSession session2, FirSimpleFunction function2) {
        String action = '@' + NativeStandardInteropNames.INSTANCE.getObjCActionClassId().asFqNameString();
        FirReceiverParameter firReceiverParameter = function2.getReceiverParameter();
        if (firReceiverParameter != null) {
            FirReceiverParameter it = firReceiverParameter;
            boolean bl = false;
            KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)it.getSource(), FirNativeErrors.INSTANCE.getMUST_NOT_HAVE_EXTENSION_RECEIVER(), (Object)(action + " method"), (DiagnosticContext)$context, null, 16, null);
        }
        Iterable $this$forEach$iv = function2.getValueParameters();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirValueParameter it = (FirValueParameter)element$iv;
            boolean bl = false;
            FirTypeRef kotlinType = it.getReturnTypeRef();
            if (FirObjCInteropKt.isObjCObjectType(kotlinType, session2)) continue;
            KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)it.getSource(), FirNativeErrors.INSTANCE.getMUST_BE_OBJC_OBJECT_TYPE(), (Object)(action + " method parameter type"), (Object)FirTypeUtilsKt.getConeType(kotlinType), (DiagnosticContext)$context, null, 32, null);
        }
        FirTypeRef returnType = function2.getReturnTypeRef();
        if (!FirTypeUtilsKt.isUnit(returnType)) {
            KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)function2.getSource(), FirNativeErrors.INSTANCE.getMUST_BE_UNIT_TYPE(), (Object)(action + " method return type"), (Object)FirTypeUtilsKt.getConeType(returnType), (DiagnosticContext)$context, null, 32, null);
        }
        FirNativeObjCActionChecker.check$checkCanGenerateFunctionImp($reporter, $context, function2);
    }

    private static final void check$checkKotlinObjCClass(FirSession session2, DiagnosticReporter $reporter, CheckerContext $context, FirClass firClass) {
        for (FirDeclaration decl : firClass.getDeclarations()) {
            if (!(decl instanceof FirSimpleFunction) || !FirAnnotationUtilsKt.hasAnnotation(((FirSimpleFunction)decl).getAnnotations(), NativeStandardInteropNames.INSTANCE.getObjCActionClassId(), session2)) continue;
            FirNativeObjCActionChecker.check$checkCanGenerateActionImp($reporter, $context, session2, (FirSimpleFunction)decl);
        }
    }
}

