/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.java.impl;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.registry.Registry;
import org.jetbrains.kotlin.com.intellij.util.containers.CollectionFactory;

public final class JavaSdkUtil {
    @NotNull
    public static List<Path> getJdkClassesRoots(@NotNull Path home, boolean isJre) {
        Path classesDir;
        Path path;
        Path[] jarDirs;
        Path libDir;
        if (home == null) {
            JavaSdkUtil.$$$reportNull$$$0(2);
        }
        if ("Home".equals(home.getFileName().toString()) && Files.exists(home.resolve("../Classes/classes.jar"), new LinkOption[0])) {
            libDir = home.resolve("lib");
            Path classesDir2 = home.resolveSibling("Classes");
            Path path2 = libDir.resolve("ext");
            Path libEndorsedDir = libDir.resolve("endorsed");
            jarDirs = new Path[]{libEndorsedDir, libDir, classesDir2, path2};
        } else if (Files.exists(home.resolve("lib/jrt-fs.jar"), new LinkOption[0])) {
            jarDirs = new Path[]{};
        } else {
            libDir = home.resolve(isJre ? "lib" : "jre/lib");
            Path libExtDir = libDir.resolve("ext");
            Path path3 = libDir.resolve("endorsed");
            jarDirs = new Path[]{path3, libDir, libExtDir};
        }
        Set<String> pathFilter = CollectionFactory.createFilePathSet();
        ArrayList<Path> rootFiles = new ArrayList<Path>();
        if (Registry.is("project.structure.add.tools.jar.to.new.jdk", false) && Files.isRegularFile(path = home.resolve("lib/tools.jar"), new LinkOption[0])) {
            rootFiles.add(path);
        }
        for (Path jarDir : jarDirs) {
            if (jarDir == null || !Files.isDirectory(jarDir, new LinkOption[0])) continue;
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(jarDir, "*.jar");){
                for (Path jarFile : stream) {
                    String canonicalPath2;
                    String jarFileName = jarFile.getFileName().toString();
                    if (jarFileName.equals("alt-rt.jar") || jarFileName.equals("alt-string.jar") || (canonicalPath2 = JavaSdkUtil.getCanonicalPath(jarFile)) == null || !pathFilter.add(canonicalPath2)) continue;
                    rootFiles.add(jarFile);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        ArrayList<Path> arrayList = new ArrayList<Path>();
        arrayList.add(home.resolve(isJre ? "bin" : "jre/bin"));
        try (DirectoryStream<Path> stream22 = Files.newDirectoryStream(home.resolve(isJre ? "lib" : "jre/lib"), x$0 -> Files.isDirectory(x$0, new LinkOption[0]));){
            Iterator iterator2 = stream22.iterator();
            while (iterator2.hasNext()) {
                Path path4 = (Path)iterator2.next();
                arrayList.add(path4);
            }
        }
        catch (IOException stream22) {
            // empty catch block
        }
        for (Path candidate2 : arrayList) {
            try {
                DirectoryStream<Path> stream = Files.newDirectoryStream(candidate2, p -> p.getFileName().toString().startsWith("jclSC") && Files.isDirectory(p, new LinkOption[0]));
                try {
                    for (Path dir2 : stream) {
                        Path vmJar = dir2.resolve("vm.jar");
                        if (!Files.isRegularFile(vmJar, new LinkOption[0])) continue;
                        rootFiles.add(vmJar);
                    }
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (IOException iOException) {}
        }
        Path classesZip = home.resolve("lib/classes.zip");
        if (Files.isRegularFile(classesZip, new LinkOption[0])) {
            rootFiles.add(classesZip);
        }
        if (rootFiles.isEmpty() && Files.isDirectory(classesDir = home.resolve("classes"), new LinkOption[0])) {
            rootFiles.add(classesDir);
        }
        ArrayList<Path> arrayList2 = rootFiles;
        if (arrayList2 == null) {
            JavaSdkUtil.$$$reportNull$$$0(3);
        }
        return arrayList2;
    }

    @Nullable
    private static String getCanonicalPath(Path file2) {
        try {
            return file2.toRealPath(new LinkOption[0]).toString();
        }
        catch (IOException e) {
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "home";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/model/java/impl/JavaSdkUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/model/java/impl/JavaSdkUtil";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getJdkClassesRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getJdkClassesRoots";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

