/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.jline.reader.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.jetbrains.kotlin.org.jline.reader.CompletingParsedLine;
import org.jetbrains.kotlin.org.jline.reader.EOFError;
import org.jetbrains.kotlin.org.jline.reader.ParsedLine;
import org.jetbrains.kotlin.org.jline.reader.Parser;

public class DefaultParser
implements Parser {
    private char[] quoteChars = new char[]{'\'', '\"'};
    private char[] escapeChars = new char[]{'\\'};
    private boolean eofOnUnclosedQuote;
    private boolean eofOnEscapedNewLine;
    private char[] openingBrackets = null;
    private char[] closingBrackets = null;
    private String[] lineCommentDelims = null;
    private BlockCommentDelims blockCommentDelims = null;
    private String regexVariable = "[a-zA-Z_]+[a-zA-Z0-9_-]*((\\.|\\['|\\[\"|\\[)[a-zA-Z0-9_-]*(|']|\"]|]))?";
    private String regexCommand = "[:]?[a-zA-Z]+[a-zA-Z0-9_-]*";
    private int commandGroup = 4;

    @Override
    public ParsedLine parse(String line, int cursor, Parser.ParseContext context2) {
        LinkedList<String> words = new LinkedList<String>();
        StringBuilder current = new StringBuilder();
        int wordCursor = -1;
        int wordIndex = -1;
        int quoteStart = -1;
        int rawWordCursor = -1;
        int rawWordLength = -1;
        int rawWordStart = 0;
        BracketChecker bracketChecker = new BracketChecker(cursor);
        boolean quotedWord = false;
        boolean lineCommented = false;
        boolean blockCommented = false;
        boolean blockCommentInRightOrder = true;
        String blockCommentEnd = this.blockCommentDelims == null ? null : this.blockCommentDelims.end;
        String blockCommentStart = this.blockCommentDelims == null ? null : this.blockCommentDelims.start;
        for (int i = 0; line != null && i < line.length(); ++i) {
            if (i == cursor) {
                wordIndex = words.size();
                wordCursor = current.length();
                rawWordCursor = i - rawWordStart;
            }
            if (quoteStart < 0 && this.isQuoteChar(line, i) && !lineCommented && !blockCommented) {
                quoteStart = i;
                if (current.length() == 0) {
                    quotedWord = true;
                    if (context2 != Parser.ParseContext.SPLIT_LINE) continue;
                    current.append(line.charAt(i));
                    continue;
                }
                current.append(line.charAt(i));
                continue;
            }
            if (quoteStart >= 0 && line.charAt(quoteStart) == line.charAt(i) && !this.isEscaped(line, i)) {
                if (!quotedWord || context2 == Parser.ParseContext.SPLIT_LINE) {
                    current.append(line.charAt(i));
                } else if (rawWordCursor >= 0 && rawWordLength < 0) {
                    rawWordLength = i - rawWordStart + 1;
                }
                quoteStart = -1;
                quotedWord = false;
                continue;
            }
            if (quoteStart < 0 && this.isDelimiter(line, i)) {
                if (lineCommented) {
                    if (!this.isCommentDelim(line, i, System.lineSeparator())) continue;
                    lineCommented = false;
                    continue;
                }
                if (blockCommented) {
                    if (!this.isCommentDelim(line, i, blockCommentEnd)) continue;
                    blockCommented = false;
                    continue;
                }
                rawWordLength = this.handleDelimiterAndGetRawWordLength(current, words, rawWordStart, rawWordCursor, rawWordLength, i);
                rawWordStart = i + 1;
                continue;
            }
            if (quoteStart < 0 && !blockCommented && (lineCommented || this.isLineCommentStarted(line, i))) {
                lineCommented = true;
                continue;
            }
            if (quoteStart < 0 && !lineCommented && (blockCommented || this.isCommentDelim(line, i, blockCommentStart))) {
                if (blockCommented) {
                    if (blockCommentEnd == null || !this.isCommentDelim(line, i, blockCommentEnd)) continue;
                    blockCommented = false;
                    i += blockCommentEnd.length() - 1;
                    continue;
                }
                blockCommented = true;
                rawWordLength = this.handleDelimiterAndGetRawWordLength(current, words, rawWordStart, rawWordCursor, rawWordLength, i);
                rawWordStart = (i += blockCommentStart == null ? 0 : blockCommentStart.length() - 1) + 1;
                continue;
            }
            if (quoteStart < 0 && !lineCommented && this.isCommentDelim(line, i, blockCommentEnd)) {
                current.append(line.charAt(i));
                blockCommentInRightOrder = false;
                continue;
            }
            if (!this.isEscapeChar(line, i)) {
                current.append(line.charAt(i));
                if (quoteStart >= 0) continue;
                bracketChecker.check(line, i);
                continue;
            }
            if (context2 != Parser.ParseContext.SPLIT_LINE) continue;
            current.append(line.charAt(i));
        }
        if (current.length() > 0 || cursor == line.length()) {
            words.add(current.toString());
            if (rawWordCursor >= 0 && rawWordLength < 0) {
                rawWordLength = line.length() - rawWordStart;
            }
        }
        if (cursor == line.length()) {
            wordIndex = words.size() - 1;
            wordCursor = ((String)words.get(words.size() - 1)).length();
            rawWordLength = rawWordCursor = cursor - rawWordStart;
        }
        if (context2 != Parser.ParseContext.COMPLETE && context2 != Parser.ParseContext.SPLIT_LINE) {
            if (this.eofOnEscapedNewLine && this.isEscapeChar(line, line.length() - 1)) {
                throw new EOFError(-1, -1, "Escaped new line", "newline");
            }
            if (this.eofOnUnclosedQuote && quoteStart >= 0) {
                throw new EOFError(-1, -1, "Missing closing quote", line.charAt(quoteStart) == '\'' ? "quote" : "dquote");
            }
            if (blockCommented) {
                throw new EOFError(-1, -1, "Missing closing block comment delimiter", "add: " + blockCommentEnd);
            }
            if (!blockCommentInRightOrder) {
                throw new EOFError(-1, -1, "Missing opening block comment delimiter", "missing: " + blockCommentStart);
            }
            if (bracketChecker.isClosingBracketMissing() || bracketChecker.isOpeningBracketMissing()) {
                String message = null;
                String missing = null;
                if (bracketChecker.isClosingBracketMissing()) {
                    message = "Missing closing brackets";
                    missing = "add: " + bracketChecker.getMissingClosingBrackets();
                } else {
                    message = "Missing opening bracket";
                    missing = "missing: " + bracketChecker.getMissingOpeningBracket();
                }
                throw new EOFError(-1, -1, message, missing, bracketChecker.getOpenBrackets(), bracketChecker.getNextClosingBracket());
            }
        }
        String openingQuote = quotedWord ? line.substring(quoteStart, quoteStart + 1) : null;
        return new ArgumentList(line, words, wordIndex, wordCursor, cursor, openingQuote, rawWordCursor, rawWordLength);
    }

    public boolean isDelimiter(CharSequence buffer, int pos) {
        return !this.isQuoted(buffer, pos) && !this.isEscaped(buffer, pos) && this.isDelimiterChar(buffer, pos);
    }

    private int handleDelimiterAndGetRawWordLength(StringBuilder current, List<String> words, int rawWordStart, int rawWordCursor, int rawWordLength, int pos) {
        if (current.length() > 0) {
            words.add(current.toString());
            current.setLength(0);
            if (rawWordCursor >= 0 && rawWordLength < 0) {
                return pos - rawWordStart;
            }
        }
        return rawWordLength;
    }

    public boolean isQuoted(CharSequence buffer, int pos) {
        return false;
    }

    public boolean isQuoteChar(CharSequence buffer, int pos) {
        if (pos < 0) {
            return false;
        }
        if (this.quoteChars != null) {
            for (char e : this.quoteChars) {
                if (e != buffer.charAt(pos)) continue;
                return !this.isEscaped(buffer, pos);
            }
        }
        return false;
    }

    private boolean isCommentDelim(CharSequence buffer, int pos, String pattern) {
        int length;
        if (pos < 0) {
            return false;
        }
        if (pattern != null && (length = pattern.length()) <= buffer.length() - pos) {
            for (int i = 0; i < length; ++i) {
                if (pattern.charAt(i) == buffer.charAt(pos + i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isLineCommentStarted(CharSequence buffer, int pos) {
        if (this.lineCommentDelims != null) {
            for (String comment : this.lineCommentDelims) {
                if (!this.isCommentDelim(buffer, pos, comment)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isEscapeChar(char ch) {
        if (this.escapeChars != null) {
            for (char e : this.escapeChars) {
                if (e != ch) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isEscapeChar(CharSequence buffer, int pos) {
        if (pos < 0) {
            return false;
        }
        char ch = buffer.charAt(pos);
        return this.isEscapeChar(ch) && !this.isEscaped(buffer, pos);
    }

    public boolean isEscaped(CharSequence buffer, int pos) {
        if (pos <= 0) {
            return false;
        }
        return this.isEscapeChar(buffer, pos - 1);
    }

    public boolean isDelimiterChar(CharSequence buffer, int pos) {
        return Character.isWhitespace(buffer.charAt(pos));
    }

    private boolean isRawEscapeChar(char key) {
        if (this.escapeChars != null) {
            for (char e : this.escapeChars) {
                if (e != key) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isRawQuoteChar(char key) {
        if (this.quoteChars != null) {
            for (char e : this.quoteChars) {
                if (e != key) continue;
                return true;
            }
        }
        return false;
    }

    public static class BlockCommentDelims {
        private final String start;
        private final String end;
    }

    private class BracketChecker {
        private int missingOpeningBracket = -1;
        private List<Integer> nested = new ArrayList<Integer>();
        private int openBrackets = 0;
        private int cursor;
        private String nextClosingBracket;

        public BracketChecker(int cursor) {
            this.cursor = cursor;
        }

        public void check(CharSequence buffer, int pos) {
            if (DefaultParser.this.openingBrackets == null || pos < 0) {
                return;
            }
            int bid = this.bracketId(DefaultParser.this.openingBrackets, buffer, pos);
            if (bid >= 0) {
                this.nested.add(bid);
            } else {
                bid = this.bracketId(DefaultParser.this.closingBrackets, buffer, pos);
                if (bid >= 0) {
                    if (!this.nested.isEmpty() && bid == this.nested.get(this.nested.size() - 1)) {
                        this.nested.remove(this.nested.size() - 1);
                    } else {
                        this.missingOpeningBracket = bid;
                    }
                }
            }
            if (this.cursor > pos) {
                this.openBrackets = this.nested.size();
                if (this.nested.size() > 0) {
                    this.nextClosingBracket = String.valueOf(DefaultParser.this.closingBrackets[this.nested.get(this.nested.size() - 1)]);
                }
            }
        }

        public boolean isOpeningBracketMissing() {
            return this.missingOpeningBracket != -1;
        }

        public String getMissingOpeningBracket() {
            if (!this.isOpeningBracketMissing()) {
                return null;
            }
            return Character.toString(DefaultParser.this.openingBrackets[this.missingOpeningBracket]);
        }

        public boolean isClosingBracketMissing() {
            return !this.nested.isEmpty();
        }

        public String getMissingClosingBrackets() {
            if (!this.isClosingBracketMissing()) {
                return null;
            }
            StringBuilder out = new StringBuilder();
            for (int i = this.nested.size() - 1; i > -1; --i) {
                out.append(DefaultParser.this.closingBrackets[this.nested.get(i)]);
            }
            return out.toString();
        }

        public int getOpenBrackets() {
            return this.openBrackets;
        }

        public String getNextClosingBracket() {
            return this.nested.size() == 2 ? this.nextClosingBracket : null;
        }

        private int bracketId(char[] brackets, CharSequence buffer, int pos) {
            for (int i = 0; i < brackets.length; ++i) {
                if (buffer.charAt(pos) != brackets[i]) continue;
                return i;
            }
            return -1;
        }
    }

    public class ArgumentList
    implements CompletingParsedLine {
        private final String line;
        private final List<String> words;
        private final int wordIndex;
        private final int wordCursor;
        private final int cursor;
        private final String openingQuote;
        private final int rawWordCursor;
        private final int rawWordLength;

        public ArgumentList(String line, List<String> words, int wordIndex, int wordCursor, int cursor, String openingQuote, int rawWordCursor, int rawWordLength) {
            this.line = line;
            this.words = Collections.unmodifiableList(Objects.requireNonNull(words));
            this.wordIndex = wordIndex;
            this.wordCursor = wordCursor;
            this.cursor = cursor;
            this.openingQuote = openingQuote;
            this.rawWordCursor = rawWordCursor;
            this.rawWordLength = rawWordLength;
        }

        @Override
        public String word() {
            if (this.wordIndex < 0 || this.wordIndex >= this.words.size()) {
                return "";
            }
            return this.words.get(this.wordIndex);
        }

        @Override
        public int wordCursor() {
            return this.wordCursor;
        }

        @Override
        public CharSequence escape(CharSequence candidate2, boolean complete) {
            int i2;
            StringBuilder sb = new StringBuilder(candidate2);
            String quote = this.openingQuote;
            boolean middleQuotes = false;
            if (this.openingQuote == null) {
                for (i2 = 0; i2 < sb.length(); ++i2) {
                    if (!DefaultParser.this.isQuoteChar(sb, i2)) continue;
                    middleQuotes = true;
                    break;
                }
            }
            if (DefaultParser.this.escapeChars != null) {
                if (DefaultParser.this.escapeChars.length > 0) {
                    Predicate<Integer> needToBeEscaped = this.openingQuote != null ? i -> DefaultParser.this.isRawEscapeChar(sb.charAt((int)i)) || String.valueOf(sb.charAt((int)i)).equals(this.openingQuote) : (middleQuotes ? i -> DefaultParser.this.isRawEscapeChar(sb.charAt((int)i)) : i -> DefaultParser.this.isDelimiterChar(sb, (int)i) || DefaultParser.this.isRawEscapeChar(sb.charAt((int)i)) || DefaultParser.this.isRawQuoteChar(sb.charAt((int)i)));
                    for (i2 = 0; i2 < sb.length(); ++i2) {
                        if (!needToBeEscaped.test(i2)) continue;
                        sb.insert(i2++, DefaultParser.this.escapeChars[0]);
                    }
                }
            } else if (this.openingQuote == null && !middleQuotes) {
                for (i2 = 0; i2 < sb.length(); ++i2) {
                    if (!DefaultParser.this.isDelimiterChar(sb, i2)) continue;
                    quote = "'";
                    break;
                }
            }
            if (quote != null) {
                sb.insert(0, quote);
                if (complete) {
                    sb.append(quote);
                }
            }
            return sb;
        }

        @Override
        public int rawWordCursor() {
            return this.rawWordCursor;
        }

        @Override
        public int rawWordLength() {
            return this.rawWordLength;
        }
    }
}

