/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirIntersectionCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirAbstractSuperCallChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "<init>", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirAbstractSuperCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirAbstractSuperCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirAbstractSuperCallChecker\n+ 2 CheckerContext.kt\norg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContextKt\n+ 3 CheckerContext.kt\norg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContextKt$findClosest$1\n+ 4 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,61:1\n93#2,3:62\n98#2:66\n93#3:65\n41#4:67\n14#4:68\n14#4:71\n295#5,2:69\n*S KotlinDebug\n*F\n+ 1 FirAbstractSuperCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirAbstractSuperCallChecker\n*L\n32#1:62,3\n32#1:66\n32#1:65\n41#1:67\n42#1:68\n49#1:71\n46#1:69,2\n*E\n"})
public final class FirAbstractSuperCallChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirAbstractSuperCallChecker INSTANCE = new FirAbstractSuperCallChecker();

    private FirAbstractSuperCallChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Object it;
        FirElement firElement;
        block17: {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            if (FirHelpersKt.explicitReceiverIsNotSuperReference(expression2)) {
                return;
            }
            CheckerContext $this$findClosest_u24default$iv = context2;
            boolean $i$f$findClosest = false;
            for (FirDeclaration it$iv : CollectionsKt.asReversed($this$findClosest_u24default$iv.getContainingDeclarations())) {
                FirElement firElement2;
                FirDeclaration firDeclaration = it$iv;
                if (!(firDeclaration instanceof FirRegularClass)) {
                    firDeclaration = null;
                }
                if ((firElement = (FirElement)((FirRegularClass)firDeclaration)) == null) continue;
                FirElement firElement3 = firElement2 = firElement;
                boolean bl = false;
                it = firElement3;
                firElement = true ? firElement2 : null;
                if (firElement == null) {
                    continue;
                }
                break block17;
            }
            firElement = null;
        }
        FirRegularClass firRegularClass = (FirRegularClass)firElement;
        if (firRegularClass == null) {
            return;
        }
        FirRegularClass closestClass = firRegularClass;
        if (closestClass.getClassKind() == ClassKind.CLASS) {
            FirCallableSymbol<?> firCallableSymbol = ReferenceUtilsKt.toResolvedCallableSymbol(expression2);
            if (firCallableSymbol == null) {
                return;
            }
            FirCallableSymbol<?> declarationSymbol = firCallableSymbol;
            ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag(declarationSymbol);
            FirClassLikeSymbol<?> $i$f$findClosest = coneClassLikeLookupTag != null ? LookupTagUtilsKt.toSymbol(coneClassLikeLookupTag, context2.getSession()) : null;
            FirRegularClassSymbol firRegularClassSymbol = $i$f$findClosest instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)$i$f$findClosest : null;
            if (firRegularClassSymbol == null) {
                return;
            }
            FirRegularClassSymbol containingClassSymbol = firRegularClassSymbol;
            FirBasedSymbol $this$isAbstract$iv = containingClassSymbol;
            boolean $i$f$isAbstract = false;
            if (((FirClassLikeSymbol)$this$isAbstract$iv).getResolvedStatus().getModality() == Modality.ABSTRACT) {
                $this$isAbstract$iv = declarationSymbol;
                $i$f$isAbstract = false;
                if (((FirCallableSymbol)$this$isAbstract$iv).getResolvedStatus().getModality() == Modality.ABSTRACT) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getCalleeReference().getSource(), FirErrors.INSTANCE.getABSTRACT_SUPER_CALL(), (DiagnosticContext)context2, null, 8, null);
                }
                if (declarationSymbol instanceof FirIntersectionCallableSymbol) {
                    boolean bl;
                    FirCallableSymbol symbolFromBaseClass;
                    Object v7;
                    block18: {
                        Iterable $this$firstOrNull$iv = ((FirIntersectionCallableSymbol)((Object)declarationSymbol)).getIntersections();
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            it = (FirCallableSymbol)element$iv;
                            boolean bl2 = false;
                            Object object = ClassMembersKt.containingClassLookupTag(it);
                            if (!((object != null && (object = LookupTagUtilsKt.toSymbol((ConeClassLikeLookupTag)object, context2.getSession())) != null ? FirHelpersKt.getClassKind(object) : null) != ClassKind.INTERFACE)) continue;
                            v7 = element$iv;
                            break block18;
                        }
                        v7 = null;
                    }
                    FirCallableSymbol firCallableSymbol2 = symbolFromBaseClass = (FirCallableSymbol)v7;
                    if (firCallableSymbol2 != null) {
                        FirCallableSymbol $this$isAbstract$iv2 = firCallableSymbol2;
                        boolean $i$f$isAbstract2 = false;
                        bl = $this$isAbstract$iv2.getResolvedStatus().getModality() == Modality.ABSTRACT;
                    } else {
                        bl = false;
                    }
                    if (bl) {
                        if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.ForbidSuperDelegationToAbstractFakeOverride)) {
                            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getCalleeReference().getSource(), FirErrors.INSTANCE.getABSTRACT_SUPER_CALL(), (DiagnosticContext)context2, null, 8, null);
                        } else {
                            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getCalleeReference().getSource(), FirErrors.INSTANCE.getABSTRACT_SUPER_CALL_WARNING(), (DiagnosticContext)context2, null, 8, null);
                        }
                    }
                }
            }
        }
    }
}

