/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava.classes;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForSourceDeclaration;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForSourceDeclarationKt$shouldNotBeVisibleAsLightClass$;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.TokenType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtDeclarationContainer;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u001a\f\u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u00020\u0004\u001a\n\u0010\b\u001a\u00020\u0001*\u00020\u0004\u001a\u0010\u0010\t\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u001a\u0010\u0010\n\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u001a\u0010\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"isPossiblyAffectedByAllOpen", "", "Lorg/jetbrains/kotlin/asJava/classes/KtLightClassForSourceDeclaration;", "getOutermostClassOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "classOrObject", "defaultJavaAncestorQualifiedName", "", "shouldNotBeVisibleAsLightClass", "classDeclaredInUnexpectedPosition", "isEnumEntryWithoutBody", "hasParseErrorsAround", "psi", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "light-classes-base"})
@SourceDebugExtension(value={"SMAP\nKtLightClassForSourceDeclaration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtLightClassForSourceDeclaration.kt\norg/jetbrains/kotlin/asJava/classes/KtLightClassForSourceDeclarationKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,276:1\n477#2:277\n1251#2,2:278\n*S KotlinDebug\n*F\n+ 1 KtLightClassForSourceDeclaration.kt\norg/jetbrains/kotlin/asJava/classes/KtLightClassForSourceDeclarationKt\n*L\n218#1:277\n218#1:278,2\n*E\n"})
public final class KtLightClassForSourceDeclarationKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isPossiblyAffectedByAllOpen(@NotNull KtLightClassForSourceDeclaration $this$isPossiblyAffectedByAllOpen) {
        Intrinsics.checkNotNullParameter((Object)$this$isPossiblyAffectedByAllOpen, (String)"<this>");
        if ($this$isPossiblyAffectedByAllOpen.isAnnotationType()) return false;
        if ($this$isPossiblyAffectedByAllOpen.isInterface()) return false;
        List<KtAnnotationEntry> list = $this$isPossiblyAffectedByAllOpen.getKotlinOrigin().getAnnotationEntries();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getAnnotationEntries(...)");
        if (((Collection)list).isEmpty()) return false;
        return true;
    }

    @NotNull
    public static final KtClassOrObject getOutermostClassOrObject(@NotNull KtClassOrObject classOrObject) {
        Intrinsics.checkNotNullParameter((Object)classOrObject, (String)"classOrObject");
        KtClassOrObject ktClassOrObject = KtPsiUtil.getOutermostClassOrObject(classOrObject);
        if (ktClassOrObject == null) {
            throw new IllegalStateException("Attempt to build a light class for a local class: " + classOrObject.getText());
        }
        return ktClassOrObject;
    }

    @Nullable
    public static final String defaultJavaAncestorQualifiedName(@NotNull KtClassOrObject $this$defaultJavaAncestorQualifiedName) {
        Intrinsics.checkNotNullParameter((Object)$this$defaultJavaAncestorQualifiedName, (String)"<this>");
        if (!($this$defaultJavaAncestorQualifiedName instanceof KtClass)) {
            return "java.lang.Object";
        }
        return $this$defaultJavaAncestorQualifiedName.isAnnotation() ? "java.lang.annotation.Annotation" : (((KtClass)$this$defaultJavaAncestorQualifiedName).isEnum() ? "java.lang.Enum" : (((KtClass)$this$defaultJavaAncestorQualifiedName).isInterface() ? "java.lang.Object" : "java.lang.Object"));
    }

    public static final boolean shouldNotBeVisibleAsLightClass(@NotNull KtClassOrObject $this$shouldNotBeVisibleAsLightClass) {
        boolean bl;
        PsiFile containingFile;
        block8: {
            Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeVisibleAsLightClass, (String)"<this>");
            PsiFile psiFile = $this$shouldNotBeVisibleAsLightClass.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
            containingFile = psiFile;
            if (containingFile instanceof KtCodeFragment) {
                return true;
            }
            KtFile ktFile = containingFile instanceof KtFile ? (KtFile)containingFile : null;
            boolean bl2 = ktFile != null ? ktFile.isCompiled() : false;
            if (bl2 && Intrinsics.areEqual((Object)((KtFile)containingFile).getVirtualFile().getExtension(), (Object)"kotlin_builtins")) {
                return true;
            }
            Sequence<PsiElement> $this$filterIsInstance$iv = PsiUtilsKt.getParentsWithSelf($this$shouldNotBeVisibleAsLightClass);
            boolean $i$f$filterIsInstance = false;
            Sequence sequence2 = SequencesKt.filter($this$filterIsInstance$iv, (Function1)shouldNotBeVisibleAsLightClass$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence2, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            Sequence $this$any$iv = sequence2;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                KtClassOrObject it = (KtClassOrObject)element$iv;
                boolean bl3 = false;
                if (!PsiUtilsKt.hasExpectModifier(it)) continue;
                bl = true;
                break block8;
            }
            bl = false;
        }
        if (bl) {
            return true;
        }
        if ($this$shouldNotBeVisibleAsLightClass.isLocal()) {
            if (containingFile.getVirtualFile() == null) {
                return true;
            }
            if (KtLightClassForSourceDeclarationKt.hasParseErrorsAround($this$shouldNotBeVisibleAsLightClass) || PsiUtilCore.hasErrorElementChild($this$shouldNotBeVisibleAsLightClass)) {
                return true;
            }
            if (KtLightClassForSourceDeclarationKt.classDeclaredInUnexpectedPosition($this$shouldNotBeVisibleAsLightClass)) {
                return true;
            }
        }
        return KtLightClassForSourceDeclarationKt.isEnumEntryWithoutBody($this$shouldNotBeVisibleAsLightClass);
    }

    private static final boolean classDeclaredInUnexpectedPosition(KtClassOrObject classOrObject) {
        if (classOrObject instanceof KtObjectDeclaration) {
            return false;
        }
        PsiElement classParent = classOrObject.getParent();
        return !(classParent instanceof KtBlockExpression) && !(classParent instanceof KtDeclarationContainer);
    }

    private static final boolean isEnumEntryWithoutBody(KtClassOrObject classOrObject) {
        if (!(classOrObject instanceof KtEnumEntry)) {
            return false;
        }
        Object object = classOrObject.getBody();
        return object != null && (object = ((KtClassBody)object).getDeclarations()) != null ? object.isEmpty() : true;
    }

    private static final boolean hasParseErrorsAround(PsiElement psi) {
        block9: {
            block10: {
                ASTNode node;
                block7: {
                    block8: {
                        ASTNode aSTNode = psi.getNode();
                        if (aSTNode == null) {
                            return false;
                        }
                        node = aSTNode;
                        ASTNode aSTNode2 = TreeUtil.nextLeaf(node);
                        if (aSTNode2 == null) break block7;
                        ASTNode nextLeaf = aSTNode2;
                        boolean bl = false;
                        if (Intrinsics.areEqual((Object)nextLeaf.getElementType(), (Object)TokenType.ERROR_ELEMENT)) break block8;
                        ASTNode aSTNode3 = nextLeaf.getTreePrev();
                        if (!Intrinsics.areEqual((Object)(aSTNode3 != null ? aSTNode3.getElementType() : null), (Object)TokenType.ERROR_ELEMENT)) break block7;
                    }
                    return true;
                }
                ASTNode aSTNode = TreeUtil.prevLeaf(node);
                if (aSTNode == null) break block9;
                ASTNode prevLeaf = aSTNode;
                boolean bl = false;
                if (Intrinsics.areEqual((Object)prevLeaf.getElementType(), (Object)TokenType.ERROR_ELEMENT)) break block10;
                ASTNode aSTNode4 = prevLeaf.getTreeNext();
                if (!Intrinsics.areEqual((Object)(aSTNode4 != null ? aSTNode4.getElementType() : null), (Object)TokenType.ERROR_ELEMENT)) break block9;
            }
            return true;
        }
        return false;
    }
}

