/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/DataClassDeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend"})
@SourceDebugExtension(value={"SMAP\nDataClassDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataClassDeclarationChecker.kt\norg/jetbrains/kotlin/resolve/checkers/DataClassDeclarationChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,53:1\n1#2:54\n*E\n"})
public final class DataClassDeclarationChecker
implements DeclarationChecker {
    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor, @NotNull DeclarationCheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!(descriptor instanceof ClassDescriptor)) {
            return;
        }
        if (!(declaration instanceof KtClassOrObject)) {
            return;
        }
        if (((ClassDescriptor)descriptor).isData() && ((ClassDescriptor)descriptor).getKind() == ClassKind.CLASS) {
            Object parameters;
            KtPrimaryConstructor primaryConstructor;
            Object object;
            if (((ClassDescriptor)descriptor).getUnsubstitutedPrimaryConstructor() == null) {
                Collection<ClassConstructorDescriptor> collection = ((ClassDescriptor)descriptor).getConstructors();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"getConstructors(...)");
                if (!collection.isEmpty()) {
                    PsiElement psiElement = ((KtClassOrObject)declaration).getNameIdentifier();
                    if (psiElement != null) {
                        PsiElement it = psiElement;
                        boolean bl = false;
                        context2.getTrace().report(Errors.PRIMARY_CONSTRUCTOR_REQUIRED_FOR_DATA_CLASS.on(it));
                    }
                }
            }
            if ((object = (primaryConstructor = ((KtClassOrObject)declaration).getPrimaryConstructor())) == null || (object = ((KtConstructor)object).getValueParameters()) == null) {
                object = CollectionsKt.emptyList();
            }
            if ((parameters = object).isEmpty()) {
                KtElementImplStub ktElementImplStub = primaryConstructor;
                PsiElement psiElement = ktElementImplStub != null && (ktElementImplStub = ktElementImplStub.getValueParameterList()) != null ? (PsiElement)ktElementImplStub : ((KtClassOrObject)declaration).getNameIdentifier();
                if (psiElement != null) {
                    PsiElement it = psiElement;
                    boolean bl = false;
                    context2.getTrace().report(Errors.DATA_CLASS_WITHOUT_PARAMETERS.on(it));
                }
            }
            Iterator iterator2 = parameters.iterator();
            while (iterator2.hasNext()) {
                KtParameter parameter = (KtParameter)iterator2.next();
                if (parameter.isVarArg()) {
                    context2.getTrace().report(Errors.DATA_CLASS_VARARG_PARAMETER.on((KtParameter)((PsiElement)parameter)));
                }
                if (parameter.hasValOrVar()) continue;
                context2.getTrace().report(Errors.DATA_CLASS_NOT_PROPERTY_PARAMETER.on((KtParameter)((PsiElement)parameter)));
            }
        }
    }
}

