/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.io;

import java.nio.ByteBuffer;
import java.util.BitSet;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.util.SystemProperties;
import org.jetbrains.kotlin.com.intellij.util.containers.LimitedPool;
import org.jetbrains.kotlin.com.intellij.util.io.FinalizationRequest;
import org.jetbrains.kotlin.com.intellij.util.io.PoolPageKey;
import org.jetbrains.kotlin.com.intellij.util.io.RandomAccessDataFile;

public class Page {
    public static final int PAGE_SIZE = SystemProperties.getIntProperty("idea.io.page.size", 8192);
    private static final LimitedPool<ByteBuffer> ourBufferPool = new LimitedPool.Sync<ByteBuffer>(10, () -> ByteBuffer.allocate(PAGE_SIZE));
    private final PoolPageKey myKey;
    private ByteBuffer buf;
    private boolean read;
    private boolean dirty;
    private int myFinalizationId;
    private BitSet myWriteMask;
    private final PageLock lock;
    private final Range myContinuousRange;

    private void ensureRead() {
        if (!this.read) {
            if (this.myWriteMask != null) {
                byte[] content = new byte[PAGE_SIZE];
                ByteBuffer b = this.getBuf();
                b.position(0);
                b.get(content, 0, PAGE_SIZE);
                this.getOwner().loadPage(this);
                int i = this.myWriteMask.nextSetBit(0);
                while (i >= 0) {
                    b.put(i, content[i]);
                    i = this.myWriteMask.nextSetBit(i + 1);
                }
                this.myWriteMask = null;
            } else {
                this.getOwner().loadPage(this);
            }
            this.read = true;
        }
    }

    @Nullable
    private Range calcContinuousRange(BitSet mask) {
        int lowestByte = mask.nextSetBit(0);
        if (lowestByte >= 0) {
            int highestByte = mask.nextClearBit(lowestByte);
            if (highestByte > 0) {
                int nextChunk = mask.nextSetBit(highestByte);
                if (nextChunk < 0) {
                    this.myContinuousRange.start = lowestByte;
                    this.myContinuousRange.end = highestByte;
                    return this.myContinuousRange;
                }
                return null;
            }
            this.myContinuousRange.start = lowestByte;
            this.myContinuousRange.end = PAGE_SIZE;
            return this.myContinuousRange;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        PageLock pageLock = this.lock;
        synchronized (pageLock) {
            if (this.dirty) {
                int start = 0;
                int end = PAGE_SIZE;
                if (this.myWriteMask != null) {
                    Range range = this.calcContinuousRange(this.myWriteMask);
                    if (range == null) {
                        this.ensureRead();
                    } else {
                        start = range.start;
                        end = range.end;
                    }
                    this.myWriteMask = null;
                }
                if (end - start > 0) {
                    this.getOwner().flushPage(this, start, end);
                }
                this.dirty = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer getBuf() {
        PageLock pageLock = this.lock;
        synchronized (pageLock) {
            if (this.buf == null) {
                this.buf = ourBufferPool.alloc();
            }
            return this.buf;
        }
    }

    private void recycle() {
        ByteBuffer buf = this.buf;
        if (buf != null) {
            ourBufferPool.recycle(buf);
        }
        this.buf = null;
        this.read = false;
        this.dirty = false;
        this.myWriteMask = null;
    }

    public long getOffset() {
        return this.myKey.getOffset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public FinalizationRequest prepareForFinalization(int finalizationId) {
        PageLock pageLock = this.lock;
        synchronized (pageLock) {
            if (this.dirty) {
                this.myFinalizationId = finalizationId;
                return new FinalizationRequest(this, finalizationId);
            }
            this.recycle();
            return null;
        }
    }

    public RandomAccessDataFile getOwner() {
        return (RandomAccessDataFile)this.getKey().getOwner();
    }

    public PoolPageKey getKey() {
        return this.myKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean flushIfFinalizationIdIsEqualTo(long finalizationId) {
        PageLock pageLock = this.lock;
        synchronized (pageLock) {
            if ((long)this.myFinalizationId == finalizationId) {
                this.flush();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean recycleIfFinalizationIdIsEqualTo(long finalizationId) {
        PageLock pageLock = this.lock;
        synchronized (pageLock) {
            if ((long)this.myFinalizationId == finalizationId) {
                this.recycle();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        PageLock pageLock = this.lock;
        synchronized (pageLock) {
            return "Page[" + this.getOwner() + ", dirty: " + this.dirty + ", offset=" + this.getOffset() + "]";
        }
    }

    private static class Range {
        int start;
        int end;
    }

    private static class PageLock {
    }
}

