/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.js.dce;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.CLITool;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.arguments.K2JSDceArguments;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.js.dce.Context;
import org.jetbrains.kotlin.js.dce.DCELogLevel;
import org.jetbrains.kotlin.js.dce.DeadCodeElimination;
import org.jetbrains.kotlin.js.dce.DeadCodeEliminationResult;
import org.jetbrains.kotlin.js.dce.DeadCodeEliminationStatus;
import org.jetbrains.kotlin.js.dce.InputFile;
import org.jetbrains.kotlin.js.dce.InputResource;
import org.jetbrains.kotlin.js.dce.PrintTreeKt;
import org.jetbrains.kotlin.js.dce.UtilKt;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMap;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMapSourceReplacementException;
import org.jetbrains.kotlin.js.sourceMap.RelativePathCalculator;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u0000 '2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001'B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0002H\u0016J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0014J&\u0010\r\u001a\u00020\u00072\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0002J\u001e\u0010\u0011\u001a\u00020\u00122\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J \u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J&\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010 \u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u001fH\u0002J\u001e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u001d\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u001fH\u0002J\u001e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u001d\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u001fH\u0002J\f\u0010$\u001a\u00020\u001f*\u00020\u001fH\u0002J\u0010\u0010%\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u001fH\u0002J\b\u0010&\u001a\u00020\u001fH\u0016\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/cli/js/dce/K2JSDce;", "Lorg/jetbrains/kotlin/cli/common/CLITool;", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JSDceArguments;", "<init>", "()V", "createArguments", "execImpl", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "services", "Lorg/jetbrains/kotlin/config/Services;", "arguments", "performDce", "files", "", "Lorg/jetbrains/kotlin/js/dce/InputFile;", "copyFiles", "", "overwriteOnlyOlderFiles", "", "copyResource", "resource", "Lorg/jetbrains/kotlin/js/dce/InputResource;", "targetFile", "Ljava/io/File;", "mapSourcePaths", "inputFile", "collectInputFiles", "baseDir", "fileName", "", "singleInputFile", "path", "collectInputFilesFromZip", "collectInputFilesFromDirectory", "metaJs", "getModuleNameFromPath", "executableScriptFileName", "Companion", "cli-js"})
@SourceDebugExtension(value={"SMAP\nK2JSDce.kt\nKotlin\n*S Kotlin\n*F\n+ 1 K2JSDce.kt\norg/jetbrains/kotlin/cli/js/dce/K2JSDce\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,248:1\n1368#2:249\n1454#2,5:250\n18#3:255\n1#4:256\n*S KotlinDebug\n*F\n+ 1 K2JSDce.kt\norg/jetbrains/kotlin/cli/js/dce/K2JSDce\n*L\n26#1:249\n26#1:250,5\n68#1:255\n*E\n"})
public final class K2JSDce
extends CLITool<K2JSDceArguments> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public K2JSDceArguments createArguments() {
        return new K2JSDceArguments();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected ExitCode execImpl(@NotNull MessageCollector messageCollector, @NotNull Services services, @NotNull K2JSDceArguments arguments) {
        ExitCode exitCode;
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)messageCollector, (String)"messageCollector");
        Intrinsics.checkNotNullParameter((Object)services, (String)"services");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        String string2 = arguments.getOutputDirectory();
        if (string2 == null) {
            string2 = "min";
        }
        File baseDir = new File(string2);
        Iterable $this$flatMap$iv = arguments.getFreeArgs();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String arg = (String)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.collectInputFiles(baseDir, arg, messageCollector);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List files2 = (List)destination$iv$iv;
        if (messageCollector.hasErrors()) {
            return ExitCode.COMPILATION_ERROR;
        }
        if (files2.isEmpty() && !arguments.getVersion()) {
            MessageCollector.report$default(messageCollector, CompilerMessageSeverity.ERROR, "no source files", null, 4, null);
            return ExitCode.COMPILATION_ERROR;
        }
        Map existingFiles = new LinkedHashMap();
        for (InputFile file2 : files2) {
            InputFile inputFile = (InputFile)existingFiles.get(file2.getOutputPath());
            if (inputFile != null) {
                InputFile it = inputFile;
                boolean bl = false;
                MessageCollector.report$default(messageCollector, CompilerMessageSeverity.ERROR, "duplicate target file will be created for '" + file2.getResource().getName() + "' and '" + it.getResource().getName() + '\'', null, 4, null);
                return ExitCode.COMPILATION_ERROR;
            }
            existingFiles.put(file2.getOutputPath(), file2);
            if (!new File(file2.getOutputPath()).isDirectory()) continue;
            MessageCollector.report$default(messageCollector, CompilerMessageSeverity.ERROR, "cannot open output file '" + file2.getOutputPath() + "': it is a directory", null, 4, null);
            return ExitCode.COMPILATION_ERROR;
        }
        if (!arguments.getDevMode()) {
            exitCode = this.performDce(files2, arguments, messageCollector);
        } else {
            String string3 = arguments.getDevModeOverwritingStrategy();
            if (string3 == null) {
                string3 = System.getProperty("kotlin.js.dce.devmode.overwriting.strategy", "older");
            }
            String devModeOverwritingStrategy = string3;
            boolean overwriteOnlyOlderFiles = Intrinsics.areEqual((Object)devModeOverwritingStrategy, (Object)"older");
            this.copyFiles(files2, overwriteOnlyOlderFiles);
            exitCode = ExitCode.OK;
        }
        return exitCode;
    }

    private final ExitCode performDce(List<InputFile> files2, K2JSDceArguments arguments, MessageCollector messageCollector) {
        Object[] $this$orEmpty$iv = arguments.getDeclarationsToKeep();
        boolean $i$f$orEmpty = false;
        Object[] objectArray = $this$orEmpty$iv;
        if ($this$orEmpty$iv == null) {
            objectArray = new String[]{};
        }
        Set includedDeclarations = ArraysKt.toSet((Object[])objectArray);
        Function2 logConsumer = (arg_0, arg_1) -> K2JSDce.performDce$lambda$2(messageCollector, arg_0, arg_1);
        DeadCodeEliminationResult dceResult = DeadCodeElimination.Companion.run((Collection<InputFile>)files2, includedDeclarations, arguments.getPrintReachabilityInfo(), (Function2<? super DCELogLevel, ? super String, Unit>)logConsumer);
        if (dceResult.getStatus() == DeadCodeEliminationStatus.FAILED) {
            return ExitCode.COMPILATION_ERROR;
        }
        if (arguments.getPrintReachabilityInfo()) {
            CompilerMessageSeverity reachabilitySeverity = CompilerMessageSeverity.INFO;
            MessageCollector.report$default(messageCollector, reachabilitySeverity, "", null, 4, null);
            Iterable<Context.Node> iterable = dceResult.getReachableNodes();
            Context context2 = dceResult.getContext();
            Intrinsics.checkNotNull((Object)context2);
            for (Context.Node node : UtilKt.extractReachableRoots(iterable, context2)) {
                PrintTreeKt.printTree(node, (Function1<? super String, Unit>)((Function1)arg_0 -> K2JSDce.performDce$lambda$3(messageCollector, reachabilitySeverity, arg_0)), false, true);
            }
        }
        return ExitCode.OK;
    }

    private final void copyFiles(List<InputFile> files2, boolean overwriteOnlyOlderFiles) {
        for (InputFile file2 : files2) {
            InputResource sourceMap;
            this.copyResource(file2.getResource(), new File(file2.getOutputPath()), overwriteOnlyOlderFiles);
            if (file2.getSourceMapResource() == null) continue;
            boolean bl = false;
            File sourceMapTarget = new File(file2.getOutputPath() + ".map");
            File inputFile = new File(sourceMap.getName());
            if (inputFile.exists() && this.mapSourcePaths(inputFile, sourceMapTarget)) continue;
            this.copyResource(sourceMap, sourceMapTarget, overwriteOnlyOlderFiles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void copyResource(InputResource resource, File targetFile, boolean overwriteOnlyOlderFiles) {
        if (overwriteOnlyOlderFiles && targetFile.exists() && ((Number)resource.getLastModified().invoke()).longValue() < targetFile.lastModified()) {
            return;
        }
        targetFile.getParentFile().mkdirs();
        Closeable closeable = (Closeable)resource.getReader().invoke();
        Throwable throwable = null;
        try {
            long l;
            InputStream input = (InputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new FileOutputStream(targetFile);
            Throwable throwable2 = null;
            try {
                FileOutputStream output = (FileOutputStream)closeable2;
                boolean bl2 = false;
                l = ByteStreamsKt.copyTo$default((InputStream)input, (OutputStream)output, (int)0, (int)2, null);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            long l2 = l;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean mapSourcePaths(File inputFile, File targetFile) {
        boolean bl;
        StringWriter jsonOut = new StringWriter();
        File file2 = targetFile.getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getParentFile(...)");
        RelativePathCalculator pathCalculator = new RelativePathCalculator(file2);
        try {
            bl = SourceMap.Companion.mapSources(FilesKt.readText$default((File)inputFile, null, (int)1, null), jsonOut, (Function1<? super String, String>)((Function1)arg_0 -> K2JSDce.mapSourcePaths$lambda$7(pathCalculator, inputFile, targetFile, arg_0)));
        }
        catch (SourceMapSourceReplacementException e) {
            bl = false;
        }
        boolean sourceMapChanged = bl;
        if (!sourceMapChanged) {
            return false;
        }
        targetFile.getParentFile().mkdirs();
        Closeable closeable = new OutputStreamWriter((OutputStream)new FileOutputStream(targetFile), "UTF-8");
        Throwable throwable = null;
        try {
            OutputStreamWriter it = (OutputStreamWriter)closeable;
            boolean bl2 = false;
            it.write(jsonOut.toString());
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return true;
    }

    private final List<InputFile> collectInputFiles(File baseDir, String fileName, MessageCollector messageCollector) {
        List list;
        File file2 = new File(fileName);
        if (file2.isDirectory()) {
            list = this.collectInputFilesFromDirectory(baseDir, fileName);
        } else if (file2.isFile()) {
            if (StringsKt.endsWith$default((String)fileName, (String)".js", (boolean)false, (int)2, null)) {
                list = CollectionsKt.listOf((Object)this.singleInputFile(baseDir, fileName));
            } else if (StringsKt.endsWith$default((String)fileName, (String)".zip", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)fileName, (String)".jar", (boolean)false, (int)2, null)) {
                list = this.collectInputFilesFromZip(baseDir, fileName);
            } else {
                MessageCollector.report$default(messageCollector, CompilerMessageSeverity.WARNING, "invalid file name '" + file2.getAbsolutePath() + "'; must end either with '.js', '.zip' or '.jar'", null, 4, null);
                list = CollectionsKt.emptyList();
            }
        } else {
            MessageCollector.report$default(messageCollector, CompilerMessageSeverity.ERROR, "source file or directory not found: " + fileName, null, 4, null);
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final InputFile singleInputFile(File baseDir, String path) {
        InputResource inputResource;
        String moduleName = this.getModuleNameFromPath(path);
        String pathToSourceMapCandidate = path + ".map";
        String pathToSourceMap = new File(pathToSourceMapCandidate).exists() ? pathToSourceMapCandidate : null;
        InputResource inputResource2 = InputResource.Companion.file(path);
        String string2 = pathToSourceMap;
        if (string2 != null) {
            void it;
            String string3 = string2;
            InputResource inputResource3 = inputResource2;
            boolean bl = false;
            inputResource = InputResource.Companion.file((String)it);
            inputResource2 = inputResource3;
        } else {
            inputResource = null;
        }
        String string4 = new File(baseDir, moduleName + ".js").getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getAbsolutePath(...)");
        String string5 = moduleName;
        String string6 = string4;
        InputResource inputResource4 = inputResource;
        InputResource inputResource5 = inputResource2;
        return new InputFile(inputResource5, inputResource4, string6, string5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<InputFile> collectInputFilesFromZip(File baseDir, String path) {
        List list;
        Closeable closeable = new ZipFile(path);
        Throwable throwable = null;
        try {
            ZipFile zipFile = (ZipFile)closeable;
            boolean bl = false;
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"entries(...)");
            list = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.distinctBy((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration)), K2JSDce::collectInputFilesFromZip$lambda$16$lambda$10), K2JSDce::collectInputFilesFromZip$lambda$16$lambda$11), arg_0 -> K2JSDce.collectInputFilesFromZip$lambda$16$lambda$12(zipFile, this, arg_0)), K2JSDce::collectInputFilesFromZip$lambda$16$lambda$13), arg_0 -> K2JSDce.collectInputFilesFromZip$lambda$16$lambda$15(this, zipFile, path, baseDir, arg_0)));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return list;
    }

    private final List<InputFile> collectInputFilesFromDirectory(File baseDir, String path) {
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)new File(path))), K2JSDce::collectInputFilesFromDirectory$lambda$17), K2JSDce::collectInputFilesFromDirectory$lambda$18), arg_0 -> K2JSDce.collectInputFilesFromDirectory$lambda$19(this, arg_0)), arg_0 -> K2JSDce.collectInputFilesFromDirectory$lambda$21(this, baseDir, arg_0)));
    }

    private final String metaJs(String $this$metaJs) {
        return StringsKt.removeSuffix((String)$this$metaJs, (CharSequence)".js") + ".meta.js";
    }

    private final String getModuleNameFromPath(String path) {
        int dotIndex = StringsKt.lastIndexOf$default((CharSequence)path, (char)'.', (int)0, (boolean)false, (int)6, null);
        int slashIndex = Math.max(StringsKt.lastIndexOf$default((CharSequence)path, (char)'/', (int)0, (boolean)false, (int)6, null), StringsKt.lastIndexOf$default((CharSequence)path, (char)'\\', (int)0, (boolean)false, (int)6, null));
        String string2 = path.substring(slashIndex + 1, dotIndex < 0 ? path.length() : dotIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        return string2;
    }

    @Override
    @NotNull
    public String executableScriptFileName() {
        return "kotlin-dce-js";
    }

    private static final Unit performDce$lambda$2(MessageCollector $messageCollector, DCELogLevel level, String message) {
        CompilerMessageSeverity compilerMessageSeverity;
        Intrinsics.checkNotNullParameter((Object)$messageCollector, (String)"$messageCollector");
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        switch (WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
            case 1: {
                compilerMessageSeverity = CompilerMessageSeverity.ERROR;
                break;
            }
            case 2: {
                compilerMessageSeverity = CompilerMessageSeverity.WARNING;
                break;
            }
            case 3: {
                compilerMessageSeverity = CompilerMessageSeverity.LOGGING;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        CompilerMessageSeverity severity = compilerMessageSeverity;
        MessageCollector.report$default($messageCollector, severity, message, null, 4, null);
        return Unit.INSTANCE;
    }

    private static final Unit performDce$lambda$3(MessageCollector $messageCollector, CompilerMessageSeverity $reachabilitySeverity, String it) {
        Intrinsics.checkNotNullParameter((Object)$messageCollector, (String)"$messageCollector");
        Intrinsics.checkNotNullParameter((Object)((Object)$reachabilitySeverity), (String)"$reachabilitySeverity");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        MessageCollector.report$default($messageCollector, $reachabilitySeverity, it, null, 4, null);
        return Unit.INSTANCE;
    }

    private static final String mapSourcePaths$lambda$7(RelativePathCalculator $pathCalculator, File $inputFile, File $targetFile, String it) {
        Intrinsics.checkNotNullParameter((Object)$pathCalculator, (String)"$pathCalculator");
        Intrinsics.checkNotNullParameter((Object)$inputFile, (String)"$inputFile");
        Intrinsics.checkNotNullParameter((Object)$targetFile, (String)"$targetFile");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String result2 = $pathCalculator.calculateRelativePathTo(new File($inputFile.getParentFile(), it));
        return result2 != null ? (new File($targetFile.getParentFile(), result2).exists() ? result2 : it) : it;
    }

    private static final boolean collectInputFilesFromZip$lambda$16$lambda$10(ZipEntry it) {
        return !it.isDirectory();
    }

    private static final boolean collectInputFilesFromZip$lambda$16$lambda$11(ZipEntry it) {
        String string2 = it.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        return StringsKt.endsWith$default((String)string2, (String)".js", (boolean)false, (int)2, null);
    }

    private static final boolean collectInputFilesFromZip$lambda$16$lambda$12(ZipFile $zipFile, K2JSDce this$0, ZipEntry it) {
        Intrinsics.checkNotNullParameter((Object)$zipFile, (String)"$zipFile");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        String string2 = it.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        return $zipFile.getEntry(this$0.metaJs(string2)) != null;
    }

    private static final String collectInputFilesFromZip$lambda$16$lambda$13(ZipEntry it) {
        return it.getName();
    }

    /*
     * WARNING - void declaration
     */
    private static final InputFile collectInputFilesFromZip$lambda$16$lambda$15(K2JSDce this$0, ZipFile $zipFile, String $path, File $baseDir, ZipEntry entry) {
        InputResource inputResource;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$zipFile, (String)"$zipFile");
        Intrinsics.checkNotNullParameter((Object)$path, (String)"$path");
        Intrinsics.checkNotNullParameter((Object)$baseDir, (String)"$baseDir");
        String string2 = entry.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        String moduleName = this$0.getModuleNameFromPath(string2);
        String pathToSourceMapCandidate = entry.getName() + ".map";
        String pathToSourceMap = $zipFile.getEntry(pathToSourceMapCandidate) != null ? pathToSourceMapCandidate : null;
        String string3 = entry.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
        InputResource inputResource2 = InputResource.Companion.zipFile($path, string3);
        String string4 = pathToSourceMap;
        if (string4 != null) {
            void it;
            String string5 = string4;
            InputResource inputResource3 = inputResource2;
            boolean bl = false;
            inputResource = InputResource.Companion.zipFile($path, (String)it);
            inputResource2 = inputResource3;
        } else {
            inputResource = null;
        }
        String string6 = new File($baseDir, moduleName + ".js").getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getAbsolutePath(...)");
        String string7 = moduleName;
        String string8 = string6;
        InputResource inputResource4 = inputResource;
        InputResource inputResource5 = inputResource2;
        return new InputFile(inputResource5, inputResource4, string8, string7);
    }

    private static final boolean collectInputFilesFromDirectory$lambda$17(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !it.isDirectory();
    }

    private static final boolean collectInputFilesFromDirectory$lambda$18(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string2 = it.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        return StringsKt.endsWith$default((String)string2, (String)".js", (boolean)false, (int)2, null);
    }

    private static final boolean collectInputFilesFromDirectory$lambda$19(K2JSDce this$0, File it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string2 = it.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        return new File(this$0.metaJs(string2)).exists();
    }

    /*
     * WARNING - void declaration
     */
    private static final InputFile collectInputFilesFromDirectory$lambda$21(K2JSDce this$0, File $baseDir, File entry) {
        InputResource inputResource;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$baseDir, (String)"$baseDir");
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        String string2 = entry.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        String moduleName = this$0.getModuleNameFromPath(string2);
        String pathToSourceMapCandidate = entry.getPath() + ".map";
        String pathToSourceMap = new File(pathToSourceMapCandidate).exists() ? pathToSourceMapCandidate : null;
        String string3 = entry.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
        InputResource inputResource2 = InputResource.Companion.file(string3);
        String string4 = pathToSourceMap;
        if (string4 != null) {
            void it;
            String string5 = string4;
            InputResource inputResource3 = inputResource2;
            boolean bl = false;
            inputResource = InputResource.Companion.file((String)it);
            inputResource2 = inputResource3;
        } else {
            inputResource = null;
        }
        String string6 = new File($baseDir, moduleName + ".js").getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getAbsolutePath(...)");
        String string7 = moduleName;
        String string8 = string6;
        InputResource inputResource4 = inputResource;
        InputResource inputResource5 = inputResource2;
        return new InputFile(inputResource5, inputResource4, string8, string7);
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Companion.main(args);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/cli/js/dce/K2JSDce$Companion;", "", "<init>", "()V", "main", "", "args", "", "", "([Ljava/lang/String;)V", "cli-js"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void main(@NotNull String[] args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            CLITool.Companion.doMain(new K2JSDce(), args);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DCELogLevel.values().length];
            try {
                nArray[DCELogLevel.ERROR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DCELogLevel.WARN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DCELogLevel.INFO.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

