/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.functions.FunctionTypeKind;
import org.jetbrains.kotlin.builtins.functions.FunctionTypeKindKt;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirLookupTrackerComponent;
import org.jetbrains.kotlin.fir.FirLookupTrackerComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.TypeUtilsKt;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousFunctionExpression;
import org.jetbrains.kotlin.fir.expressions.FirArrayLiteral;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import org.jetbrains.kotlin.fir.expressions.FirCheckNotNullCall;
import org.jetbrains.kotlin.fir.expressions.FirElvisExpression;
import org.jetbrains.kotlin.fir.expressions.FirErrorExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirNamedArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvable;
import org.jetbrains.kotlin.fir.expressions.FirSafeCallExpression;
import org.jetbrains.kotlin.fir.expressions.FirSmartCastExpression;
import org.jetbrains.kotlin.fir.expressions.FirSpreadArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirTryExpression;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.expressions.FirWrappedArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.FirSamResolver;
import org.jetbrains.kotlin.fir.resolve.ImplicitIntegerCoercionKt;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.ArgumentTypeMismatch;
import org.jetbrains.kotlin.fir.resolve.calls.CallInfo;
import org.jetbrains.kotlin.fir.resolve.calls.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.CandidateFactoryKt;
import org.jetbrains.kotlin.fir.resolve.calls.CheckerSink;
import org.jetbrains.kotlin.fir.resolve.calls.DynamicReceiverExpectedButWasNonDynamic;
import org.jetbrains.kotlin.fir.resolve.calls.ErrorTypeInArguments;
import org.jetbrains.kotlin.fir.resolve.calls.FirNamedReferenceWithCandidate;
import org.jetbrains.kotlin.fir.resolve.calls.FunctionTypeKindSubstitutor;
import org.jetbrains.kotlin.fir.resolve.calls.InapplicableWrongReceiver;
import org.jetbrains.kotlin.fir.resolve.calls.NullForNotNullType;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionContext;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionDiagnostic;
import org.jetbrains.kotlin.fir.resolve.calls.UnsafeCall;
import org.jetbrains.kotlin.fir.resolve.calls.UnstableSmartCast;
import org.jetbrains.kotlin.fir.resolve.inference.LambdaWithTypeVariableAsExpectedTypeAtom;
import org.jetbrains.kotlin.fir.resolve.inference.PostponedArgumentsKt;
import org.jetbrains.kotlin.fir.resolve.inference.PostponedResolvedAtom;
import org.jetbrains.kotlin.fir.resolve.inference.model.ConeArgumentConstraintPosition;
import org.jetbrains.kotlin.fir.resolve.inference.model.ConeReceiverConstraintPosition;
import org.jetbrains.kotlin.fir.resolve.transformers.PhaseUtilsKt;
import org.jetbrains.kotlin.fir.resolve.transformers.ReturnTypeCalculator;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.ConeTypeParameterLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.types.ArrayUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeDynamicType;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeIntersector;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeTypeVariableType;
import org.jetbrains.kotlin.fir.types.ConeTypeVariableTypeConstructor;
import org.jetbrains.kotlin.fir.types.FirFunctionTypeKindServiceKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FunctionalTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.InferenceUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;
import org.jetbrains.kotlin.fir.types.impl.ConeTypeParameterTypeImpl;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilder;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilderKt;
import org.jetbrains.kotlin.resolve.calls.inference.model.Constraint;
import org.jetbrains.kotlin.resolve.calls.inference.model.ConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.model.SimpleConstraintSystemConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.model.VariableWithConstraints;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.MarkerExtensionsKt;
import org.jetbrains.kotlin.types.model.SimpleTypeMarker;
import org.jetbrains.kotlin.types.model.TypeConstructorMarker;
import org.jetbrains.kotlin.types.model.TypeParameterMarker;
import org.jetbrains.kotlin.types.model.TypeSystemCommonSuperTypesContext;
import org.jetbrains.kotlin.types.model.TypeSystemContextHelpersKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0094\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001aD\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012\u001aF\u0010\u0014\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u001aN\u0010\u0017\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00182\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\b\b\u0002\u0010\u0019\u001a\u00020\u0012\u001a\u001c\u0010\u001a\u001a\u00020\f*\u00020\f2\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\bH\u0002\u001aN\u0010\u001d\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\b\b\u0002\u0010\u0019\u001a\u00020\u0012\u001aV\u0010\u001e\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\b\b\u0002\u0010\u0019\u001a\u00020\u0012\u001a&\u0010 \u001a\u0004\u0018\u00010\f*\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\fH\u0002\u001a\u0018\u0010$\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001aR\u0010%\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010&\u001a\u00020\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a>\u0010)\u001a\u00020\u0005*\u00020\u00062\u0006\u0010*\u001a\u00020+2\u0006\u0010\t\u001a\u00020\n2\b\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a@\u0010.\u001a\u0004\u0018\u00010\f*\u00020\u00062\u0006\u0010\"\u001a\u00020#2\u0006\u0010/\u001a\u0002002\u0006\u0010*\u001a\u00020+2\u0006\u0010\t\u001a\u00020\n2\b\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a6\u00101\u001a\u0004\u0018\u00010\f*\u00020\u00062\u0006\u0010\"\u001a\u00020#2\u0006\u0010/\u001a\u0002002\u0006\u0010\t\u001a\u00020\n2\u0006\u00102\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a*\u00103\u001a\u0004\u0018\u00010\f2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010,\u001a\u00020-2\u0006\u00102\u001a\u00020\fH\u0002\u001a2\u00104\u001a\u00020\u0012*\u00020\n2\u0006\u0010\"\u001a\u00020#2\u0006\u0010/\u001a\u0002002\u0006\u00102\u001a\u00020\f2\u0006\u00105\u001a\u00020\f2\u0006\u00106\u001a\u000207\u001a0\u00108\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020#2\u0006\u0010/\u001a\u0002002\u0006\u00109\u001a\u00020\f2\u0006\u0010:\u001a\u00020;2\u0006\u00106\u001a\u000207H\u0002\u001a\u000e\u0010<\u001a\u0004\u0018\u00010=*\u00020\nH\u0002\u001a\u001a\u0010>\u001a\u00020\f*\u00020\n2\u0006\u0010\"\u001a\u00020#2\u0006\u0010,\u001a\u00020-\u001a \u0010?\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\"\u001a\u00020#H\u0000\u001a\u001c\u0010@\u001a\u00020\u0012*\u00020\f2\u0006\u0010A\u001a\u00020B2\u0006\u0010\u000f\u001a\u00020CH\u0002\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006D"}, d2={"SAM_LOOKUP_NAME", "Lorg/jetbrains/kotlin/name/Name;", "getSAM_LOOKUP_NAME", "()Lorg/jetbrains/kotlin/name/Name;", "resolveArgumentExpression", "", "Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;", "csBuilder", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystemBuilder;", "argument", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "expectedType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "sink", "Lorg/jetbrains/kotlin/fir/resolve/calls/CheckerSink;", "context", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;", "isReceiver", "", "isDispatch", "resolveBlockArgument", "block", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "resolveSubCallArgument", "Lorg/jetbrains/kotlin/fir/expressions/FirResolvable;", "useNullableArgumentType", "prepareTypeForPartiallyCompletedPCLACall", "candidate", "outerCSBuilder", "resolvePlainExpressionArgument", "resolvePlainArgumentType", "argumentType", "argumentTypeWithCustomConversion", "Lorg/jetbrains/kotlin/fir/types/ConeInferenceContext;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "prepareCapturedType", "checkApplicabilityForArgumentType", "argumentTypeBeforeCapturing", "position", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/ConstraintPosition;", "resolveArgument", "callInfo", "Lorg/jetbrains/kotlin/fir/resolve/calls/CallInfo;", "parameter", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "prepareExpectedType", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "getExpectedTypeWithSAMConversion", "candidateExpectedType", "getExpectedTypeWithImplicitIntegerCoercion", "shouldUseSamConversion", "expectedFunctionType", "returnTypeCalculator", "Lorg/jetbrains/kotlin/fir/resolve/transformers/ReturnTypeCalculator;", "isSubtypeForSamConversion", "actualExpressionType", "classLikeExpectedFunctionType", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "namedReferenceWithCandidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/FirNamedReferenceWithCandidate;", "getExpectedType", "captureFromTypeParameterUpperBoundIfNeeded", "hasSupertypeWithGivenClassId", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/types/model/TypeSystemCommonSuperTypesContext;", "resolve"})
@SourceDebugExtension(value={"SMAP\nArguments.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Arguments.kt\norg/jetbrains/kotlin/fir/resolve/calls/ArgumentsKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,746:1\n11102#2:747\n11437#2,3:748\n1#3:751\n1#3:779\n1755#4,3:752\n1734#4,3:755\n669#4,11:758\n1611#4,9:769\n1863#4:778\n1864#4:780\n1620#4:781\n*S KotlinDebug\n*F\n+ 1 Arguments.kt\norg/jetbrains/kotlin/fir/resolve/calls/ArgumentsKt\n*L\n327#1:747\n327#1:748,3\n366#1:779\n576#1:752,3\n637#1:755,3\n728#1:758,11\n366#1:769,9\n366#1:778\n366#1:780\n366#1:781\n*E\n"})
public final class ArgumentsKt {
    @NotNull
    private static final Name SAM_LOOKUP_NAME;

    @NotNull
    public static final Name getSAM_LOOKUP_NAME() {
        return SAM_LOOKUP_NAME;
    }

    public static final void resolveArgumentExpression(@NotNull Candidate $this$resolveArgumentExpression, @NotNull ConstraintSystemBuilder csBuilder, @NotNull FirExpression argument, @Nullable ConeKotlinType expectedType, @NotNull CheckerSink sink, @NotNull ResolutionContext context2, boolean isReceiver, boolean isDispatch) {
        Intrinsics.checkNotNullParameter((Object)$this$resolveArgumentExpression, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)csBuilder, (String)"csBuilder");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        FirExpression firExpression = argument;
        if (firExpression instanceof FirFunctionCall || firExpression instanceof FirWhenExpression || firExpression instanceof FirTryExpression || firExpression instanceof FirCheckNotNullCall || firExpression instanceof FirElvisExpression) {
            ArgumentsKt.resolveSubCallArgument$default($this$resolveArgumentExpression, csBuilder, (FirResolvable)((Object)argument), expectedType, sink, context2, isReceiver, isDispatch, false, 128, null);
        } else if (firExpression instanceof FirSafeCallExpression) {
            FirExpression nestedQualifier;
            FirStatement firStatement = ((FirSafeCallExpression)argument).getSelector();
            FirExpression firExpression2 = firStatement instanceof FirExpression ? (FirExpression)firStatement : null;
            FirExpression firExpression3 = nestedQualifier = firExpression2 != null ? FirExpressionUtilKt.unwrapSmartcastExpression(firExpression2) : null;
            if (nestedQualifier instanceof FirQualifiedAccessExpression) {
                ArgumentsKt.resolveSubCallArgument($this$resolveArgumentExpression, csBuilder, (FirResolvable)((Object)nestedQualifier), expectedType, sink, context2, isReceiver, isDispatch, true);
            } else {
                ConeKotlinType coneKotlinType = expectedType;
                ArgumentsKt.checkApplicabilityForArgumentType(csBuilder, argument, TypeConstructionUtilsKt.constructClassLikeType$default(StandardClassIds.INSTANCE.getUnit(), new ConeTypeProjection[0], false, null, 4, null), coneKotlinType != null ? coneKotlinType.getType() : null, SimpleConstraintSystemConstraintPosition.INSTANCE, false, false, sink, context2);
            }
        } else if (firExpression instanceof FirCallableReferenceAccess) {
            if (((FirCallableReferenceAccess)argument).getCalleeReference() instanceof FirResolvedNamedReference) {
                ArgumentsKt.resolvePlainExpressionArgument$default($this$resolveArgumentExpression, csBuilder, argument, expectedType, sink, context2, isReceiver, isDispatch, false, 128, null);
            } else {
                PostponedArgumentsKt.preprocessCallableReference($this$resolveArgumentExpression, (FirCallableReferenceAccess)argument, expectedType, context2);
            }
        } else if (firExpression instanceof FirAnonymousFunctionExpression) {
            PostponedArgumentsKt.preprocessLambdaArgument$default($this$resolveArgumentExpression, csBuilder, (FirAnonymousFunctionExpression)argument, expectedType, context2, sink, false, null, 96, null);
        } else if (firExpression instanceof FirWrappedArgumentExpression) {
            ArgumentsKt.resolveArgumentExpression($this$resolveArgumentExpression, csBuilder, ((FirWrappedArgumentExpression)argument).getExpression(), expectedType, sink, context2, isReceiver, isDispatch);
        } else if (firExpression instanceof FirBlock) {
            ArgumentsKt.resolveBlockArgument($this$resolveArgumentExpression, csBuilder, (FirBlock)argument, expectedType, sink, context2, isReceiver, isDispatch);
        } else if (firExpression instanceof FirErrorExpression) {
            FirExpression wrappedExpression = ((FirErrorExpression)argument).getExpression();
            if (wrappedExpression != null) {
                ArgumentsKt.resolveArgumentExpression($this$resolveArgumentExpression, csBuilder, wrappedExpression, expectedType, sink, context2, isReceiver, isDispatch);
            } else {
                ArgumentsKt.resolvePlainExpressionArgument$default($this$resolveArgumentExpression, csBuilder, argument, expectedType, sink, context2, isReceiver, isDispatch, false, 128, null);
            }
        } else {
            ArgumentsKt.resolvePlainExpressionArgument$default($this$resolveArgumentExpression, csBuilder, argument, expectedType, sink, context2, isReceiver, isDispatch, false, 128, null);
        }
    }

    private static final void resolveBlockArgument(Candidate $this$resolveBlockArgument, ConstraintSystemBuilder csBuilder, FirBlock block, ConeKotlinType expectedType, CheckerSink sink, ResolutionContext context2, boolean isReceiver, boolean isDispatch) {
        List<FirExpression> returnArguments = UtilsKt.returnExpressions(block);
        if (returnArguments.isEmpty()) {
            ConeKotlinType coneKotlinType = expectedType;
            ArgumentsKt.checkApplicabilityForArgumentType(csBuilder, block, FirTypeUtilsKt.getResolvedType(block), coneKotlinType != null ? coneKotlinType.getType() : null, SimpleConstraintSystemConstraintPosition.INSTANCE, false, false, sink, context2);
            return;
        }
        for (FirExpression argument : returnArguments) {
            ArgumentsKt.resolveArgumentExpression($this$resolveBlockArgument, csBuilder, argument, expectedType, sink, context2, isReceiver, isDispatch);
        }
    }

    public static final void resolveSubCallArgument(@NotNull Candidate $this$resolveSubCallArgument, @NotNull ConstraintSystemBuilder csBuilder, @NotNull FirResolvable argument, @Nullable ConeKotlinType expectedType, @NotNull CheckerSink sink, @NotNull ResolutionContext context2, boolean isReceiver, boolean isDispatch, boolean useNullableArgumentType) {
        Intrinsics.checkNotNullParameter((Object)$this$resolveSubCallArgument, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)csBuilder, (String)"csBuilder");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!(argument instanceof FirExpression)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        Candidate candidate2 = CandidateFactoryKt.candidate(argument);
        if (candidate2 == null) {
            ArgumentsKt.resolvePlainExpressionArgument($this$resolveSubCallArgument, csBuilder, (FirExpression)((Object)argument), expectedType, sink, context2, isReceiver, isDispatch, useNullableArgumentType);
            return;
        }
        Candidate candidate3 = candidate2;
        ReturnTypeCalculator returnTypeCalculator = context2.getReturnTypeCalculator();
        Object obj = candidate3.getSymbol().getFir();
        Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration");
        ConeKotlinType type2 = returnTypeCalculator.tryCalculateReturnType((FirCallableDeclaration)obj).getType();
        ConeKotlinType argumentType = ArgumentsKt.prepareTypeForPartiallyCompletedPCLACall(candidate3.getSubstitutor().substituteOrSelf(type2), candidate3, csBuilder);
        ArgumentsKt.resolvePlainArgumentType($this$resolveSubCallArgument, csBuilder, (FirExpression)((Object)argument), argumentType, expectedType, sink, context2, isReceiver, isDispatch, useNullableArgumentType);
    }

    public static /* synthetic */ void resolveSubCallArgument$default(Candidate candidate2, ConstraintSystemBuilder constraintSystemBuilder, FirResolvable firResolvable, ConeKotlinType coneKotlinType, CheckerSink checkerSink, ResolutionContext resolutionContext, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 0x80) != 0) {
            bl3 = false;
        }
        ArgumentsKt.resolveSubCallArgument(candidate2, constraintSystemBuilder, firResolvable, coneKotlinType, checkerSink, resolutionContext, bl, bl2, bl3);
    }

    private static final ConeKotlinType prepareTypeForPartiallyCompletedPCLACall(ConeKotlinType $this$prepareTypeForPartiallyCompletedPCLACall, Candidate candidate2, ConstraintSystemBuilder outerCSBuilder) {
        if (!candidate2.getSystem().getUsesOuterCs()) {
            return $this$prepareTypeForPartiallyCompletedPCLACall;
        }
        KotlinTypeMarker kotlinTypeMarker = MarkerExtensionsKt.safeSubstitute(outerCSBuilder.buildCurrentSubstitutor(), TypeComponentsKt.getTypeContext(candidate2.getCallInfo().getSession()), $this$prepareTypeForPartiallyCompletedPCLACall);
        Intrinsics.checkNotNull((Object)kotlinTypeMarker, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
        return (ConeKotlinType)kotlinTypeMarker;
    }

    public static final void resolvePlainExpressionArgument(@NotNull Candidate $this$resolvePlainExpressionArgument, @NotNull ConstraintSystemBuilder csBuilder, @NotNull FirExpression argument, @Nullable ConeKotlinType expectedType, @NotNull CheckerSink sink, @NotNull ResolutionContext context2, boolean isReceiver, boolean isDispatch, boolean useNullableArgumentType) {
        Intrinsics.checkNotNullParameter((Object)$this$resolvePlainExpressionArgument, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)csBuilder, (String)"csBuilder");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (expectedType == null) {
            return;
        }
        if (argument instanceof FirArrayLiteral && !FirTypeUtilsKt.isResolved(argument)) {
            return;
        }
        ConeKotlinType argumentType = FirTypeUtilsKt.getResolvedType(argument);
        ArgumentsKt.resolvePlainArgumentType($this$resolvePlainExpressionArgument, csBuilder, argument, argumentType, expectedType, sink, context2, isReceiver, isDispatch, useNullableArgumentType);
    }

    public static /* synthetic */ void resolvePlainExpressionArgument$default(Candidate candidate2, ConstraintSystemBuilder constraintSystemBuilder, FirExpression firExpression, ConeKotlinType coneKotlinType, CheckerSink checkerSink, ResolutionContext resolutionContext, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 0x80) != 0) {
            bl3 = false;
        }
        ArgumentsKt.resolvePlainExpressionArgument(candidate2, constraintSystemBuilder, firExpression, coneKotlinType, checkerSink, resolutionContext, bl, bl2, bl3);
    }

    public static final void resolvePlainArgumentType(@NotNull Candidate $this$resolvePlainArgumentType, @NotNull ConstraintSystemBuilder csBuilder, @NotNull FirExpression argument, @NotNull ConeKotlinType argumentType, @Nullable ConeKotlinType expectedType, @NotNull CheckerSink sink, @NotNull ResolutionContext context2, boolean isReceiver, boolean isDispatch, boolean useNullableArgumentType) {
        ConeKotlinType coneKotlinType;
        Intrinsics.checkNotNullParameter((Object)$this$resolvePlainArgumentType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)csBuilder, (String)"csBuilder");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)argumentType, (String)"argumentType");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        ConstraintPosition position = isReceiver ? new ConeReceiverConstraintPosition(argument) : new ConeArgumentConstraintPosition(argument);
        FirSession session2 = context2.getSession();
        ConeKotlinType capturedType = ArgumentsKt.prepareCapturedType(argumentType, context2);
        ConeKotlinType argumentTypeForApplicabilityCheck = null;
        ConeKotlinType coneKotlinType2 = argumentTypeForApplicabilityCheck = useNullableArgumentType ? org.jetbrains.kotlin.fir.types.TypeUtilsKt.withNullability$default(capturedType, ConeNullability.NULLABLE, TypeComponentsKt.getTypeContext(session2), null, false, 12, null) : capturedType;
        if (expectedType != null && (coneKotlinType = ArgumentsKt.argumentTypeWithCustomConversion(context2.getTypeContext(), session2, expectedType, argumentTypeForApplicabilityCheck)) != null) {
            ConeKotlinType it = coneKotlinType;
            boolean bl = false;
            argumentTypeForApplicabilityCheck = it;
            $this$resolvePlainArgumentType.getSubstitutor().substituteOrSelf(argumentTypeForApplicabilityCheck);
            $this$resolvePlainArgumentType.setUsesFunctionConversion(true);
        }
        ArgumentsKt.checkApplicabilityForArgumentType(csBuilder, argument, argumentTypeForApplicabilityCheck, expectedType, position, isReceiver, isDispatch, sink, context2);
    }

    public static /* synthetic */ void resolvePlainArgumentType$default(Candidate candidate2, ConstraintSystemBuilder constraintSystemBuilder, FirExpression firExpression, ConeKotlinType coneKotlinType, ConeKotlinType coneKotlinType2, CheckerSink checkerSink, ResolutionContext resolutionContext, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 0x100) != 0) {
            bl3 = false;
        }
        ArgumentsKt.resolvePlainArgumentType(candidate2, constraintSystemBuilder, firExpression, coneKotlinType, coneKotlinType2, checkerSink, resolutionContext, bl, bl2, bl3);
    }

    /*
     * WARNING - void declaration
     */
    private static final ConeKotlinType argumentTypeWithCustomConversion(ConeInferenceContext $this$argumentTypeWithCustomConversion, FirSession session2, ConeKotlinType expectedType, ConeKotlinType argumentType) {
        void $this$mapTo$iv$iv;
        FunctionTypeKind functionTypeKind = FunctionalTypeUtilsKt.functionTypeKind(expectedType, session2);
        if (functionTypeKind == null) {
            return null;
        }
        FunctionTypeKind expectedTypeKind = functionTypeKind;
        if (FunctionTypeKindKt.isBasicFunctionOrKFunction(expectedTypeKind)) {
            return null;
        }
        ConeClassLikeType expectedFunctionType = FunctionalTypeUtilsKt.customFunctionTypeToSimpleFunctionType(expectedType, session2);
        ConeKotlinType coneKotlinType = FunctionalTypeUtilsKt.findSubtypeOfBasicFunctionType(argumentType, session2, expectedFunctionType);
        if (coneKotlinType == null) {
            return null;
        }
        ConeKotlinType argumentTypeWithInvoke = coneKotlinType;
        List<SimpleTypeMarker> list = $this$argumentTypeWithCustomConversion.fastCorrespondingSupertypes(ConeTypeUtilsKt.unwrapLowerBound(argumentTypeWithInvoke), $this$argumentTypeWithCustomConversion.typeConstructor(expectedFunctionType));
        Object object = list != null ? (SimpleTypeMarker)CollectionsKt.firstOrNull(list) : null;
        ConeKotlinType coneKotlinType2 = object instanceof ConeKotlinType ? (ConeKotlinType)object : null;
        if (coneKotlinType2 == null) {
            return null;
        }
        ConeKotlinType functionType = coneKotlinType2;
        ConeTypeProjection[] $this$map$iv = functionType.getTypeArguments();
        boolean $i$f$map = false;
        ConeTypeProjection[] coneTypeProjectionArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var17_17 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ConeKotlinType coneKotlinType3 = ConeTypeProjectionKt.getType((ConeTypeProjection)it);
            if (coneKotlinType3 == null) {
                coneKotlinType3 = session2.getBuiltinTypes().getNullableAnyType().getType();
            }
            collection.add(coneKotlinType3);
        }
        object = (List)destination$iv$iv;
        if (object.isEmpty()) {
            boolean bl = false;
            return null;
        }
        List typeArguments = (List)object;
        return ResolveUtilsKt.createFunctionType$default(expectedTypeKind, typeArguments.subList(0, CollectionsKt.getLastIndex((List)typeArguments)), null, (ConeKotlinType)CollectionsKt.last((List)typeArguments), null, 16, null);
    }

    @NotNull
    public static final ConeKotlinType prepareCapturedType(@NotNull ConeKotlinType argumentType, @NotNull ResolutionContext context2) {
        Intrinsics.checkNotNullParameter((Object)argumentType, (String)"argumentType");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (org.jetbrains.kotlin.fir.types.TypeUtilsKt.isRaw(argumentType)) {
            return argumentType;
        }
        ConeKotlinType coneKotlinType = (ConeKotlinType)context2.getTypeContext().captureFromExpression(TypeExpansionUtilsKt.fullyExpandedType(argumentType, context2.getSession()));
        if (coneKotlinType == null) {
            coneKotlinType = argumentType;
        }
        return coneKotlinType;
    }

    private static final void checkApplicabilityForArgumentType(ConstraintSystemBuilder csBuilder, FirExpression argument, ConeKotlinType argumentTypeBeforeCapturing, ConeKotlinType expectedType, ConstraintPosition position, boolean isReceiver, boolean isDispatch, CheckerSink sink, ResolutionContext context2) {
        if (expectedType == null) {
            return;
        }
        ConeKotlinType argumentType = ArgumentsKt.captureFromTypeParameterUpperBoundIfNeeded(argumentTypeBeforeCapturing, expectedType, context2.getSession());
        if (isReceiver && isDispatch) {
            if (!ConeTypeUtilsKt.isNullable(expectedType) && ConeTypeUtilsKt.isMarkedNullable(argumentType)) {
                sink.reportDiagnostic(new InapplicableWrongReceiver(expectedType, argumentType));
            }
            return;
        }
        if (isReceiver && expectedType instanceof ConeDynamicType && !(argumentType instanceof ConeDynamicType)) {
            sink.reportDiagnostic(new DynamicReceiverExpectedButWasNonDynamic(argumentType));
            return;
        }
        if (!ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(csBuilder, argumentType, expectedType, position)) {
            ConeKotlinType unstableType;
            FirSmartCastExpression smartcastExpression;
            FirSmartCastExpression firSmartCastExpression = smartcastExpression = argument instanceof FirSmartCastExpression ? (FirSmartCastExpression)argument : null;
            if (smartcastExpression != null && !smartcastExpression.isStable() && ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(csBuilder, unstableType = FirTypeUtilsKt.getConeType(smartcastExpression.getSmartcastType()), expectedType, position)) {
                sink.reportDiagnostic(new UnstableSmartCast(smartcastExpression, expectedType, InferenceUtilsKt.isTypeMismatchDueToNullability(TypeComponentsKt.getTypeContext(context2.getSession()), argumentType, expectedType)));
                return;
            }
            if (!isReceiver) {
                sink.reportDiagnostic(ArgumentsKt.checkApplicabilityForArgumentType$subtypeError(argument, argumentType, context2, csBuilder, expectedType));
                return;
            }
            ConeKotlinType nullableExpectedType = org.jetbrains.kotlin.fir.types.TypeUtilsKt.withNullability$default(expectedType, ConeNullability.NULLABLE, TypeComponentsKt.getTypeContext(context2.getSession()), null, false, 12, null);
            if (ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(csBuilder, argumentType, nullableExpectedType, position)) {
                sink.reportDiagnostic(new UnsafeCall(argumentType));
            } else {
                csBuilder.addSubtypeConstraint(argumentType, expectedType, position);
                sink.reportDiagnostic(new InapplicableWrongReceiver(expectedType, argumentType));
            }
        }
    }

    public static final void resolveArgument(@NotNull Candidate $this$resolveArgument, @NotNull CallInfo callInfo, @NotNull FirExpression argument, @Nullable FirValueParameter parameter, boolean isReceiver, @NotNull CheckerSink sink, @NotNull ResolutionContext context2) {
        Intrinsics.checkNotNullParameter((Object)$this$resolveArgument, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)callInfo, (String)"callInfo");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        PhaseUtilsKt.ensureResolvedTypeDeclaration$default(argument.getConeTypeOrNull(), context2.getSession(), null, 2, null);
        ConeKotlinType expectedType = ArgumentsKt.prepareExpectedType($this$resolveArgument, context2.getSession(), context2.getBodyResolveComponents().getScopeSession(), callInfo, argument, parameter, context2);
        ArgumentsKt.resolveArgumentExpression($this$resolveArgument, $this$resolveArgument.getSystem().getBuilder(), argument, expectedType, sink, context2, isReceiver, false);
    }

    private static final ConeKotlinType prepareExpectedType(Candidate $this$prepareExpectedType, FirSession session2, ScopeSession scopeSession, CallInfo callInfo, FirExpression argument, FirValueParameter parameter, ResolutionContext context2) {
        ConeKotlinType coneKotlinType;
        if (parameter == null) {
            return null;
        }
        ConeKotlinType basicExpectedType = ArgumentsKt.getExpectedType(argument, session2, parameter);
        ConeKotlinType coneKotlinType2 = ArgumentsKt.getExpectedTypeWithSAMConversion($this$prepareExpectedType, session2, scopeSession, argument, basicExpectedType, context2);
        if (coneKotlinType2 != null) {
            ConeKotlinType coneKotlinType3;
            ConeKotlinType it = coneKotlinType3 = coneKotlinType2;
            boolean bl = false;
            FirLookupTrackerComponent firLookupTrackerComponent = FirLookupTrackerComponentKt.getLookupTracker(session2);
            if (firLookupTrackerComponent != null) {
                FirLookupTrackerComponent lookupTracker = firLookupTrackerComponent;
                boolean bl2 = false;
                ClassId classId = ConeTypeUtilsKt.getClassId(ConeTypeUtilsKt.lowerBoundIfFlexible(FirTypeUtilsKt.getConeType(parameter.getReturnTypeRef())));
                if (classId != null) {
                    ClassId classId2;
                    ClassId it2 = classId2 = classId;
                    boolean bl3 = false;
                    classId = !it2.isLocal() ? classId2 : null;
                    if (classId != null) {
                        ClassId classId3 = classId;
                        boolean bl4 = false;
                        String string2 = SAM_LOOKUP_NAME.asString();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
                        FirLookupTrackerComponentKt.recordClassMemberLookup(lookupTracker, string2, classId3, callInfo.getCallSite().getSource(), callInfo.getContainingFile().getSource());
                        FirLookupTrackerComponentKt.recordClassLikeLookup(lookupTracker, classId3, callInfo.getCallSite().getSource(), callInfo.getContainingFile().getSource());
                    }
                }
            }
            coneKotlinType = coneKotlinType3;
        } else {
            coneKotlinType = ArgumentsKt.getExpectedTypeWithImplicitIntegerCoercion(session2, argument, parameter, basicExpectedType);
            if (coneKotlinType == null) {
                coneKotlinType = basicExpectedType;
            }
        }
        ConeKotlinType expectedType = coneKotlinType;
        return $this$prepareExpectedType.getSubstitutor().substituteOrSelf(expectedType);
    }

    private static final ConeKotlinType getExpectedTypeWithSAMConversion(Candidate $this$getExpectedTypeWithSAMConversion, FirSession session2, ScopeSession scopeSession, FirExpression argument, ConeKotlinType candidateExpectedType, ResolutionContext context2) {
        if (FunctionalTypeUtilsKt.isSomeFunctionType(candidateExpectedType, session2)) {
            return null;
        }
        FirSamResolver.SamConversionInfo samConversionInfo = context2.getBodyResolveComponents().getSamResolver().getSamInfoForPossibleSamType(candidateExpectedType);
        if (samConversionInfo == null) {
            return null;
        }
        FirSamResolver.SamConversionInfo samConversionInfo2 = samConversionInfo;
        ConeKotlinType expectedFunctionType = samConversionInfo2.getFunctionalType();
        if (!ArgumentsKt.shouldUseSamConversion(argument, session2, scopeSession, candidateExpectedType, expectedFunctionType, context2.getReturnTypeCalculator())) {
            return null;
        }
        HashMap<FirExpression, FirSamResolver.SamConversionInfo> hashMap = $this$getExpectedTypeWithSAMConversion.getFunctionTypesOfSamConversions();
        if (hashMap == null) {
            HashMap<FirExpression, FirSamResolver.SamConversionInfo> hashMap2;
            HashMap<FirExpression, FirSamResolver.SamConversionInfo> it = hashMap2 = new HashMap<FirExpression, FirSamResolver.SamConversionInfo>();
            boolean bl = false;
            $this$getExpectedTypeWithSAMConversion.setFunctionTypesOfSamConversions(it);
            hashMap = hashMap2;
        }
        HashMap<FirExpression, FirSamResolver.SamConversionInfo> samConversions = hashMap;
        ((Map)samConversions).put(FirExpressionUtilKt.unwrapArgument(argument), samConversionInfo2);
        return expectedFunctionType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final ConeKotlinType getExpectedTypeWithImplicitIntegerCoercion(FirSession session2, FirExpression argument, FirValueParameter parameter, ConeKotlinType candidateExpectedType) {
        ConeKotlinType argumentType;
        ConeKotlinType coneKotlinType;
        if (!FirLanguageSettingsComponentKt.getLanguageVersionSettings(session2).supportsFeature(LanguageFeature.ImplicitSignedToUnsignedIntegerConversion)) {
            return null;
        }
        if (!ImplicitIntegerCoercionKt.isMarkedWithImplicitIntegerCoercion(parameter)) {
            return null;
        }
        if (!ConeBuiltinTypeUtilsKt.isUnsignedTypeOrNullableUnsignedType(TypeExpansionUtilsKt.fullyExpandedType(candidateExpectedType, session2))) {
            return null;
        }
        if (ResolveUtilsKt.isIntegerLiteralOrOperatorCall(argument)) {
            coneKotlinType = FirTypeUtilsKt.getResolvedType(argument);
        } else {
            FirCallableSymbol firCallableSymbol;
            FirReference firReference = ReferenceUtilsKt.toReference(argument, session2);
            if (firReference == null) return null;
            FirCallableSymbol firCallableSymbol2 = FirReferenceUtilsKt.toResolvedCallableSymbol$default(firReference, false, 1, null);
            if (firCallableSymbol2 == null) return null;
            FirCallableSymbol it = firCallableSymbol = firCallableSymbol2;
            boolean bl = false;
            if (!it.getRawStatus().isConst()) return null;
            if (!ImplicitIntegerCoercionKt.isMarkedWithImplicitIntegerCoercion(it)) return null;
            boolean bl2 = true;
            if (!bl2) return null;
            FirCallableSymbol firCallableSymbol3 = firCallableSymbol;
            FirCallableSymbol firCallableSymbol4 = firCallableSymbol3;
            if (firCallableSymbol4 == null) return null;
            coneKotlinType = firCallableSymbol4.getResolvedReturnType();
        }
        ConeKotlinType coneKotlinType2 = argumentType = coneKotlinType;
        if (coneKotlinType2 == null) return null;
        ConeKotlinType coneKotlinType3 = org.jetbrains.kotlin.fir.types.TypeUtilsKt.withNullability$default(coneKotlinType2, candidateExpectedType.getNullability(), TypeComponentsKt.getTypeContext(session2), null, false, 12, null);
        return coneKotlinType3;
    }

    public static final boolean shouldUseSamConversion(@NotNull FirExpression $this$shouldUseSamConversion, @NotNull FirSession session2, @NotNull ScopeSession scopeSession, @NotNull ConeKotlinType candidateExpectedType, @NotNull ConeKotlinType expectedFunctionType, @NotNull ReturnTypeCalculator returnTypeCalculator) {
        boolean bl;
        ConeClassLikeType classLikeExpectedFunctionType;
        Intrinsics.checkNotNullParameter((Object)$this$shouldUseSamConversion, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        Intrinsics.checkNotNullParameter((Object)candidateExpectedType, (String)"candidateExpectedType");
        Intrinsics.checkNotNullParameter((Object)expectedFunctionType, (String)"expectedFunctionType");
        Intrinsics.checkNotNullParameter((Object)returnTypeCalculator, (String)"returnTypeCalculator");
        FirExpression unwrapped = FirExpressionUtilKt.unwrapArgument($this$shouldUseSamConversion);
        if (unwrapped instanceof FirAnonymousFunctionExpression || unwrapped instanceof FirCallableReferenceAccess) {
            return true;
        }
        ConeKotlinType coneType = FirTypeUtilsKt.getResolvedType($this$shouldUseSamConversion);
        if (org.jetbrains.kotlin.fir.types.TypeUtilsKt.isSubtypeOf$default(coneType, candidateExpectedType, session2, false, 4, null)) {
            return false;
        }
        if (FunctionalTypeUtilsKt.isSomeFunctionType(coneType, session2)) {
            return true;
        }
        ConeSimpleKotlinType coneSimpleKotlinType = ConeTypeUtilsKt.lowerBoundIfFlexible(expectedFunctionType);
        ConeClassLikeType coneClassLikeType = classLikeExpectedFunctionType = coneSimpleKotlinType instanceof ConeClassLikeType ? (ConeClassLikeType)coneSimpleKotlinType : null;
        if (classLikeExpectedFunctionType == null || coneType instanceof ConeIntegerLiteralType) {
            return false;
        }
        FirNamedReferenceWithCandidate namedReferenceWithCandidate = ArgumentsKt.namedReferenceWithCandidate(unwrapped);
        Object object = namedReferenceWithCandidate;
        if (object != null && (object = ((FirNamedReferenceWithCandidate)object).getCandidate()) != null && (object = ((Candidate)object).getPostponedAtoms()) != null) {
            boolean bl2;
            block10: {
                Iterable $this$any$iv = (Iterable)object;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        PostponedResolvedAtom it = (PostponedResolvedAtom)element$iv;
                        boolean bl3 = false;
                        if (!(it instanceof LambdaWithTypeVariableAsExpectedTypeAtom && Intrinsics.areEqual((Object)TypeSystemContextHelpersKt.typeConstructor(((LambdaWithTypeVariableAsExpectedTypeAtom)it).getExpectedType(), TypeComponentsKt.getTypeContext(session2)), (Object)TypeSystemContextHelpersKt.typeConstructor(coneType, TypeComponentsKt.getTypeContext(session2))))) continue;
                        bl2 = true;
                        break block10;
                    }
                    bl2 = false;
                }
            }
            bl = bl2;
        } else {
            bl = false;
        }
        if (bl) {
            return true;
        }
        return ArgumentsKt.isSubtypeForSamConversion(session2, scopeSession, coneType, classLikeExpectedFunctionType, returnTypeCalculator);
    }

    private static final boolean isSubtypeForSamConversion(FirSession session2, ScopeSession scopeSession, ConeKotlinType actualExpressionType, ConeClassLikeType classLikeExpectedFunctionType, ReturnTypeCalculator returnTypeCalculator) {
        boolean bl;
        block6: {
            boolean returnTypeCompatible;
            FirFunctionSymbol<?> firFunctionSymbol = FunctionalTypeUtilsKt.findContributedInvokeSymbol(actualExpressionType, session2, scopeSession, classLikeExpectedFunctionType, false);
            if (firFunctionSymbol == null) {
                return false;
            }
            FirFunctionSymbol<?> invokeSymbol = firFunctionSymbol;
            ConeSimpleKotlinType expectedReturnType = ConeTypeUtilsKt.lowerBoundIfFlexible(FunctionalTypeUtilsKt.returnType(classLikeExpectedFunctionType, session2));
            boolean bl2 = returnTypeCompatible = ConeTypeUtilsKt.originalIfDefinitelyNotNullable(expectedReturnType) instanceof ConeTypeParameterType || AbstractTypeChecker.INSTANCE.isSubtypeOf(TypeComponentsKt.getTypeContext(session2).newTypeCheckerState(false, true), (KotlinTypeMarker)returnTypeCalculator.tryCalculateReturnType((FirCallableDeclaration)invokeSymbol.getFir()).getType(), (KotlinTypeMarker)expectedReturnType, false);
            if (!returnTypeCompatible) {
                return false;
            }
            if (((FirFunction)invokeSymbol.getFir()).getValueParameters().size() != classLikeExpectedFunctionType.getTypeArguments().length - 1) {
                return false;
            }
            List parameterPairs = CollectionsKt.zip((Iterable)((FirFunction)invokeSymbol.getFir()).getValueParameters(), (Iterable)FunctionalTypeUtilsKt.valueParameterTypesIncludingReceiver(classLikeExpectedFunctionType, session2));
            Iterable $this$all$iv = parameterPairs;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Pair pair = (Pair)element$iv;
                    boolean bl3 = false;
                    FirValueParameter invokeParameter = (FirValueParameter)pair.component1();
                    ConeKotlinType expectedParameter = (ConeKotlinType)pair.component2();
                    ConeSimpleKotlinType expectedParameterType = ConeTypeUtilsKt.lowerBoundIfFlexible(expectedParameter);
                    if (ConeTypeUtilsKt.originalIfDefinitelyNotNullable(expectedParameterType) instanceof ConeTypeParameterType || AbstractTypeChecker.INSTANCE.isSubtypeOf(TypeComponentsKt.getTypeContext(session2).newTypeCheckerState(false, true), (KotlinTypeMarker)FirTypeUtilsKt.getConeType(invokeParameter.getReturnTypeRef()), (KotlinTypeMarker)expectedParameterType, false)) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final FirNamedReferenceWithCandidate namedReferenceWithCandidate(FirExpression $this$namedReferenceWithCandidate) {
        FirNamedReferenceWithCandidate firNamedReferenceWithCandidate;
        FirExpression firExpression = $this$namedReferenceWithCandidate;
        if (firExpression instanceof FirResolvable) {
            FirReference firReference = ((FirResolvable)((Object)$this$namedReferenceWithCandidate)).getCalleeReference();
            firNamedReferenceWithCandidate = firReference instanceof FirNamedReferenceWithCandidate ? (FirNamedReferenceWithCandidate)firReference : null;
        } else if (firExpression instanceof FirSafeCallExpression) {
            FirStatement firStatement = ((FirSafeCallExpression)$this$namedReferenceWithCandidate).getSelector();
            FirExpression firExpression2 = firStatement instanceof FirExpression ? (FirExpression)firStatement : null;
            firNamedReferenceWithCandidate = firExpression2 != null ? ArgumentsKt.namedReferenceWithCandidate(firExpression2) : null;
        } else {
            firNamedReferenceWithCandidate = null;
        }
        return firNamedReferenceWithCandidate;
    }

    @NotNull
    public static final ConeKotlinType getExpectedType(@NotNull FirExpression $this$getExpectedType, @NotNull FirSession session2, @NotNull FirValueParameter parameter) {
        ConeKotlinType expectedType;
        Intrinsics.checkNotNullParameter((Object)$this$getExpectedType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        FirExpression firExpression = $this$getExpectedType;
        boolean shouldUnwrapVarargType = firExpression instanceof FirSpreadArgumentExpression || firExpression instanceof FirNamedArgumentExpression ? false : parameter.isVararg();
        ConeKotlinType coneKotlinType = expectedType = shouldUnwrapVarargType ? ArrayUtilsKt.varargElementType(FirTypeUtilsKt.getConeType(parameter.getReturnTypeRef())) : FirTypeUtilsKt.getConeType(parameter.getReturnTypeRef());
        if (!FirFunctionTypeKindServiceKt.getFunctionTypeService(session2).hasExtensionKinds()) {
            return expectedType;
        }
        return new FunctionTypeKindSubstitutor(session2).substituteOrSelf(expectedType);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ConeKotlinType captureFromTypeParameterUpperBoundIfNeeded(@NotNull ConeKotlinType argumentType, @NotNull ConeKotlinType expectedType, @NotNull FirSession session2) {
        ConeKotlinType coneKotlinType;
        Object v2;
        ConeInferenceContext context2;
        block8: {
            void $this$singleOrNull$iv;
            Intrinsics.checkNotNullParameter((Object)argumentType, (String)"argumentType");
            Intrinsics.checkNotNullParameter((Object)expectedType, (String)"expectedType");
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            ClassId classId = ConeTypeUtilsKt.getClassId(ConeTypeUtilsKt.upperBoundIfFlexible(expectedType));
            if (classId == null) {
                return argumentType;
            }
            ClassId expectedTypeClassId = classId;
            ConeSimpleKotlinType coneSimpleKotlinType = ConeTypeUtilsKt.lowerBoundIfFlexible(argumentType);
            ConeTypeParameterType coneTypeParameterType = coneSimpleKotlinType instanceof ConeTypeParameterType ? (ConeTypeParameterType)coneSimpleKotlinType : null;
            if (coneTypeParameterType == null) {
                return argumentType;
            }
            ConeTypeParameterType simplifiedArgumentType = coneTypeParameterType;
            context2 = TypeComponentsKt.getTypeContext(session2);
            Iterable iterable = TypeUtilsKt.collectUpperBounds(simplifiedArgumentType);
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                ConeClassLikeType it = (ConeClassLikeType)element$iv;
                boolean bl = false;
                if (!ArgumentsKt.hasSupertypeWithGivenClassId(it, expectedTypeClassId, context2)) continue;
                if (found$iv) {
                    v2 = null;
                    break block8;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v2 = !found$iv ? null : single$iv;
        }
        ConeClassLikeType coneClassLikeType = v2;
        if (coneClassLikeType == null) {
            return argumentType;
        }
        ConeClassLikeType chosenSupertype = coneClassLikeType;
        ConeKotlinType coneKotlinType2 = (ConeKotlinType)context2.captureFromExpression(chosenSupertype);
        if (coneKotlinType2 == null) {
            return argumentType;
        }
        ConeKotlinType capturedType = coneKotlinType2;
        if (argumentType instanceof ConeDefinitelyNotNullType) {
            ConeDefinitelyNotNullType coneDefinitelyNotNullType = org.jetbrains.kotlin.fir.types.TypeUtilsKt.create$default(ConeDefinitelyNotNullType.Companion, capturedType, TypeComponentsKt.getTypeContext(session2), false, 4, null);
            coneKotlinType = coneDefinitelyNotNullType != null ? (ConeKotlinType)coneDefinitelyNotNullType : capturedType;
        } else {
            coneKotlinType = capturedType;
        }
        return coneKotlinType;
    }

    private static final boolean hasSupertypeWithGivenClassId(ConeKotlinType $this$hasSupertypeWithGivenClassId, ClassId classId, TypeSystemCommonSuperTypesContext context2) {
        TypeSystemCommonSuperTypesContext $this$hasSupertypeWithGivenClassId_u24lambda_u2414 = context2;
        boolean bl = false;
        return $this$hasSupertypeWithGivenClassId_u24lambda_u2414.anySuperTypeConstructor($this$hasSupertypeWithGivenClassId, (Function1<? super SimpleTypeMarker, Boolean>)((Function1)arg_0 -> ArgumentsKt.hasSupertypeWithGivenClassId$lambda$14$lambda$13($this$hasSupertypeWithGivenClassId_u24lambda_u2414, classId, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    private static final ConeKotlinType checkApplicabilityForArgumentType$subtypeError$tryGetConeTypeThatCompatibleWithKtType(ConstraintSystemBuilder $csBuilder, ResolutionContext $context, ConeKotlinType type2) {
        if (type2 instanceof ConeTypeVariableType) {
            ConeTypeParameterLookupTag originalTypeParameter;
            List list;
            Iterable $this$mapNotNull$iv;
            List<Constraint> constraints;
            ConeTypeVariableTypeConstructor lookupTag = ((ConeTypeVariableType)type2).getTypeConstructor();
            VariableWithConstraints variableWithConstraints = $csBuilder.currentStorage().getNotFixedTypeVariables().get(lookupTag);
            List<Constraint> list2 = constraints = variableWithConstraints != null ? variableWithConstraints.getConstraints() : null;
            if (list2 != null) {
                void $this$mapNotNullTo$iv$iv;
                $this$mapNotNull$iv = list2;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    ConeKotlinType it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl = false;
                    Constraint it = (Constraint)element$iv$iv;
                    boolean bl2 = false;
                    KotlinTypeMarker kotlinTypeMarker = it.getType();
                    if ((kotlinTypeMarker instanceof ConeKotlinType ? (ConeKotlinType)kotlinTypeMarker : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                list = (List)destination$iv$iv;
            } else {
                list = null;
            }
            List constraintTypes = list;
            $this$mapNotNull$iv = constraintTypes;
            if (!($this$mapNotNull$iv == null || $this$mapNotNull$iv.isEmpty())) {
                return ConeTypeIntersector.INSTANCE.intersectTypes(TypeComponentsKt.getTypeContext($context.getSession()), constraintTypes);
            }
            TypeParameterMarker typeParameterMarker = lookupTag.getOriginalTypeParameter();
            ConeTypeParameterLookupTag coneTypeParameterLookupTag = originalTypeParameter = typeParameterMarker instanceof ConeTypeParameterLookupTag ? (ConeTypeParameterLookupTag)typeParameterMarker : null;
            if (originalTypeParameter != null) {
                return new ConeTypeParameterTypeImpl(originalTypeParameter, ConeTypeUtilsKt.isNullable(type2), ((ConeTypeVariableType)type2).getAttributes());
            }
        } else if (type2 instanceof ConeIntegerLiteralType) {
            ConeClassLikeType coneClassLikeType = (ConeClassLikeType)CollectionsKt.firstOrNull((Iterable)((ConeIntegerLiteralType)type2).getPossibleTypes());
            return coneClassLikeType != null ? (ConeKotlinType)coneClassLikeType : type2;
        }
        return type2;
    }

    private static final ResolutionDiagnostic checkApplicabilityForArgumentType$subtypeError(FirExpression $argument, ConeKotlinType argumentType, ResolutionContext $context, ConstraintSystemBuilder $csBuilder, ConeKotlinType actualExpectedType) {
        if (FirTypeUtilsKt.isNullLiteral($argument) && actualExpectedType.getNullability() == ConeNullability.NOT_NULL) {
            return new NullForNotNullType($argument, actualExpectedType);
        }
        if (argumentType instanceof ConeErrorType || actualExpectedType instanceof ConeErrorType) {
            return ErrorTypeInArguments.INSTANCE;
        }
        ConeKotlinType preparedExpectedType = ArgumentsKt.checkApplicabilityForArgumentType$subtypeError$tryGetConeTypeThatCompatibleWithKtType($csBuilder, $context, actualExpectedType);
        ConeKotlinType preparedActualType = ArgumentsKt.checkApplicabilityForArgumentType$subtypeError$tryGetConeTypeThatCompatibleWithKtType($csBuilder, $context, argumentType);
        return new ArgumentTypeMismatch(preparedExpectedType, preparedActualType, $argument, InferenceUtilsKt.isTypeMismatchDueToNullability(TypeComponentsKt.getTypeContext($context.getSession()), argumentType, actualExpectedType));
    }

    private static final boolean hasSupertypeWithGivenClassId$lambda$14$lambda$13(TypeSystemCommonSuperTypesContext $this_with, ClassId $classId, SimpleTypeMarker it) {
        Intrinsics.checkNotNullParameter((Object)$this_with, (String)"$this_with");
        Intrinsics.checkNotNullParameter((Object)$classId, (String)"$classId");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        TypeConstructorMarker typeConstructor2 = $this_with.typeConstructor(it);
        return typeConstructor2 instanceof ConeClassLikeLookupTag && Intrinsics.areEqual((Object)((ConeClassLikeLookupTag)typeConstructor2).getClassId(), (Object)$classId);
    }

    static {
        Name name2 = Name.special("<SAM-CONSTRUCTOR>");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"special(...)");
        SAM_LOOKUP_NAME = name2;
    }
}

