/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.wasm.ir.convertors;

import java.io.InputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.wasm.ir.convertors.ByteReader;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J*\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001f0$H\u0086\b\u00f8\u0001\u0000J\b\u0010%\u001a\u00020&H\u0016J\u0017\u0010'\u001a\u00020(2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016\u00a2\u0006\u0002\u0010)R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR \u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u000b\"\u0004\b\u0017\u0010\rR\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u001a\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/wasm/ir/convertors/MyByteReader;", "Lorg/jetbrains/kotlin/wasm/ir/convertors/ByteReader;", "ins", "Ljava/io/InputStream;", "<init>", "(Ljava/io/InputStream;)V", "getIns", "()Ljava/io/InputStream;", "offset", "", "getOffset", "()J", "setOffset", "(J)V", "sizeLimits", "", "Lorg/jetbrains/kotlin/wasm/ir/convertors/MyByteReader$SizeLimit;", "getSizeLimits", "()Ljava/util/List;", "setSizeLimits", "(Ljava/util/List;)V", "currentMaxSize", "getCurrentMaxSize", "setCurrentMaxSize", "isEof", "", "()Z", "read", "amount", "", "limitSize", "", "size", "reason", "", "block", "Lkotlin/Function0;", "readByte", "", "readBytes", "", "(Ljava/lang/Integer;)[B", "SizeLimit", "wasm.ir"})
public final class MyByteReader
extends ByteReader {
    @NotNull
    private final InputStream ins;
    private long offset;
    @NotNull
    private List<SizeLimit> sizeLimits;
    private long currentMaxSize;

    public MyByteReader(@NotNull InputStream ins) {
        Intrinsics.checkNotNullParameter((Object)ins, (String)"ins");
        this.ins = ins;
        Object[] objectArray = new SizeLimit[]{new SizeLimit(Long.MAX_VALUE, "Root")};
        this.sizeLimits = CollectionsKt.mutableListOf((Object[])objectArray);
        this.currentMaxSize = Long.MAX_VALUE;
    }

    @NotNull
    public final InputStream getIns() {
        return this.ins;
    }

    public final long getOffset() {
        return this.offset;
    }

    public final void setOffset(long l) {
        this.offset = l;
    }

    @NotNull
    public final List<SizeLimit> getSizeLimits() {
        return this.sizeLimits;
    }

    public final void setSizeLimits(@NotNull List<SizeLimit> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.sizeLimits = list;
    }

    public final long getCurrentMaxSize() {
        return this.currentMaxSize;
    }

    public final void setCurrentMaxSize(long l) {
        this.currentMaxSize = l;
    }

    @Override
    public boolean isEof() {
        throw new IllegalStateException("Not implemented".toString());
    }

    @Override
    @NotNull
    public ByteReader read(int amount) {
        throw new IllegalStateException("Not implemented".toString());
    }

    public final void limitSize(int size, @NotNull String reason, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$limitSize = false;
        long maxSize = this.getOffset() + (long)size;
        this.getSizeLimits().add(new SizeLimit(maxSize, reason));
        this.setCurrentMaxSize(maxSize);
        block.invoke();
        if (!(this.getOffset() == this.getCurrentMaxSize())) {
            boolean bl = false;
            String string2 = "Ending size-limited block \"" + reason + "\". We haven't read all " + size + " bytes.";
            throw new IllegalArgumentException(string2.toString());
        }
        CollectionsKt.removeLast(this.getSizeLimits());
        this.setCurrentMaxSize(((SizeLimit)CollectionsKt.last(this.getSizeLimits())).getMaxSize());
    }

    @Override
    public byte readByte() {
        int b = this.ins.read();
        if (b == -1) {
            throw new IllegalStateException("UnexpectedEnd".toString());
        }
        long l = this.offset;
        this.offset = l + 1L;
        if (this.offset > this.currentMaxSize) {
            throw new IllegalStateException(("Reading bytes past limit " + this.currentMaxSize + " Reason: " + ((SizeLimit)CollectionsKt.last(this.sizeLimits)).getReason()).toString());
        }
        return (byte)b;
    }

    @Override
    @NotNull
    public byte[] readBytes(@Nullable Integer amount) {
        if (!(amount != null)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        int n = 0;
        byte[] byArray = new byte[amount.intValue()];
        while (n < amount) {
            int n2 = n++;
            byArray[n2] = this.readByte();
        }
        return byArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/wasm/ir/convertors/MyByteReader$SizeLimit;", "", "maxSize", "", "reason", "", "<init>", "(JLjava/lang/String;)V", "getMaxSize", "()J", "getReason", "()Ljava/lang/String;", "wasm.ir"})
    public static final class SizeLimit {
        private final long maxSize;
        @NotNull
        private final String reason;

        public SizeLimit(long maxSize, @NotNull String reason) {
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            this.maxSize = maxSize;
            this.reason = reason;
        }

        public final long getMaxSize() {
            return this.maxSize;
        }

        @NotNull
        public final String getReason() {
            return this.reason;
        }
    }
}

