/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.util;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorUtilKt;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.incremental.KotlinLookupLocation;
import org.jetbrains.kotlin.incremental.UtilsKt;
import org.jetbrains.kotlin.incremental.components.EnumWhenTracker;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=50, d1={"\u0000$\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a&\u0010\u0000\u001a\u00020\u0001*\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a8\u0006\f"}, d2={"record", "", "Lorg/jetbrains/kotlin/incremental/components/LookupTracker;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/kotlin/incremental/components/EnumWhenTracker;", "subjectType", "subjectExpression", "elseEntry", "Lorg/jetbrains/kotlin/psi/KtWhenEntry;", "frontend"})
public final class IncrementalTrackerUtilKt {
    public static final void record(@NotNull LookupTracker $this$record, @NotNull KtExpression expression2, @NotNull KotlinType type2) {
        Intrinsics.checkNotNullParameter((Object)$this$record, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        if (KotlinTypeKt.isError(type2) || TypeUtilsKt.isUnit(type2)) {
            return;
        }
        ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            return;
        }
        ClassifierDescriptor typeDescriptor = classifierDescriptor;
        DeclarationDescriptor declarationDescriptor = typeDescriptor.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getContainingDeclaration(...)");
        DeclarationDescriptor scopeDescriptor = declarationDescriptor;
        if (scopeDescriptor instanceof PackageFragmentDescriptor && !DescriptorUtils.isLocal(typeDescriptor)) {
            LookupLocation lookupLocation = new KotlinLookupLocation(expression2);
            PackageFragmentDescriptor packageFragmentDescriptor = (PackageFragmentDescriptor)scopeDescriptor;
            Name name2 = typeDescriptor.getName();
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"getName(...)");
            UtilsKt.record($this$record, lookupLocation, packageFragmentDescriptor, name2);
        } else if (scopeDescriptor instanceof ClassDescriptor && !DescriptorUtils.isLocal(typeDescriptor)) {
            LookupLocation lookupLocation = new KotlinLookupLocation(expression2);
            ClassDescriptor classDescriptor = (ClassDescriptor)scopeDescriptor;
            Name name3 = typeDescriptor.getName();
            Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"getName(...)");
            UtilsKt.record($this$record, lookupLocation, classDescriptor, name3);
        }
        for (TypeProjection typeArgument : type2.getArguments()) {
            if (typeArgument.isStarProjection()) continue;
            KotlinType kotlinType = typeArgument.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
            IncrementalTrackerUtilKt.record($this$record, expression2, kotlinType);
        }
    }

    public static final void record(@NotNull EnumWhenTracker $this$record, @Nullable KotlinType subjectType, @NotNull KtExpression subjectExpression, @Nullable KtWhenEntry elseEntry) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$record, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)subjectExpression, (String)"subjectExpression");
        if (elseEntry != null) {
            return;
        }
        if (!(subjectExpression instanceof KtNameReferenceExpression)) {
            return;
        }
        Object object = subjectType;
        if (object == null || (object = ((KotlinType)object).getConstructor()) == null || (object = object.getDeclarationDescriptor()) == null) {
            return;
        }
        Object declarationDescriptor = object;
        Object object2 = DescriptorUtilKt.containingPackage((DeclarationDescriptor)declarationDescriptor);
        if (object2 == null || (object2 = ((FqName)object2).toString()) == null) {
            return;
        }
        Object containingPackage = object2;
        String string3 = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)declarationDescriptor).asString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"asString(...)");
        String fqName = string3;
        Object object3 = ((KtNameReferenceExpression)subjectExpression).getContainingFile().getVirtualFile();
        if (object3 == null || (object3 = ((VirtualFile)object3).getPath()) == null) {
            return;
        }
        Object filePath = object3;
        if (StringsKt.startsWith$default((String)fqName, (String)((String)containingPackage + '.'), (boolean)false, (int)2, null)) {
            StringBuilder stringBuilder = new StringBuilder().append((String)containingPackage).append('.');
            String string4 = fqName.substring(((String)containingPackage).length() + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            string2 = stringBuilder.append(StringsKt.replace$default((String)string4, (String)".", (String)"$", (boolean)false, (int)4, null)).toString();
        } else {
            string2 = StringsKt.replace$default((String)fqName, (String)".", (String)"$", (boolean)false, (int)4, null);
        }
        String owner = string2;
        $this$record.report((String)filePath, owner);
    }
}

