/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.PlatformSpecificCastChecker;
import org.jetbrains.kotlin.builtins.PlatformToKotlinClassMapper;
import org.jetbrains.kotlin.com.google.common.collect.Maps;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionImpl;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.IntersectionTypeConstructor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeIntersector;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeReconstructionResult;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUnifier;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.checker.TypeCheckingProcedure;
import org.jetbrains.kotlin.types.expressions.DataFlowAnalyzer;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J \u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0002J\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0007H\u0002J\u0010\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0007H\u0002J \u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0010\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J&\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u0007J$\u0010'\u001a\u00020\u00052\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00070)2\u0006\u0010%\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\u0005J\u0018\u0010*\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\"2\u0006\u0010+\u001a\u00020\u0007H\u0002J\u0018\u0010,\u001a\u00020\u00052\u0006\u0010-\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u0007H\u0002J\u0018\u0010.\u001a\u00020\u00052\u0006\u0010-\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u0007H\u0002J\u0010\u0010/\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\"H\u0002\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/types/CastDiagnosticsUtil;", "", "<init>", "()V", "isCastPossible", "", "lhsType", "Lorg/jetbrains/kotlin/types/KotlinType;", "rhsType", "platformToKotlinClassMapper", "Lorg/jetbrains/kotlin/builtins/PlatformToKotlinClassMapper;", "platformSpecificCastChecker", "Lorg/jetbrains/kotlin/builtins/PlatformSpecificCastChecker;", "isRelated", "a", "b", "mapToPlatformIndependentClasses", "", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "type", "isFinal", "isTrait", "isCastErased", "supertype", "subtype", "typeChecker", "Lorg/jetbrains/kotlin/types/checker/KotlinTypeChecker;", "findStaticallyKnownSubtype", "Lorg/jetbrains/kotlin/types/TypeReconstructionResult;", "subtypeConstructor", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "allParametersReified", "castIsUseless", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpressionWithTypeRHS;", "context", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "targetType", "actualType", "isRefinementUseless", "possibleTypes", "", "shouldCheckForExactType", "expectedType", "isExactTypeCast", "candidateType", "isUpcast", "checkExactTypeForUselessCast", "frontend"})
@SourceDebugExtension(value={"SMAP\nCastDiagnosticsUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CastDiagnosticsUtil.kt\norg/jetbrains/kotlin/types/CastDiagnosticsUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,291:1\n1755#2,3:292\n1755#2,3:295\n1557#2:299\n1628#2,3:300\n1734#2,3:303\n1557#2:306\n1628#2,3:307\n1#3:298\n*S KotlinDebug\n*F\n+ 1 CastDiagnosticsUtil.kt\norg/jetbrains/kotlin/types/CastDiagnosticsUtil\n*L\n50#1:292,3\n84#1:295,3\n174#1:299\n174#1:300,3\n209#1:303,3\n229#1:306\n229#1:307,3\n*E\n"})
public final class CastDiagnosticsUtil {
    @NotNull
    public static final CastDiagnosticsUtil INSTANCE = new CastDiagnosticsUtil();

    private CastDiagnosticsUtil() {
    }

    @JvmStatic
    public static final boolean isCastPossible(@NotNull KotlinType lhsType, @NotNull KotlinType rhsType, @NotNull PlatformToKotlinClassMapper platformToKotlinClassMapper, @NotNull PlatformSpecificCastChecker platformSpecificCastChecker) {
        Intrinsics.checkNotNullParameter((Object)lhsType, (String)"lhsType");
        Intrinsics.checkNotNullParameter((Object)rhsType, (String)"rhsType");
        Intrinsics.checkNotNullParameter((Object)platformToKotlinClassMapper, (String)"platformToKotlinClassMapper");
        Intrinsics.checkNotNullParameter((Object)platformSpecificCastChecker, (String)"platformSpecificCastChecker");
        TypeConstructor typeConstructor2 = lhsType.getConstructor();
        if (typeConstructor2 instanceof IntersectionTypeConstructor) {
            boolean bl;
            block14: {
                Iterable $this$any$iv = ((IntersectionTypeConstructor)typeConstructor2).getSupertypes();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        KotlinType it = (KotlinType)element$iv;
                        boolean bl2 = false;
                        if (!CastDiagnosticsUtil.isCastPossible(it, rhsType, platformToKotlinClassMapper, platformSpecificCastChecker)) continue;
                        bl = true;
                        break block14;
                    }
                    bl = false;
                }
            }
            return bl;
        }
        boolean rhsNullable = TypeUtils.isNullableType(rhsType);
        boolean lhsNullable = TypeUtils.isNullableType(lhsType);
        if (KotlinBuiltIns.isNothing(lhsType)) {
            return true;
        }
        if (KotlinBuiltIns.isNullableNothing(lhsType) && !rhsNullable) {
            return false;
        }
        if (KotlinBuiltIns.isNothing(rhsType)) {
            return false;
        }
        if (KotlinBuiltIns.isNullableNothing(rhsType)) {
            return lhsNullable;
        }
        if (lhsNullable && rhsNullable) {
            return true;
        }
        if (KotlinTypeKt.isError(lhsType)) {
            return true;
        }
        if (INSTANCE.isRelated(lhsType, rhsType, platformToKotlinClassMapper)) {
            return true;
        }
        if (TypeUtils.isTypeParameter(lhsType) || TypeUtils.isTypeParameter(rhsType)) {
            return true;
        }
        if (platformSpecificCastChecker.isCastPossible(lhsType, rhsType)) {
            return true;
        }
        if (INSTANCE.isFinal(lhsType) || INSTANCE.isFinal(rhsType)) {
            return false;
        }
        return INSTANCE.isTrait(lhsType) || INSTANCE.isTrait(rhsType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isRelated(KotlinType a, KotlinType b, PlatformToKotlinClassMapper platformToKotlinClassMapper) {
        ClassDescriptor it;
        boolean bl;
        List<ClassDescriptor> aClasses = this.mapToPlatformIndependentClasses(a, platformToKotlinClassMapper);
        List<ClassDescriptor> bClasses = this.mapToPlatformIndependentClasses(b, platformToKotlinClassMapper);
        Iterable $this$any$iv = aClasses;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl = false;
        } else {
            for (Object element$iv : $this$any$iv) {
                it = (ClassDescriptor)element$iv;
                boolean bl2 = false;
                if (!DescriptorUtils.isSubtypeOfClass(b, it)) continue;
                return true;
            }
            bl = false;
        }
        if (bl) return true;
        $this$any$iv = bClasses;
        $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            Object element$iv;
            if (!iterator2.hasNext()) return false;
            element$iv = iterator2.next();
            it = (ClassDescriptor)element$iv;
            boolean bl3 = false;
        } while (!DescriptorUtils.isSubtypeOfClass(a, it));
        return true;
    }

    private final List<ClassDescriptor> mapToPlatformIndependentClasses(KotlinType type2, PlatformToKotlinClassMapper platformToKotlinClassMapper) {
        ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
        ClassDescriptor classDescriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
        if (classDescriptor == null) {
            return CollectionsKt.emptyList();
        }
        ClassDescriptor descriptor = classDescriptor;
        Collection<ClassDescriptor> collection = platformToKotlinClassMapper.mapPlatformClass(descriptor);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"mapPlatformClass(...)");
        return CollectionsKt.plus(collection, (Object)descriptor);
    }

    private final boolean isFinal(KotlinType type2) {
        return !TypeUtils.canHaveSubtypes(KotlinTypeChecker.DEFAULT, type2);
    }

    private final boolean isTrait(KotlinType type2) {
        ClassifierDescriptor it = type2.getConstructor().getDeclarationDescriptor();
        boolean bl = false;
        return it instanceof ClassDescriptor && ((ClassDescriptor)it).getKind() == ClassKind.INTERFACE;
    }

    @JvmStatic
    public static final boolean isCastErased(@NotNull KotlinType supertype, @NotNull KotlinType subtype, @NotNull KotlinTypeChecker typeChecker) {
        Intrinsics.checkNotNullParameter((Object)supertype, (String)"supertype");
        Intrinsics.checkNotNullParameter((Object)subtype, (String)"subtype");
        Intrinsics.checkNotNullParameter((Object)typeChecker, (String)"typeChecker");
        boolean isNonReifiedTypeParameter = TypeUtils.isNonReifiedTypeParameter(subtype);
        boolean isUpcast = typeChecker.isSubtypeOf(supertype, subtype);
        if (isNonReifiedTypeParameter && !isUpcast) {
            boolean nullableToDefinitelyNotNull;
            boolean bl = nullableToDefinitelyNotNull = !TypeUtils.isNullableType(subtype) && Intrinsics.areEqual((Object)TypeUtilsKt.makeNotNullable(supertype), (Object)subtype);
            if (!nullableToDefinitelyNotNull) {
                return true;
            }
        }
        if (supertype.isMarkedNullable() || subtype.isMarkedNullable()) {
            KotlinType kotlinType = TypeUtils.makeNotNullable(supertype);
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"makeNotNullable(...)");
            KotlinType kotlinType2 = TypeUtils.makeNotNullable(subtype);
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"makeNotNullable(...)");
            return CastDiagnosticsUtil.isCastErased(kotlinType, kotlinType2, typeChecker);
        }
        if (isUpcast) {
            return false;
        }
        if (isNonReifiedTypeParameter) {
            return true;
        }
        if (INSTANCE.allParametersReified(subtype)) {
            return false;
        }
        KotlinType kotlinType = CastDiagnosticsUtil.findStaticallyKnownSubtype(supertype, subtype.getConstructor()).getResultingType();
        if (kotlinType == null) {
            return true;
        }
        KotlinType staticallyKnownSubtype = kotlinType;
        return !typeChecker.isSubtypeOf(staticallyKnownSubtype, subtype);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final TypeReconstructionResult findStaticallyKnownSubtype(@NotNull KotlinType supertype, @NotNull TypeConstructor subtypeConstructor) {
        HashMap<Object, Object> hashMap;
        void $this$mapTo$iv$iv;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)supertype, (String)"supertype");
        Intrinsics.checkNotNullParameter((Object)subtypeConstructor, (String)"subtypeConstructor");
        boolean bl2 = bl = !supertype.isMarkedNullable();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-CastDiagnosticsUtil$findStaticallyKnownSubtype$22 = false;
            String $i$a$-assert-CastDiagnosticsUtil$findStaticallyKnownSubtype$22 = "This method only makes sense for non-nullable types";
            throw new AssertionError((Object)$i$a$-assert-CastDiagnosticsUtil$findStaticallyKnownSubtype$22);
        }
        ClassifierDescriptor classifierDescriptor = subtypeConstructor.getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            throw new IllegalStateException(("Can't create default type for " + subtypeConstructor).toString());
        }
        ClassifierDescriptor descriptor = classifierDescriptor;
        SimpleType simpleType = descriptor.getDefaultType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getDefaultType(...)");
        SimpleType subtypeWithVariables = simpleType;
        KotlinType supertypeWithVariables = TypeCheckingProcedure.findCorrespondingSupertype(subtypeWithVariables, supertype);
        List<TypeParameterDescriptor> list = subtypeWithVariables.getConstructor().getParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getParameters(...)");
        List<TypeParameterDescriptor> variables2 = list;
        Iterable $this$map$iv = variables2;
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(p0.getTypeConstructor());
        }
        Set variableConstructors = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        if (supertypeWithVariables != null) {
            TypeUnifier.UnificationResult unificationResult = TypeUnifier.unify(new TypeProjectionImpl(supertype), new TypeProjectionImpl(supertypeWithVariables), variableConstructors::contains);
            Intrinsics.checkNotNullExpressionValue((Object)unificationResult, (String)"unify(...)");
            TypeUnifier.UnificationResult solution = unificationResult;
            hashMap = Maps.newHashMap(solution.getSubstitution());
        } else {
            hashMap = Maps.newHashMapWithExpectedSize(variables2.size());
        }
        HashMap $i$f$map22 = hashMap;
        Intrinsics.checkNotNull($i$f$map22);
        Map substitution = $i$f$map22;
        boolean allArgumentsInferred = true;
        for (TypeParameterDescriptor variable : variables2) {
            TypeProjection value2 = (TypeProjection)substitution.get(variable.getTypeConstructor());
            if (value2 != null) continue;
            TypeConstructor typeConstructor2 = variable.getTypeConstructor();
            Intrinsics.checkNotNullExpressionValue((Object)typeConstructor2, (String)"getTypeConstructor(...)");
            TypeProjection typeProjection = TypeUtils.makeStarProjection(variable);
            Intrinsics.checkNotNullExpressionValue((Object)typeProjection, (String)"makeStarProjection(...)");
            substitution.put(typeConstructor2, typeProjection);
            allArgumentsInferred = false;
        }
        KotlinType substituted = TypeSubstitutor.create(substitution).substitute(subtypeWithVariables, Variance.INVARIANT);
        return new TypeReconstructionResult(substituted, allArgumentsInferred);
    }

    private final boolean allParametersReified(KotlinType subtype) {
        boolean bl;
        block3: {
            List<TypeParameterDescriptor> list = subtype.getConstructor().getParameters();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getParameters(...)");
            Iterable $this$all$iv = list;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    TypeParameterDescriptor it = (TypeParameterDescriptor)element$iv;
                    boolean bl2 = false;
                    if (it.isReified()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public final boolean castIsUseless(@NotNull KtBinaryExpressionWithTypeRHS expression2, @NotNull ExpressionTypingContext context2, @NotNull KotlinType targetType, @NotNull KotlinType actualType) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
        Intrinsics.checkNotNullParameter((Object)actualType, (String)"actualType");
        KotlinType kotlinType = KtPsiUtil.isSafeCast(expression2) ? TypeUtils.makeNullable(targetType) : targetType;
        Intrinsics.checkNotNull((Object)kotlinType);
        KotlinType refinedTargetType = kotlinType;
        Collection<KotlinType> collection = DataFlowAnalyzer.getAllPossibleTypes(expression2.getLeft(), actualType, context2);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getAllPossibleTypes(...)");
        Collection<KotlinType> possibleTypes = collection;
        KotlinType kotlinType2 = context2.expectedType;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"expectedType");
        return this.isRefinementUseless(possibleTypes, refinedTargetType, this.shouldCheckForExactType(expression2, kotlinType2));
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isRefinementUseless(@NotNull Collection<? extends KotlinType> possibleTypes, @NotNull KotlinType targetType, boolean shouldCheckForExactType) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(possibleTypes, (String)"possibleTypes");
        Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
        Iterable $this$map$iv = possibleTypes;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KotlinType kotlinType = (KotlinType)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(FlexibleTypesKt.upperIfFlexible((KotlinType)it));
        }
        KotlinType kotlinType = TypeIntersector.intersectTypes((List)destination$iv$iv);
        if (kotlinType == null) {
            return false;
        }
        KotlinType intersectedType = kotlinType;
        return shouldCheckForExactType ? this.isExactTypeCast(intersectedType, targetType) : this.isUpcast(intersectedType, targetType);
    }

    private final boolean shouldCheckForExactType(KtBinaryExpressionWithTypeRHS expression2, KotlinType expectedType) {
        if (TypeUtils.noExpectedType(expectedType)) {
            return this.checkExactTypeForUselessCast(expression2);
        }
        return TypeUtils.isDontCarePlaceholder(expectedType);
    }

    private final boolean isExactTypeCast(KotlinType candidateType, KotlinType targetType) {
        return Intrinsics.areEqual((Object)candidateType, (Object)targetType) && FunctionTypesKt.isExtensionFunctionType(candidateType) == FunctionTypesKt.isExtensionFunctionType(targetType);
    }

    private final boolean isUpcast(KotlinType candidateType, KotlinType targetType) {
        if (!KotlinTypeChecker.DEFAULT.isSubtypeOf(candidateType, targetType)) {
            return false;
        }
        if (FunctionTypesKt.isFunctionType(candidateType) && FunctionTypesKt.isFunctionType(targetType)) {
            return FunctionTypesKt.isExtensionFunctionType(candidateType) == FunctionTypesKt.isExtensionFunctionType(targetType);
        }
        return true;
    }

    private final boolean checkExactTypeForUselessCast(KtBinaryExpressionWithTypeRHS expression2) {
        boolean bl;
        PsiElement parent2 = expression2.getParent();
        while (parent2 instanceof KtParenthesizedExpression || parent2 instanceof KtLabeledExpression || parent2 instanceof KtAnnotatedExpression) {
            parent2 = ((KtExpressionImpl)parent2).getParent();
        }
        PsiElement psiElement = parent2;
        if (psiElement instanceof KtValueArgument) {
            bl = true;
        } else if (psiElement instanceof KtQualifiedExpression) {
            KtExpression receiver = ((KtQualifiedExpression)parent2).getReceiverExpression();
            bl = PsiTreeUtil.isAncestor(receiver, expression2, false);
        } else {
            bl = psiElement instanceof KtBinaryExpression || psiElement instanceof KtUnaryExpression ? true : psiElement instanceof KtProperty || psiElement instanceof KtPropertyAccessor || psiElement instanceof KtNamedFunction || psiElement instanceof KtFunctionLiteral;
        }
        return bl;
    }
}

